/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.BrowserListeners;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.HtmlPanelSupport;
import com.mathworks.html.HtmlPanelSupportFactory;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.jxbrowser.chromium.BrowserFocusListener;
import com.mathworks.html.jxbrowser.chromium.CrashRecoveryListener;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumNavigator;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumPanel;
import com.mathworks.html.jxbrowser.chromium.MWDialogHandler;
import com.mathworks.html.jxbrowser.chromium.MWDialogHandlerBase;
import com.mathworks.html.jxbrowser.chromium.MailToHandler;
import com.mathworks.html.jxbrowser.chromium.ProxyHandler;
import com.mathworks.html.jxbrowser.chromium.StatusTextDOMListener;
import com.mathworks.html.jxbrowser.chromium.console.JavaScriptConsole;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserFactory;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.ProxyConfig;
import com.teamdev.jxbrowser.chromium.dom.DOMElement;
import com.teamdev.jxbrowser.chromium.dom.events.DOMEventListener;
import com.teamdev.jxbrowser.chromium.dom.events.DOMEventType;
import com.teamdev.jxbrowser.chromium.events.ConsoleListener;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.RenderListener;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;

public class JxBrowserChromiumFactory
implements HtmlPanelSupportFactory {
    private final ProxyHandler fProxyHandler = new ProxyHandler();
    private final Browser fBrowser;
    private JxBrowserChromiumPanel fPanel;

    public JxBrowserChromiumFactory() {
        this.fBrowser = JxBrowserChromiumFactory.createBrowser(this.fProxyHandler);
    }

    JxBrowserChromiumFactory(Browser browser) {
        this.fBrowser = browser;
    }

    @Override
    public synchronized HtmlPanelSupport buildSupport(BrowserListeners browserListeners) {
        this.addBasicListeners(browserListeners);
        JxBrowserChromiumNavigator jxBrowserChromiumNavigator = JxBrowserChromiumNavigator.create(this.fBrowser, browserListeners);
        this.fPanel = new JxBrowserChromiumPanel(this.fBrowser, jxBrowserChromiumNavigator, browserListeners);
        return this.fPanel;
    }

    private void addBasicListeners(BrowserListeners browserListeners) {
        Collection<MWDialogHandlerBase> collection = this.createDialogHandlers();
        this.fBrowser.setDialogHandler((DialogHandler)new MWDialogHandler(collection));
        this.fBrowser.addRenderListener((RenderListener)new CrashRecoveryListener());
        this.fBrowser.getView().getComponent().addFocusListener(new BrowserFocusListener(this.fBrowser));
        this.fBrowser.addLoadListener((LoadListener)new StatusTextLoadListener(browserListeners.getStatusTextListener()));
        browserListeners.getRequestHandler().addRequestHandler(new MailToHandler());
        this.fBrowser.addConsoleListener((ConsoleListener)JavaScriptConsole.getInstance());
    }

    private static Browser createBrowser(ProxyHandler proxyHandler) {
        try {
            File file = JxBrowserChromiumFactory.getCacheDir();
            BrowserContext browserContext = JxBrowserChromiumFactory.getBrowserContext(file);
            if (browserContext == null) {
                return BrowserFactory.create((ProxyConfig)proxyHandler.getProxyConfig());
            }
            return BrowserFactory.create((BrowserContext)browserContext, (ProxyConfig)proxyHandler.getProxyConfig());
        }
        catch (Throwable throwable) {
            return BrowserFactory.create();
        }
    }

    private static File getCacheDir() {
        File file;
        if (Environment.isMac()) {
            return null;
        }
        File file2 = HtmlPanel.getResourceDirectory();
        if (file2.exists() && file2.isDirectory() && file2.canWrite() && ((file = new File(file2, "cache")).exists() || file.mkdir())) {
            return file;
        }
        return null;
    }

    private static BrowserContext getBrowserContext(File file) {
        return file == null ? null : new BrowserContext(file.getAbsolutePath());
    }

    private Collection<MWDialogHandlerBase> createDialogHandlers() {
        MWDialogHandlerBase mWDialogHandlerBase = this.fProxyHandler.createProxyDialogHandler(this.fBrowser);
        if (mWDialogHandlerBase != null) {
            return Arrays.asList(mWDialogHandlerBase);
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized void doWhenPanelCreated(HtmlPanelSupportFactory.ComponentCreatedListener componentCreatedListener) {
        componentCreatedListener.panelCreated(this.fPanel.getComponent());
    }

    public static void setChromiumDirectory(File file) {
        BrowserPreferences.setChromiumDir((String)file.getAbsolutePath());
    }

    static {
        LoggerProvider.getBrowserLogger().setLevel(Level.OFF);
        LoggerProvider.getChromiumProcessLogger().setLevel(Level.OFF);
        LoggerProvider.getIPCLogger().setLevel(Level.OFF);
        String string = Locale.getDefault().getLanguage();
        BrowserPreferences.setChromiumSwitches((String[])new String[]{"--allow-file-access-from-files", String.format("--lang=%s", string)});
    }

    private class StatusTextLoadListener
    extends LoadAdapter {
        private final StatusTextDOMListener iListener;

        private StatusTextLoadListener(StatusTextListener statusTextListener) {
            this.iListener = new StatusTextDOMListener(JxBrowserChromiumFactory.this.fBrowser, statusTextListener);
        }

        public void onFinishLoadingFrame(FinishLoadingEvent finishLoadingEvent) {
            DOMElement dOMElement = JxBrowserChromiumFactory.this.fBrowser.getDocument().getDocumentElement();
            dOMElement.addEventListener(DOMEventType.OnMouseOver, (DOMEventListener)this.iListener, true);
        }
    }
}

