/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.HtmlPanelLoadFailureHandlerMap;
import com.mathworks.html.LoadFailure;
import com.mathworks.html.LoadFailureHandlerMap;
import com.mathworks.html.PageLoadFailureHandler;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumNavigator;
import com.teamdev.jxbrowser.chromium.events.FailLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.NetErrorCode;

class LoadFailureListener
extends LoadAdapter {
    private final JxBrowserChromiumNavigator fNavigator;
    private final HtmlPanelLoadFailureHandlerMap fHandlerMap = new HtmlPanelLoadFailureHandlerMap();

    LoadFailureListener(JxBrowserChromiumNavigator jxBrowserChromiumNavigator) {
        this.fNavigator = jxBrowserChromiumNavigator;
    }

    public void onFailLoadingFrame(FailLoadingEvent failLoadingEvent) {
        LoadFailure loadFailure = LoadFailureListener.getLoadFailureForEvent(failLoadingEvent);
        if (loadFailure != null) {
            PageLoadFailureHandler pageLoadFailureHandler = this.fHandlerMap.getHandler(loadFailure);
            pageLoadFailureHandler.handleLoadFailure(loadFailure, this.fNavigator, Url.parseSilently(failLoadingEvent.getValidatedURL()));
        }
    }

    void addLoadFailureHandlers(LoadFailureHandlerMap loadFailureHandlerMap) {
        this.fHandlerMap.addOverrides(loadFailureHandlerMap);
    }

    private static LoadFailure getLoadFailureForEvent(FailLoadingEvent failLoadingEvent) {
        try {
            NetErrorCode netErrorCode = NetErrorCode.parse((int)failLoadingEvent.getErrorCode());
            switch (netErrorCode) {
                case PROXY_CONNECTION_FAILED: {
                    return LoadFailure.PROXY_CONNECTION_FAILED;
                }
                case FILE_NOT_FOUND: {
                    return LoadFailure.PAGE_NOT_FOUND;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

