/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.HtmlUtils;
import com.mathworks.html.StatusTextChangedEvent;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.Url;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeAtPoint;
import com.teamdev.jxbrowser.chromium.dom.events.DOMEvent;
import com.teamdev.jxbrowser.chromium.dom.events.DOMEventListener;
import java.awt.Point;
import java.net.MalformedURLException;

class StatusTextDOMListener
implements DOMEventListener {
    private final Browser fBrowser;
    private final StatusTextListener fStatusTextListener;

    StatusTextDOMListener(Browser browser, StatusTextListener statusTextListener) {
        this.fBrowser = browser;
        this.fStatusTextListener = statusTextListener;
    }

    public void handleEvent(DOMEvent dOMEvent) {
        String string;
        DOMNodeAtPoint dOMNodeAtPoint;
        Point point = this.fBrowser.getView().getComponent().getMousePosition();
        if (point != null && (dOMNodeAtPoint = this.fBrowser.getNodeAtPoint(point)) != null && (string = dOMNodeAtPoint.getAbsoluteLinkURL()) != null) {
            String string2 = StatusTextDOMListener.getUrlStatusText(string);
            this.fStatusTextListener.statusChanged(new StatusTextChangedEvent(string2));
            return;
        }
        this.fStatusTextListener.statusChanged(new StatusTextChangedEvent(""));
    }

    private static String getUrlStatusText(String string) {
        try {
            Url url = Url.parse(string);
            if (url.getType() == Url.UrlType.CUSTOM_PROTOCOL || HtmlUtils.isValidUrl(string)) {
                return url.getUnencodedUrl();
            }
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }
}

