/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.BrowserListeners;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.chromium.LoadHtmlHandler;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.StartLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.TitleEvent;
import com.teamdev.jxbrowser.chromium.events.TitleListener;
import java.util.regex.Pattern;

class TitleAndPageChangeAdapter
extends LoadAdapter
implements TitleListener {
    private final BrowserListeners fBrowserListeners;
    private final LoadHtmlHandler fLoadHtmlHandler;
    private String fTitle = "";
    private Url fLastUrl = null;

    TitleAndPageChangeAdapter(BrowserListeners browserListeners, LoadHtmlHandler loadHtmlHandler) {
        this.fBrowserListeners = browserListeners;
        this.fLoadHtmlHandler = loadHtmlHandler;
    }

    public void onStartLoadingFrame(StartLoadingEvent startLoadingEvent) {
        if (startLoadingEvent.isMainFrame()) {
            this.setTitle("");
        }
    }

    public synchronized void onFinishLoadingFrame(FinishLoadingEvent finishLoadingEvent) {
        String string;
        if (finishLoadingEvent.isMainFrame() && (string = finishLoadingEvent.getValidatedURL()) != null && !string.isEmpty()) {
            Url url;
            Url url2 = url = Url.parseSilently(string);
            int n = this.fLoadHtmlHandler.getIndexFromUrl(url);
            if (n >= 0) {
                url2 = new CustomProtocolUrl("text", String.valueOf(n));
            }
            String string2 = this.determineTitleForLoadedPage(finishLoadingEvent.getBrowser(), url, url2);
            PageChangedEvent pageChangedEvent = new PageChangedEvent(string2, url2, this.fLastUrl);
            this.fLastUrl = url2;
            this.fBrowserListeners.getPageChangedListener().pageChanged(pageChangedEvent);
        }
    }

    private String determineTitleForLoadedPage(Browser browser, Url url, Url url2) {
        String string = this.getTitle();
        if (string != null && !string.isEmpty()) {
            return string;
        }
        String string2 = browser.getTitle();
        if (string2 != null && !string2.isEmpty()) {
            if (TitleAndPageChangeAdapter.isPageName(string2, url)) {
                return url2.toString();
            }
            return string2;
        }
        return url2 == null ? "" : url2.toString();
    }

    private static boolean isPageName(String string, Url url) {
        if (url.getType() == Url.UrlType.FILE) {
            FileUrl fileUrl = (FileUrl)url;
            String string2 = fileUrl.getFile().getName();
            return string.matches(Pattern.quote(string2) + "([?#].*)?$");
        }
        return false;
    }

    public synchronized void onTitleChange(TitleEvent titleEvent) {
        String string = titleEvent.getTitle();
        this.setTitle(string);
        this.fBrowserListeners.getTitleListener().dataRetrieved(string);
    }

    private synchronized void setTitle(String string) {
        this.fTitle = string;
    }

    synchronized String getTitle() {
        return this.fTitle;
    }
}

