/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium.console;

import com.mathworks.html.jxbrowser.chromium.console.JavaScriptConsole;
import com.mathworks.html.jxbrowser.chromium.console.JavaScriptConsoleHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class DialogConsoleHandler
implements JavaScriptConsoleHandler {
    private StringBuilder fMessages = new StringBuilder();
    private JDialog fDialog;
    private JTextField fFormatField;
    private JComboBox<JavaScriptConsole.Level> fLevelCombo;
    private JTextArea fTextArea;

    DialogConsoleHandler() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogConsoleHandler.this.createDialog();
            }
        });
    }

    private synchronized void createDialog() {
        this.fDialog = new JDialog();
        this.fDialog.setTitle("JavaScript Console");
        this.fTextArea = new JTextArea();
        this.fDialog.getContentPane().setLayout(new BorderLayout());
        this.fDialog.getContentPane().add((Component)this.fTextArea, "Center");
        this.fLevelCombo = DialogConsoleHandler.createLevelCombo();
        this.fFormatField = DialogConsoleHandler.createFormatField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("Format:"));
        jPanel.add(this.fFormatField);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(new JLabel("Level:"));
        jPanel.add(this.fLevelCombo);
        this.fDialog.getContentPane().add((Component)jPanel, "South");
        this.fDialog.pack();
        this.fDialog.setSize(600, 400);
        this.fDialog.setVisible(true);
        this.updateSettingsFields();
        this.attemptFlush();
    }

    private static JComboBox<JavaScriptConsole.Level> createLevelCombo() {
        final JComboBox<JavaScriptConsole.Level> jComboBox = new JComboBox<JavaScriptConsole.Level>(new LevelModel());
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptConsole.Level level = (JavaScriptConsole.Level)((Object)jComboBox.getItemAt(jComboBox.getSelectedIndex()));
                JavaScriptConsole.setLevel(level);
            }
        });
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        return jComboBox;
    }

    private static JTextField createFormatField() {
        final JTextField jTextField = new JTextField();
        jTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptConsole.setFormat(jTextField.getText());
            }
        });
        return jTextField;
    }

    @Override
    public synchronized void log(String string) {
        this.fMessages.append(string).append('\n');
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogConsoleHandler.this.attemptFlush();
            }
        });
    }

    private synchronized void attemptFlush() {
        if (this.fTextArea != null) {
            this.fTextArea.append(this.fMessages.toString());
            this.fMessages = new StringBuilder();
        }
    }

    @Override
    public synchronized void settingsChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogConsoleHandler.this.updateSettingsFields();
            }
        });
    }

    private synchronized void updateSettingsFields() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogConsoleHandler.this.fFormatField.setText(JavaScriptConsole.getFormat());
                DialogConsoleHandler.this.fLevelCombo.setSelectedIndex(JavaScriptConsole.getLevel().ordinal());
            }
        });
    }

    @Override
    public synchronized void dispose() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogConsoleHandler.this.fDialog.dispose();
            }
        });
    }

    private static class LevelModel
    extends DefaultComboBoxModel<JavaScriptConsole.Level> {
        private LevelModel() {
            super(JavaScriptConsole.Level.values());
        }
    }
}

