/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.GpibDll;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.mwSystem;

public final class GpibADVANTECH
extends GpibDll {
    private static final int TIMEOUT = 5;
    private double fTimeout = 10.0;

    public GpibADVANTECH() throws TMException {
        this.deleteInstrumentObject(this);
    }

    public GpibADVANTECH(String string, int n, int n2) throws Exception {
        try {
            this.configureProps(string, "Advantech", n, n2, false);
            mwSystem.load((String)string);
        }
        catch (SecurityException securityException) {
            this.deleteInstrumentObject(this);
            GpibADVANTECH.displayError(securityException.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.deleteInstrumentObject(this);
            GpibADVANTECH.displayError(unsatisfiedLinkError.getMessage());
        }
        catch (TMException tMException) {
            this.deleteInstrumentObject(this);
            GpibADVANTECH.displayError(tMException.getMessage());
        }
    }

    @Override
    protected final int[] getValidCompareBits() {
        int[] nArray = new int[]{7, 8};
        return nArray;
    }

    @Override
    public double GetDouble(int n, int n2) {
        switch (n2) {
            case 5: {
                return this.fTimeout;
            }
        }
        return -11.0;
    }

    @Override
    public int SetDouble(int n, int n2, double d) {
        int n3 = this.SetDoubleNative(n, n2, d);
        switch (n2) {
            case 5: {
                if (n3 < 0) break;
                double[] dArray = new double[]{0.0, 1.0E-5, 3.0E-5, 1.0E-4, 3.0E-4, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 1.0, 3.0, 10.0, 30.0, 100.0, 300.0, 1000.0};
                this.fTimeout = dArray[n3];
            }
        }
        return n3;
    }

    @Override
    protected void verifyReadOperation() throws TMException {
        GpibADVANTECH.displayError("Asynchronous operation is not supported by the Advantech GPIB adaptor.");
    }

    @Override
    protected void verifyWriteOperation(int n) throws TMException {
        if (n == 1) {
            GpibADVANTECH.displayError("Asynchronous operation is not supported by the Advantech GPIB adaptor.");
        }
    }

    public String getInspectorToolbarObjectName() {
        return "GPIB";
    }

    @Override
    public native int Create(int var1, int var2, int var3, double var4, boolean var6, boolean var7);

    @Override
    public native int Close(int var1);

    @Override
    public native int[] FindBoards();

    @Override
    public native Object[] FindInstruments(int[] var1, String[] var2);

    @Override
    public native int Clear(int var1);

    @Override
    public native int Set(int var1, int var2, int var3);

    public native int SetDoubleNative(int var1, int var2, double var3);

    @Override
    public native int Write(int var1, String var2, int var3, int var4);

    @Override
    public native int WriteBinaryByte(int var1, byte[] var2, int var3, int var4);

    @Override
    public native int WriteBinaryShort(int var1, short[] var2, int var3, int var4);

    @Override
    public native int WriteBinaryInt(int var1, int[] var2, int var3, int var4);

    @Override
    public native int WriteBinaryFloat(int var1, float[] var2, int var3, int var4);

    @Override
    public native int WriteBinaryDouble(int var1, double[] var2, int var3, int var4);

    @Override
    public native int WriteBinaryChar(int var1, char[] var2, int var3, int var4);

    @Override
    public native Object[] Read(int var1, int var2);

    @Override
    public native Object[] ReadBinary(int var1, int var2, int var3);

    @Override
    public native int WriteBinaryByteAsync(Instrument var1, int var2, byte[] var3, int var4);

    @Override
    public native int ReadBinaryByteAsync(Instrument var1, int var2, int var3);

    @Override
    public native byte[] GetAsyncReadData(int var1, int var2);

    @Override
    public native int StopAsync(int var1);

    @Override
    public native int Trigger(int var1);

    @Override
    public native int Lines(int var1, int var2, int var3);

    @Override
    public native String HwInfo(int var1);

    public native int PPollConfig(int var1, int var2, int var3, int var4);

    public native int PPoll(int var1, int var2);

    @Override
    public native int SPoll(int var1);

    @Override
    public native String TranslateErrorCode(int var1, int var2);
}

