/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.toolbox.instrument.AdaptorInfo;
import com.mathworks.toolbox.instrument.BusManagementStatusStruct;
import com.mathworks.toolbox.instrument.Gpib;
import com.mathworks.toolbox.instrument.HandshakeStatusStruct;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.InputBuffer;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.toolbox.testmeas.util.mwSystem;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

abstract class GpibDll
extends Gpib
implements ActionListener,
AutoConvertStringToMatlabChar {
    private static final int DAV = 1;
    private static final int NDAC = 2;
    private static final int NRFD = 3;
    private static final int IFC = 4;
    private static final int REN = 5;
    private static final int SRQ = 6;
    private static final int ATN = 7;
    private static final int EOI = 8;
    private static final int EOIMODE = 1;
    private static final int EOSMODE = 2;
    private static final int EOSCHAR = 3;
    private static final int COMPAREBITS = 4;
    private static final int TIMEOUT = 5;
    private static final int SUCCESS = 1;
    private static final String[] gpibAdaptors = AdaptorInfo.GPIB_ADAPTORS;
    private static final String[] gpibVendors = AdaptorInfo.GPIB_VENDORS;
    protected static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription"};
    protected static final String POWERON = "Timeout occurred during FOPEN. Make sure the instrument is powered on," + LINESEP + "connected to the bus and at the primary " + "address specified.";
    protected static final String INUSE = "The specified configuration is not available. " + LINESEP + "Use INSTRFIND " + "to determine if other instrument objects " + "are connected" + LINESEP + "to the requested " + "instrument.";
    private BusManagementStatusStruct busManagementStatus = new BusManagementStatusStruct();
    private HandshakeStatusStruct handshakeStatus = new HandshakeStatusStruct();
    private Object[] info = new Object[5];
    private Object[] hwinfo = new Object[7];
    private boolean objectPolls = false;
    private int oldTransferStatus = 0;
    private static final Object[] comVals = new Object[]{new Double(7.0), new Double(8.0)};
    private static final Object[] comVals8 = new Object[]{new Double(8.0)};
    private static final Object[] SadVals = new Object[]{new Double(0.0), new Double(96.0), new Double(97.0), new Double(98.0), new Double(99.0), new Double(100.0), new Double(101.0), new Double(102.0), new Double(103.0), new Double(104.0), new Double(105.0), new Double(106.0), new Double(107.0), new Double(108.0), new Double(109.0), new Double(110.0), new Double(111.0), new Double(112.0), new Double(113.0), new Double(114.0), new Double(115.0), new Double(116.0), new Double(117.0), new Double(118.0), new Double(119.0), new Double(120.0), new Double(121.0), new Double(122.0), new Double(123.0), new Double(124.0), new Double(125.0), new Double(126.0)};
    private static final HandshakeStatusStruct hss = new HandshakeStatusStruct();
    private static final BusManagementStatusStruct bmss = new BusManagementStatusStruct();
    static ICProp[] objectICProps = new ICProp[]{new ICProp("BoardIndex", "double", "none", "", "", "whileopen", 1, 0), new ICProp("BusManagementStatus", "struct", "none", null, bmss, "always", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "eosCharCode", "whileOpen", 0, 0), new ICProp("CompareBits", "double", "bounded", comVals, new Integer(8), "never", 1, 0), new ICProp("EOIMode", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("EOSCharCode", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("EOSMode", "string", "enum", EOSMVals, "none", "never", 1, 0), new ICProp("HandshakeStatus", "struct", "none", null, hss, "always", 1, 0), new ICProp("PrimaryAddress", "double", "bounded", PadVals, "", "whileOpen", 1, 0), new ICProp("SecondaryAddress", "double", "enum", SadVals, new Integer(0), "whileOpen", 1, 0), new ICProp("Type", "string", "none", "", "gpib", "always", 0, 0)};

    public GpibDll() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            GpibDll.displayError("The Instrument Control Toolbox license check failed when trying to execute: 'gpib'.");
        }
        this.objectProps = DefaultICProp.addObjectProps(objectICProps);
    }

    public final void setBusManagementStatus(BusManagementStatusStruct busManagementStatusStruct) throws TMException {
        GpibDll.displayError(this.createReadOnlyPropertyError("BusManagementStatus"));
    }

    public final BusManagementStatusStruct getBusManagementStatus() {
        if (this.status == 1) {
            this.busManagementStatus.setInterfaceClear(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 4)));
            this.busManagementStatus.setRemoteEnable(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 5)));
            this.busManagementStatus.setServiceRequest(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 6)));
            this.busManagementStatus.setAttention(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 7)));
            this.busManagementStatus.setEndOrIdentify(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 8)));
        }
        return this.busManagementStatus;
    }

    public final void setHandshakeStatus(HandshakeStatusStruct handshakeStatusStruct) throws TMException {
        GpibDll.displayError(this.createReadOnlyPropertyError("HandshakeStatus"));
    }

    public final HandshakeStatusStruct getHandshakeStatus() {
        if (this.status == 1) {
            this.handshakeStatus.setDataValid(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 1)));
            this.handshakeStatus.setNotDataAccepted(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 2)));
            this.handshakeStatus.setNotReadyForData(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 3)));
        }
        return this.handshakeStatus;
    }

    protected static String[] getGPIBAdaptors() {
        return gpibVendors;
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("GPIB" + this.boardIndex + "-" + this.primaryAddress) || this.name.equals("GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress);
    }

    @Override
    protected final void updateNameProperties() {
        if (this.nameStandardFormat) {
            if (this.secondaryAddress == 0) {
                this.setName("GPIB" + this.boardIndex + "-" + this.primaryAddress);
            } else {
                this.setName("GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress);
            }
        }
    }

    @Override
    protected final void setHardwareCompareBits(int n) throws TMException {
        int n2 = this.Set(this.handle, 4, n);
        if (n2 < 1) {
            GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
        }
    }

    @Override
    protected final void setHardwareEOIMode(boolean bl) throws TMException {
        int n = this.Set(this.handle, 1, this.bool2int(bl));
        if (n < 1) {
            GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected final void setHardwareEOSChar(int n) throws TMException {
        int n2 = this.Set(this.handle, 3, n);
        if (n2 < 1) {
            GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
        }
    }

    @Override
    protected final void setHardwareEOSMode(int n) throws TMException {
        int n2 = this.Set(this.handle, 2, n);
        if (n2 < 1) {
            GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
        }
    }

    @Override
    protected final int[] getValidSecondaryAddress() {
        int[] nArray = new int[]{96, 126};
        return nArray;
    }

    @Override
    protected void setHardwareTimeout(double d) throws TMException {
        int n = this.SetDouble(this.handle, 5, d);
        if (n < 1) {
            GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected double getHardwareTimeout() {
        return this.GetDouble(this.handle, 5);
    }

    public void configureProps(String string, String string2, int n, int n2, boolean bl) throws TMException {
        int n3 = string.lastIndexOf("mw" + string2.toLowerCase());
        String string3 = string.substring(0, n3 - 1);
        if (!this.isVendorSupported(string3, string2)) {
            TMStringUtil.error((String)"Specified ADAPTOR was not found or could not be loaded.");
        }
        this.boardIndex = n;
        this.primaryAddress = n2;
        this.type = "gpib";
        this.objectPolls = bl;
        this.displayName = "GPIB";
        this.name = this.secondaryAddress == 0 ? "GPIB" + this.boardIndex + "-" + this.primaryAddress : "GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress;
        this.info[0] = string;
        this.info[2] = string2;
        this.info[1] = GpibDll.jarVersion();
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"GPIB board vendor:", (String)this.info[2], "GPIB board index:", String.valueOf(this.boardIndex), "Primary address:", String.valueOf(this.primaryAddress)};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return "primary address " + this.primaryAddress + " (" + (String)this.info[2] + " board " + this.boardIndex + ")";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", GpibDll.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "GpibDllTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    protected boolean isInUse() {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof GpibDll)) continue;
            GpibDll gpibDll = (GpibDll)e;
            if (gpibDll.boardIndex != this.boardIndex || gpibDll.primaryAddress != this.primaryAddress || gpibDll.secondaryAddress != this.secondaryAddress || gpibDll.status != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void openHardware() throws TMException {
        if (this.isInUse()) {
            GpibDll.displayError(INUSE);
        }
        this.handle = this.Create(this.boardIndex, this.primaryAddress, this.secondaryAddress, this.timeout, this.eoiMode, false);
        if (this.handle < 1) {
            String string = this.TranslateErrorCode(this.handle, this.handle);
            if (string.indexOf("timeout") != -1) {
                string = POWERON;
            }
            GpibDll.displayError("GPIB: " + string);
        }
    }

    @Override
    protected void closeHardware() throws TMException {
        int n;
        if (this.objectPolls) {
            Poller.removeInstrument(this);
        }
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if ((n = this.Close(this.handle)) < 1) {
            GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
    }

    @Override
    public final Object[] constructorargs() {
        Object[] objectArray = new Object[]{this.info[0], new Integer(this.boardIndex), new Integer(this.primaryAddress)};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "gpib('" + this.info[2] + "', " + this.boardIndex + ", " + this.primaryAddress + ");";
    }

    @Override
    public String getConstructorDescription() {
        return "Vendor - " + this.info[2] + ", BoardIndex - " + this.boardIndex + ", PrimaryAddress - " + this.primaryAddress;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'BoardIndex', " + this.boardIndex + ", 'PrimaryAddress', " + this.primaryAddress + ", 'Tag', '" + this.tag + "');";
    }

    @Override
    public boolean supportsAsynchronousOperations() {
        return this.objectPolls;
    }

    @Override
    protected void hardwareStopAsync() throws TMException {
        this.oldTransferStatus = this.transferStatus;
        if (this.status == 0) {
            return;
        }
        int n = this.StopAsync(this.handle);
        if (n < 1) {
            GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected void hardwareFlushOutput() throws TMException {
        int n;
        this.oldTransferStatus = this.transferStatus;
        if (this.status == 1 && this.transferStatus == 2 && (n = this.StopAsync(this.handle)) < 1) {
            GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    public int getAsyncActionType(int n, int n2) {
        if (n == 1) {
            n = this.transferStatus == 2 ? 2 : (this.transferStatus == 1 ? 1 : (this.oldTransferStatus == 2 ? 2 : (this.oldTransferStatus == 1 ? 1 : -1)));
        }
        return n;
    }

    @Override
    protected void verifyWriteOperation(int n) throws TMException {
        if (this.transferStatus == 2) {
            GpibDll.displayError("An asynchronous write is already in progress.");
        } else if (this.transferStatus == 1) {
            GpibDll.displayError("An asynchronous read is already in progress.");
        }
    }

    @Override
    protected void verifyReadOperation() throws TMException {
        if (this.transferStatus == 2) {
            GpibDll.displayError("An asynchronous write is already in progress.");
        } else if (this.transferStatus == 1) {
            GpibDll.displayError("An asynchronous read is already in progress.");
        }
        this.transferStatus = 1;
    }

    @Override
    public int writeBinaryToHardwareAsync(byte[] byArray) {
        return this.WriteBinaryByteAsync(this, this.handle, byArray, byArray.length);
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        return this.Write(this.handle, string, string.length(), this.bool2int(this.eoiMode));
    }

    @Override
    protected int writeBytes(Object object, int n, int n2) {
        if (object instanceof byte[]) {
            return this.WriteBinaryByte(this.handle, (byte[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Byte) {
            return this.WriteBinaryByte(this.handle, GpibDll.object2byteArray(object), n, this.bool2int(this.eoiMode));
        }
        if (object instanceof short[]) {
            return this.WriteBinaryShort(this.handle, (short[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Short) {
            return this.WriteBinaryShort(this.handle, GpibDll.object2shortArray(object), n, this.bool2int(this.eoiMode));
        }
        if (object instanceof int[]) {
            return this.WriteBinaryInt(this.handle, (int[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Integer) {
            return this.WriteBinaryInt(this.handle, GpibDll.object2intArray(object), n, this.bool2int(this.eoiMode));
        }
        if (object instanceof float[]) {
            return this.WriteBinaryFloat(this.handle, (float[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Float) {
            return this.WriteBinaryFloat(this.handle, GpibDll.object2floatArray(object), n, this.bool2int(this.eoiMode));
        }
        if (object instanceof double[]) {
            return this.WriteBinaryDouble(this.handle, (double[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Double) {
            return this.WriteBinaryDouble(this.handle, GpibDll.object2doubleArray(object), n, this.bool2int(this.eoiMode));
        }
        return -1;
    }

    @Override
    public int readBinaryFromHardwareAsync(int n) {
        return this.ReadBinaryByteAsync(this, this.handle, n);
    }

    @Override
    protected Object[] readAsciiFromHardware(int n, double d) {
        Object[] objectArray = this.Read(this.handle, n);
        if (objectArray.length == 1) {
            return objectArray;
        }
        objectArray[1] = (Integer)objectArray[1] == 1 ? InputBuffer.REASONS[1] : InputBuffer.REASONS[0];
        return objectArray;
    }

    @Override
    protected Object[] readBinaryFromHardware(int n, double d) {
        return this.ReadBinary(this.handle, n, 0);
    }

    @Override
    public byte[] readAsynchronousDataFromHardware(int n) {
        return this.GetAsyncReadData(this.handle, n);
    }

    @Override
    protected String getErrorMessageFromHardware(int n) {
        return "GPIB: " + this.TranslateErrorCode(this.handle, n);
    }

    @Override
    protected int getSuccessValue() {
        return 1;
    }

    @Override
    protected void hardwareGPIBTrigger() throws TMException {
        int n = this.Trigger(this.handle);
        if (n < 1) {
            GpibDll.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    @Override
    protected void hardwareGPIBClear() throws TMException {
        int n = this.Clear(this.handle);
        if (n < 1) {
            GpibDll.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    public int spoll(int n) throws TMException {
        int n2 = 0;
        if (n == 0) {
            n2 = this.SPoll(this.handle);
            if (n2 < 0) {
                GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
            }
            return n2;
        }
        long l = GpibDll.currentNanoTicTime();
        while (!GpibDll.nanoTicTimeout(l, this.timeout)) {
            n2 = this.SPoll(this.handle);
            if (n2 >= 0) continue;
            GpibDll.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
        }
        return n2;
    }

    public Object[] hardwareInfo(String string, String string2, String string3) throws TMException {
        if (!this.isVendorSupported(string3, string2)) {
            TMStringUtil.error((String)"Specified ADAPTOR was not found or could not be loaded.");
        }
        this.hwinfo[0] = string;
        this.hwinfo[1] = GpibDll.jarVersion();
        this.hwinfo[2] = string2;
        this.hwinfo[5] = this.HwInfo(3);
        this.hwinfo[6] = this.HwInfo(4);
        int[] nArray = this.FindBoards();
        if (nArray == null) {
            return this.hwinfo;
        }
        this.hwinfo[3] = nArray;
        if (GpibDll.getScanCommands().size() == 0) {
            return this.hwinfo;
        }
        Object[] objectArray = this.FindInstruments(nArray, TMStringUtil.vector2StringArray(GpibDll.getScanCommands()));
        if (objectArray == null) {
            this.hwinfo[4] = null;
            return this.hwinfo;
        }
        int n = objectArray.length / 3;
        int[] nArray2 = new int[n];
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < objectArray.length; i += 3) {
            nArray2[n2] = (Integer)objectArray[i];
            stringArray[n2] = "gpib('" + string2 + "', " + nArray2[n2] + ", " + (Integer)objectArray[i + 1] + ");";
            ++n2;
        }
        this.hwinfo[4] = stringArray;
        nArray = null;
        objectArray = null;
        nArray2 = null;
        stringArray = null;
        return this.hwinfo;
    }

    public boolean isVendorSupported(String string, String string2) throws TMException {
        if ((string2 = string2.toLowerCase()).equals("test")) {
            return true;
        }
        String[] stringArray = GpibDll.findValidAdaptors(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String[] findValidAdaptors(String string) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        String[] stringArray = GpibDll.findValidGpib32AdaptorsToTestBasedOnInstalledGpib32Dll();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        String string2 = Instrument.extension();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                mwSystem.load((String)(string + FILESEP + stringArray[i] + string2));
                stringArray2[n++] = gpibVendors[AdaptorInfo.indexOf(gpibAdaptors, stringArray[i])];
                continue;
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        return stringArray3;
    }

    public static String[] findValidGpib32AdaptorsToTestBasedOnInstalledGpib32Dll() {
        if (gpib32DllVendor.equals("")) {
            return gpibAdaptors;
        }
        String[] stringArray = new String[gpibAdaptors.length];
        int n = 0;
        for (int i = 0; i < gpibAdaptors.length; ++i) {
            if (!AdaptorInfo.GPIB_32_IMPACT[i]) {
                stringArray[n++] = gpibAdaptors[i];
                continue;
            }
            if (gpib32DllVendor.equals(AdaptorInfo.GPIB_VENDORS[i])) {
                stringArray[n++] = gpibAdaptors[i];
                continue;
            }
            if (gpib32DllVendor.equals("none") && !AdaptorInfo.GPIB_VENDORS[i].equals("ni")) {
                stringArray[n++] = gpibAdaptors[i];
                continue;
            }
            if (AdaptorInfo.GPIB_VENDORS[i].equals("contec")) {
                stringArray[n++] = gpibAdaptors[i];
                continue;
            }
            if (gpib32DllVendor.equals("mcc") && AdaptorInfo.GPIB_VENDORS[i].equals("ics")) {
                stringArray[n++] = gpibAdaptors[i];
                continue;
            }
            if (gpib32DllVendor.equals("cec") && AdaptorInfo.GPIB_VENDORS[i].equals("keithley")) {
                stringArray[n++] = gpibAdaptors[i];
                continue;
            }
            if (!gpib32DllVendor.equals("ni") || !AdaptorInfo.GPIB_VENDORS[i].equals("mcc")) continue;
            stringArray[n++] = gpibAdaptors[i];
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public Object[] ObjectHardwareInfo() {
        this.info[3] = this.HwInfo(3);
        this.info[4] = this.HwInfo(4);
        return this.info;
    }

    @Override
    protected Object[] getHwInfoStruct() {
        this.ObjectHardwareInfo();
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < this.objectProps.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("BoardIndex")) {
                iCPropArray[i].setDefaultValue(new Integer(this.boardIndex));
                continue;
            }
            if (string.equals("CompareBits")) {
                int[] nArray = this.getValidCompareBits();
                if (nArray[0] != 8) continue;
                iCPropArray[i].setConstraintValue(comVals8);
                continue;
            }
            if (string.equals("Name")) {
                if (this.secondaryAddress == 0) {
                    iCPropArray[i].setDefaultValue("GPIB" + this.boardIndex + "-" + this.primaryAddress);
                    continue;
                }
                iCPropArray[i].setDefaultValue("GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress);
                continue;
            }
            if (!string.equals("PrimaryAddress")) continue;
            iCPropArray[i].setDefaultValue(new Integer(this.primaryAddress));
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidDisplay());
            return;
        }
        String string = LINESEP + "   GPIB Object Using " + this.info[2] + " Adaptor : " + this.name + LINESEP + LINESEP + this.gpibDisplay();
        System.out.println(string);
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay() + "    GPIB specific properties:" + LINESEP + "    BoardIndex" + LINESEP + "    CompareBits" + LINESEP + "    EOIMode: [ {on} | off ]" + LINESEP + "    EOSCharCode" + LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + LINESEP + "    PrimaryAddress" + LINESEP + "    SecondaryAddress" + LINESEP + " " + LINESEP;
    }

    abstract int Create(int var1, int var2, int var3, double var4, boolean var6, boolean var7);

    abstract int Close(int var1);

    abstract int[] FindBoards();

    abstract Object[] FindInstruments(int[] var1, String[] var2);

    abstract int Clear(int var1);

    abstract int Set(int var1, int var2, int var3);

    abstract int SetDouble(int var1, int var2, double var3);

    abstract double GetDouble(int var1, int var2);

    abstract int Write(int var1, String var2, int var3, int var4);

    abstract int WriteBinaryByte(int var1, byte[] var2, int var3, int var4);

    abstract int WriteBinaryShort(int var1, short[] var2, int var3, int var4);

    abstract int WriteBinaryInt(int var1, int[] var2, int var3, int var4);

    abstract int WriteBinaryFloat(int var1, float[] var2, int var3, int var4);

    abstract int WriteBinaryDouble(int var1, double[] var2, int var3, int var4);

    abstract int WriteBinaryChar(int var1, char[] var2, int var3, int var4);

    abstract Object[] Read(int var1, int var2);

    abstract Object[] ReadBinary(int var1, int var2, int var3);

    abstract int WriteBinaryByteAsync(Instrument var1, int var2, byte[] var3, int var4);

    abstract int ReadBinaryByteAsync(Instrument var1, int var2, int var3);

    abstract byte[] GetAsyncReadData(int var1, int var2);

    abstract int StopAsync(int var1);

    abstract int Trigger(int var1);

    abstract int Lines(int var1, int var2, int var3);

    abstract String HwInfo(int var1);

    abstract int SPoll(int var1);

    abstract String TranslateErrorCode(int var1, int var2);
}

