/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.I2C;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.util.DefaultSyncICProp;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.math.BigDecimal;
import java.util.ArrayList;

public class I2CAARDVARK
extends I2C {
    protected int fTargetPower = 1;
    static ICProp[] objectAardvarkProps = new ICProp[]{new ICProp("fTargetPower", "string", "enum", PULLUP_VALS, "both", "never", 1, 0)};

    public I2CAARDVARK(String string, String string2, int n, int n2) throws TMException {
        super(string, string2, n, n2);
        this.objectProps = DefaultSyncICProp.addObjectProps(this.objectProps, objectAardvarkProps);
        try {
            this.openHardware();
            this.fTargetPower = this.nativeGetTargetPower(this.fId);
            this.closeHardware();
        }
        catch (Exception exception) {
            this.fTargetPower = 0;
        }
    }

    public I2CAARDVARK(String string, String string2, int n) throws TMException {
        this(string, string2, n, 0);
    }

    public I2CAARDVARK() throws TMException {
        this.deleteInstrumentObject(this);
    }

    @Override
    protected String HwInfo(int n) {
        switch (n) {
            case 3: {
                return "aardvark" + this.aardvarkExtension();
            }
            case 4: {
                return "Total Phase I2C Driver";
            }
        }
        return null;
    }

    @Override
    public Object[] constructorargs() {
        Object[] objectArray = new Object[]{this.fConstructorArgs};
        return objectArray;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'BoardIndex'," + this.fBoardIndex + ",'RemoteAddress', " + this.fRemoteAddress + ", 'Tag', '" + this.tag + "');";
    }

    @Override
    protected String getHardwareBoardSerial(int n) {
        return new BigDecimal(this.nativeGetBoardSerial(n)).toPlainString();
    }

    @Override
    protected Integer[][] findAllBoards() {
        int n;
        Integer[][] integerArray = new Integer[2][];
        int[] nArray = this.nativeFindBoards();
        if (nArray == null) {
            return integerArray;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 32768) {
                arrayList2.add(nArray[n]);
                continue;
            }
            arrayList.add(nArray[n] - 32768);
        }
        integerArray[0] = arrayList.toArray(new Integer[arrayList.size()]);
        integerArray[1] = arrayList2.toArray(new Integer[arrayList2.size()]);
        for (n = 0; n < 2; ++n) {
            if (integerArray[n].length != 0) continue;
            integerArray[n] = null;
        }
        return integerArray;
    }

    @Override
    public boolean hasI2CSlaveReturnedAck() {
        byte[] byArray = new byte[]{0};
        Object[] objectArray = new Object[]{};
        try {
            objectArray = this.nativeWriteExtImpl(this.fId, this.fRemoteAddress, byArray, 0);
        }
        catch (TMException tMException) {
            // empty catch block
        }
        return (Integer)objectArray[1] == 0;
    }

    @Override
    public void updatePropsOnOpen() {
        try {
            this.setTargetPower(this.fTargetPower);
        }
        catch (Exception exception) {
            this.fTargetPower = 0;
        }
    }

    public int getTargetPower() throws TMException {
        if (this.status == 1) {
            return this.nativeGetTargetPower(this.fId);
        }
        return this.fTargetPower;
    }

    public void setTargetPower(int n) throws TMException {
        if (this.status == 1 && this.nativeSetTargetPower(this.fId, n) < 0) {
            I2CAARDVARK.displayError(sInstrumentResources.getString("Instrument.general.operationfailed"));
        } else {
            this.fTargetPower = n;
            this.postPropertyChangedEvent("TargetPower", PULLUP_VALS[this.fTargetPower]);
        }
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        super.updateObjectSpecificProperties(iCPropArray);
        for (int i = 0; i < iCPropArray.length; ++i) {
            if (!this.name.equals("TargetPower")) continue;
            iCPropArray[i].setDefaultValue(this.fTargetPower);
        }
    }

    @Override
    protected native int nativeOpen(int var1);

    @Override
    protected native int nativeClose(int var1);

    @Override
    protected native Object[] nativeReadImpl(int var1, long var2, int var4, int var5) throws TMException;

    @Override
    protected native int nativeWriteImpl(int var1, long var2, int var4, byte[] var5, int var6) throws TMException;

    protected native Object[] nativeWriteExtImpl(int var1, int var2, byte[] var3, int var4) throws TMException;

    protected native double nativeGetBoardSerial(int var1);

    @Override
    protected native int[] nativeFindBoards();

    @Override
    protected native String nativeGetErrorMessageFromHardware(int var1);

    @Override
    protected native double nativeSetBitRate(int var1, long var2, double var4);

    @Override
    protected native double nativeGetBitRate(int var1, long var2);

    @Override
    protected native int nativeGetPullupResistors(int var1);

    @Override
    protected native int nativeSetPullupResistors(int var1, int var2);

    protected native int nativeGetTargetPower(int var1);

    protected native int nativeSetTargetPower(int var1, int var2);

    @Override
    protected native int nativeSetHardwareTimeout(int var1, int var2, int var3);

    @Override
    protected native int nativeGetHardwareTimeout(int var1);

    private String aardvarkExtension() {
        String string = platform == 0 ? ".dll" : ".so";
        return string;
    }
}

