/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.InstrumentReader;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.util.Vector;

public class InputBuffer {
    private static byte[] BYTE_ARRAY = new byte[1];
    public static final int SIZE = 0;
    public static final int TERMINATOR = 1;
    public static final int EOILINE = 2;
    public static final int DATAGRAM = 3;
    public static final int DATAGRAM_TERM = 4;
    public static final Integer[] REASONS = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4)};
    private int maxBufferSize = 512;
    private int dataEnd = 0;
    private int dataStart = 0;
    private int bytesAvailable = 0;
    private byte[] buffer;
    private byte lastByte = (byte)-1;
    private Vector<ReadTerminator> nextRead = new Vector();
    private ReadTerminator lastReadTerminator = null;
    private int lastReadTerminatorType = 0;
    private InstrumentReader reader = null;

    public int[] packetPeek(byte[] byArray, int n, byte[] byArray2) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int n2 = byArray != null ? byArray.length : 0;
        for (int i = this.dataStart; !(i > this.dataStart + this.bytesAvailable - n2 || this.findHeader(byArray, i, nArray, nArray2) && this.findTerminator(byArray2, i, n, n2, nArray3)); ++i) {
        }
        return new int[]{nArray[0], nArray2[0], nArray3[0]};
    }

    private boolean findHeader(byte[] byArray, int n, int[] nArray, int[] nArray2) {
        if (this.findSequence(byArray, n)) {
            nArray[0] = 1;
            nArray2[0] = n - this.dataStart;
            return true;
        }
        return false;
    }

    private boolean findTerminator(byte[] byArray, int n, int n2, int n3, int[] nArray) {
        int n4 = n2 + n3;
        if (n4 > this.bytesAvailable) {
            return true;
        }
        int n5 = n + n4;
        if (this.findSequence(byArray, n5)) {
            nArray[0] = 1;
            return true;
        }
        return false;
    }

    private boolean findSequence(byte[] byArray, int n) {
        int n2 = byArray != null ? byArray.length : 0;
        for (int i = 0; i < n2; ++i) {
            if (this.buffer[(n + i) % this.maxBufferSize] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public InputBuffer(InstrumentReader instrumentReader) {
        this.buffer = new byte[this.maxBufferSize];
        this.reader = instrumentReader;
    }

    public void dispose() {
        this.buffer = null;
        this.disposeNextRead();
        this.nextRead = null;
    }

    public Vector<ReadTerminator> getNextRead() {
        return this.nextRead;
    }

    public void setSize(int n) {
        this.maxBufferSize = n;
        this.buffer = null;
        this.disposeNextRead();
        this.nextRead = null;
        this.dataEnd = 0;
        this.dataStart = 0;
        this.bytesAvailable = 0;
        this.buffer = new byte[this.maxBufferSize];
        this.nextRead = new Vector();
    }

    public void flush() {
        this.setSize(this.maxBufferSize);
    }

    public String toString() {
        return "Start: " + this.dataStart + " End: " + this.dataEnd;
    }

    public int getBytesAvailable() {
        return this.bytesAvailable;
    }

    public boolean isReadComplete(int n) {
        for (int i = 0; i < this.nextRead.size(); ++i) {
            ReadTerminator readTerminator = this.nextRead.elementAt(i);
            if (readTerminator.getType() != n) continue;
            return true;
        }
        return false;
    }

    public boolean isReadComplete(int n, int n2) {
        for (int i = 0; i < this.nextRead.size(); ++i) {
            ReadTerminator readTerminator = this.nextRead.elementAt(i);
            int n3 = readTerminator.getType();
            if (n3 != n && n3 != n2) continue;
            return true;
        }
        return false;
    }

    public int getNextSize() {
        if (this.nextRead.size() == 0) {
            return 0;
        }
        return this.nextRead.firstElement().getNumberOfBytes();
    }

    public int getNextReason() {
        if (this.nextRead.size() == 0) {
            return 0;
        }
        return this.nextRead.firstElement().getType();
    }

    public Object getNextUserData() {
        if (this.nextRead.size() == 0) {
            return null;
        }
        return this.nextRead.firstElement().getUserData();
    }

    public Vector<Object> getUserData(int n) {
        if (this.nextRead.size() == 0) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        for (int i = 0; i < this.nextRead.size(); ++i) {
            ReadTerminator readTerminator = this.nextRead.elementAt(i);
            vector.addElement(readTerminator.getUserData());
            if ((n2 += readTerminator.getNumberOfBytes()) <= n) continue;
            return vector;
        }
        return null;
    }

    public int getByteCountToNextDatagram() {
        if (this.nextRead.size() == 0) {
            return -1;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nextRead.size(); ++i) {
            ReadTerminator readTerminator = this.nextRead.elementAt(i);
            n += readTerminator.getNumberOfBytes();
            n2 = readTerminator.getType();
            if (n2 != 3 && n2 != 4) continue;
            return n;
        }
        return -1;
    }

    public byte getLastByte() {
        return this.lastByte;
    }

    public synchronized void addData(byte by) {
        InputBuffer.BYTE_ARRAY[0] = by;
        this.addData(BYTE_ARRAY, 0, null, 0, 1);
    }

    public synchronized void addData(byte[] byArray) {
        this.addData(byArray, 0, null, 0, byArray.length);
    }

    public synchronized void addData(byte by, int n) {
        InputBuffer.BYTE_ARRAY[0] = by;
        this.addData(BYTE_ARRAY, n, null, 0, 1);
    }

    public synchronized void addData(byte by, int n, Object object) {
        InputBuffer.BYTE_ARRAY[0] = by;
        this.addData(BYTE_ARRAY, n, object, 0, 1);
    }

    public synchronized void addData(byte[] byArray, int n) {
        this.addData(byArray, n, null, 0, byArray.length);
    }

    public synchronized void addData(byte[] byArray, int n, Object object) {
        this.addData(byArray, n, object, 0, byArray.length);
    }

    public synchronized void addData(byte[] byArray, int n, Object object, int n2, int n3) {
        if (byArray.length == 0) {
            return;
        }
        try {
            int n4 = this.bytesAvailable;
            this.addDataToBuffer(byArray, n2, n3);
            int n5 = this.bytesAvailable - n4;
            if (this.nextRead.size() == 0) {
                this.lastReadTerminator = new ReadTerminator(n5, n, object);
                this.lastReadTerminatorType = n;
                this.nextRead.add(this.lastReadTerminator);
                return;
            }
            if (this.lastReadTerminatorType == 0) {
                this.lastReadTerminator.addNumberOfBytes(n5);
                if (n != 0) {
                    this.lastReadTerminatorType = n;
                    this.lastReadTerminator.setType(n);
                }
                if (object != null) {
                    this.lastReadTerminator.setUserData(object);
                }
            } else {
                this.lastReadTerminator = new ReadTerminator(n5, n, object);
                this.lastReadTerminatorType = n;
                this.nextRead.add(this.lastReadTerminator);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            new TMException("InputBuffer exceeded available memory.");
        }
    }

    private synchronized void addDataToBuffer(byte[] byArray, int n, int n2) {
        int n3 = this.maxBufferSize - this.bytesAvailable;
        if (n3 == 0) {
            return;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        int n4 = this.maxBufferSize - this.dataEnd;
        boolean bl = false;
        if (n2 > n4) {
            bl = true;
        }
        if (bl) {
            int n5 = n2 - n4;
            if (byArray.length == 1) {
                this.buffer[0] = byArray[0];
            } else {
                System.arraycopy(byArray, n, this.buffer, this.dataEnd, n4);
                System.arraycopy(byArray, n + n4, this.buffer, 0, n5);
            }
            this.dataEnd = n5;
        } else if (byArray.length == 1) {
            this.buffer[this.dataEnd] = byArray[0];
            ++this.dataEnd;
        } else {
            System.arraycopy(byArray, n, this.buffer, this.dataEnd, n2);
            this.dataEnd += n2;
        }
        this.lastByte = byArray[byArray.length - 1];
        this.bytesAvailable += n2;
        this.reader.updateBytesAvailable(this.bytesAvailable);
        byArray = null;
    }

    public synchronized byte[] getData(int n) {
        if (this.nextRead.size() == 0) {
            return null;
        }
        Object[] objectArray = this.getDataWithInfo(n);
        byte[] byArray = (byte[])objectArray[0];
        objectArray = null;
        return byArray;
    }

    public synchronized Object[] getDataWithInfo(int n) {
        if (this.nextRead.size() == 0) {
            return null;
        }
        ReadTerminator readTerminator = this.nextRead.firstElement();
        int n2 = readTerminator.getNumberOfBytes();
        int n3 = readTerminator.getType();
        boolean bl = false;
        if (n2 <= n) {
            n = n2;
            this.nextRead.removeElementAt(0);
            readTerminator.setUserData(null);
            readTerminator = null;
        } else {
            bl = true;
            n3 = 0;
        }
        byte[] byArray = this.getDataFromBuffer(n);
        if (bl) {
            readTerminator.decrementNumberOfBytes(byArray.length);
        }
        Object[] objectArray = new Object[]{byArray, REASONS[n3]};
        return objectArray;
    }

    public synchronized Object[] getDataWithInfoAndUserData(int n) {
        if (this.nextRead.size() == 0) {
            return null;
        }
        ReadTerminator readTerminator = this.nextRead.firstElement();
        int n2 = readTerminator.getNumberOfBytes();
        int n3 = readTerminator.getType();
        Object object = readTerminator.getUserData();
        boolean bl = false;
        if (n2 <= n) {
            n = n2;
            this.nextRead.removeElementAt(0);
            readTerminator.setUserData(null);
            readTerminator = null;
        } else {
            bl = true;
            n3 = 0;
        }
        byte[] byArray = this.getDataFromBuffer(n);
        if (bl) {
            readTerminator.decrementNumberOfBytes(byArray.length);
        }
        Object[] objectArray = new Object[]{byArray, REASONS[n3], object};
        return objectArray;
    }

    public synchronized byte[] getData() {
        if (this.nextRead.size() == 0) {
            return null;
        }
        Object[] objectArray = this.getDataWithInfo();
        byte[] byArray = (byte[])objectArray[0];
        objectArray = null;
        return byArray;
    }

    public synchronized Object[] getDataAcrossBlocks(int n) {
        Object[] objectArray = this.getDataWithInfo(n);
        byte[] byArray = (byte[])objectArray[0];
        n -= byArray.length;
        while (n > 0 && this.nextRead.size() != 0) {
            objectArray = this.getDataWithInfo(n);
            byte[] byArray2 = (byte[])objectArray[0];
            n -= byArray2.length;
            byArray = this.concat(byArray, byArray2);
        }
        objectArray[0] = byArray;
        return objectArray;
    }

    protected byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public synchronized Object[] getDataWithInfo() {
        if (this.nextRead.size() == 0) {
            return null;
        }
        ReadTerminator readTerminator = this.nextRead.firstElement();
        int n = readTerminator.getNumberOfBytes();
        int n2 = readTerminator.getType();
        this.nextRead.removeElementAt(0);
        readTerminator.setUserData(null);
        readTerminator = null;
        Object[] objectArray = new Object[]{this.getDataFromBuffer(n), REASONS[n2]};
        return objectArray;
    }

    public synchronized byte[] getAllData() {
        this.disposeNextRead();
        this.nextRead = new Vector();
        return this.getDataFromBuffer(this.bytesAvailable);
    }

    private synchronized byte[] getDataFromBuffer(int n) {
        if (this.bytesAvailable == 0) {
            return null;
        }
        if (n > this.bytesAvailable) {
            n = this.bytesAvailable;
        }
        boolean bl = false;
        if (this.dataStart + n > this.maxBufferSize) {
            bl = true;
        }
        byte[] byArray = new byte[n];
        if (bl) {
            System.arraycopy(this.buffer, this.dataStart, byArray, 0, this.maxBufferSize - this.dataStart);
            System.arraycopy(this.buffer, 0, byArray, this.maxBufferSize - this.dataStart, n - (this.maxBufferSize - this.dataStart));
        } else {
            System.arraycopy(this.buffer, this.dataStart, byArray, 0, n);
        }
        this.dataStart += n;
        if (this.dataStart >= this.maxBufferSize) {
            this.dataStart -= this.maxBufferSize;
        }
        this.bytesAvailable -= n;
        this.reader.updateBytesAvailable(this.bytesAvailable);
        return byArray;
    }

    private void disposeNextRead() {
        if (this.nextRead == null) {
            return;
        }
        for (int i = this.nextRead.size() - 1; i > 0; --i) {
            ReadTerminator readTerminator = this.nextRead.elementAt(i);
            readTerminator.setUserData(null);
            readTerminator = null;
        }
    }

    class ReadTerminator {
        private int numberOfBytes = 0;
        private int type = 0;
        private Object userData = null;

        public ReadTerminator(int n, int n2, Object object) {
            this.numberOfBytes = n;
            this.type = n2;
            this.userData = object;
        }

        public String toString() {
            return "Size: " + this.numberOfBytes + " Type: " + this.type;
        }

        public int getNumberOfBytes() {
            return this.numberOfBytes;
        }

        public void addNumberOfBytes(int n) {
            this.numberOfBytes += n;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public Object getUserData() {
            return this.userData;
        }

        public void setUserData(Object object) {
            this.userData = object;
        }

        public void decrementNumberOfBytes(int n) {
            this.numberOfBytes -= n;
        }
    }
}

