/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.InstrumentAsync;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Vector;

public class RsibVisa
extends InstrumentAsync
implements ActionListener {
    private static final int EOIMODE = 100;
    private static final int TIMEOUT = 104;
    protected static final int SUCCESS = 0;
    protected static final int ADAPTOR_DLL_NAME = 0;
    protected static final int ADAPTOR_DLL_VERSION = 1;
    protected static final int ADAPTOR_NAME = 2;
    protected static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription", "vendordriverversion"};
    protected static final String HW_NOT_AVAILABLE_ERROR = "Use INSTRHWINFO for a list of available configurations. Use INSTRFIND to " + LINESEP + "determine if other instrument objects are connected to the requested instrument.";
    protected String alias = "";
    protected boolean eoiMode = true;
    protected String remoteHost = "";
    protected String rsrcName = "";
    protected VISA visa;
    protected String visaName;
    protected boolean useAlias;
    private int defaultRM;
    private Object[] info = new Object[6];
    private int readId = 0;
    private int writeId = 0;
    private int oldTransferStatus = 0;
    protected static final String[] dModeVals = new String[]{"byte"};
    protected static final Object[] comVals = new Object[]{new Double(8.0)};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Alias", "string", "none", "", "", "always", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "byte", "whileOpen", 0, 0), new ICProp("EOIMode", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("RemoteHost", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("RsrcName", "string", "none", "", "", "always", 1, 0), new ICProp("Type", "string", "none", "", "visa-rsib", "always", 0, 0)};

    public RsibVisa() {
        this.deleteInstrumentObject(this);
    }

    public RsibVisa(String string, String string2, String string3, String string4) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            RsibVisa.displayError("The Instrument Control Toolbox license check failed when trying to execute: 'visa'.");
        }
        try {
            this.rsrcName = this.visaName = string3;
            try {
                this.parseName(this.visaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alias = string4;
            this.useAlias = !this.alias.equals("");
            this.info[0] = string + FILESEP + string2;
            this.info[1] = RsibVisa.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject("rs", (String)this.info[0]);
            this.name = "VISA-RSIB-" + this.remoteHost;
            this.type = "visa-rsib";
            this.displayName = "VISA-RSIB";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("VISA-RSIB-" + this.remoteHost);
    }

    protected void updateNameProperties() {
        this.rsrcName = "RSIB::" + this.remoteHost + "::INSTR";
        if (this.nameStandardFormat) {
            this.setName("VISA-RSIB-" + this.remoteHost);
        }
    }

    private void parseName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return;
        }
        String string2 = string.substring(n + 2, string.length());
        if ((n = string2.indexOf("::")) == -1) {
            return;
        }
        this.remoteHost = string2.substring(0, n);
        if (!(string2 = string2.substring(n + 2, string2.length())).toUpperCase().equals("INSTR")) {
            return;
        }
        this.rsrcName = "RSIB::" + this.remoteHost + "::INSTR";
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "EOIMode", this.bool2OnOff(this.eoiMode));
        if (this.bytesAvailableFcnMode == 1) {
            vector.addElement((Comparable<?>)((Object)"BytesAvailableFcnMode"));
            vector.addElement((Comparable<?>)((Object)"byte"));
        }
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public void setAlias(String string) throws TMException {
        RsibVisa.displayError(this.createReadOnlyPropertyError("Alias"));
    }

    public String getAlias() {
        return this.alias;
    }

    public final void setEOIMode(boolean bl) throws TMException {
        if (this.status == 0) {
            this.eoiMode = bl;
            this.postPropertyChangedEvent("EOIMode", this.bool2OnOff(this.eoiMode));
            return;
        }
        try {
            this.setHardwareEOIMode(bl);
            this.eoiMode = bl;
            this.postPropertyChangedEvent("EOIMode", this.bool2OnOff(this.eoiMode));
        }
        catch (Exception exception) {
            RsibVisa.displayError(exception.getMessage());
        }
    }

    public final boolean getEOIMode() {
        return this.eoiMode;
    }

    public final void setRemoteHost(String string) throws TMException {
        if (this.useAlias) {
            RsibVisa.displayError("RemoteHost cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            RsibVisa.displayError("RemoteHost cannot be set while OBJ is open.");
        }
        this.remoteHost = string;
        this.postPropertyChangedEvent("RemoteHost", this.remoteHost);
        this.updateNameProperties();
    }

    public final String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRsrcName(String string) throws TMException {
        RsibVisa.displayError(this.createReadOnlyPropertyError("RsrcName"));
    }

    public String getRsrcName() {
        return this.rsrcName;
    }

    protected void setHardwareEOIMode(boolean bl) throws TMException {
        this.visa.setProperty(this.handle, 100, this.bool2int(bl));
    }

    @Override
    protected void setHardwareTimeout(double d) throws TMException {
        this.visa.setHardwareTimeout(this.handle, d, 104);
    }

    @Override
    protected double getHardwareTimeout() {
        int n = this.visa.Get(this.handle, 104);
        return (double)n / 1000.0;
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"Remote host:", this.remoteHost};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return this.remoteHost;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", RsibVisa.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "RsibVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    protected void openHardware() throws TMException {
        String string;
        int[] nArray;
        if (this.isInUse()) {
            RsibVisa.displayError("The specified configuration: " + this.rsrcName + " is not available.  " + LINESEP + HW_NOT_AVAILABLE_ERROR);
        }
        if ((nArray = this.visa.Create(this, string = this.rsrcName)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
        } else {
            RsibVisa.displayError("Could not open VISA object. Use INSTRHWINFO for a list of available configurations.");
        }
        Object[] objectArray = this.visa.GetAliasInfo(this.visaName);
        if (objectArray != null) {
            this.parseName((String)objectArray[1]);
        }
    }

    protected boolean isInUse() {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof RsibVisa)) continue;
            RsibVisa rsibVisa = (RsibVisa)e;
            if (!rsibVisa.remoteHost.equals(this.remoteHost) || rsibVisa.status != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updatePropsOnOpen() throws TMException {
        this.setHardwareEOIMode(this.eoiMode);
        this.setHardwareTimeout(this.timeout);
        this.timeout = this.getHardwareTimeout();
    }

    @Override
    public boolean supportsAsynchronousOperations() {
        return false;
    }

    @Override
    protected void closeHardware() throws TMException {
        int n;
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if ((n = this.visa.Close(this.handle, this.defaultRM)) < 0) {
            RsibVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
    }

    @Override
    protected void hardwareStopAsync() {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 1: {
                this.visa.StopAsync(this.handle, this.readId);
                break;
            }
            case 2: {
                this.visa.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    public final Object[] constructorargs() {
        String string = (String)this.info[0];
        int n = string.lastIndexOf(FILESEP);
        Object[] objectArray = new Object[]{string.substring(0, n), string.substring(n + 1), this.rsrcName, this.alias};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "visa('" + this.info[2] + "', '" + this.rsrcName + "');";
    }

    @Override
    public String getConstructorDescription() {
        return "Vendor - " + this.info[2] + ", Resource Name - " + this.rsrcName;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'RsrcName', '" + this.rsrcName + "', 'Tag', '" + this.tag + "');";
    }

    @Override
    protected void hardwareFlushInput() {
    }

    @Override
    protected void hardwareFlushOutput() throws TMException {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 2: {
                this.visa.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    protected void verifyWriteOperation(int n) throws TMException {
        if (n == 1) {
            RsibVisa.displayError("Asynchronous operation is not supported for VISA-RSIB objects.");
        }
    }

    @Override
    protected void verifyReadOperation() throws TMException {
        RsibVisa.displayError("Asynchronous operation is not supported for VISA-RSIB objects.");
    }

    @Override
    public int getAsyncActionType(int n, int n2) {
        if (n == 0) {
            n = this.transferStatus == 2 ? 2 : (this.transferStatus == 1 ? 0 : (this.oldTransferStatus == 2 ? 2 : (this.oldTransferStatus == 1 ? 0 : -1)));
        }
        return n;
    }

    @Override
    protected String getAsciiMessage(Object[] objectArray) {
        return this.getAsciiMessage(objectArray, 0, 0);
    }

    @Override
    protected String getAsciiMessage(String string) {
        return this.getAsciiMessage(string, 0, 0);
    }

    @Override
    protected void updateWriteTransferStatus(boolean bl) {
        this.transferStatus = bl ? 2 : 0;
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        return this.visa.Write(this.handle, string, string.length());
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) {
        if (platformByteOrder != this.byteOrder) {
            Object object2 = null;
            try {
                object2 = BinarySwapBytes.swap(object, n2, n);
            }
            catch (Exception exception) {
                return -1;
            }
            object = object2;
        }
        return this.visa.writeBytes(this.handle, object, n, n2);
    }

    @Override
    public int writeBinaryToHardwareAsync(byte[] byArray) {
        int n = this.visa.WriteBinaryByteAsync(this.handle, byArray, byArray.length);
        if (n >= 0) {
            this.writeId = n;
        }
        return n;
    }

    @Override
    protected String removeTerminator(String string) {
        return this.removeTerminator(string, 0, 0);
    }

    protected int getReadTerminatorSize() {
        return 1;
    }

    @Override
    protected Object[] readAsciiFromHardware(int n, double d) {
        return this.visa.Read(this.handle, n);
    }

    @Override
    protected Object[] readBinaryFromHardware(int n, double d) {
        return this.visa.ReadBinary(this.handle, n, 0);
    }

    @Override
    public byte[] readAsynchronousDataFromHardware(int n) {
        return this.visa.GetAsyncReadData(this.handle, n);
    }

    @Override
    public int readBinaryFromHardwareAsync(int n) {
        int n2 = this.visa.ReadBinaryByteAsync(this.handle, n);
        if (n2 >= 0) {
            this.readId = n2;
        }
        return n2;
    }

    @Override
    protected int okToGenerateTerminatorBytesAvailableEvent(byte[] byArray) {
        return 0;
    }

    @Override
    protected String getErrorMessageFromHardware(int n) {
        return "VISA: " + this.visa.TranslateErrorCode(this.handle, n);
    }

    @Override
    protected int getSuccessValue() {
        return 0;
    }

    @Override
    protected String wasAsciiReadSuccessful(String string, int n, int n2) {
        String string2 = "";
        switch (n) {
            case 0: {
                if (n2 != 0 || string.length() != this.inputBufferSize) break;
                string2 = "The input buffer was filled before the EOI line was asserted.";
                break;
            }
            default: {
                if (string.length() == n) break;
                string2 = "The EOI line was asserted before SIZE values were available.";
            }
        }
        return string2;
    }

    @Override
    protected String wasBinaryReadSuccessful(int n, int n2, String string, int n3) {
        if (!string.equals("")) {
            return string;
        }
        if (n < n2) {
            return "The EOI line was asserted before SIZE values were available.";
        }
        return "";
    }

    @Override
    protected String getTimeoutMessage(int n, int n2) {
        if (n == 0) {
            return "A timeout occurred before the EOI line was asserted.";
        }
        return "A timeout occurred before the EOI line was asserted or SIZE values were available.";
    }

    protected void hardwareGPIBTrigger() throws TMException {
        int n = this.visa.Trigger(this.handle);
        if (n < 0) {
            RsibVisa.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    protected void hardwareGPIBClear() throws TMException {
        int n = this.visa.Clear(this.handle);
        if (n < 0) {
            RsibVisa.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    public char spoll(int n) throws TMException {
        return this.visa.spoll(this.handle, n, this.getHardwareTimeout());
    }

    public Object ObjectHardwareInfo() {
        return this.visa.ObjectHardwareInfo(this.info, this.handle);
    }

    @Override
    protected Object[] getHwInfoStruct() {
        this.ObjectHardwareInfo();
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("VISA-RSIB-" + this.remoteHost);
                continue;
            }
            if (string.equals("RemoteHost")) {
                iCPropArray[i].setDefaultValue(this.remoteHost);
                continue;
            }
            if (string.equals("RsrcName")) {
                iCPropArray[i].setDefaultValue(this.rsrcName);
                continue;
            }
            if (!string.equals("Alias")) continue;
            iCPropArray[i].setDefaultValue(this.alias);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidDisplay());
            return;
        }
        String string = LINESEP + "   VISA-RSIB Object Using " + this.info[2] + " Adaptor : " + this.name + LINESEP + LINESEP + "   Communication Address " + LINESEP + "      RemoteHost:         " + this.remoteHost + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
        System.out.println(string);
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay() + "    VISA-RSIB specific properties:" + LINESEP + "    EOIMode: [ {on} | off ]" + LINESEP + "    RemoteHost" + LINESEP + " " + LINESEP;
    }
}

