/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.ASCIITableConverter;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.Serial;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

public final class SerialVisa
extends Serial
implements ActionListener,
AutoConvertStringToMatlabChar {
    private static final int BAUDRATE = 0;
    private static final int DATABITS = 1;
    private static final int PARITY = 2;
    private static final int STOPBITS = 3;
    private static final int FLOWCONTROL = 4;
    private static final int TERMINATOR = 5;
    private static final int DATA_TERMINAL_READY = 6;
    private static final int REQUEST_TO_SEND = 7;
    private static final int TIMEOUT = 8;
    private static final int CARRIER_DETECT = 9;
    private static final int CLEAR_TO_SEND = 10;
    private static final int DATA_SET_READY = 11;
    private static final int RING_INDICATOR = 12;
    private static final int DATA_AVAILABLE = 13;
    private static final int ADAPTOR_DLL_NAME = 0;
    private static final int ADAPTOR_DLL_VERSION = 1;
    private static final int ADAPTOR_NAME = 2;
    public static final int VENDOR_DRIVER_NAME = 3;
    public static final int VENDOR_DRIVER_DESCRIPTION = 4;
    public static final int VENDOR_DRIVER_VERSION = 5;
    private static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription", "vendordriverversion"};
    private static final int FLOW_CTRL_NONE = 0;
    private static final int FLOW_CTRL_SOFT = 1;
    private static final int FLOW_CTRL_HARD = 2;
    private static final int SUCCESS = 0;
    private String alias = "";
    private String rsrcName = "";
    private VISA visa;
    protected String visaName;
    protected boolean useAlias;
    private int defaultRM;
    private Object[] info = new Object[6];
    private int writeId = 0;
    private static final Object[] StopVals = new Object[]{new Double(1.0), new Double(2.0)};
    private static final Object[] AsciiVals = new Object[]{TermVals};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Alias", "string", "none", "", "", "always", 1, 0), new ICProp("BaudRate", "double", "none", "", new Integer(9600), "never", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "terminator", "whileOpen", 0, 0), new ICProp("DataBits", "double", "bounded", dBitVals, new Integer(8), "never", 1, 0), new ICProp("DataTerminalReady", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("FlowControl", "string", "enum", flowVals, "none", "never", 1, 0), new ICProp("Parity", "string", "enum", ParVals, "none", "never", 1, 0), new ICProp("PinStatus", "struct", "none", null, pss, "always", 1, 0), new ICProp("Port", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("ReadAsyncMode", "string", "enum", AsyncVals, "continuous", "never", 1, 0), new ICProp("RequestToSend", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("RsrcName", "string", "none", "", "", "always", 1, 0), new ICProp("StopBits", "double", "bounded", StopVals, new Integer(1), "never", 1, 0), new ICProp("Terminator", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("Type", "string", "none", "", "visa-serial", "always", 0, 0)};

    public SerialVisa() {
        this.deleteInstrumentObject(this);
    }

    public SerialVisa(String string, String string2, String string3, String string4) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            SerialVisa.displayError("The Instrument Control Toolbox license check failed when trying to execute: 'visa'.");
        }
        try {
            this.rsrcName = this.visaName = string3;
            try {
                this.parseName(this.visaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alias = string4;
            this.useAlias = !this.alias.equals("");
            this.info[0] = string + FILESEP + string2;
            this.info[1] = SerialVisa.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.type = "visa-serial";
            this.name = "VISA-Serial-" + this.port;
            this.displayName = "VISA-Serial";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    public String getInspectorToolbarObjectName() {
        return "VISA-serial";
    }

    public void setAlias(String string) throws TMException {
        SerialVisa.displayError(this.createReadOnlyPropertyError("Alias"));
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setPort(String string) throws TMException {
        if (this.useAlias) {
            SerialVisa.displayError("Port cannot be set for a VISA object that has an alias.");
        }
        super.setPort(string);
    }

    public void setRsrcName(String string) throws TMException {
        SerialVisa.displayError(this.createReadOnlyPropertyError("RsrcName"));
    }

    public String getRsrcName() {
        return this.rsrcName;
    }

    @Override
    protected void setHardwareBaudRate(int n) throws TMException {
        int n2 = this.visa.Set(this.handle, 0, n);
        if (n2 < 0) {
            SerialVisa.displayError("VISA: BaudRate could not be set to the specified value.");
        }
    }

    @Override
    protected void setHardwareDataBits(int n) throws TMException {
        int n2 = this.visa.Set(this.handle, 1, n);
        if (n2 < 0) {
            SerialVisa.displayError("VISA: DataBits could not be set to the specified value.");
        }
    }

    @Override
    protected void setHardwareDataTerminalReady(boolean bl) throws TMException {
        int n = this.visa.Set(this.handle, 6, this.bool2int(bl));
        if (n < 0) {
            SerialVisa.displayError("VISA: DataTerminalReady could not be set to the specified value.");
        }
    }

    @Override
    protected boolean getHardwareDataTerminalReady() {
        return this.int2bool(this.visa.Get(this.handle, 6));
    }

    @Override
    protected void setHardwareFlowControl(int n) throws TMException {
        int n2 = 1;
        switch (n) {
            case 0: {
                n2 = this.visa.Set(this.handle, 4, 0);
                break;
            }
            case 1: {
                n2 = this.visa.Set(this.handle, 4, 2);
                break;
            }
            case 2: {
                n2 = this.visa.Set(this.handle, 4, 1);
            }
        }
        if (n2 < 0) {
            SerialVisa.displayError("VISA: FlowControl could not be set to the specified value.");
        }
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("VISA-Serial-" + this.port);
    }

    @Override
    protected void setHardwareParity(int n) throws TMException {
        int n2 = this.visa.Set(this.handle, 2, n);
        if (n2 < 0) {
            SerialVisa.displayError("VISA: Parity could not be set to the specified value.");
        }
    }

    @Override
    protected String getHardwareCarrierDetect() {
        return this.int2OnOff(this.visa.Get(this.handle, 9));
    }

    @Override
    protected String getHardwareClearToSend() {
        return this.int2OnOff(this.visa.Get(this.handle, 10));
    }

    @Override
    protected String getHardwareDataSetReady() {
        return this.int2OnOff(this.visa.Get(this.handle, 11));
    }

    @Override
    protected String getHardwareRingIndicator() {
        return this.int2OnOff(this.visa.Get(this.handle, 12));
    }

    @Override
    protected void setHardwarePort() {
        this.rsrcName = this.port.toUpperCase() + "::INSTR";
        if (this.nameStandardFormat) {
            this.setName("VISA-Serial-" + this.port);
        }
    }

    @Override
    protected void setHardwareRequestToSend(boolean bl) throws TMException {
        int n = this.visa.Set(this.handle, 7, this.bool2int(bl));
        if (n < 0) {
            SerialVisa.displayError("VISA: RequestToSend could not be set to the specified value.");
        }
    }

    @Override
    protected boolean getHardwareRequestToSend() {
        return this.int2bool(this.visa.Get(this.handle, 7));
    }

    @Override
    protected void setHardwareStopBits(double d) throws TMException {
        int n = this.visa.Set(this.handle, 3, (int)d * 10);
        if (n < 0) {
            SerialVisa.displayError("VISA: StopBits could not be set to the specified value.");
        }
    }

    @Override
    protected double[] getValidStopBits() {
        double[] dArray = new double[]{1.0, 2.0};
        return dArray;
    }

    @Override
    protected void setHardwareTerminator(int n) throws TMException {
        int n2 = this.visa.Set(this.handle, 5, n);
        if (n2 < 0) {
            SerialVisa.displayError("VISA: Terminator could not be set to the specified value.");
        }
    }

    @Override
    protected int[] getTerminatorInteger(MLArrayRef mLArrayRef) throws TMException {
        return ASCIITableConverter.convertTerminatorObjectToInt(mLArrayRef, false);
    }

    @Override
    protected void setHardwareTimeout(double d) throws TMException {
        this.visa.setHardwareTimeout(this.handle, d, 8);
    }

    @Override
    protected double getHardwareTimeout() {
        int n = this.visa.Get(this.handle, 8);
        return (double)n / 1000.0;
    }

    private void parseName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return;
        }
        String string2 = n == 4 ? "ASRL1" : string.substring(0, n);
        int n2 = this.str2num(string2.substring(4));
        if (n2 < 0) {
            return;
        }
        if (!string.substring(n + 2, string.length()).toUpperCase().equals("INSTR")) {
            return;
        }
        this.rsrcName = string2 + "::INSTR";
        this.port = string2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", SerialVisa.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "SerialVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    protected void openHardware() throws TMException {
        int[] nArray;
        if (SerialVisa.isInUse(this.port)) {
            SerialVisa.displayError("The specified configuration: " + this.rsrcName + " is not available. " + LINESEP + "Use INSTRHWINFO for a list of available ports. Use INSTRFIND to determine" + LINESEP + "if other instrument objects are connected to the requested instrument.");
        }
        if ((nArray = this.visa.Create(this, this.rsrcName)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
        } else {
            SerialVisa.displayError("The specified configuration: " + this.rsrcName + " is not available. " + LINESEP + "Use INSTRHWINFO for a list of available ports. Use INSTRFIND to determine" + LINESEP + "if other instrument objects are connected to the requested instrument.");
        }
        Object[] objectArray = this.visa.GetAliasInfo(this.visaName);
        if (objectArray != null) {
            this.parseName((String)objectArray[1]);
        }
    }

    @Override
    protected void closeHardware() throws TMException {
        Poller.removeInstrument(this);
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        try {
            this.setHardwareFlowControl(0);
        }
        catch (TMException tMException) {
            // empty catch block
        }
        int n = this.visa.Close(this.handle, this.defaultRM);
        if (n < 0) {
            SerialVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    public static boolean isInUse(String string) {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof SerialVisa)) continue;
            SerialVisa serialVisa = (SerialVisa)e;
            if (!serialVisa.port.equals(string) || serialVisa.status != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        this.terminatorObject.dispose();
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
    }

    @Override
    public final Object[] constructorargs() {
        String string = (String)this.info[0];
        int n = string.lastIndexOf(FILESEP);
        Object[] objectArray = new Object[]{string.substring(0, n), string.substring(n + 1), this.rsrcName, this.alias};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "visa('" + this.info[2] + "', '" + this.rsrcName + "');";
    }

    @Override
    public String getConstructorDescription() {
        return "Vendor - " + this.info[2] + ", Resource Name - " + this.rsrcName;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'RsrcName', '" + this.rsrcName + "', 'Tag', '" + this.tag + "');";
    }

    @Override
    protected void hardwareFlushInput() {
        while (this.getBytesAvailableFromHardware() > 0) {
            this.readBytes(this.getBytesAvailableFromHardware());
        }
    }

    @Override
    protected void stopHardwareDueToWriteTimeout() {
        try {
            this.hardwareFlushOutput();
        }
        catch (TMException tMException) {
            // empty catch block
        }
        if (this.transferStatus == 2 || this.transferStatus == 3) {
            this.visa.StopAsync(this.handle, 2);
        }
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        return this.visa.Write(this.handle, string, string.length());
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) {
        if (platformByteOrder != this.byteOrder) {
            Object object2 = null;
            try {
                object2 = BinarySwapBytes.swap(object, n2, n);
            }
            catch (Exception exception) {
                return -1;
            }
            object = object2;
        }
        return this.writeBytes(object, n, n2);
    }

    private int writeBytes(Object object, int n, int n2) {
        return this.visa.writeBytes(this.handle, object, n, n2);
    }

    @Override
    protected int writeAsyncDataToHardware(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.dataToWriteAsync, n, byArray, 0, n2);
        this.writeId = this.visa.WriteBinaryByte(this.handle, byArray, n2);
        byArray = null;
        return this.writeId;
    }

    @Override
    protected void cleanupWriteAsync() {
        if (!this.outputEmptyFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new ICEvent("OutputEmpty", SerialVisa.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected byte[] readBytes(int n) {
        Object[] objectArray = this.visa.ReadBinary(this.handle, n, 0);
        if (objectArray.length == 3) {
            return (byte[])objectArray[0];
        }
        return null;
    }

    @Override
    protected int getBytesAvailableFromHardware() {
        return this.visa.Get(this.handle, 13);
    }

    @Override
    public int getSuccessValue() {
        return 0;
    }

    @Override
    public String getErrorMessageFromHardware(int n) {
        if (n == this.getReadTimeoutErrorCode()) {
            return "A timeout occurred before the read operation completed.";
        }
        return "VISA: " + this.visa.TranslateErrorCode(this.handle, n);
    }

    @Override
    protected int getReadTimeoutErrorCode() {
        return -123456789;
    }

    public char spoll(int n) throws TMException {
        return this.visa.spoll(this.handle, n, this.getHardwareTimeout());
    }

    public Object ObjectHardwareInfo() {
        return this.visa.ObjectHardwareInfo(this.info, this.handle);
    }

    @Override
    protected Object[] getHwInfoStruct() {
        this.ObjectHardwareInfo();
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    public static String[] findValidAdaptors(String string) throws Exception {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return VISA.findValidAdaptors(string);
    }

    public Object[] hardwareInfo(String string, String string2) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return this.visa.hardwareInfo(string, string2);
    }

    public Object[] hardwareInfoOnGeneric(String string, String string2) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return this.visa.hardwareInfoOnGeneric(string, string2);
    }

    public Object[] hardwareInfoOnGPIB(String string, String string2) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return this.visa.hardwareInfoOnGPIB(string, string2);
    }

    public Object[] hardwareInfoOnVXI(String string, String string2) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return this.visa.hardwareInfoOnVXI(string, string2);
    }

    public Object[] hardwareInfoOnPXI(String string, String string2) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return this.visa.hardwareInfoOnPXI(string, string2);
    }

    public Object[] hardwareInfoOnGPIBVXI(String string, String string2) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return this.visa.hardwareInfoOnGPIBVXI(string, string2);
    }

    public Object[] hardwareInfoOnSerial(String string, String string2) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return this.visa.hardwareInfoOnSerial(string, string2);
    }

    public Object[] hardwareInfoOn(String string, String string2, String string3) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return this.visa.hardwareInfoOn(string, string2, string3);
    }

    public void clrdevice() throws TMException {
        this.verifyObjectState();
        int n = this.visa.Clear(this.handle);
        if (n < 0) {
            SerialVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    public Object[] getAliasInfo(String string) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        return this.visa.GetAliasInfo(string);
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("VISA-Serial-" + this.port);
                continue;
            }
            if (string.equals("Port")) {
                iCPropArray[i].setDefaultValue(this.port);
                continue;
            }
            if (string.equals("RsrcName")) {
                iCPropArray[i].setDefaultValue(this.rsrcName);
                continue;
            }
            if (!string.equals("Alias")) continue;
            iCPropArray[i].setDefaultValue(this.alias);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidDisplay());
            return;
        }
        String string = LINESEP + "   VISA-Serial Object Using " + this.info[2] + " Adaptor : " + this.name + LINESEP + LINESEP + "   Communication Settings " + LINESEP + "      Port:               " + this.port + LINESEP + "      BaudRate:           " + this.baudRate + LINESEP + "      Terminator:         " + this.displayTerminator + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
        System.out.println(string);
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay("terminator") + "    " + LINESEP + "    VISA-SERIAL specific properties:" + LINESEP + "    BaudRate" + LINESEP + "    DataBits" + LINESEP + "    DataTerminalReady: [ {on} | off ]" + LINESEP + "    FlowControl: [ {none} | hardware | software ]" + LINESEP + "    Parity: [ {none} | odd | even | mark | space ]" + LINESEP + "    Port" + LINESEP + "    ReadAsyncMode: [ {continuous} | manual ]" + LINESEP + "    RequestToSend: [ {on} | off ]" + LINESEP + "    StopBits" + LINESEP + "    Terminator" + LINESEP + " " + LINESEP;
    }
}

