/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.TCPIP;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class TCPIPBinder
implements Runnable {
    private ServerSocket fServer;
    private InetAddress fNetworkAddress;
    private TCPIP fTcpip;
    private int fRemotePort;
    private boolean fExiting;

    public TCPIPBinder() {
        throw new Error("TCPIPBinder: Invalid invocation");
    }

    public TCPIPBinder(TCPIP tCPIP, int n, InetAddress inetAddress) {
        this.fNetworkAddress = inetAddress;
        this.fTcpip = tCPIP;
        this.fRemotePort = n;
    }

    @Override
    public void run() {
        this.startServer();
    }

    private void startServer() {
        try {
            this.fExiting = false;
            this.fServer = new ServerSocket(this.fRemotePort);
            this.fServer.setReuseAddress(true);
            InetAddress inetAddress = InetAddress.getByName("0.0.0.0");
            do {
                Socket socket;
                if ((socket = this.fServer.accept()).getInetAddress().equals(this.fNetworkAddress) || this.fNetworkAddress.equals(inetAddress)) {
                    this.stopServer();
                    this.connectionCallback(socket);
                    return;
                }
                socket.close();
            } while (!this.fExiting);
        }
        catch (Exception exception) {
            this.fTcpip.setError(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() throws IOException {
        TCPIPBinder tCPIPBinder = this;
        synchronized (tCPIPBinder) {
            if (this.fServer != null) {
                this.fExiting = true;
                this.fServer.close();
                this.fServer = null;
            }
        }
    }

    private void connectionCallback(Socket socket) {
        this.fTcpip.serverConnectEvent(socket);
    }
}

