/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.instrument.browser.ICTBrowserDesktop;
import com.mathworks.toolbox.instrument.browser.ICTBrowserTreeDetail;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileReader;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;

public class ICTTreeviewPanel
extends DTClientBase
implements ActionListener {
    private static final ImageIcon scanImage = CommonIcon.REFRESH.getIcon();
    private static final String ACTION = "ACTION";
    private static final int SCAN = 1;
    private ICTBrowserTreeDetail btd = null;
    private BrowserClient bc = null;
    private static ICTTreeviewPanel sInstance = null;

    private ICTTreeviewPanel() {
        this.setTitle(ICTBrowserDesktop.sBrowserResources.getString("InstrumentTreeviewPanel.title"));
        this.setPermitUserUndock(false);
        this.setPermitUserClose(false);
        this.initialize();
    }

    public static synchronized ICTTreeviewPanel getInstance() {
        if (sInstance == null) {
            sInstance = new ICTTreeviewPanel();
        }
        return sInstance;
    }

    public String getTitle() {
        String string = (String)this.getClientProperty(DTClientProperty.TITLE);
        return string;
    }

    public static void cleanup() {
        ICTTreeviewPanel.getInstance().btd.cleanup();
        sInstance = null;
    }

    private void initialize() {
        this.bc = new InstrumentControlBrowser();
        this.btd = new ICTBrowserTreeDetail(this.bc, null);
        this.btd.showRootNode(false);
        BrowserConfigFileReader browserConfigFileReader = new BrowserConfigFileReader("tmtool.cfg");
        this.btd.init(browserConfigFileReader);
        this.setLayout(new BorderLayout());
        this.add(this.btd.getTreeViewComponent(), "Center");
    }

    private void createToolbar() {
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setName("ICTTreeViewTB");
        mJToolBar.setFloatable(false);
        MJButton mJButton = this.createToolbarButton(scanImage, "Scan For All Hardware", 1);
        mJToolBar.add((Component)mJButton);
        this.setToolBar((JToolBar)mJToolBar);
    }

    private MJButton createToolbarButton(ImageIcon imageIcon, String string, int n) {
        MJButton mJButton = new MJButton((Icon)imageIcon);
        mJButton.setToolTipText(string);
        mJButton.setFlyOverAppearance(true);
        mJButton.setFocusTraversable(false);
        mJButton.setPreferredSize(new Dimension(30, 22));
        mJButton.setMinimumSize(new Dimension(30, 22));
        mJButton.setMaximumSize(new Dimension(30, 22));
        mJButton.addActionListener((ActionListener)this);
        mJButton.putClientProperty((Object)ACTION, (Object)new Integer(n));
        return mJButton;
    }

    public void expandTree() {
        this.btd.expandAll();
    }

    public void collapseTree() {
        this.btd.collapseAll();
    }

    public boolean isTwoPanelNodeSelected() {
        int n = this.btd.getSelectedNode().getType();
        return n == 1 || n == 0;
    }

    public void updateMenuItems(MJMenu mJMenu) {
        InstrumentControlBrowser instrumentControlBrowser = (InstrumentControlBrowser)this.btd.getBrowserClients();
        instrumentControlBrowser.updateMenu(mJMenu, this.btd.getSelectedNode());
    }

    public JMenu getDynamicFileMenu() {
        InstrumentControlBrowser instrumentControlBrowser = (InstrumentControlBrowser)this.btd.getBrowserClients();
        return instrumentControlBrowser.getCurrentNodeMenu(this.btd.getSelectedNode());
    }

    public JMenu getToolsMenu() {
        if (this.btd == null) {
            return null;
        }
        InstrumentControlBrowser instrumentControlBrowser = (InstrumentControlBrowser)this.btd.getBrowserClients();
        return instrumentControlBrowser.getToolsMenu();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = (Integer)((JComponent)actionEvent.getSource()).getClientProperty(ACTION);
        switch (n) {
            case 1: {
                this.refresh();
            }
        }
    }

    public void refresh() {
        this.btd.refresh();
    }

    public void processEvent(ActionEvent actionEvent) {
        InstrumentControlBrowser instrumentControlBrowser = (InstrumentControlBrowser)this.btd.getBrowserClients();
        instrumentControlBrowser.actionPerformed(actionEvent);
    }
}

