/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentAsync;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.browser.TablePage;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.DeviceObjectListener;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.instrument.guiutil.InstrumentObjectExporter;
import com.mathworks.toolbox.instrument.guiutil.NewObjectDialog;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.JTableHeader;
import org.w3c.dom.Element;

public class ObjectTablePage
extends TablePage
implements Runnable,
ChangeListener,
InstrumentObjectListener,
DeviceObjectListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int INSTRUMENT = 0;
    public static final int INTERFACE = 1;
    public static final int DEVICE = 2;
    private static final String[] INSTRUMENT_HEADINGS = new String[]{"Object Type", "Type", "Name"};
    private static final String[] INTERFACE_HEADINGS = new String[]{"Type", "Name"};
    private static final String[] DEVICE_HEADINGS = new String[]{"Type", "Driver", "Name"};
    private static final String[][] HEADINGS = new String[][]{INSTRUMENT_HEADINGS, INTERFACE_HEADINGS, DEVICE_HEADINGS};
    private static final int[] INSTRUMENT_WIDTH = new int[]{250, 250, 500};
    private static final int[] INTERFACE_WIDTH = new int[]{150, 1000};
    private static final int[] DEVICE_WIDTH = new int[]{250, 250, 500};
    private static final int[][] WIDTHS = new int[][]{INSTRUMENT_WIDTH, INTERFACE_WIDTH, DEVICE_WIDTH};
    private static final String[] HISTORY_HEADINGS = new String[]{"Type", "Description", "Creation Date"};
    private static final int[] HISTORY_WIDTH = new int[]{150, 700, 300};
    private static final String ACTION = "ACTION";
    private static final int NEW = 0;
    private static final int DELETE = 1;
    private static final int EXPORT = 2;
    private static final int REMOVE_ROW = 3;
    private static final int RECREATE = 4;
    private int type = -1;
    private JTabbedPane tabPanel;
    private JScrollPane objectScrollPane;
    private String[] headings = INSTRUMENT_HEADINGS;
    private Object[][] data;
    private Object[] tableUserData;
    private JScrollPane historyScrollPane;
    private Object[][] history_data_instrument;
    private Object[][] history_data_interface;
    private Object[][] history_data_device;
    private Object[] history_userData_instrument;
    private Object[] history_userData_interface;
    private Object[] history_userData_device;
    private JButton newButton;
    private JButton deleteButton;
    private JButton exportButton;
    private JButton removeButton;
    private JButton recreateButton;
    private NewObjectDialog newObjectDialog = null;
    private Object[] matlabArgs = new Object[]{"privateDisconnect", ""};
    private RecreateObjectRunnable recreateObjectRunnable = null;

    public ObjectTablePage() {
        this.setLayout(new BorderLayout(0, 0));
        this.layoutPanel();
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        super.setup();
        this.type = (Integer)browserTreeNode.getUserData();
        switch (this.type) {
            case 0: {
                Instrument.addInstrumentObjectListener(this);
                Device.addDeviceObjectListener(this);
                break;
            }
            case 1: {
                Instrument.addInstrumentObjectListener(this);
                break;
            }
            case 2: {
                Device.addDeviceObjectListener(this);
            }
        }
        this.stateChanged(null);
    }

    @Override
    public void cleanup() {
        switch (this.type) {
            case 0: {
                Instrument.removeInstrumentObjectListener(this);
                Device.removeDeviceObjectListener(this);
                break;
            }
            case 1: {
                Instrument.removeInstrumentObjectListener(this);
                break;
            }
            case 2: {
                Device.removeDeviceObjectListener(this);
            }
        }
        super.cleanup();
    }

    @Override
    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        Element element2;
        int n;
        if (this.history_data_instrument != null) {
            for (n = 0; n < this.history_data_instrument.length; ++n) {
                element2 = browserConfigFileWriter.addNode(element, "HistoryObjects");
                element2.setAttribute("Location", "Instrument");
                element2.setAttribute("Type", (String)this.history_data_instrument[n][0]);
                element2.setAttribute("Description", (String)this.history_data_instrument[n][1]);
                element2.setAttribute("Date", (String)this.history_data_instrument[n][2]);
                element2.setAttribute("Constructor", (String)this.history_userData_instrument[n]);
            }
        }
        if (this.history_data_interface != null) {
            for (n = 0; n < this.history_data_interface.length; ++n) {
                element2 = browserConfigFileWriter.addNode(element, "HistoryObjects");
                element2.setAttribute("Location", "Interface");
                element2.setAttribute("Type", (String)this.history_data_interface[n][0]);
                element2.setAttribute("Description", (String)this.history_data_interface[n][1]);
                element2.setAttribute("Date", (String)this.history_data_interface[n][2]);
                element2.setAttribute("Constructor", (String)this.history_userData_interface[n]);
            }
        }
        if (this.history_data_device != null) {
            for (n = 0; n < this.history_data_device.length; ++n) {
                element2 = browserConfigFileWriter.addNode(element, "HistoryObjects");
                element2.setAttribute("Location", "Device");
                element2.setAttribute("Type", (String)this.history_data_device[n][0]);
                element2.setAttribute("Description", (String)this.history_data_device[n][1]);
                element2.setAttribute("Date", (String)this.history_data_device[n][2]);
                element2.setAttribute("Constructor", (String)this.history_userData_device[n]);
            }
        }
    }

    public void load(Element element) {
        String string = element.getAttribute("Location");
        String string2 = element.getAttribute("Type");
        String string3 = element.getAttribute("Description");
        String string4 = element.getAttribute("Date");
        String string5 = element.getAttribute("Constructor");
        if (string.equals("Instrument")) {
            Object[] objectArray = new Object[]{string2, string3, string4};
            this.history_data_instrument = this.appendData(this.history_data_instrument, objectArray);
            this.history_userData_instrument = this.appendData(this.history_userData_instrument, string5);
        } else if (string.equals("Interface")) {
            Object[] objectArray = new Object[]{string2, string3, string4};
            this.history_data_interface = this.appendData(this.history_data_interface, objectArray);
            this.history_userData_interface = this.appendData(this.history_userData_interface, string5);
        } else if (string.equals("Device")) {
            Object[] objectArray = new Object[]{string2, string3, string4};
            this.history_data_device = this.appendData(this.history_data_device, objectArray);
            this.history_userData_device = this.appendData(this.history_userData_device, string5);
        }
    }

    private void layoutPanel() {
        this.tabPanel = new JTabbedPane();
        this.add(this.tabPanel, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        jPanel.add((Component)this.createButtonPanel(), "South");
        JTableHeader jTableHeader = table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.objectScrollPane = new JScrollPane((Component)table);
        jPanel.add((Component)this.objectScrollPane, "Center");
        this.objectScrollPane.setPreferredSize(new Dimension(200, 50));
        this.tabPanel.addTab("Existing Objects", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        jPanel2.add((Component)this.createHistoryButtonPanel(), "South");
        this.historyScrollPane = new JScrollPane();
        this.historyScrollPane.setPreferredSize(new Dimension(200, 50));
        jPanel2.add((Component)this.historyScrollPane, "Center");
        this.tabPanel.addTab("History", jPanel2);
        this.tabPanel.addChangeListener(this);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        this.newButton = new JButton("New Object...");
        this.newButton.putClientProperty(ACTION, new Integer(0));
        this.newButton.addActionListener(this);
        this.newButton.setName("New Object Button");
        this.exportButton = new JButton("Export...");
        this.exportButton.putClientProperty(ACTION, new Integer(2));
        this.exportButton.addActionListener(this);
        this.exportButton.setName("Export");
        this.exportButton.setEnabled(false);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.putClientProperty(ACTION, new Integer(1));
        this.deleteButton.addActionListener(this);
        this.deleteButton.setName("Delete Button");
        this.deleteButton.setEnabled(false);
        jPanel2.add(this.newButton);
        jPanel2.add(this.exportButton);
        jPanel2.add(this.deleteButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createHistoryButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 0));
        this.removeButton = new JButton("Delete");
        this.removeButton.putClientProperty(ACTION, new Integer(3));
        this.removeButton.addActionListener(this);
        this.removeButton.setName("Remove Button");
        this.recreateButton = new JButton("Create");
        this.recreateButton.putClientProperty(ACTION, new Integer(4));
        this.recreateButton.addActionListener(this);
        this.recreateButton.setName("Recreate Button");
        jPanel2.add(this.recreateButton);
        jPanel2.add(this.removeButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void createTableData() {
        this.data = null;
        switch (this.type) {
            case 0: {
                this.createInstrumentTableData();
                break;
            }
            case 1: {
                this.createInterfaceTableData();
                break;
            }
            case 2: {
                this.createDeviceTableData();
            }
        }
        if (tableModel != null) {
            tableModel.setData(this.data);
            this.setUserData(this.tableUserData);
        }
    }

    private void createInstrumentTableData() {
        Object object;
        int n;
        Vector vector = (Vector)Instrument.getNonLockedObjects().clone();
        Vector vector2 = (Vector)Device.getNonLockedObjects().clone();
        this.data = new Object[vector.size() + vector2.size()][INSTRUMENT_HEADINGS.length];
        this.tableUserData = new Object[this.data.length];
        int n2 = vector.size();
        for (n = 0; n < vector.size(); ++n) {
            object = (Instrument)vector.elementAt(n);
            this.data[n][0] = "Interface";
            this.data[n][1] = ((Instrument)object).getType();
            this.data[n][2] = ((Instrument)object).getName();
            this.tableUserData[n] = object;
        }
        for (n = n2; n < this.data.length; ++n) {
            object = (ICDevice)vector2.elementAt(n - n2);
            this.data[n][0] = "Device";
            this.data[n][1] = ((Device)object).getType();
            this.data[n][2] = ((Device)object).getName();
            this.tableUserData[n] = object;
        }
    }

    private void createInterfaceTableData() {
        Vector vector = (Vector)Instrument.getNonLockedObjects().clone();
        this.data = new Object[vector.size()][INTERFACE_HEADINGS.length];
        this.tableUserData = new Object[this.data.length];
        for (int i = 0; i < vector.size(); ++i) {
            Instrument instrument = (Instrument)vector.elementAt(i);
            this.data[i][0] = instrument.getType();
            this.data[i][1] = instrument.getName();
            this.tableUserData[i] = instrument;
        }
    }

    private void createDeviceTableData() {
        Vector vector = (Vector)Device.getNonLockedObjects().clone();
        this.data = new Object[vector.size()][DEVICE_HEADINGS.length];
        this.tableUserData = new Object[this.data.length];
        for (int i = 0; i < vector.size(); ++i) {
            ICDevice iCDevice = (ICDevice)vector.elementAt(i);
            this.data[i][0] = iCDevice.getType();
            this.data[i][1] = iCDevice.getDriverName();
            this.data[i][2] = iCDevice.getName();
            this.tableUserData[i] = iCDevice;
        }
    }

    private void updateButtonState(boolean bl) {
        this.deleteButton.setEnabled(bl);
        this.exportButton.setEnabled(bl);
    }

    private void createHistoryTableData() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ObjectTablePage.this.createHistoryTableData();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        switch (this.type) {
            case 0: {
                this.data = this.history_data_instrument;
                this.tableUserData = this.history_userData_instrument;
                break;
            }
            case 1: {
                this.data = this.history_data_interface;
                this.tableUserData = this.history_userData_interface;
                break;
            }
            case 2: {
                this.data = this.history_data_device;
                this.tableUserData = this.history_userData_device;
            }
        }
        if (tableModel != null) {
            tableModel.setData(this.data);
            this.setUserData(this.tableUserData);
        }
        this.removeButton.setEnabled(this.data != null && this.data.length != 0);
        this.recreateButton.setEnabled(this.data != null && this.data.length != 0);
    }

    private void updateHistoryTableData() {
        this.data = tableModel.getData();
        this.tableUserData = this.getUserData();
        switch (this.type) {
            case 0: {
                this.history_data_instrument = this.data;
                this.history_userData_instrument = this.tableUserData;
                break;
            }
            case 1: {
                this.history_data_interface = this.data;
                this.history_userData_interface = this.tableUserData;
                break;
            }
            case 2: {
                this.history_data_device = this.data;
                this.history_userData_device = this.tableUserData;
            }
        }
        this.removeButton.setEnabled(this.data != null && this.data.length != 0);
        this.recreateButton.setEnabled(this.data != null && this.data.length != 0);
    }

    public void addInterfaceData(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, TMStringUtil.getDate()};
        this.history_data_interface = this.appendData(this.history_data_interface, objectArray);
        this.history_data_instrument = this.appendData(this.history_data_instrument, objectArray);
        this.history_userData_interface = this.appendData(this.history_userData_interface, string3);
        this.history_userData_instrument = this.appendData(this.history_userData_instrument, string3);
        if (this.tabPanel.getSelectedIndex() == 1) {
            this.createHistoryTableData();
        }
    }

    public void addDeviceData(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, TMStringUtil.getDate()};
        this.history_data_device = this.appendData(this.history_data_device, objectArray);
        this.history_data_instrument = this.appendData(this.history_data_instrument, objectArray);
        this.history_userData_device = this.appendData(this.history_userData_device, string3);
        this.history_userData_instrument = this.appendData(this.history_userData_instrument, string3);
        if (this.tabPanel.getSelectedIndex() == 1) {
            this.createHistoryTableData();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = (Integer)((JButton)actionEvent.getSource()).getClientProperty(ACTION);
        switch (n) {
            case 0: {
                if (this.newObjectDialog == null) {
                    this.newObjectDialog = new NewObjectDialog(this.type);
                } else {
                    this.newObjectDialog.setInstrumentObjType(this.type);
                }
                MJFrame mJFrame = (MJFrame)SwingUtilities.windowForComponent((Component)((Object)this));
                this.newObjectDialog.showAsDialog(mJFrame, true);
                break;
            }
            case 2: {
                MJFrame mJFrame = (MJFrame)SwingUtilities.windowForComponent((Component)((Object)this));
                new InstrumentObjectExporter(this.objectArray2Vector(this.tableUserData)).showAsDialog(mJFrame);
                break;
            }
            case 1: {
                this.deleteObjects();
                break;
            }
            case 4: {
                this.recreateObjectFromHistoryTable();
                break;
            }
            case 3: {
                this.removeRowFromHistoryTable();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        switch (this.tabPanel.getSelectedIndex()) {
            case 0: {
                if (this.objectScrollPane.getViewport().getView() == null) {
                    this.objectScrollPane.getViewport().setView((Component)table);
                }
                this.headings = HEADINGS[this.type];
                this.configureTable(this.headings, WIDTHS[this.type]);
                this.createTableData();
                break;
            }
            case 1: {
                if (this.historyScrollPane.getViewport().getView() == null) {
                    this.historyScrollPane.getViewport().setView((Component)table);
                }
                this.configureTable(HISTORY_HEADINGS, HISTORY_WIDTH);
                this.createHistoryTableData();
            }
        }
    }

    private void deleteObjects() {
        int[] nArray = table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int n = nArray[0];
        try {
            Object[] objectArray = this.getUserData();
            Object[] objectArray2 = new Object[nArray.length];
            for (int i = nArray.length - 1; i >= 0; --i) {
                Object object = objectArray[nArray[i]];
                if (object instanceof Instrument) {
                    Instrument instrument = (Instrument)object;
                    if (object instanceof InstrumentAsync) {
                        instrument.stopasync();
                    }
                    instrument.fclose();
                    instrument.dispose();
                } else {
                    ((ICDevice)object).dispose();
                }
                objectArray2[i] = object;
            }
            this.matlabArgs[1] = objectArray2;
            Matlab.whenMatlabReady((Runnable)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tableModel.getRowCount() == 0) {
            return;
        }
        if (n < tableModel.getRowCount()) {
            table.getSelectionModel().setSelectionInterval(n, n);
        } else {
            table.getSelectionModel().setSelectionInterval(tableModel.getRowCount() - 1, tableModel.getRowCount() - 1);
        }
        table.requestFocus();
    }

    private Vector<Object> objectArray2Vector(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }

    private void removeRowFromHistoryTable() {
        int[] nArray = table.getSelectedRows();
        if (nArray.length == 0) {
            TMStringUtil.error((MJFrame)this.getFrameForDialog(), (String)"Delete Error", (String)"To delete a row in the table, the row must be selected.");
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            try {
                tableModel.remove(nArray[i]);
                this.removeUserData(nArray[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(arrayIndexOutOfBoundsException.getMessage());
            }
        }
        table.getSelectionModel().clearSelection();
        this.updateHistoryTableData();
    }

    public void removeDuplicates(int n) {
        int n2;
        Object[][] objectArray = null;
        Object[] objectArray2 = null;
        switch (n) {
            case 0: {
                objectArray = this.history_data_instrument;
                objectArray2 = this.history_userData_instrument;
                break;
            }
            case 1: {
                objectArray = this.history_data_interface;
                objectArray2 = this.history_userData_interface;
                break;
            }
            case 2: {
                objectArray = this.history_data_device;
                objectArray2 = this.history_userData_device;
            }
        }
        int[] nArray = new int[objectArray.length];
        int n3 = 0;
        for (n2 = objectArray.length; n2 >= 1; --n2) {
            if (this.contain(nArray, n2 - 1, n3)) continue;
            Object object = objectArray[n2 - 1][0];
            Object object2 = objectArray[n2 - 1][1];
            for (int i = 0; i < n2 - 1; ++i) {
                if (this.contain(nArray, i, n3) || !objectArray[i][0].equals(object) || !objectArray[i][1].equals(object2)) continue;
                nArray[n3++] = i;
            }
        }
        if (n3 == 0) {
            return;
        }
        nArray = this.sortData(nArray, n3);
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            objectArray = this.removeData(objectArray, nArray[n2], 3);
        }
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            objectArray2 = this.removeData(objectArray2, nArray[n2]);
        }
        switch (n) {
            case 0: {
                this.history_data_instrument = objectArray;
                this.history_userData_instrument = objectArray2;
                break;
            }
            case 1: {
                this.history_data_interface = objectArray;
                this.history_userData_interface = objectArray2;
                break;
            }
            case 2: {
                this.history_data_device = objectArray;
                this.history_userData_device = objectArray2;
            }
        }
        if (this.tabPanel.getSelectedIndex() == 1) {
            this.createHistoryTableData();
        }
    }

    private boolean contain(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private int[] sortData(int[] nArray, int n) {
        int n2;
        int[] nArray2 = new int[nArray.length];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray2[n2] = -1;
        }
        for (n2 = 0; n2 < n; ++n2) {
            nArray2[nArray[n2]] = 1;
        }
        int[] nArray3 = new int[n];
        int n3 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] != 1) continue;
            nArray3[n3++] = i;
        }
        return nArray3;
    }

    private void recreateObjectFromHistoryTable() {
        int[] nArray = table.getSelectedRows();
        if (nArray.length == 0) {
            TMStringUtil.error((MJFrame)this.getFrameForDialog(), (String)"Recreate Error", (String)"To create an object, the object's row must be selected.");
            return;
        }
        Object[] objectArray = this.getUserData();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)objectArray[nArray[i]];
        }
        if (this.recreateObjectRunnable == null) {
            this.recreateObjectRunnable = new RecreateObjectRunnable();
        }
        this.recreateObjectRunnable.configure(stringArray);
        Matlab.whenMatlabReady((Runnable)this.recreateObjectRunnable);
    }

    public MJFrame getFrameForDialog() {
        return (MJFrame)SwingUtilities.windowForComponent((Component)((Object)this));
    }

    @Override
    public void run() {
        try {
            Matlab.mtFeval((String)"instrgate", (Object[])this.matlabArgs, (int)0);
            table.requestFocus();
        }
        catch (Exception exception) {
            System.out.println("ObjectTablePage Exception: " + exception.getMessage());
        }
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.tabPanel.getSelectedIndex() == 0) {
                this.createTableData();
            }
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ObjectTablePage.this.instrumentObjectAdded(null, null, null);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.tabPanel.getSelectedIndex() == 0) {
                this.createTableData();
            }
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ObjectTablePage.this.instrumentObjectDeleted(null, null, null);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void deviceObjectAdded(Device device, String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.tabPanel.getSelectedIndex() == 0) {
                this.createTableData();
            }
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ObjectTablePage.this.deviceObjectAdded(null, null);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void deviceObjectDeleted(Device device, String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.tabPanel.getSelectedIndex() == 0) {
                this.createTableData();
            }
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ObjectTablePage.this.deviceObjectDeleted(null, null);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        this.updateButtonState(!listSelectionModel.isSelectionEmpty());
    }

    class RecreateObjectRunnable
    implements Runnable,
    MatlabListener {
        private Object[] args = new Object[]{"privateBrowserHelper", "recreate", ""};
        private Matlab matlab = new Matlab();

        RecreateObjectRunnable() {
        }

        public void configure(String[] stringArray) {
            this.args[2] = stringArray;
        }

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", this.args, 0, (MatlabListener)this);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            int n = Matlab.getExecutionStatus((int)matlabEvent.getStatus());
            if (n != 0) {
                TMStringUtil.error((MJFrame)ObjectTablePage.this.getFrameForDialog(), (String)"Object Creation Error", (String)"An error occurred while creating the instrument object.");
            }
        }
    }
}

