/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.deviceobj;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceMCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceMCodeBank;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectCommunicationTable;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectPage;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectPageInfo;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectResultsExporter;
import com.mathworks.toolbox.instrument.browser.deviceobj.InvokeMCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.ResultsMCode;
import com.mathworks.toolbox.instrument.device.PropertyChangedListener;
import com.mathworks.toolbox.instrument.device.drivers.GenericDriver;
import com.mathworks.toolbox.instrument.device.guiutil.panels.FunctionPanel;
import com.mathworks.toolbox.instrument.device.guiutil.panels.FunctionPanelListener;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DeviceObjectCommunicationPage
extends JPanel
implements FunctionPanelListener,
PropertyChangedListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String ACTION = "ACTION";
    private static final int EXPORT = 0;
    private FunctionPanel functionPanel = null;
    private DeviceObjectCommunicationTable table;
    private final Object[] tableRow = new Object[4];
    private JEditorPane outputWindow;
    private JButton export;
    private DeviceObjectPage parent = null;
    private ExecuteCommandRunnable executeCommandRunnable = null;
    private ICDevice deviceObject = null;

    public DeviceObjectCommunicationPage(DeviceObjectPage deviceObjectPage) {
        this.parent = deviceObjectPage;
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layoutPanel();
    }

    public void dispose() {
    }

    public void update(DeviceObjectPageInfo deviceObjectPageInfo) {
        this.functionPanel.update(deviceObjectPageInfo.getObject(), deviceObjectPageInfo.getParser(), deviceObjectPageInfo.getDeviceDriverHelper());
        this.deviceObject = deviceObjectPageInfo.getObject();
        this.functionPanel.setFunction(deviceObjectPageInfo.getFunction());
        this.functionPanel.setObject(deviceObjectPageInfo.getFunctionObject());
        this.functionPanel.setInputArguments(deviceObjectPageInfo.getInputArguments());
        this.functionPanel.setOutputArguments(deviceObjectPageInfo.getOutputArguments());
        this.table.setup(deviceObjectPageInfo);
        this.outputWindow.setText(deviceObjectPageInfo.getFunctionResponse());
        this.export.setEnabled(deviceObjectPageInfo.getFunctionOutputAvailable());
        ICDevice.addPropertyChangedListener(this);
        FunctionPanel.addFunctionPanelListener(this);
    }

    public void cleanup(DeviceObjectPageInfo deviceObjectPageInfo) {
        if (deviceObjectPageInfo != null) {
            deviceObjectPageInfo.setDeviceDriverHelper(this.functionPanel.getDeviceDriverHelper());
            deviceObjectPageInfo.setFunction(this.functionPanel.getFunction());
            deviceObjectPageInfo.setFunctionObject(this.functionPanel.getObject());
            deviceObjectPageInfo.setInputArguments(this.functionPanel.getInputArguments());
            deviceObjectPageInfo.setOutputArguments(this.functionPanel.getOutputArguments());
            deviceObjectPageInfo.setFunctionResponse(this.outputWindow.getText());
            deviceObjectPageInfo.setFunctionOutputAvailable(this.export.isEnabled());
        }
        this.functionPanel.cleanup();
        ICDevice.removePropertyChangedListener(this);
        FunctionPanel.removeFunctionPanelListener(this);
        this.table.cleanup(deviceObjectPageInfo);
    }

    public void addTable() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].equals(this.table)) continue;
            return;
        }
        this.add((Component)this.table, "Center");
    }

    public void layoutPanel() {
        this.setLayout(new BorderLayout(0, 4));
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)this.createCommandPanel(), "North");
        jPanel.add((Component)this.createResponsePanel(), "Center");
        this.add((Component)jPanel, "North");
        this.table = new DeviceObjectCommunicationTable();
        this.add((Component)this.table, "Center");
    }

    private JPanel createCommandPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Select an instrument function"));
        this.functionPanel = new FunctionPanel();
        jPanel.add(this.functionPanel);
        return jPanel;
    }

    private JPanel createResponsePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder("Response"));
        this.outputWindow = new JEditorPane();
        this.outputWindow.setEditorKit(this.outputWindow.getEditorKitForContentType("text/html"));
        this.outputWindow.setText("<html></html>");
        this.outputWindow.setBorder(BorderFactory.createLoweredBevelBorder());
        this.outputWindow.setName("Output window");
        JScrollPane jScrollPane = new JScrollPane(this.outputWindow);
        jScrollPane.setPreferredSize(new Dimension(100, 70));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.add((Component)jScrollPane, "Center");
        this.export = new JButton("Export...");
        this.export.setName("Export Button");
        this.export.setEnabled(false);
        this.export.putClientProperty(ACTION, new Integer(0));
        this.export.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.add(this.export);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                ResultsMCode[] resultsMCodeArray = new ResultsMCode[]{this.table.getLastInvokeMCode()};
                MJFrame mJFrame = (MJFrame)SwingUtilities.windowForComponent(this);
                new DeviceObjectResultsExporter(resultsMCodeArray).showAsDialog(mJFrame);
            }
        }
    }

    @Override
    public void functionExecuted(String string, String string2, String string3, String string4) {
        this.clearResponseWindow();
        String string5 = this.functionPanel.generateCode();
        InvokeMCode invokeMCode = new InvokeMCode(string5, string, string2);
        if (this.executeCommandRunnable == null) {
            this.executeCommandRunnable = new ExecuteCommandRunnable();
        }
        this.executeCommandRunnable.setObject(this.deviceObject);
        this.executeCommandRunnable.setCode(string5);
        this.executeCommandRunnable.setOutputArguments(string4);
        this.executeCommandRunnable.setDeviceMCode(invokeMCode);
        this.tableRow[0] = string;
        this.tableRow[1] = string2;
        this.tableRow[2] = string3;
        this.tableRow[3] = string4;
        this.table.appendData(this.tableRow, invokeMCode);
        this.parent.postBlockEventsEvent(true);
        Matlab.whenMatlabReady((Runnable)this.executeCommandRunnable);
    }

    @Override
    public void propertyChanged(Object object, String string, Object object2) {
        if (!object.equals(this.deviceObject)) {
            return;
        }
        if (!string.equals("Status")) {
            return;
        }
        if (object2.equals("open")) {
            this.appendStateChangedRow("connect", DeviceMCode.createConnectMCode());
        } else {
            this.appendStateChangedRow("disconnect", DeviceMCode.createDisconnectMCode());
        }
    }

    private void appendStateChangedRow(String string, DeviceMCode deviceMCode) {
        this.tableRow[0] = string;
        this.tableRow[1] = "Device object";
        this.tableRow[2] = "";
        this.tableRow[3] = "";
        this.table.appendData(this.tableRow, deviceMCode);
    }

    public void setCodeBank(DeviceMCodeBank deviceMCodeBank) {
        this.table.setCodeBank(deviceMCodeBank);
    }

    public void exportHistoryTable(MJFrame mJFrame) {
        this.table.exportHistoryTable(mJFrame);
    }

    protected JPanel add(JPanel jPanel, JPanel jPanel2, int n) {
        JPanel jPanel3 = new JPanel(new BorderLayout(0, n));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "Center");
        return jPanel3;
    }

    public DeviceObjectCommunicationTable getTable() {
        return this.table;
    }

    private void clearResponseWindow() {
        this.outputWindow.setText("<html></html>");
    }

    public String generateCodeForSession() {
        return this.table.generateCode();
    }

    public class ExecuteCommandRunnable
    implements Runnable,
    MatlabListener {
        private final Object[] args = new Object[]{"privateBrowserHelper", "executeFunction", "", "", ""};
        private final Matlab matlab = new Matlab();
        private InvokeMCode deviceMCode;

        public void setObject(ICDevice iCDevice) {
            this.args[2] = iCDevice.getMATLABObject();
        }

        public void setCode(String string) {
            this.args[3] = string;
        }

        public void setOutputArguments(String string) {
            this.args[4] = string;
        }

        public void setDeviceMCode(InvokeMCode invokeMCode) {
            this.deviceMCode = invokeMCode;
        }

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", this.args, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            Object[] objectArray = (Object[])matlabEvent.getResult();
            if (objectArray == null) {
                return;
            }
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            int n = objectArray.length;
            if (string2.equals("no") && DeviceObjectCommunicationPage.this.deviceObject.getDriverType() == 4 && n > 2) {
                GenericDriver genericDriver = (GenericDriver)DeviceObjectCommunicationPage.this.deviceObject.getDriver();
                genericDriver.SetErrorMessage((String)objectArray[2]);
            }
            DeviceObjectCommunicationPage.this.outputWindow.setText("<html>" + string + "</html>");
            if (string2.equals("yes")) {
                DeviceObjectCommunicationPage.this.export.setEnabled(true);
                this.deviceMCode.setVariables(objectArray[2]);
                this.deviceMCode.setVariableNames((String[])objectArray[3]);
            } else {
                DeviceObjectCommunicationPage.this.export.setEnabled(false);
                this.deviceMCode.setVariables(null);
            }
            DeviceObjectCommunicationPage.this.parent.postBlockEventsEvent(false);
        }
    }
}

