/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.ivicWrapper;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IVICInstrumentMCode;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObjectPage;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObjectStore;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentStore;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentTreeIconRenderer;
import com.mathworks.toolbox.instrument.device.drivers.xml.IviCWrapperXMLParser;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class IviCInstrumentObject {
    public static final String ConnectionStatus = "ConnectionStatus";
    public static final String EnableExport = "EnableExport";
    public static final String IviCInstrumentMATLABHelperFunction = "privateIviCInstrumentHelper";
    private String fName;
    private boolean fConnected = false;
    private MLArrayRef fIvicInstrumentObj;
    private String fSessionLogCode = "";
    private String fResource;
    private String fUnderlyingDriverName;
    private IVICInstrumentMCode fExportedVariables;
    private IviCInstrumentObjectPage fListener;
    public JTree fIvicInstrumentObjTree;
    public String fInstrumentType;
    public boolean fSimulate;
    private String fHardwareAsset;
    private String fSession;
    private String fLogicalName;
    private InstrumentControlBrowser fBrowser;
    private IviCInstrumentObjectPage fIvicInstrumentObjPage;
    private String[] pathsInInstrumentControlBrowser;

    public IviCInstrumentObject(String string, String string2, String string3, String string4, InstrumentControlBrowser instrumentControlBrowser) {
        this.fName = string;
        this.fInstrumentType = string2;
        this.fResource = string3;
        this.fUnderlyingDriverName = string4;
        this.fBrowser = instrumentControlBrowser;
        this.pathsInInstrumentControlBrowser = new String[]{"Instrument Control Toolbox", "IVI Instruments", this.fInstrumentType};
        IviCInstrumentObjectCreationWorker iviCInstrumentObjectCreationWorker = new IviCInstrumentObjectCreationWorker();
        iviCInstrumentObjectCreationWorker.start();
    }

    private void createIviInstrumentObjNode() {
        String[] stringArray = new String[]{"Instrument Control Toolbox", "IVI Instruments", this.fInstrumentType};
        BrowserTreeNode browserTreeNode = this.fBrowser.getNode(stringArray, this.fName);
        if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(this.fName, (BrowserClient)this.fBrowser);
        }
        if (this.fIvicInstrumentObjPage == null) {
            this.fIvicInstrumentObjPage = new IviCInstrumentObjectPage(this.fBrowser);
        }
        this.addIviCInstrumentObjectListener(this.fIvicInstrumentObjPage);
        browserTreeNode.setPanel((JPanel)((Object)this.fIvicInstrumentObjPage));
        ImageIcon imageIcon = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/object_small.gif"));
        browserTreeNode.setIcon(imageIcon);
        browserTreeNode.setUserData((Object)this.fName);
        String string = (String)browserTreeNode.getUserData();
        browserTreeNode.setType(19);
        browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "ivi_instrument_object");
        this.fBrowser.addNode(this.fName, stringArray, browserTreeNode);
        String[] stringArray2 = new String[]{"Instrument Control Toolbox", "IVI Instruments"};
        BrowserTreeNode browserTreeNode2 = this.fBrowser.getNode(stringArray2, this.fInstrumentType);
        this.fBrowser.postNodeExpandEvent(browserTreeNode2);
        IviCInstrumentObjectStore.add(this.fName, this);
    }

    public String[] getPathsInBrowser() {
        return this.pathsInInstrumentControlBrowser;
    }

    public BrowserTreeNode getNode() {
        return this.fListener.getInstrumentControlBrowser().getNode(this.pathsInInstrumentControlBrowser, this.fName);
    }

    public void dispose() {
        this.fListener.getInstrumentControlBrowser().removeNode(this.fName, this.pathsInInstrumentControlBrowser);
        if (this.fHardwareAsset == null) {
            return;
        }
        IviConfigStoreCleanUpWorker iviConfigStoreCleanUpWorker = new IviConfigStoreCleanUpWorker();
        iviConfigStoreCleanUpWorker.start();
    }

    public String getDriverName() {
        return this.fUnderlyingDriverName;
    }

    public String getResource() {
        return this.fResource;
    }

    public boolean isConnected() {
        return this.fConnected;
    }

    public String getMcode() {
        return this.fSessionLogCode;
    }

    private void addMcodeToSessionLog(String string) {
        this.fSessionLogCode = this.fSessionLogCode + string + "\n";
    }

    public void connect() {
        ConnectionWorker connectionWorker = new ConnectionWorker();
        connectionWorker.start();
    }

    public void disconnect() {
        if (this.isConnected()) {
            String string = "% Disconnect Ivi instrument object from hardware.\n";
            string = string + this.fName + ".close();";
            this.addMcodeToSessionLog(string);
            DisconnectionWorker disconnectionWorker = new DisconnectionWorker();
            disconnectionWorker.start();
        }
    }

    private void populateDriverTreeStructure() {
        DefaultMutableTreeNode defaultMutableTreeNode = IviCInstrumentStore.getIviCInstrument(this.fInstrumentType).getTreeRootNode();
        this.fIvicInstrumentObjTree = new JTree(defaultMutableTreeNode);
        this.fIvicInstrumentObjTree.setCellRenderer(new IviCInstrumentTreeIconRenderer());
        this.fIvicInstrumentObjTree.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.fIvicInstrumentObjTree.getModel();
        this.fIvicInstrumentObjTree.setEnabled(true);
        this.fIvicInstrumentObjTree.setVisible(true);
        TreePath treePath = new TreePath(defaultTreeModel.getRoot());
        this.fIvicInstrumentObjTree.setSelectionPath(treePath);
        this.fIvicInstrumentObjTree.addTreeSelectionListener(this.fListener);
    }

    public void setDriverProp(String string, String string2) {
        CommandExecutionWorker commandExecutionWorker = new CommandExecutionWorker();
        String string3 = this.fName + "." + string + "=" + string2 + ";";
        commandExecutionWorker.setCode(string3);
        commandExecutionWorker.start();
        this.fExportedVariables = new IVICInstrumentMCode(string3, string, "IviInstrumentObject");
    }

    public void getDriverProp(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(n > 0 ? n + 1 : 0);
        String string3 = string2 + " = " + this.fName + "." + string + ";";
        CommandExecutionWorker commandExecutionWorker = new CommandExecutionWorker();
        commandExecutionWorker.setCode(string3);
        commandExecutionWorker.setOutputArguments(string2);
        commandExecutionWorker.start();
        this.fExportedVariables = new IVICInstrumentMCode(string3, string2, "IviInstrumentObject");
    }

    public void executeMethod(String string, String string2, String string3) {
        String string4 = "";
        if (string.length() > 0) {
            string4 = "[" + string + "] = ";
        }
        string4 = string4 + this.fName + "." + string2 + "(" + string3 + ");";
        CommandExecutionWorker commandExecutionWorker = new CommandExecutionWorker();
        commandExecutionWorker.setCode(string4);
        commandExecutionWorker.setOutputArguments(string);
        commandExecutionWorker.start();
        this.fExportedVariables = new IVICInstrumentMCode(string4, string2, "IviInstrumentObject");
    }

    private void postIvicInstrumentObjectEvent(String string) {
        if (this.fListener != null) {
            this.fListener.updateIviCInstrumentObjectStatus(string);
        }
    }

    private void addIviCInstrumentObjectListener(IviCInstrumentObjectPage iviCInstrumentObjectPage) {
        this.fListener = iviCInstrumentObjectPage;
    }

    private void removeIviCInstrumentObjectListener() {
        this.fListener = null;
    }

    public IVICInstrumentMCode getLastInvokeMCode() {
        return this.fExportedVariables;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        this.fName = string;
    }

    private class CommandExecutionWorker
    extends MatlabWorker {
        private final Object[] args;

        private CommandExecutionWorker() {
            this.args = new Object[]{IviCInstrumentObject.IviCInstrumentMATLABHelperFunction, "executeFunction", IviCInstrumentObject.this.fIvicInstrumentObj, IviCInstrumentObject.this.fName, "", ""};
        }

        public void setCode(String string) {
            this.args[4] = string;
            IviCInstrumentObject.this.addMcodeToSessionLog(string);
        }

        public void setOutputArguments(String string) {
            this.args[5] = string;
        }

        public Object runOnMatlabThread() {
            Object[] objectArray = null;
            try {
                objectArray = (Object[])CommandExecutionWorker.feval((String)"instrgate", (Object[])this.args, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return objectArray;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            if (string2.equals("yes")) {
                IviCInstrumentObject.this.postIvicInstrumentObjectEvent(IviCInstrumentObject.EnableExport);
                IviCInstrumentObject.this.fExportedVariables.setVariables(objectArray[2]);
                IviCInstrumentObject.this.fExportedVariables.setVariableNames((String[])objectArray[3]);
            }
            IviCInstrumentObject.this.postIvicInstrumentObjectEvent(string);
        }
    }

    private class IviCInstrumentObjectCreationWorker
    extends MatlabWorker {
        private final Object[] matlabArgs;

        public Object runOnMatlabThread() {
            Object object = null;
            IviCInstrumentObject.this.fBrowser.postBlockEventsEvent(true);
            try {
                object = IviCInstrumentObjectCreationWorker.feval((String)"instrgate", (Object[])this.matlabArgs, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                object = exception.getMessage();
            }
            return object;
        }

        public IviCInstrumentObjectCreationWorker() {
            this.matlabArgs = new Object[]{IviCInstrumentObject.IviCInstrumentMATLABHelperFunction, "create", IviCInstrumentObject.this.fInstrumentType, true};
            String string = "% Create an IVI instrument object\n";
            string = string + IviCInstrumentObject.this.fName + " = instrument.ivic." + IviCInstrumentObject.this.fInstrumentType + "();\n";
            IviCInstrumentObject.this.addMcodeToSessionLog(string);
            boolean bl = IviCInstrumentStore.getIviCInstrument(IviCInstrumentObject.this.fInstrumentType).getTreeRootNode() == null;
            this.matlabArgs[3] = bl;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            IviCInstrumentObject.this.fBrowser.postBlockEventsEvent(false);
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            if (string.equalsIgnoreCase("no")) {
                JOptionPane.showMessageDialog(null, "Can not create IVI instrument object, You may need to run mex -setup.");
                return;
            }
            Object[] objectArray2 = (Object[])objectArray[1];
            IviCInstrumentObject.this.fIvicInstrumentObj = (MLArrayRef)objectArray2[0];
            if (objectArray.length > 2) {
                try {
                    String string2 = (String)objectArray[2];
                    IviCWrapperXMLParser iviCWrapperXMLParser = new IviCWrapperXMLParser();
                    DefaultMutableTreeNode defaultMutableTreeNode = iviCWrapperXMLParser.parseString(string2);
                    IviCInstrumentStore.getIviCInstrument(IviCInstrumentObject.this.fInstrumentType).setTreeRootNode(defaultMutableTreeNode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IviCInstrumentObject.this.createIviInstrumentObjNode();
            IviCInstrumentObject.this.populateDriverTreeStructure();
        }
    }

    private class ConnectionWorker
    extends MatlabWorker {
        private Object[] matlabArgs;

        private ConnectionWorker() {
        }

        public Object runOnMatlabThread() {
            Object object = null;
            try {
                IviCInstrumentObject.this.fBrowser.postBlockEventsEvent(true);
                this.matlabArgs = IviCInstrumentObject.this.fLogicalName != null ? new Object[]{IviCInstrumentObject.IviCInstrumentMATLABHelperFunction, "connectWithLogicalName", IviCInstrumentObject.this.fIvicInstrumentObj, IviCInstrumentObject.this.fName, IviCInstrumentObject.this.fLogicalName, IviCInstrumentObject.this.fSimulate} : new Object[]{IviCInstrumentObject.IviCInstrumentMATLABHelperFunction, "connect", IviCInstrumentObject.this.fIvicInstrumentObj, IviCInstrumentObject.this.fName, IviCInstrumentObject.this.fUnderlyingDriverName, IviCInstrumentObject.this.fResource, IviCInstrumentObject.this.fSimulate};
                object = ConnectionWorker.feval((String)"instrgate", (Object[])this.matlabArgs, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            IviCInstrumentObject.this.fBrowser.postBlockEventsEvent(false);
            if (object == null) {
                return;
            }
            IviCInstrumentObject.this.fConnected = false;
            String[] stringArray = (String[])object;
            if (stringArray[0].equalsIgnoreCase("connected")) {
                String string = "";
                IviCInstrumentObject.this.fConnected = true;
                if (stringArray.length > 1) {
                    IviCInstrumentObject.this.fHardwareAsset = stringArray[1];
                    IviCInstrumentObject.this.fSession = stringArray[2];
                    IviCInstrumentObject.this.fLogicalName = stringArray[3];
                    string = "% Create an IVI configuration store entry\n";
                    string = string + "configStore = iviconfigurationstore;\n";
                    string = string + "add(configStore, 'HardwareAsset', '" + IviCInstrumentObject.this.fHardwareAsset + "' , '" + IviCInstrumentObject.this.fResource + "');\n";
                    string = string + "% Add a driver session to the IVI configuration store.\n";
                    string = string + "add(configStore, 'DriverSession', '" + IviCInstrumentObject.this.fSession + "' , '" + IviCInstrumentObject.this.fUnderlyingDriverName + "' , '" + IviCInstrumentObject.this.fHardwareAsset + "');\n";
                    string = string + "% Add a logical name to the IVI configuration store.\n";
                    string = string + "add(configStore, 'LogicalName', '" + IviCInstrumentObject.this.fLogicalName + "' , '" + IviCInstrumentObject.this.fSession + "');\n";
                    string = string + "% Save the changes to the IVI configuration store.\n";
                    string = string + "commit(configStore);\n\n";
                }
                string = string + "% Connect IVI instrument object to hardware.\n";
                string = IviCInstrumentObject.this.fSimulate ? string + IviCInstrumentObject.this.fName + ".InitWithOption('" + IviCInstrumentObject.this.fLogicalName + "', false, false, 'fSimulate=true');\n" : string + IviCInstrumentObject.this.fName + ".init('" + IviCInstrumentObject.this.fLogicalName + "', false, false);\n";
                IviCInstrumentObject.this.addMcodeToSessionLog(string);
            }
            IviCInstrumentObject.this.postIvicInstrumentObjectEvent(IviCInstrumentObject.ConnectionStatus);
        }
    }

    private class DisconnectionWorker
    extends MatlabWorker {
        private final Object[] matlabArgs;

        private DisconnectionWorker() {
            this.matlabArgs = new Object[]{IviCInstrumentObject.IviCInstrumentMATLABHelperFunction, "disconnect", IviCInstrumentObject.this.fIvicInstrumentObj, IviCInstrumentObject.this.fName};
        }

        public Object runOnMatlabThread() {
            Object object = null;
            try {
                object = DisconnectionWorker.feval((String)"instrgate", (Object[])this.matlabArgs, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                object = exception.getMessage();
            }
            return object;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (object == null) {
                return;
            }
            String[] stringArray = (String[])object;
            if (stringArray[0].equalsIgnoreCase("disconnected")) {
                IviCInstrumentObject.this.fConnected = false;
                IviCInstrumentObject.this.postIvicInstrumentObjectEvent(IviCInstrumentObject.ConnectionStatus);
            } else {
                IviCInstrumentObject.this.fConnected = true;
                IviCInstrumentObject.this.postIvicInstrumentObjectEvent(IviCInstrumentObject.ConnectionStatus);
            }
        }
    }

    private class IviConfigStoreCleanUpWorker
    extends MatlabWorker {
        private IviConfigStoreCleanUpWorker() {
        }

        public Object runOnMatlabThread() {
            Object object = null;
            try {
                object = IviConfigStoreCleanUpWorker.feval((String)"instrument.internal.udm.ConfigStoreUtility.removeLogicalName", (Object[])new Object[]{IviCInstrumentObject.this.fHardwareAsset, IviCInstrumentObject.this.fSession, IviCInstrumentObject.this.fLogicalName}, (int)0, (boolean)false);
            }
            catch (Exception exception) {
                object = exception.getMessage();
            }
            return object;
        }

        public void runOnAWTEventDispatchThread(Object object) {
        }
    }
}

