/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.objects;

import com.mathworks.toolbox.instrument.VxiGpibVisa;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;

public class GPIBVXIObject
extends BrowserObject {
    private static final String[] MEMORY_INCREMENT = new String[]{"block", "FIFO"};
    protected String vendor;
    protected String chassisIndex;
    protected String logicalAddress;
    protected String eoiMode = "on";
    protected Object eosCharCode = "LF";
    protected String eosMode = "none";
    protected String memoryIncrement = "block";

    public GPIBVXIObject(String string, String string2, String string3, String string4, String string5) {
        super(string4, string5);
        this.vendor = string;
        this.chassisIndex = string2;
        this.logicalAddress = string3;
    }

    @Override
    public String[] getHeadingInfoColumnOne() {
        String[] stringArray = new String[]{"VISA vendor:", this.vendor, "Chassis index:", this.chassisIndex, "Logical address:", this.logicalAddress};
        return stringArray;
    }

    @Override
    public String getDescriptiveText() {
        return "chassis " + this.chassisIndex + ", logical address " + this.logicalAddress;
    }

    @Override
    public String getType() {
        return "GPIB-VXI";
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getChassisIndex() {
        return this.chassisIndex;
    }

    public String getLogicalAddress() {
        return this.logicalAddress;
    }

    public void setEOSCharCode(Object object) {
        this.eosCharCode = object;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((VxiGpibVisa)this.instrumentObject).setEOSCharCode(this.eosCharCode);
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting EOSCharCode", (String)tMException.getMessage());
        }
    }

    public Object getEOSCharCode() {
        return this.eosCharCode;
    }

    public void setEOSMode(String string) {
        this.eosMode = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((VxiGpibVisa)this.instrumentObject).setEOSMode(this.getIndex(EOSMODE, this.eosMode));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting EOSMode", (String)tMException.getMessage());
        }
    }

    public String getEOSMode() {
        return this.eosMode;
    }

    public String getEOIMode() {
        return this.eoiMode;
    }

    public void setEOIMode(String string) {
        this.eoiMode = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((VxiGpibVisa)this.instrumentObject).setEOIMode(this.str2bool(this.eoiMode));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting EOIMode", (String)tMException.getMessage());
        }
    }

    public void setMemoryIncrement(String string) {
        this.memoryIncrement = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((VxiGpibVisa)this.instrumentObject).setMemoryIncrement(this.getIndex(MEMORY_INCREMENT, this.memoryIncrement));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting MemoryIncrement", (String)tMException.getMessage());
        }
    }

    public String getMemoryIncrement() {
        return this.memoryIncrement;
    }
}

