/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.DeviceClient;
import com.mathworks.toolbox.instrument.device.InstrumentDriver;
import com.mathworks.toolbox.instrument.device.PropertyInfo;
import com.mathworks.toolbox.instrument.device.util.Displays;
import com.mathworks.toolbox.instrument.device.util.PropertyUtil;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.lang.reflect.Method;
import java.util.Vector;

public abstract class DeviceChild
implements DeviceClient {
    protected static Vector<DeviceChild> allObjects = new Vector();
    protected PropertyInfo[] objectProps = null;
    protected InstrumentDriver driver;
    private MLArrayRef MATLABObject = null;
    protected String defaultName = "";
    protected int hwindex = 0;
    protected String hwname = "";
    protected String name = "";
    protected Device parent = null;
    protected String type = "";
    static PropertyInfo[] baseProperties = new PropertyInfo[]{new PropertyInfo("HwIndex", "double", "none", null, new Integer(1), "always", 0, 0), new PropertyInfo("HwName", "string", "none", "", "", "always", 0, 0), new PropertyInfo("Name", "string", "none", "", "", "never", 0, 0), new PropertyInfo("Parent", "object", "object", null, "", "always", 0, 0), new PropertyInfo("Type", "string", "none", "", "", "always", 0, 0)};

    public DeviceChild() {
        allObjects.addElement(this);
    }

    public void willExecuteDriverMethodCode() {
        this.parent.willExecuteDriverMethodCode();
    }

    public void didExecuteDriverMethodCode() {
        this.parent.willExecuteDriverMethodCode();
    }

    public void setMATLABObject(MLArrayRef mLArrayRef) {
        if (this.MATLABObject != null) {
            this.MATLABObject.dispose();
        }
        this.MATLABObject = mLArrayRef;
    }

    @Override
    public MLArrayRef getMATLABObject() {
        return this.MATLABObject;
    }

    public Vector<DeviceChild> jinstrfind() {
        return allObjects;
    }

    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidChildDisplay("channel"));
            return;
        }
        System.out.println("");
        System.out.println("   Device channel object: " + this.getType());
        System.out.println("");
    }

    @Override
    public String getDisplayName() {
        return "device group";
    }

    public Object getBasePropertyValue(String string) throws TMException {
        string = this.findPropertyCompleteName(string);
        try {
            Method method = this.getClass().getMethod("get" + string, null);
            return method.invoke((Object)this, (Object[])null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setHwIndex(int n) throws TMException {
        TMStringUtil.throwReadOnlyPropertyError((String)"HwIndex");
    }

    public int getHwIndex() {
        return this.hwindex;
    }

    public void setHwName(String string) throws TMException {
        TMStringUtil.throwReadOnlyPropertyError((String)"HwName");
    }

    public String getHwName() {
        if (this.hwname.equals("")) {
            this.hwname = this.defaultName;
        }
        return this.hwname;
    }

    public void setName(String string) throws TMException {
        this.name = string;
        this.parent.postPropertyChangedEvent(this, "Name", this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setParent(MLArrayRef mLArrayRef) throws TMException {
        TMStringUtil.throwReadOnlyPropertyError((String)"Parent");
    }

    public MLArrayRef getParent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getMATLABObject();
    }

    public Device getJParent() {
        return this.parent;
    }

    public void setType(String string) throws TMException {
        TMStringUtil.throwReadOnlyPropertyError((String)"Type");
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void dispose() throws TMException {
        if (!this.isvalid()) {
            return;
        }
        allObjects.removeElement(this);
        if (this.MATLABObject != null) {
            this.MATLABObject.dispose();
        }
        this.driver = null;
        this.objectProps = null;
        this.parent = null;
    }

    @Override
    public boolean isvalid() {
        return allObjects.contains(this);
    }

    public String[] getMethodNames() {
        return this.getDriverMethods();
    }

    @Override
    public boolean isMethod(String string) {
        String[] stringArray = this.getMethodNames();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isDeviceChildMethod(String string) {
        return this.isMethod(string);
    }

    public String getMethodSignature(String string) throws TMException {
        return this.driver.getMethodSignature(string, this.getObjectType());
    }

    public Object[] executeMethod(String string) throws TMException {
        return this.executeMethod(string, null);
    }

    public Object[] executeMethod(String string, Object[] objectArray) throws TMException {
        this.parent.verifyObjectState();
        return this.driver.executeMethod(string, this.getObjectType(), objectArray, this.hwindex);
    }

    @Override
    public String getInstrumentMethodHelp(String string) throws TMException {
        return this.driver.getMethodHelp(string, this.getObjectType());
    }

    public String findPropertyCompleteName(String string) throws TMException {
        try {
            String[] stringArray = TMStringUtil.vector2StringArray(this.getAllProperties());
            int n = TMStringUtil.findPropertyCompleteName((String)string, (String[])stringArray);
            return stringArray[n];
        }
        catch (TMException tMException) {
            if (tMException.getMessage().endsWith("unique")) {
                throw new TMException("The '" + string + "' property name is ambiguous for device group objects.");
            }
            throw new TMException("There is no '" + string + "' property for device group objects.");
        }
    }

    public static PropertyInfo[] getBasePropertyInfo() {
        return baseProperties;
    }

    @Override
    public Vector<String> getProperties() {
        return this.getDriverProperties();
    }

    @Override
    public Vector<String> getAllProperties() throws TMException {
        Vector<String> vector = this.getBasePropertyNames();
        Vector<String> vector2 = this.getProperties();
        if (vector2 == null) {
            return vector;
        }
        return TMStringUtil.sort(vector2, vector);
    }

    @Override
    public Vector<String> getBasePropertyNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < baseProperties.length; ++i) {
            vector.addElement(DeviceChild.baseProperties[i].name);
        }
        return vector;
    }

    @Override
    public boolean isBaseProperty(String string) {
        try {
            string = this.findPropertyCompleteName(string);
            return this.getBasePropertyNames().indexOf(string) != -1;
        }
        catch (TMException tMException) {
            return false;
        }
    }

    private int getBasePropertyIndex(String string) {
        return this.getBasePropertyNames().indexOf(string);
    }

    @Override
    public boolean isGroupProperty(String string) {
        return false;
    }

    @Override
    public String getInstrumentGroupHelp(String string) throws TMException {
        throw new TMException("Invalid property: " + string + ".");
    }

    public void verifyObjectState() throws TMException {
        this.parent.verifyObjectState();
    }

    public final String[] getPropertyNames() throws TMException {
        return TMStringUtil.vector2StringArray(this.getAllProperties());
    }

    public final int[] isInterfaceSpecific() throws TMException {
        return PropertyUtil.isInterfaceSpecific(this);
    }

    public final String setDisplay() throws TMException {
        return Displays.setDisplay(this);
    }

    public final Object createPropSetArray(String string) throws TMException {
        return PropertyUtil.createPropSetArray(this, string);
    }

    public final String createPropSetDisplay(String[] stringArray) throws TMException {
        return PropertyUtil.createPropSetDisplay(this, stringArray);
    }

    @Override
    public Object[] getValidRange(String string) {
        return this.driver.getValidRange(string, this.getObjectType());
    }

    @Override
    public int getNumberOfEnums(String string) {
        return this.driver.getNumberOfEnums(string, this.getObjectType());
    }

    @Override
    public String getSetList(String string) {
        return this.driver.getSetList(string, this.getObjectType());
    }

    public final Object[] propinfo() throws TMException {
        if (!this.isvalid()) {
            TMStringUtil.error((String)"Device object OBJ is an invalid object.");
        }
        if (this.objectProps == null) {
            this.objectProps = this.getPropertyInfo();
        }
        this.updateObjectSpecificProperties(this.objectProps);
        return PropertyUtil.propinfo(this, this.objectProps);
    }

    public final Object[] propinfo(String[] stringArray) throws TMException {
        if (!this.isvalid()) {
            TMStringUtil.error((String)"Device object OBJ is an invalid object.");
        }
        if (this.objectProps == null) {
            this.objectProps = this.getPropertyInfo();
        }
        this.updateObjectSpecificProperties(this.objectProps);
        return PropertyUtil.propinfoWithoutName(this, this.getPropertyInfo(stringArray));
    }

    private void updateObjectSpecificProperties(PropertyInfo[] propertyInfoArray) {
        for (int i = 0; i < propertyInfoArray.length; ++i) {
            if (propertyInfoArray[i].name.equals("HwIndex")) {
                propertyInfoArray[i].defaultValue = new Integer(this.hwindex);
                continue;
            }
            if (propertyInfoArray[i].name.equals("HwName")) {
                propertyInfoArray[i].defaultValue = this.hwname;
                continue;
            }
            if (propertyInfoArray[i].name.equals("Name")) {
                propertyInfoArray[i].defaultValue = this.name;
                continue;
            }
            if (propertyInfoArray[i].name.equals("Parent")) {
                propertyInfoArray[i].setDefaultValue(this.parent.getMATLABObject());
                continue;
            }
            if (!propertyInfoArray[i].name.equals("Type")) continue;
            propertyInfoArray[i].defaultValue = this.type;
        }
    }

    @Override
    public String getInstrumentPropertyHelp(String string) throws TMException {
        return this.driver.getPropertyHelp(this.findPropertyCompleteName(string), this.getObjectType());
    }

    public PropertyInfo getInstrumentPropertyInformation(String string) {
        return this.driver.getPropertyInformation(string, this.getObjectType());
    }

    public Object[] ObjectHardwareInfo() throws TMException {
        return this.parent.ObjectHardwareInfo();
    }

    public Object[] ObjectHardwareInfo(String[] stringArray) throws TMException {
        return this.parent.ObjectHardwareInfo(stringArray);
    }

    public PropertyInfo[] getPropertyInfo() throws TMException {
        Vector<String> vector = this.getAllProperties();
        PropertyInfo[] propertyInfoArray = new PropertyInfo[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            propertyInfoArray[i] = this.getPropertyInfo(vector.elementAt(i));
        }
        return propertyInfoArray;
    }

    public PropertyInfo[] getPropertyInfo(String[] stringArray) throws TMException {
        PropertyInfo[] propertyInfoArray = new PropertyInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            propertyInfoArray[i] = this.getPropertyInfo(this.findPropertyCompleteName(stringArray[i]));
        }
        return propertyInfoArray;
    }

    @Override
    public PropertyInfo getPropertyInfo(String string) throws TMException {
        int n = this.getBasePropertyIndex(string);
        if (n != -1) {
            return baseProperties[n];
        }
        return this.getInstrumentPropertyInformation(this.findPropertyCompleteName(string));
    }

    public abstract Vector<String> getDriverProperties();

    public abstract String[] getDriverMethods();

    public abstract String getObjectType();

    public Object getParentObject() throws TMException {
        if (this.objectProps == null) {
            this.objectProps = this.getPropertyInfo();
        }
        for (int i = 0; i < this.objectProps.length; ++i) {
            if (!this.objectProps[i].name.equals("Parent")) continue;
            this.objectProps[i].setDefaultValue(this.parent.getMATLABObject());
            Object[] objectArray = new Object[]{this.objectProps[i].defaultValue};
            return objectArray;
        }
        return null;
    }
}

