/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.InstrumentDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.drivers.xml.XMLDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;

public abstract class ExternalDriver
extends XMLDriver
implements InstrumentDriver,
Runnable {
    protected MLArrayRef deviceMLObject = null;
    protected ICDevice deviceObject = null;
    protected double timeout = 10.0;
    protected String logicalName = "";
    protected String resourceName = "";
    protected String instrumentModel = "";
    protected Object[] getArgs = new Object[]{"privateEvaluateGetCode", "", "", "", "", ""};
    protected Object[] setArgs = new Object[]{"privateEvaluateSetCode", "", "", "", "", "", ""};
    protected Object[] itrArgs = new Object[]{"privateExecuteMCode", "", "", null, ""};

    public ExternalDriver(Parser parser) throws TMException {
        this.xmlParser = parser;
        this.driverName = this.xmlParser.getDriverName();
        this.validateDriverType();
    }

    public ExternalDriver(Parser parser, String string) throws TMException {
        this(parser);
        this.resourceName = string;
    }

    protected abstract void validateDriverType() throws TMException;

    @Override
    public abstract Object[] defineConstructorArgs();

    @Override
    public abstract int defineDriverType();

    @Override
    public abstract String defineConstructor();

    @Override
    public abstract String defineConstructorDescription();

    @Override
    public void setJDeviceObject(Device device) {
        this.deviceObject = (ICDevice)device;
    }

    @Override
    public void setDeviceObject(MLArrayRef mLArrayRef) {
        this.deviceMLObject = mLArrayRef;
        this.getArgs[1] = this.deviceMLObject;
        this.setArgs[1] = this.deviceMLObject;
        this.itrArgs[2] = this.deviceMLObject;
    }

    @Override
    public void dispose() throws TMException {
        if (this.deviceMLObject != null) {
            this.deviceMLObject.dispose();
        }
        if (this.xmlParser != null) {
            this.xmlParser.dispose();
        }
    }

    public static boolean parseOkToWarn() {
        return OK_TO_WARN;
    }

    @Override
    public abstract int getStatusBasedOnInterface();

    @Override
    public String getInstrumentModel() {
        return this.instrumentModel;
    }

    @Override
    public void setInstrumentModel(String string) throws TMException {
        TMStringUtil.error((String)"Changing the 'InstrumentModel' property of device objects is not allowed.");
    }

    @Override
    public String getRsrcName() {
        return this.resourceName;
    }

    @Override
    public String getLogicalName() {
        return this.logicalName;
    }

    @Override
    public void open() throws TMException {
    }

    @Override
    public void close() throws TMException {
    }

    @Override
    public void setTimeout(double d) throws TMException {
        this.timeout = d;
    }

    @Override
    public double getTimeout() {
        return this.timeout;
    }

    @Override
    public String getInterfaceConstructor() {
        return "";
    }

    @Override
    public String getError() throws TMException {
        throw new TMException("geterror is not a supported function for this driver.");
    }

    @Override
    public void hwreset() throws TMException {
        throw new TMException("devicereset is not a supported function for this driver.");
    }

    @Override
    public String selftest() throws TMException {
        throw new TMException("selftest is not a supported function for this driver.");
    }

    @Override
    public Object[] executeMethod(String string, String string2, Object[] objectArray) throws TMException {
        return null;
    }

    @Override
    public Object[] executeMethod(String string, String string2, Object[] objectArray, int n) throws TMException {
        return null;
    }

    @Override
    public void setProperty(String string, String string2, Object object) throws TMException {
        this.currentChannelIndex = -1;
        this.setPropertyValue(string, string2, object);
    }

    @Override
    public void setProperty(String string, String string2, Object object, int n) throws TMException {
        this.currentChannelIndex = n;
        this.setPropertyValue(string, string2, object);
    }

    @Override
    public Object getProperty(String string, String string2) throws TMException {
        this.currentChannelIndex = -1;
        return this.getPropertyValue(string, string2);
    }

    @Override
    public Object getProperty(String string, String string2, int n) throws TMException {
        this.currentChannelIndex = n;
        return this.getPropertyValue(string, string2);
    }

    @Override
    public Vector<String> getPropertyGroups() {
        return this.xmlParser.getPropertyGroups();
    }

    @Override
    public Object getDefaultValue(String string, String string2) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        String string3 = (String)propertyDefinition.getDefaultValue();
        return propertyDefinition.getOutputValue(string3);
    }

    public void setPropertyValue(String string, String string2, Object object) throws TMException {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        if (!propertyDefinition.isValidValue(object, string2, this)) {
            TMStringUtil.error((String)propertyDefinition.getErrorMessage(this));
        }
        object = propertyDefinition.getValidValue(object);
        if (this.currentChannelIndex == -1) {
            propertyDefinition.setCurrentValue(object);
        } else {
            propertyDefinition.setCurrentValue(object, this.currentChannelIndex);
        }
        this.setPropertyValueFromMCode(propertyDefinition, object, string2);
    }

    protected void setPropertyValueFromMCode(PropertyDefinition propertyDefinition, Object object, String string) throws TMException {
        this.setArgs[2] = propertyDefinition.getName();
        this.setArgs[3] = object;
        this.setArgs[4] = propertyDefinition.getSetMCodeToEvaluate();
        this.setArgs[5] = new Integer(this.currentChannelIndex);
        this.setArgs[6] = string;
        this.deviceObject.willExecuteDriverPropertyCode();
        if (!NativeMatlab.nativeIsMatlabThread()) {
            this.matlabMCR.whenMatlabReady((Runnable)this);
            return;
        }
        try {
            MatlabMCR.mtFevalConsoleOutput((String)"instrgate", (Object[])this.setArgs, (int)0);
        }
        catch (Exception exception) {
            throw new TMException(exception.getMessage());
        }
        this.deviceObject.didExecuteDriverPropertyCode();
    }

    @Override
    public void run() {
        try {
            MatlabMCR.mtFeval((String)"instrgate", (Object[])this.setArgs, (int)0);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public Object getPropertyValue(String string, String string2) throws TMException {
        Object object;
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        Object object2 = this.getPropertyValueFromMCode(propertyDefinition, string2);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof double[]) {
            double[] dArray = (double[])object2;
            if (dArray == null || dArray.length == 0) {
                return new Double(0.0);
            }
            object2 = new Double(dArray[0]);
        } else if (object2 instanceof boolean[]) {
            boolean[] blArray = (boolean[])object2;
            object2 = ((Boolean)(object2 = new Boolean(blArray[0]))).booleanValue() ? "on" : "off";
        } else if (object2 instanceof String && (object = propertyDefinition.getOutputValue((String)object2)) != null) {
            object2 = object;
        }
        if (this.currentChannelIndex == -1) {
            propertyDefinition.setCurrentValue(object2);
        } else {
            propertyDefinition.setCurrentValue(object2, this.currentChannelIndex);
        }
        return object2;
    }

    protected Object getPropertyValueFromMCode(PropertyDefinition propertyDefinition, String string) {
        this.getArgs[2] = propertyDefinition.getName();
        this.getArgs[3] = propertyDefinition.getGetMCodeToEvaluate();
        this.getArgs[4] = new Integer(this.currentChannelIndex);
        this.getArgs[5] = string;
        Object object = null;
        this.deviceObject.willExecuteDriverPropertyCode();
        try {
            object = MatlabMCR.mtFevalConsoleOutput((String)"instrgate", (Object[])this.getArgs, (int)1);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        this.deviceObject.didExecuteDriverPropertyCode();
        return object;
    }

    @Override
    public boolean isValidConstraint(String string, String string2, String string3) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        try {
            Object object = this.getPropertyValue(string, string2);
            Object object2 = propertyDefinition.getOutputValue(string3);
            return object == object2;
        }
        catch (TMException tMException) {
            return false;
        }
    }

    protected MLArrayRef initRefWithObject(Object object) {
        try {
            Object[] objectArray = new Object[]{new Integer(45), object};
            MLArrayRef mLArrayRef = (MLArrayRef)MatlabMCR.mtFeval((String)"system_dependent", (Object[])objectArray, (int)1);
            return mLArrayRef;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return Device.USERDATA;
        }
    }
}

