/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml.property;

import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.testmeas.guiutil.RangeTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PositiveDoubleProperty
extends PropertyConstraint {
    private Double[] constraintValues = new Double[2];
    private RangeTextField valueTextField = null;

    public PositiveDoubleProperty() {
        this.constraintValues[0] = new Double(0.0);
        this.constraintValues[1] = new Double(Double.POSITIVE_INFINITY);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getConstraint() {
        return 0;
    }

    @Override
    public Object[] getConstraintValues() {
        return this.constraintValues;
    }

    @Override
    public Object getDefaultValue() {
        return new Double(0.0);
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof Double) {
            return (Double)object >= 0.0;
        }
        return false;
    }

    @Override
    public String getSetList() {
        return "[ 0 to inf]";
    }

    @Override
    public String getSetError() {
        return "a value between 0 and inf";
    }

    @Override
    public JPanel getPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 2, 0));
        jPanel.add(new JLabel("A positive double value:"));
        this.valueTextField = new RangeTextField("Double Property Value", 0.0, Double.MAX_VALUE, "0");
        this.valueTextField.setMode(1);
        this.valueTextField.setOKToBeEmpty(false);
        this.valueTextField.setOKToError(false);
        jPanel.add((Component)this.valueTextField);
        Dimension dimension = this.valueTextField.getPreferredSize();
        if (dimension.width < 93) {
            dimension.width = 93;
        }
        this.valueTextField.setPreferredSize(dimension);
        return jPanel;
    }

    @Override
    public Object getPanelValue() {
        return this.valueTextField.getText();
    }

    @Override
    public void setPanelValue(Object object) {
        this.valueTextField.setText((String)object);
    }

    @Override
    public String getCellArrayOfValues(int n) {
        if (n == 0) {
            return "{}";
        }
        String string = "";
        double d = 1000.0;
        double d2 = 0.0;
        double d3 = d - d2;
        double d4 = Math.floor(d3 / (double)n);
        if (d4 == 0.0) {
            d4 = d3 / (double)n;
        }
        for (int i = 0; i < n; ++i) {
            string = string + String.valueOf(d2 + (double)i * d4) + ", ";
        }
        string = string.substring(0, string.length() - 2);
        string = "{" + string + "}";
        return string;
    }
}

