/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.testmeas.guiutil.RangeTextField;
import com.mathworks.toolbox.testmeas.guiutil.TMHelpViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class TestOptionsDialog
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String ACTION = "ACTION";
    private static final int CANCEL = 0;
    private static final int OK = 1;
    private static final int HELP = 2;
    private MIDTestToolClient client;
    private ButtonGroup runModeButtonGroup;
    private ButtonGroup failActionButtonGroup;
    private JTextField noErrorMessageTextField;
    private RangeTextField numValuesTextField;
    private MJFrame frame;
    private MJDialog dialog;

    public TestOptionsDialog(MIDTestToolClient mIDTestToolClient, int n, int n2, String string, String string2) {
        this.client = mIDTestToolClient;
        this.layoutPanel(string2);
        this.setRunMode(n);
        this.setFailAction(n2);
        this.setErrorMessage(string);
        this.setNumOfValues(string2);
        this.setName("Test Options Dialog");
    }

    private void layoutPanel(String string) {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = this.add(this.createRunModePanel(), this.createFailActionPanel(), 5);
        JPanel jPanel2 = this.add(jPanel, this.createErrorMessagePanel(), 5);
        JPanel jPanel3 = this.add(jPanel2, this.createNumValuesPanel(string), 5);
        this.add((Component)jPanel3, "North");
        this.add((Component)this.createLowerButtonPanel(), "South");
    }

    private JPanel createRunModePanel() {
        JRadioButton jRadioButton = new JRadioButton("Run all steps", true);
        JRadioButton jRadioButton2 = new JRadioButton("Run current step only", false);
        this.runModeButtonGroup = new ButtonGroup();
        this.runModeButtonGroup.add(jRadioButton);
        this.runModeButtonGroup.add(jRadioButton2);
        jRadioButton.setName("Run all steps Radiobutton");
        jRadioButton2.setName("Run current step only Radiobutton");
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Select run mode");
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    private JPanel createFailActionPanel() {
        JRadioButton jRadioButton = new JRadioButton("Continue test", true);
        JRadioButton jRadioButton2 = new JRadioButton("Reset instrument and continue test", false);
        JRadioButton jRadioButton3 = new JRadioButton("Stop test", false);
        JRadioButton jRadioButton4 = new JRadioButton("Stop test and reset instrument", false);
        this.failActionButtonGroup = new ButtonGroup();
        this.failActionButtonGroup.add(jRadioButton);
        this.failActionButtonGroup.add(jRadioButton2);
        this.failActionButtonGroup.add(jRadioButton3);
        this.failActionButtonGroup.add(jRadioButton4);
        jRadioButton.setName("Continue test Radiobutton");
        jRadioButton2.setName("Reset instrument and continue test Radiobutton");
        jRadioButton3.setName("Stop test Radiobutton");
        jRadioButton4.setName("Stop test and reset instrument Radiobutton");
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 0, 0));
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        jPanel.add(jRadioButton3);
        jPanel.add(jRadioButton4);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Select fail action");
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    private JPanel createErrorMessagePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.noErrorMessageTextField = new JTextField("+0, No error");
        this.noErrorMessageTextField.setName("No error Text Field");
        jPanel.add((Component)new JLabel("Message returned from instrument when no error occurred: "), "West");
        jPanel.add((Component)this.noErrorMessageTextField, "Center");
        return jPanel;
    }

    private JPanel createNumValuesPanel(String string) {
        JPanel jPanel = new JPanel(new BorderLayout(64, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.numValuesTextField = new RangeTextField("Test Options Number of Values To Test", 0.0, Double.MAX_VALUE, string);
        this.numValuesTextField.setMode(0);
        this.numValuesTextField.setOKToBeEmpty(false);
        this.numValuesTextField.setOKToError(true);
        this.numValuesTextField.setName("Number of Values Text Field");
        jPanel.add((Component)new JLabel("Number of values to test for double properties: "), "West");
        jPanel.add((Component)this.numValuesTextField, "Center");
        return jPanel;
    }

    private JPanel createLowerButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        JButton jButton = new JButton("OK");
        jButton.addActionListener(this);
        jButton.putClientProperty(ACTION, new Integer(1));
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(this);
        jButton2.putClientProperty(ACTION, new Integer(0));
        JButton jButton3 = new JButton("Help");
        jButton3.setMnemonic(72);
        jButton3.addActionListener(this);
        jButton3.putClientProperty(ACTION, new Integer(2));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jButton.setName("Test Options OK Button");
        jButton2.setName("Test Options Cancel Button");
        jButton3.setName("Test Options Help Button");
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void showAsDialog(MJFrame mJFrame) {
        this.frame = mJFrame;
        this.dialog = new MJDialog((Frame)this.frame, "Test Preferences", true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        Point point = this.frame.getLocation();
        this.dialog.setLocation(point.x, point.y);
        this.dialog.setResizable(false);
        this.dialog.show();
    }

    private JPanel add(JPanel jPanel, JPanel jPanel2, int n) {
        JPanel jPanel3 = new JPanel(new BorderLayout(0, n));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "Center");
        return jPanel3;
    }

    private void selectIndexInButtonGroup(ButtonGroup buttonGroup, int n) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (n2 == n) {
                jRadioButton.setSelected(true);
                break;
            }
            ++n2;
        }
    }

    private int getSelectedIndexInButtonGroup(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.isSelected()) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public void setRunMode(int n) {
        this.selectIndexInButtonGroup(this.runModeButtonGroup, n);
    }

    public int getRunMode() {
        return this.getSelectedIndexInButtonGroup(this.runModeButtonGroup);
    }

    public void setFailAction(int n) {
        this.selectIndexInButtonGroup(this.failActionButtonGroup, n);
    }

    public int getFailAction() {
        return this.getSelectedIndexInButtonGroup(this.failActionButtonGroup);
    }

    public void setErrorMessage(String string) {
        this.noErrorMessageTextField.setText(string);
    }

    public String getErrorMessage() {
        return this.noErrorMessageTextField.getText();
    }

    public void setNumOfValues(String string) {
        this.numValuesTextField.setText(string);
    }

    public String getNumOfValues() {
        return this.numValuesTextField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.dialog.dispose();
                break;
            }
            case 1: {
                this.client.updateTestOptions(this.getRunMode(), this.getFailAction(), this.getErrorMessage(), this.getNumOfValues());
                this.dialog.dispose();
                break;
            }
            case 2: {
                TMHelpViewer tMHelpViewer = TMHelpViewer.getInstance();
                tMHelpViewer.update("instrument", "midtest_csh\\testprefs.html", "Test Preferences Help");
                tMHelpViewer.addToDialog();
            }
        }
        this.dialog.getRootPane().setDefaultButton(null);
    }
}

