/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverClient;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import javax.swing.ImageIcon;

public class MIDNode
extends BrowserTreeNode {
    private static final long serialVersionUID = 1L;
    public static final int kRoot = 0;
    public static final int kSummary = 1;
    public static final int kInitialization = 2;
    public static final int kGroupList = 3;
    public static final int kGroup = 4;
    public static final int kProperty = 5;
    public static final int kFunction = 6;
    public static final int kDevicePropertyList = 7;
    public static final int kDeviceFunctionList = 8;
    public static final int kGroupPropertyList = 9;
    public static final int kGroupFunctionList = 10;
    public static final int kNumTreeNodeTypes = 11;
    protected int fType;
    private boolean isRoot = false;
    private boolean isProperty = false;
    private boolean isFunction = false;
    private boolean isEditable = false;
    private boolean isRemoveable = false;
    private boolean isCloneable = false;
    private boolean isDeviceList = false;
    private static ImageIcon sDriverIcon;
    private static ImageIcon sSummaryIcon;
    private static ImageIcon sInitializationIcon;
    private static ImageIcon sGroupIcon;
    private static ImageIcon sPropertyIcon;
    private static ImageIcon sFunctionIcon;

    public MIDNode(String string, DriverClient driverClient, int n, Object object) {
        super(string, (BrowserClient)driverClient, object);
        this.setType(n);
    }

    public int getType() {
        return this.fType;
    }

    public void setType(int n) {
        this.fType = n;
        switch (this.fType) {
            case 0: {
                this.isRoot = true;
                break;
            }
            case 4: {
                this.isRemoveable = true;
                this.isEditable = true;
                break;
            }
            case 5: {
                this.isRemoveable = true;
                this.isProperty = true;
                this.isEditable = true;
                this.isCloneable = true;
                break;
            }
            case 6: {
                this.isRemoveable = true;
                this.isFunction = true;
                this.isEditable = true;
                this.isCloneable = true;
                break;
            }
            case 7: 
            case 8: {
                this.isDeviceList = true;
            }
        }
    }

    public boolean getEditable() {
        return this.isEditable;
    }

    public ImageIcon getIcon() {
        ImageIcon imageIcon = null;
        switch (this.getType()) {
            case 0: {
                imageIcon = sDriverIcon;
                break;
            }
            case 1: {
                imageIcon = sSummaryIcon;
                break;
            }
            case 2: {
                imageIcon = sInitializationIcon;
                break;
            }
            case 3: 
            case 4: {
                imageIcon = sGroupIcon;
                break;
            }
            case 7: 
            case 9: {
                imageIcon = sPropertyIcon;
                break;
            }
            case 8: 
            case 10: {
                imageIcon = sFunctionIcon;
            }
        }
        return imageIcon;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public boolean isDeviceList() {
        return this.isDeviceList;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isRemoveable() {
        return this.isRemoveable;
    }

    public boolean isCloneable() {
        return this.isCloneable;
    }

    static {
        try {
            Class<MIDNode> clazz = MIDNode.class;
            sDriverIcon = new ImageIcon(clazz.getResource("resources/driverfile.gif"));
            sSummaryIcon = new ImageIcon(clazz.getResource("resources/doc_summary.gif"));
            sInitializationIcon = new ImageIcon(clazz.getResource("resources/doc_init_and_cleanup.gif"));
            sGroupIcon = new ImageIcon(clazz.getResource("resources/group.gif"));
            sPropertyIcon = new ImageIcon(clazz.getResource("resources/doc_property.gif"));
            sFunctionIcon = new ImageIcon(clazz.getResource("resources/doc_function.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

