/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.icdevice;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.DeviceChild;
import com.mathworks.toolbox.instrument.device.InstrumentDriver;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.instrument.device.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Calendar;
import java.util.Vector;

public class ICDeviceChild
extends DeviceChild
implements AutoConvertStringToMatlabChar {
    public static final int OUTPUT = 0;
    public static final int INPUT = 1;
    public static final int GROUP = 2;
    public static final String[] BASE_PROPS = new String[]{"HwIndex", "HwName", "Name", "Parent", "Type"};
    private String TYPE;
    private String childType = "output";
    private String className = "icoutput";
    private String childTypeName = "Output";

    public ICDeviceChild(ICDevice iCDevice, InstrumentDriver instrumentDriver, Object object) {
        Object[] objectArray = (Object[])object;
        this.parent = iCDevice;
        this.hwindex = (Integer)objectArray[0];
        this.driver = instrumentDriver;
    }

    public ICDeviceChild(ICDevice iCDevice, int n, InstrumentDriver instrumentDriver, int n2) {
        this.parent = iCDevice;
        this.hwindex = n;
        this.driver = instrumentDriver;
    }

    protected void assignNameValues(String string) {
        this.childType = string.toLowerCase();
        this.className = "ic" + this.childType;
        this.childTypeName = this.childType.substring(0, 1).toUpperCase() + this.childType.substring(1).toLowerCase();
        this.name = this.childTypeName + this.hwindex;
        this.type = this.parent.getType() + "-" + this.childType;
        this.TYPE = string;
        this.hwname = this.driver.getGroupName(this.childType, this.hwindex);
        this.defaultName = this.name;
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidChildDisplay(this.childType));
            return;
        }
        System.out.println("");
        System.out.println("   Device " + this.childType + " .object: " + this.getType());
        System.out.println("");
    }

    @Override
    public String getDisplayName() {
        return this.childType + " group";
    }

    public String mclass() {
        return this.className;
    }

    public String getChildTypeName() {
        return this.childTypeName;
    }

    @Override
    public String getObjectType() {
        return this.TYPE;
    }

    protected void open(String string) throws TMException {
        if (string.equals("object")) {
            return;
        }
        Vector<String> vector = this.getDriverProperties();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = vector.elementAt(i);
            this.driver.setProperty(string2, this.TYPE, this.driver.getDisplayValue(string2, this.TYPE, this.hwindex), this.hwindex);
        }
    }

    @Override
    public Vector<String> getDriverProperties() {
        return this.driver.getProperties(this.childType);
    }

    public InstrumentDriver getDriver() {
        return this.driver;
    }

    @Override
    public String[] getDriverMethods() {
        try {
            return this.driver.getMethods(this.childType);
        }
        catch (TMException tMException) {
            return null;
        }
    }

    public boolean isParentMethod(String string) {
        try {
            String[] stringArray = this.driver.getMethods("parent");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].toLowerCase().equals(string.toLowerCase())) continue;
                return true;
            }
        }
        catch (TMException tMException) {
            // empty catch block
        }
        return false;
    }

    public boolean isMethodMCode(String string) throws TMException {
        return this.driver.isMethodMCode(string, this.TYPE);
    }

    public String getMethodMCode(String string) throws TMException {
        return this.driver.getMethodMCode(string, this.TYPE);
    }

    public void setProperty(String string, Object object) throws TMException {
        Object object2;
        string = this.findPropertyCompleteName(string);
        switch (this.parent.getStatus()) {
            case 1: {
                this.driver.setProperty(string, this.TYPE, object, this.hwindex);
                break;
            }
            case 0: {
                this.driver.isValidPropertyValue(string, this.TYPE, object);
                this.driver.setCurrentValue(string, this.TYPE, object, this.hwindex);
            }
        }
        this.parent.postPropertyChangedEvent(this, string, object);
        if (this.parent.getStatus() == 1 && this.parent.getConfirmationFcn() != Device.CALLBACK && !object.equals(object2 = this.driver.getDisplayValue(string, this.TYPE))) {
            this.parent.executeConfirmationEvent(this, Calendar.getInstance(), string, object, object2);
        }
    }

    public Object getProperty(String string) throws TMException {
        string = this.findPropertyCompleteName(string);
        switch (this.parent.getStatus()) {
            case 1: {
                return this.driver.getProperty(string, this.TYPE, this.hwindex);
            }
            case 0: {
                return this.driver.getDisplayValue(string, this.TYPE, this.hwindex);
            }
        }
        return null;
    }

    public String isValidPropertyName(String string) {
        try {
            Vector<String> vector = this.getAllProperties();
            int n = TMStringUtil.findPropertyCompleteName((String)string, (String[])TMStringUtil.vector2StringArray(vector));
            return vector.elementAt(n);
        }
        catch (TMException tMException) {
            return "";
        }
    }
}

