/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.util;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.device.CallbackQueue;
import com.mathworks.toolbox.instrument.device.DeleteListenerObject;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.PropertyListenerObject;
import com.mathworks.toolbox.instrument.device.event.Event;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Calendar;
import java.util.Vector;

public class MLNotifier {
    private static Vector<Object> propertyChangedCallbacks = new Vector();
    private static Vector<Object> objectCreateCallbacks = new Vector();
    private static Vector<Object> objectDestroyCallbacks = new Vector();

    public void cleanup() {
        for (int i = 0; i < propertyChangedCallbacks.size(); ++i) {
            PropertyListenerObject propertyListenerObject = (PropertyListenerObject)propertyChangedCallbacks.elementAt(i);
            if (!propertyListenerObject.okToDispose()) continue;
            propertyListenerObject.cleanup();
        }
    }

    public void cleanupDestroyCallbacks() {
        for (int i = 0; i < objectDestroyCallbacks.size(); ++i) {
            DeleteListenerObject deleteListenerObject = (DeleteListenerObject)objectDestroyCallbacks.elementAt(i);
            if (!deleteListenerObject.okToDispose()) continue;
            deleteListenerObject.cleanup();
        }
    }

    public void addNotification(String string, MLArrayRef mLArrayRef) throws TMException {
        if ((string = string.toLowerCase()).equals("propertychangedpostset")) {
            propertyChangedCallbacks.addElement(new PropertyListenerObject(mLArrayRef));
        } else if (string.equals("objectcreated")) {
            objectCreateCallbacks.addElement(mLArrayRef);
        } else if (string.equals("objectdeleted")) {
            objectDestroyCallbacks.addElement(new DeleteListenerObject(mLArrayRef));
        } else {
            throw new TMException("Invalid TYPE. TYPE can be 'PropertyChangedPostSet', 'ObjectCreated' or 'ObjectDeleted'.");
        }
    }

    public void addNotification(String string, Vector<Object> vector, String[] stringArray, MLArrayRef mLArrayRef) throws TMException {
        if ((string = string.toLowerCase()).equals("propertychangedpostset")) {
            propertyChangedCallbacks.addElement(new PropertyListenerObject(mLArrayRef, vector, stringArray));
        } else if (string.equals("objectcreated")) {
            TMStringUtil.warning((String)"The CALLBACK will not be evaluated since OBJ is already created.");
        } else if (string.equals("objectdeleted")) {
            objectDestroyCallbacks.addElement(new DeleteListenerObject(mLArrayRef, vector));
        } else {
            throw new TMException("Invalid syntax. Type 'instrhelp instrnotify' for more information.");
        }
    }

    public static void removeNotification(String string, int n) throws TMException {
        if (n == -1) {
            throw new TMException("The specified CALLBACK was not found.");
        }
        if ((string = string.toLowerCase()).equals("propertychangedpostset")) {
            propertyChangedCallbacks.removeElementAt(n);
        } else if (string.equals("objectcreated")) {
            objectCreateCallbacks.removeElementAt(n);
        } else if (string.equals("objectdeleted")) {
            objectDestroyCallbacks.removeElementAt(n);
        } else {
            throw new TMException("Invalid TYPE. TYPE can be 'PropertyChangedPostSet', 'ObjectCreated' or 'ObjectDeleted'.");
        }
    }

    public void propertyChangedNotification(Object object, int n, String string, Object object2, Calendar calendar, MatlabMCR matlabMCR) {
        for (int i = 0; i < propertyChangedCallbacks.size(); ++i) {
            PropertyListenerObject propertyListenerObject = (PropertyListenerObject)propertyChangedCallbacks.elementAt(i);
            if (!propertyListenerObject.throwEvent(object, string)) continue;
            Event event = new Event("PropertyChangedPostSet", MLNotifier.constructClockVector(calendar), string, object2);
            matlabMCR.whenMatlabReady((Runnable)new CallbackQueue(object, n, propertyListenerObject.getCallback(), event));
        }
    }

    public void objectCreatedNotification(Device device, int n, Calendar calendar, MatlabMCR matlabMCR) {
        for (int i = 0; i < objectCreateCallbacks.size(); ++i) {
            Event event = new Event("ObjectCreated", MLNotifier.constructClockVector(calendar));
            matlabMCR.whenMatlabReady((Runnable)new CallbackQueue(device, n, objectCreateCallbacks.elementAt(i), event));
        }
    }

    public void objectDeletedNotification(Device device, int n, Calendar calendar, MatlabMCR matlabMCR) {
        for (int i = 0; i < objectDestroyCallbacks.size(); ++i) {
            DeleteListenerObject deleteListenerObject = (DeleteListenerObject)objectDestroyCallbacks.elementAt(i);
            if (!deleteListenerObject.throwEvent(device)) continue;
            Event event = new Event("ObjectDeleted", MLNotifier.constructClockVector(calendar));
            matlabMCR.whenMatlabReady((Runnable)new CallbackQueue(device, n, deleteListenerObject.getCallback(), event));
        }
    }

    public static Object[] getNotificationCallbacks() {
        Object[] objectArray = new Object[]{propertyChangedCallbacks, objectCreateCallbacks, objectDestroyCallbacks};
        return objectArray;
    }

    public static Vector<Object> getNotificationCallbacks(String string) throws TMException {
        if ((string = string.toLowerCase()).equals("propertychangedpostset")) {
            return propertyChangedCallbacks;
        }
        if (string.equals("objectcreated")) {
            return objectCreateCallbacks;
        }
        if (string.equals("objectdeleted")) {
            return objectDestroyCallbacks;
        }
        throw new TMException("Invalid TYPE. TYPE can be 'PropertyChangedPostSet', 'ObjectCreated' or 'ObjectDeleted'.");
    }

    public static final double[][] constructClockVector(Calendar calendar) {
        double[][] dArray = new double[1][6];
        double d = calendar.get(14);
        dArray[0][0] = calendar.get(1);
        dArray[0][1] = calendar.get(2) + 1;
        dArray[0][2] = calendar.get(5);
        dArray[0][3] = calendar.get(11);
        dArray[0][4] = calendar.get(12);
        dArray[0][5] = (int)Math.round((double)calendar.get(13) + d / 1000.0);
        return dArray;
    }
}

