/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.editors;

import com.mathworks.mwswing.MJButton;
import com.mathworks.page.utils.VertFlowLayout;
import com.mathworks.toolbox.instrument.editors.ASCIITableViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TerminatorEditor
extends ASCIITableViewer
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private Object readTerminatorValue = "LF";
    private Object writeTerminatorValue = "LF";
    private JTextField readTerminator;
    private JTextField writeTerminator;
    private MJButton setReadButton;
    private MJButton setWriteButton;
    private MJButton setBothButton;
    private static String[] initialValues = new String[]{"LF", "10", "CR", "13", "LF/CR", "", "CR/LF", "", "", ""};
    protected static Object[][] terminatorExtra = new Object[][]{{"", ""}, {"CR/LF", ""}, {"LF/CR", ""}};

    public TerminatorEditor() {
        super("Terminator");
        this.initializeTable();
        this.table.setRowSelectionInterval(0, 0);
        this.table.setColumnSelectionInterval(0, 0);
    }

    public void initializeTable() {
    }

    @Override
    public void addValuesToTable() {
        this.model.insertRow(0, terminatorExtra);
    }

    @Override
    public void updateTable(int n) {
        switch (n) {
            case 0: {
                Object[][] objectArray = new Object[][]{{terminatorExtra[0][0], terminatorExtra[0][1]}};
                Object[][] objectArray2 = new Object[][]{{terminatorExtra[1][0], terminatorExtra[1][1]}};
                Object[][] objectArray3 = new Object[][]{{terminatorExtra[2][0], terminatorExtra[2][1]}};
                this.model.insertRow(0, objectArray);
                this.model.insertRow(11, objectArray2);
                this.model.insertRow(47, objectArray3);
                break;
            }
            case 1: {
                this.model.insertRow(0, terminatorExtra);
            }
        }
        for (int i = 0; i < terminatorExtra.length; ++i) {
            this.model.removeLastRow();
        }
    }

    @Override
    public JLabel createLabel() {
        return new JLabel("Double click on an option to set both terminators.");
    }

    @Override
    public JPanel createPropertyPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        jPanel.setBorder(this.createBorder("Current Terminator Values"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel("Read:"), "West");
        this.readTerminator = new JTextField("LF", 10);
        this.readTerminator.setEditable(false);
        this.readTerminator.putClientProperty("ACTION", "READ");
        jPanel2.add((Component)this.readTerminator, "Center");
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel("Write:"), "West");
        this.writeTerminator = new JTextField("LF", 10);
        this.writeTerminator.setEditable(false);
        this.writeTerminator.putClientProperty("ACTION", "WRITE");
        jPanel3.add((Component)this.writeTerminator, "Center");
        jPanel.add(jPanel3);
        return jPanel;
    }

    @Override
    public JPanel createSetButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 0, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.setReadButton = new MJButton("Set Read");
        this.setReadButton.addActionListener((ActionListener)this);
        this.setReadButton.setFocusTraversable(true);
        this.setWriteButton = new MJButton("Set Write");
        this.setWriteButton.addActionListener((ActionListener)this);
        this.setWriteButton.setFocusTraversable(true);
        this.setBothButton = new MJButton("Set Both");
        this.setBothButton.addActionListener((ActionListener)this);
        this.setBothButton.setFocusTraversable(true);
        jPanel2.add((Component)this.setReadButton);
        jPanel.add(jPanel2);
        jPanel3.add((Component)this.setWriteButton);
        jPanel.add(jPanel3);
        jPanel4.add((Component)this.setBothButton);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "North");
        JPanel jPanel6 = new JPanel((LayoutManager)new VertFlowLayout(3));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(92, 5, 0, 0));
        jPanel6.add(jPanel5);
        return jPanel6;
    }

    @Override
    public Object getValue() {
        Object[] objectArray = new Object[]{this.readTerminatorValue, this.writeTerminatorValue};
        return objectArray;
    }

    @Override
    public void setValue(Object object) {
        Object[] objectArray = (Object[])object;
        this.updateProperty("Set Read", objectArray[0]);
        this.updateProperty("Set Write", objectArray[1]);
    }

    @Override
    public boolean updateProperty(String string, Object object) {
        if (string.equals("Set Read")) {
            this.readTerminatorValue = object;
            this.updateTextField(this.readTerminator, this.readTerminatorValue);
        } else if (string.equals("Set Write")) {
            this.writeTerminatorValue = object;
            this.updateTextField(this.writeTerminator, this.writeTerminatorValue);
        } else if (string.equals("Set Both")) {
            this.writeTerminatorValue = this.readTerminatorValue = object;
            this.updateTextField(this.readTerminator, this.readTerminatorValue);
            this.updateTextField(this.writeTerminator, this.writeTerminatorValue);
        }
        return true;
    }

    @Override
    public boolean mouseDoubleClick() {
        return this.updateProperty("Set Both", this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn()));
    }

    @Override
    public void saveMostRecentValues() {
        for (int i = 0; i < initialValues.length; i += 2) {
            TerminatorEditor.initialValues[i] = (String)this.table.getValueAt(i / 2, 0);
            TerminatorEditor.initialValues[i + 1] = (String)this.table.getValueAt(i / 2, 1);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.updateFromTextField(focusEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.hitEnter = true;
            this.updateFromTextField(keyEvent);
        }
    }

    public void updateFromTextField(ComponentEvent componentEvent) {
        JTextField jTextField = (JTextField)componentEvent.getSource();
        String string = (String)jTextField.getClientProperty("ACTION");
        String string2 = jTextField.getText();
        int n = this.findCode(string2);
        if (n == -1) {
            if (string.equals("READ")) {
                jTextField.setText((String)this.readTerminatorValue);
            } else {
                jTextField.setText((String)this.writeTerminatorValue);
            }
        } else {
            if (string.equals("READ")) {
                this.readTerminatorValue = string2;
            } else {
                this.writeTerminatorValue = string2;
            }
            this.updateMostRecentTableValues(n);
            this.table.setRowSelectionInterval(0, 0);
            if (string2.equals(this.table.getValueAt(0, 0))) {
                this.table.setColumnSelectionInterval(0, 0);
            } else {
                this.table.setColumnSelectionInterval(0, 1);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

