/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.icb;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.AdaptorInfo;
import com.mathworks.toolbox.instrument.icb.HardwarePanel;
import com.mathworks.toolbox.instrument.icb.IJFrame;
import com.mathworks.toolbox.instrument.icb.InitializationPanel;
import com.mathworks.toolbox.instrument.icb.SendPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.UIManager;

public class SendFrame
extends IJFrame {
    private static final long serialVersionUID = 1L;
    private MJLabel sampleTimeLabel;
    private MJTextField sampleTime;
    private HardwarePanel hwPanel;
    private InitializationPanel iPanel;
    private SendPanel sPanel;

    public SendFrame() {
        this.setTitle("Block Parameters: Send Instrument");
    }

    @Override
    public String makeBlockDescription() {
        return "Send simulation data to an instrument.";
    }

    @Override
    public MJPanel makeParameterPanel() {
        MJPanel mJPanel = new MJPanel();
        MJPanel mJPanel2 = new MJPanel();
        MJTabbedPane mJTabbedPane = new MJTabbedPane();
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        mJPanel2.setLayout((LayoutManager)new FlowLayout(0));
        this.sampleTimeLabel = new MJLabel("Block sample time (-1 for inherited):");
        mJPanel2.add((Component)this.sampleTimeLabel);
        this.sampleTime = new MJTextField();
        this.sampleTime.setColumns(IJFrame.sSmallColumnWidth);
        this.sampleTime.getDocument().addDocumentListener(new IJFrame.TextChangedListener());
        mJPanel2.add((Component)this.sampleTime);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)mJPanel2, (Object)gridBagConstraints);
        this.hwPanel = new HardwarePanel();
        this.hwPanel.addActionListener(this.fActionListener);
        this.hwPanel.addItemListener(this.fItemListener);
        this.hwPanel.addTextListener(this.fTextListener);
        mJTabbedPane.addTab("Hardware Configuration", (Component)((Object)this.hwPanel));
        this.iPanel = new InitializationPanel();
        this.iPanel.addItemListener(this.fItemListener);
        this.iPanel.addTextListener(this.fTextListener);
        mJTabbedPane.addTab("Instrument Initialization", (Component)((Object)this.iPanel));
        this.sPanel = new SendPanel();
        this.sPanel.addActionListener(this.fActionListener);
        this.sPanel.addItemListener(this.fItemListener);
        this.sPanel.addTextListener(this.fTextListener);
        mJTabbedPane.addTab("Send", (Component)((Object)this.sPanel));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        mJPanel.add((Component)mJTabbedPane, (Object)gridBagConstraints);
        return mJPanel;
    }

    @Override
    public Object[] getParameterValues() {
        Object[] objectArray = new Object[2];
        String[] stringArray = new String[34];
        String[] stringArray2 = new String[34];
        objectArray[0] = stringArray;
        objectArray[1] = stringArray2;
        stringArray[0] = new String("sampleTime");
        stringArray2[0] = this.sampleTime.getText();
        int n = this.hwPanel.getParameterValues(stringArray, stringArray2, 1);
        n = this.iPanel.getParameterValues(stringArray, stringArray2, n);
        n = this.sPanel.getParameterValues(stringArray, stringArray2, n);
        return objectArray;
    }

    @Override
    public void updateParameterValues(String[] stringArray, String[] stringArray2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], stringArray2[i]);
        }
        this.sampleTime.setText((String)hashMap.get("sampleTime"));
        this.hwPanel.setParameterValues(hashMap);
        this.iPanel.setParameterValues(hashMap);
        this.sPanel.setParameterValues(hashMap);
    }

    @Override
    public void updateParameterValue(String string, String string2) {
        if (string.compareToIgnoreCase("sampleTime") == 0) {
            this.sampleTime.setText(string2);
        }
    }

    @Override
    public void internalDisableComponents() {
        this.sampleTimeLabel.setEnabled(false);
        this.sampleTime.setEnabled(false);
        this.sampleTime.setBackground(this.getBackground());
        this.hwPanel.disableComponents();
        this.iPanel.disableComponents();
        this.sPanel.disableComponents();
    }

    @Override
    public void internalEnableComponents() {
        this.sampleTimeLabel.setEnabled(true);
        this.sampleTime.setEnabled(true);
        this.sampleTime.setBackground(Color.white);
        this.hwPanel.enableComponents();
        this.iPanel.enableComponents();
        this.sPanel.enableComponents();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SendFrame sendFrame = new SendFrame();
        sendFrame.setDefaultCloseOperation(2);
        Object[] objectArray = sendFrame.sampleValues();
        sendFrame.updateParameterValues((String[])objectArray[0], (String[])objectArray[1]);
        sendFrame.applyButton().setEnabled(false);
        sendFrame.displayParameterValues();
        sendFrame.cancelIsDisable();
        sendFrame.helpIsDisable();
        sendFrame.setupWindowClosingExit();
        sendFrame.show();
    }

    public void displayParameterValues() {
        this.applyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JButton)actionEvent.getSource()).setEnabled(false);
                Object[] objectArray = SendFrame.this.getParameterValues();
                String[] stringArray = (String[])objectArray[1];
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println(stringArray[i]);
                }
            }
        });
    }

    public void cancelIsDisable() {
        this.cancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendFrame.this.internalDisableComponents();
            }
        });
    }

    public void helpIsDisable() {
        this.helpButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendFrame.this.internalEnableComponents();
            }
        });
    }

    public void setupWindowClosingExit() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }
        });
    }

    public Object[] sampleValues() {
        Object[] objectArray = new Object[2];
        String[] stringArray = new String[28];
        String[] stringArray2 = new String[28];
        stringArray[0] = new String("sampleTime");
        stringArray2[0] = "-1";
        stringArray[1] = new String("isWorkspaceObject");
        stringArray2[1] = "off";
        stringArray[2] = new String("protocol");
        stringArray2[2] = HardwarePanel.PROTOCOLS[0];
        stringArray[3] = new String("timeout");
        stringArray2[3] = "10";
        stringArray[4] = new String("inputBufferSize");
        stringArray2[4] = "512";
        stringArray[5] = new String("serialPort");
        stringArray2[5] = HardwarePanel.SERIAL_PORTS[0];
        stringArray[6] = new String("baudRate");
        stringArray2[6] = "9600";
        stringArray[7] = new String("gpibVendor");
        stringArray2[7] = AdaptorInfo.GPIB_NAMES[0];
        stringArray[8] = new String("boardIndex");
        stringArray2[8] = "0";
        stringArray[9] = new String("primaryAddress");
        stringArray2[9] = "1";
        stringArray[10] = new String("secondaryAddress");
        stringArray2[10] = "0";
        stringArray[11] = new String("visaVendor");
        stringArray2[11] = HardwarePanel.VISA_VENDORS[0];
        stringArray[12] = new String("visaSerialPort");
        stringArray2[12] = "1";
        stringArray[13] = new String("chassisIndex");
        stringArray2[13] = "0";
        stringArray[14] = new String("logicalAddress");
        stringArray2[14] = "0";
        stringArray[15] = new String("tcpRemoteHost");
        stringArray2[15] = "127.0.0.1";
        stringArray[16] = new String("tcpRemotePort");
        stringArray2[16] = "80";
        stringArray[17] = new String("udpRemoteHost");
        stringArray2[17] = "127.0.0.1";
        stringArray[18] = new String("udpRemotePort");
        stringArray2[18] = "9090";
        stringArray[19] = new String("wsVariableName");
        stringArray2[19] = "obj";
        stringArray[20] = new String("initAction");
        stringArray2[20] = "Send ASCII Commands";
        stringArray[21] = new String("initCommand");
        stringArray2[21] = "'CHAN1:SCALE 1'";
        stringArray[22] = new String("initFunction");
        stringArray2[22] = "myCallback";
        stringArray[23] = new String("command");
        stringArray2[23] = "curve";
        stringArray[24] = new String("sendFormat");
        stringArray2[24] = SendPanel.FORMATS[2];
        stringArray[25] = new String("asciiFormatting");
        stringArray2[25] = "%f";
        stringArray[26] = new String("precision");
        stringArray2[26] = SendPanel.PRECISIONS[1];
        stringArray[27] = new String("byteOrder");
        stringArray2[27] = SendPanel.BYTE_ORDERS[1];
        objectArray[0] = stringArray;
        objectArray[1] = stringArray2;
        return objectArray;
    }
}

