/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.instrcomm;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJTable;
import com.mathworks.toolbox.instrument.guiutil.DataExporter;
import com.mathworks.toolbox.instrument.instrcomm.MCode;
import com.mathworks.toolbox.instrument.instrcomm.MCodeBank;
import com.mathworks.toolbox.instrument.instrcomm.MCodeWriter;
import com.mathworks.toolbox.instrument.instrcomm.TableContextMenu;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class HistoryTable
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Point POINT_ZERO = new Point(0, 0);
    private static final String[] columnNames = new String[]{"Action", "Data", "Size", "Format"};
    protected Object[][] data;
    private HistoryTableModel model;
    private MJTable table;
    private JScrollPane scrollPane;
    private TableContextMenu contextMenu;
    private String lastObjectCommunicatingWith = "";
    private Vector<MCode> commands = new Vector();
    private MCodeBank codeBank = new MCodeBank();
    private MCodeWriter writer;
    private Hashtable<String, Object> variables = new Hashtable();
    private boolean okToAddCommunicatingWithRow = true;
    private boolean addedFirstTime = false;
    private Dimension tableDimension = new Dimension(0, 0);
    private Dimension scrollPaneDimension = new Dimension(0, 0);

    public HistoryTable() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.layoutPanel();
        this.contextMenu = new TableContextMenu(this);
        this.contextMenu.addContextMenu((JTable)this.table);
    }

    public void cleanup() {
        this.codeBank.cleanup();
        this.contextMenu.cleanup(this);
    }

    public void setup() {
        this.codeBank.setup();
        this.contextMenu.setup(this);
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.model = new HistoryTableModel();
        this.table = new MJTable((TableModel)this.model);
        this.table.setName("History Table");
        this.scrollPane = new JScrollPane((Component)this.table);
        jPanel.add((Component)this.scrollPane, "Center");
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.table.setSelectionMode(2);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(220);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.add((Component)jPanel, "Center");
    }

    public void addRow(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        this.model.append(objectArray);
        this.tableDimension = this.table.getSize(this.tableDimension);
        this.scrollPaneDimension = this.scrollPane.getSize(this.scrollPaneDimension);
        if (this.tableDimension.height + 34 >= this.scrollPaneDimension.height) {
            this.scrollPane.getViewport().setViewPosition(new Point(0, this.tableDimension.height + 5));
        } else {
            this.scrollPane.getViewport().setViewPosition(POINT_ZERO);
        }
    }

    public void addMCode(MCode mCode) {
        this.codeBank.addLineOfCode(mCode);
        this.commands.addElement(mCode);
    }

    public boolean addCommunicatingWithRow(String string) {
        if (this.lastObjectCommunicatingWith == null) {
            return false;
        }
        if (this.lastObjectCommunicatingWith.equals(string)) {
            return false;
        }
        if (this.addedFirstTime || !this.okToAddCommunicatingWithRow) {
            return false;
        }
        this.addedFirstTime = true;
        this.lastObjectCommunicatingWith = string;
        this.addRow("Communicating with", string, "", "");
        return true;
    }

    public void save(String string) {
        if (this.writer == null) {
            this.writer = new MCodeWriter();
        }
        this.writer.createFile(string, this.codeBank);
    }

    public String getFileText() {
        if (this.writer == null) {
            this.writer = new MCodeWriter();
        }
        return this.writer.writeFile(this.codeBank);
    }

    public Hashtable<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Hashtable<String, Object> hashtable) {
        this.variables = hashtable;
    }

    public void addVariable(String string, Object object) {
        this.variables.put(string, object);
    }

    public void removeVariable(String string) {
        this.variables.remove(string);
    }

    public String getVariableName(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.data.length; ++i) {
            String string = (String)this.data[i][0];
            if (!string.equals("Read") && !string.equals("Read (Query)") || ++n2 != n + 1) continue;
            n3 = i;
            break;
        }
        return this.commands.elementAt(n3).getVariableName();
    }

    public String[] getReadVariableNames(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.data[nArray[i]][1];
        }
        return stringArray;
    }

    public boolean isReadRow(int n) {
        String string = (String)this.data[n][0];
        String string2 = "Read";
        return string.toLowerCase().contains(string2.toLowerCase());
    }

    public boolean containsReadRow() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isReadRow(i)) continue;
            return true;
        }
        return false;
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public Object[][] getTableData() {
        return this.data;
    }

    public void setTableData(Object[][] objectArray) {
        this.data = null;
        this.data = objectArray;
        this.model.fireTableDataChanged();
    }

    public MCodeBank getCodeBank() {
        return this.codeBank;
    }

    public void setCodeBank(MCodeBank mCodeBank) {
        if (mCodeBank != this.codeBank && this.codeBank != null) {
            this.codeBank.cleanup();
            this.codeBank = null;
        }
        mCodeBank.setup();
        this.codeBank = mCodeBank;
    }

    public void setCommands(Vector<MCode> vector) {
        this.commands = vector;
    }

    public Vector<MCode> getCommands() {
        return this.commands;
    }

    public String getLastCommunicatingWithName() {
        return this.lastObjectCommunicatingWith;
    }

    public void setLastCommunicatingWithName(String string) {
        this.lastObjectCommunicatingWith = string;
        if (this.lastObjectCommunicatingWith.equals("")) {
            this.addedFirstTime = false;
        }
    }

    public void setOkToAddCommunicatingWithRow(boolean bl) {
        this.okToAddCommunicatingWithRow = bl;
    }

    public int getActionColumnWidth() {
        return this.table.getColumnModel().getColumn(0).getWidth();
    }

    public void setActionColumnWidth(int n) {
        this.table.getColumnModel().getColumn(0).setPreferredWidth(n);
    }

    public int getCommunicationColumnWidth() {
        return this.table.getColumnModel().getColumn(1).getWidth();
    }

    public void setCommunicationColumnWidth(int n) {
        this.table.getColumnModel().getColumn(1).setPreferredWidth(n);
    }

    public int getSizeColumnWidth() {
        return this.table.getColumnModel().getColumn(2).getWidth();
    }

    public void setSizeColumnWidth(int n) {
        this.table.getColumnModel().getColumn(2).setPreferredWidth(n);
    }

    public int getFormatColumnWidth() {
        return this.table.getColumnModel().getColumn(3).getWidth();
    }

    public void setFormatColumnWidth(int n) {
        this.table.getColumnModel().getColumn(3).setPreferredWidth(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        String string = (String)jComponent.getClientProperty("ACTION");
        if (string.equals("DELETE")) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length == 0) {
                TMStringUtil.error((String)"Delete Error", (String)"To delete a row in the table, the row must be selected.");
                return;
            }
            for (int i = nArray.length - 1; i >= 0; --i) {
                try {
                    this.deleteRow(nArray[i]);
                    this.commands.elementAt(nArray[i]).dispose();
                    this.commands.removeElementAt(nArray[i]);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println(arrayIndexOutOfBoundsException.getMessage());
                }
            }
            this.table.getSelectionModel().clearSelection();
        } else if (string.equals("DELETE ALL")) {
            this.deleteAllRows();
            this.table.getSelectionModel().clearSelection();
        } else if (string.equals("EXPORT")) {
            DataExporter dataExporter = new DataExporter(this, this.table.getSelectedRows());
            dataExporter.setVariableNames(this.getReadVariableNames(this.table.getSelectedRows()));
            dataExporter.showAsDialog(new MJFrame());
        }
    }

    public void deleteRow(int n) {
        MCode mCode = this.commands.elementAt(n);
        this.variables.remove(mCode.getVariableName());
        this.model.remove(n);
    }

    public void deleteAllRows() {
        for (int i = 0; i < this.commands.size(); ++i) {
            this.commands.elementAt(i).dispose();
        }
        this.commands = new Vector();
        this.data = null;
        this.variables = new Hashtable();
        this.lastObjectCommunicatingWith = "";
        this.model.fireTableDataChanged();
    }

    public class HistoryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (HistoryTable.this.data == null) {
                return 0;
            }
            return HistoryTable.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return HistoryTable.this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            HistoryTable.this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void append(Object[] objectArray) {
            int n;
            int n2 = this.getRowCount() + 1;
            Object[][] objectArray2 = new Object[n2][this.getColumnCount()];
            if (HistoryTable.this.data != null) {
                for (n = 0; n < n2 - 1; ++n) {
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        objectArray2[n][i] = HistoryTable.this.data[n][i];
                    }
                }
            }
            for (n = 0; n < objectArray.length; ++n) {
                objectArray2[n2 - 1][n] = objectArray[n];
            }
            HistoryTable.this.data = null;
            HistoryTable.this.data = objectArray2;
            this.fireTableRowsInserted(n2 - 1, HistoryTable.this.data.length);
        }

        public void remove(int n) {
            int n2;
            int n3;
            int n4 = this.getRowCount() - 1;
            Object[][] objectArray = new Object[n4][this.getColumnCount()];
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                    objectArray[n3][n2] = HistoryTable.this.data[n3][n2];
                }
            }
            for (n3 = n; n3 < n4; ++n3) {
                for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                    objectArray[n3][n2] = HistoryTable.this.data[n3 + 1][n2];
                }
            }
            HistoryTable.this.data = null;
            HistoryTable.this.data = objectArray;
            this.fireTableRowsInserted(n4 - 1, HistoryTable.this.data.length);
        }
    }
}

