/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.hadoop;

import com.mathworks.toolbox.parallel.hadoop.MatlabConfiguration;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class MatlabInputFormat
extends InputFormat<Void, InputSplit> {
    public RecordReader<Void, InputSplit> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new InputSplitRecordReader();
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        MatlabConfiguration mathworksConf = new MatlabConfiguration(context.getConfiguration());
        switch (mathworksConf.getInputSplitType()) {
            case FILE: {
                return this.getFileSplits(mathworksConf, context);
            }
        }
        throw new IllegalStateException();
    }

    private List<InputSplit> getFileSplits(MatlabConfiguration mathworksConf, JobContext context) throws IOException, InterruptedException {
        FileInputFormat<Void, Void> fileInputFormat = new FileInputFormat<Void, Void>(){

            public RecordReader<Void, Void> createRecordReader(InputSplit split, TaskAttemptContext context) {
                return null;
            }
        };
        return fileInputFormat.getSplits(context);
    }

    public static class InputSplitRecordReader
    extends RecordReader<Void, InputSplit> {
        private boolean fHasNextBeenCalled = false;
        private InputSplit fInputSplit = null;

        public void close() throws IOException {
            this.fInputSplit = null;
        }

        public Void getCurrentKey() {
            return null;
        }

        public InputSplit getCurrentValue() {
            return this.fHasNextBeenCalled ? this.fInputSplit : null;
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.fHasNextBeenCalled ? 1.0f : 0.0f;
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext context) {
            this.fHasNextBeenCalled = inputSplit == null;
            this.fInputSplit = inputSplit;
        }

        public boolean nextKeyValue() {
            boolean hasNextBeenCalled = this.fHasNextBeenCalled;
            this.fInputSplit = hasNextBeenCalled ? null : this.fInputSplit;
            this.fHasNextBeenCalled = true;
            return !hasNextBeenCalled;
        }
    }
}

