/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;

public class SerializationUtils {
    private static Base64 sConverter = new Base64();
    private static Charset sUtf8Charset = Charset.forName("UTF-8");

    public static String serializeConfiguration(Configuration configuration) throws IOException {
        DataOutputBuffer dataOutputBuffer = new DataOutputBuffer();
        configuration.write((DataOutput)dataOutputBuffer);
        return SerializationUtils.encodeToString(dataOutputBuffer.getData());
    }

    public static Configuration deserializeConfiguration(String serializedConfiguration) throws IOException {
        byte[] data = SerializationUtils.decodeFromString(serializedConfiguration);
        DataInputBuffer dataInputBuffer = new DataInputBuffer();
        dataInputBuffer.reset(data, data.length);
        Configuration configuration = new Configuration();
        configuration.readFields((DataInput)dataInputBuffer);
        return configuration;
    }

    public static String encodeToString(byte[] data) {
        assert (data != null);
        return new String(Base64.encodeBase64((byte[])data), sUtf8Charset);
    }

    public static byte[] decodeFromString(String data) {
        assert (data != null);
        return Base64.decodeBase64((byte[])data.getBytes(sUtf8Charset));
    }

    private SerializationUtils() {
    }
}

