/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.fixedpoint;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.fixedpoint.FixedPointFunctionAbstractPanel;
import com.mathworks.toolbox.fixedpoint.FixedPointMenuAction;
import com.mathworks.toolbox.fixedpoint.SyntaxEnum;
import com.mathworks.toolbox.fixedpoint.TextWidget;
import com.mathworks.toolbox.fixedpoint.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FimathPanel
extends FixedPointFunctionAbstractPanel {
    public static final String PRODUCT_MODE_COMBOBOX_NAME = "ProductModeComboBox";
    public static final String PRODUCT_WORD_LENGTH_FIELD = "ProductWordLengthField";
    public static final String PRODUCT_FRACTION_LENGTH_FIELD = "ProductFractionLengthField";
    public static final String SUM_MODE_COMBOBOX_NAME = "SumModeComboBox";
    public static final String SUM_WORD_LENGTH_FIELD = "SumWordLengthField";
    public static final String SUM_FRACTION_LENGTH_FIELD = "SumFractionLengthField";
    public static final String CAST_BEFORE_SUM_CHECKBOX = "CastBeforeSumCheckBox";
    public static final RoundingMethod ROUNDING_ENUM_DEFAULT = RoundingMethod.NEAREST;
    public static final OverflowAction OVERFLOW_ENUM_DEFAULT = OverflowAction.SATURATE;
    public static final PrecisionMode PRECISION_ENUM_DEFAULT = PrecisionMode.FULL_PRECISION;
    public static final String WORD_LENGTH_DEFAULT = "32";
    public static final String FRACTION_LENGTH_DEFAULT = "30";
    public static final boolean CAST_BEFORE_SUM_DEFAULT = true;
    public static final String BUNDLE_STR = "com.mathworks.toolbox.fixedpoint.resources.RES_fixedpoint";
    public static final ResourceBundle LOCAL_BUNDLE = ResourceBundle.getBundle("com.mathworks.toolbox.fixedpoint.resources.RES_fixedpoint");
    public static final Properties ENGLISH_BUNDLE = Utilities.getEnglishResourceBundle("com.mathworks.toolbox.fixedpoint.resources.RES_fixedpoint");
    private static final ListCellRenderer<?> SYNTAX_ENUM_LIST_RENDERER = FimathPanel.createSyntaxEnumRenderer();
    private MJComboBox fOverflowActionComboBox;
    private MJComboBox fProductModeComboBox;
    private MJComboBox fRoundingMethodComboBox;
    private MJComboBox fSumModeComboBox;
    private MJCheckBox fCastBeforeSumCheckBox;
    private TextWidget fProductFractionLengthTextField;
    private TextWidget fProductWordLengthTextField;
    private TextWidget fSumFractionLengthTextField;
    private TextWidget fSumWordLengthTextField;
    private MJLabel fProductFractionLengthLabel;
    private MJLabel fProductWordLengthLabel;
    private MJLabel fSumFractionLengthLabel;
    private MJLabel fSumWordLengthLabel;

    public FimathPanel() {
        this.getComponent().setName("FimathPanel");
        this.initComponents();
    }

    @Override
    public String getFunctionName() {
        return "fimath";
    }

    @Override
    public Map<String, String> getParameterMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("RoundingMethod", Utilities.quoteSelection(this.fRoundingMethodComboBox));
        linkedHashMap.put("OverflowAction", Utilities.quoteSelection(this.fOverflowActionComboBox));
        linkedHashMap.put("ProductMode", Utilities.quoteSelection(this.fProductModeComboBox));
        if (!this.fProductModeComboBox.getSelectedItem().equals(PrecisionMode.FULL_PRECISION)) {
            linkedHashMap.put("ProductWordLength", this.fProductWordLengthTextField.getText());
            if (this.fProductModeComboBox.getSelectedItem().equals(PrecisionMode.SPECIFY_PRECISION)) {
                linkedHashMap.put("ProductFractionLength", this.fProductFractionLengthTextField.getText());
            }
        }
        linkedHashMap.put("SumMode", Utilities.quoteSelection(this.fSumModeComboBox));
        if (!this.fSumModeComboBox.getSelectedItem().equals(PrecisionMode.FULL_PRECISION)) {
            linkedHashMap.put("SumWordLength", this.fSumWordLengthTextField.getText());
            if (this.fSumModeComboBox.getSelectedItem().equals(PrecisionMode.SPECIFY_PRECISION)) {
                linkedHashMap.put("SumFractionLength", this.fSumFractionLengthTextField.getText());
            }
            linkedHashMap.put("CastBeforeSum", this.fCastBeforeSumCheckBox.isSelected() ? "true" : "false");
        }
        return linkedHashMap;
    }

    @Override
    public String getHelpFunction() {
        return "ref/fimath.html";
    }

    @Override
    protected void updateComponents() {
        this.updateProductMode();
        this.updateSumMode();
        this.updateCastBeforeSum();
    }

    private void updateProductMode() {
        FimathPanel.updatePrecisionComponents(this.fProductModeComboBox, this.fProductWordLengthLabel, this.fProductWordLengthTextField, this.fProductFractionLengthLabel, this.fProductFractionLengthTextField);
    }

    private void updateSumMode() {
        FimathPanel.updatePrecisionComponents(this.fSumModeComboBox, this.fSumWordLengthLabel, this.fSumWordLengthTextField, this.fSumFractionLengthLabel, this.fSumFractionLengthTextField);
    }

    private void updateCastBeforeSum() {
        boolean bl = !this.fSumModeComboBox.getSelectedItem().equals(PrecisionMode.FULL_PRECISION);
        this.fCastBeforeSumCheckBox.setVisible(bl);
    }

    private static void updatePrecisionComponents(MJComboBox mJComboBox, MJLabel mJLabel, TextWidget textWidget, MJLabel mJLabel2, TextWidget textWidget2) {
        PrecisionMode precisionMode = (PrecisionMode)mJComboBox.getSelectedItem();
        boolean bl = precisionMode != PrecisionMode.FULL_PRECISION;
        mJLabel.setVisible(bl);
        textWidget.setVisible(bl);
        boolean bl2 = precisionMode == PrecisionMode.SPECIFY_PRECISION;
        mJLabel2.setVisible(bl2);
        textWidget2.setVisible(bl2);
    }

    private void initComponents() {
        MJLabel mJLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("RoundingMethodPromptStr"));
        mJLabel.setName("RoundingLabel");
        this.fRoundingMethodComboBox = FimathPanel.createSyntaxEnumComboBox((Enum[])RoundingMethod.values());
        this.fRoundingMethodComboBox.setName("RoundingComboBox");
        this.fRoundingMethodComboBox.setSelectedItem((Object)ROUNDING_ENUM_DEFAULT);
        MJLabel mJLabel2 = new MJLabel(FixedPointMenuAction.BUNDLE.getString("OverflowActionPromptStr"));
        mJLabel2.setName("OverflowLabel");
        this.fOverflowActionComboBox = FimathPanel.createSyntaxEnumComboBox((Enum[])OverflowAction.values());
        this.fOverflowActionComboBox.setName("OverflowComboBox");
        this.fOverflowActionComboBox.setSelectedItem((Object)OVERFLOW_ENUM_DEFAULT);
        MJLabel mJLabel3 = new MJLabel(FixedPointMenuAction.BUNDLE.getString("ProductModePromptStr"));
        mJLabel3.setName("ProdModeLabel");
        this.fProductModeComboBox = FimathPanel.createSyntaxEnumComboBox((Enum[])PrecisionMode.values());
        this.fProductModeComboBox.setSelectedItem((Object)PRECISION_ENUM_DEFAULT);
        this.fProductModeComboBox.setName(PRODUCT_MODE_COMBOBOX_NAME);
        this.fProductWordLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("ProductWordLengthPromptStr"));
        this.fProductWordLengthLabel.setName("ProdWordLenLabel");
        this.fProductWordLengthTextField = new TextWidget(WORD_LENGTH_DEFAULT, PRODUCT_WORD_LENGTH_FIELD);
        this.fProductFractionLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("ProductFractionLengthPromptStr"));
        this.fProductFractionLengthLabel.setName("ProdFracLenLabel");
        this.fProductFractionLengthTextField = new TextWidget(FRACTION_LENGTH_DEFAULT, PRODUCT_FRACTION_LENGTH_FIELD);
        MJLabel mJLabel4 = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SumModePromptStr"));
        mJLabel4.setName("SumModeLabel");
        this.fSumModeComboBox = FimathPanel.createSyntaxEnumComboBox((Enum[])PrecisionMode.values());
        this.fSumModeComboBox.setName(SUM_MODE_COMBOBOX_NAME);
        this.fSumModeComboBox.setSelectedItem((Object)PRECISION_ENUM_DEFAULT);
        this.fSumWordLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SumWordLengthPromptStr"));
        this.fSumWordLengthLabel.setName("SumWordLenLabel");
        this.fSumWordLengthTextField = new TextWidget(WORD_LENGTH_DEFAULT, SUM_WORD_LENGTH_FIELD);
        this.fSumFractionLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SumFractionLengthPromptStr"));
        this.fSumFractionLengthLabel.setName("SumFracLenLabel");
        this.fSumFractionLengthTextField = new TextWidget(FRACTION_LENGTH_DEFAULT, SUM_FRACTION_LENGTH_FIELD);
        this.fCastBeforeSumCheckBox = new MJCheckBox(FixedPointMenuAction.BUNDLE.getString("CastBeforeSumPromptStr"));
        this.fCastBeforeSumCheckBox.setName(CAST_BEFORE_SUM_CHECKBOX);
        this.fCastBeforeSumCheckBox.setSelected(true);
        this.fProductModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FimathPanel.this.updatePanel();
            }
        });
        this.fSumModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FimathPanel.this.updatePanel();
            }
        });
        this.addComponentPair((Component)mJLabel, (Component)this.fRoundingMethodComboBox);
        this.addComponentPair((Component)mJLabel2, (Component)this.fOverflowActionComboBox);
        this.addComponentPair((Component)mJLabel3, (Component)this.fProductModeComboBox);
        this.addComponentPair((Component)this.fProductWordLengthLabel, this.fProductWordLengthTextField.getComponent());
        this.addComponentPair((Component)this.fProductFractionLengthLabel, this.fProductFractionLengthTextField.getComponent());
        this.addComponentPair((Component)mJLabel4, (Component)this.fSumModeComboBox);
        this.addComponentPair((Component)this.fSumWordLengthLabel, this.fSumWordLengthTextField.getComponent());
        this.addComponentPair((Component)this.fSumFractionLengthLabel, this.fSumFractionLengthTextField.getComponent());
        this.addComponent((Component)this.fCastBeforeSumCheckBox);
    }

    static <T extends Enum<T>> MJComboBox createSyntaxEnumComboBox(T[] TArray) {
        MJComboBox mJComboBox = new MJComboBox((Object[])TArray);
        mJComboBox.setRenderer(SYNTAX_ENUM_LIST_RENDERER);
        return mJComboBox;
    }

    private static ListCellRenderer<?> createSyntaxEnumRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object instanceof SyntaxEnum) {
                    this.setText(((SyntaxEnum)object).toDisplayString());
                }
                return this;
            }
        };
    }

    public static enum PrecisionMode implements SyntaxEnum
    {
        FULL_PRECISION("FullPrecision", "FullPrecisionStr"),
        KEEP_LSB("KeepLSB", "KeepLSBStr"),
        KEEP_MSB("KeepMSB", "KeepMSBStr"),
        SPECIFY_PRECISION("SpecifyPrecision", "SpecifyPrecisionStr");

        private final String fValue;
        private final String fKey;

        @Override
        public String toString() {
            return this.toSyntaxString();
        }

        @Override
        public String toSyntaxString() {
            return this.fValue;
        }

        @Override
        public String toDisplayString() {
            return LOCAL_BUNDLE.getString(this.fKey);
        }

        private PrecisionMode(String string2, String string3) {
            this.fValue = string2;
            this.fKey = string3;
        }
    }

    public static enum OverflowAction implements SyntaxEnum
    {
        SATURATE("Saturate", "SaturateStr"),
        WRAP("Wrap", "WrapStr");

        private final String fValue;
        private final String fResourceKey;

        @Override
        public String toString() {
            return this.toSyntaxString();
        }

        @Override
        public String toSyntaxString() {
            return this.fValue;
        }

        @Override
        public String toDisplayString() {
            return LOCAL_BUNDLE.getString(this.fResourceKey);
        }

        private OverflowAction(String string2, String string3) {
            this.fResourceKey = string3;
            this.fValue = string2;
        }
    }

    public static enum RoundingMethod implements SyntaxEnum
    {
        CEIL("Ceiling", "CeilingStr"),
        CONVERGENT("Convergent", "ConvergentStr"),
        FLOOR("Floor", "FloorStr"),
        NEAREST("Nearest", "NearestStr"),
        ROUND("Round", "RoundStr"),
        ZERO("Zero", "ZeroStr");

        private final String fValue;
        private final String fResourceKey;

        @Override
        public String toString() {
            return this.toSyntaxString();
        }

        @Override
        public String toSyntaxString() {
            return this.fValue;
        }

        @Override
        public String toDisplayString() {
            return LOCAL_BUNDLE.getString(this.fResourceKey);
        }

        private RoundingMethod(String string2, String string3) {
            this.fResourceKey = string3;
            this.fValue = string2;
        }
    }
}

