/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.FadeActionListener;
import com.mathworks.appmanagement.NonFadeActionListener;
import com.sun.awt.AWTUtilities;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.Timer;

final class Fader {
    static final float FRAME_INTERVAL = 25.0f;
    static final float FADE_TIME = 5000.0f;
    private Window window;
    private Timer timer;

    Fader(Window window) {
        this.setWindow(window);
        this.timer = new Timer(25, null);
    }

    void fade() {
        if (Fader.isTranslucencySupported()) {
            this.setWindowOpacity(0.999f);
            this.timer.addActionListener(new FadeActionListener(this));
        } else {
            this.timer.setInitialDelay(5000);
            this.timer.addActionListener(new NonFadeActionListener(this.window));
        }
        this.timer.restart();
    }

    void reset() {
        for (ActionListener actionListener : this.timer.getActionListeners()) {
            this.timer.removeActionListener(actionListener);
            this.timer.stop();
            if (!Fader.isTranslucencySupported()) continue;
            this.setWindowOpacity(1.0f);
        }
    }

    void setWindowOpacity(float f) {
        AWTUtilities.setWindowOpacity((Window)this.window, (float)f);
    }

    private static boolean isTranslucencySupported() {
        return AWTUtilities.isTranslucencySupported((AWTUtilities.Translucency)AWTUtilities.Translucency.TRANSLUCENT);
    }

    void setWindow(Window window) {
        this.window = window;
    }

    private void dispose() {
        this.window.dispose();
        this.window = null;
    }

    float getOpacity() {
        return AWTUtilities.getWindowOpacity((Window)this.window);
    }

    void stop() {
        this.dispose();
        this.timer.stop();
    }
}

