/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.norm.AbstractProxy;
import com.sun.jini.norm.NormServer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import net.jini.admin.JoinAdmin;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class AdminProxy
extends AbstractProxy
implements JoinAdmin,
DestroyAdmin {
    private static final long serialVersionUID = 1L;

    static AdminProxy create(NormServer normServer, Uuid uuid) {
        if (normServer instanceof RemoteMethodControl) {
            return new ConstrainableAdminProxy(normServer, uuid);
        }
        return new AdminProxy(normServer, uuid);
    }

    AdminProxy(NormServer normServer, Uuid uuid) {
        super(normServer, uuid);
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("server and uuid must be non-null");
    }

    public Entry[] getLookupAttributes() throws RemoteException {
        return this.server.getLookupAttributes();
    }

    public void addLookupAttributes(Entry[] entryArray) throws RemoteException {
        this.server.addLookupAttributes(entryArray);
    }

    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) throws RemoteException {
        this.server.modifyLookupAttributes(entryArray, entryArray2);
    }

    public String[] getLookupGroups() throws RemoteException {
        return this.server.getLookupGroups();
    }

    public void addLookupGroups(String[] stringArray) throws RemoteException {
        this.server.addLookupGroups(stringArray);
    }

    public void removeLookupGroups(String[] stringArray) throws RemoteException {
        this.server.removeLookupGroups(stringArray);
    }

    public void setLookupGroups(String[] stringArray) throws RemoteException {
        this.server.setLookupGroups(stringArray);
    }

    public LookupLocator[] getLookupLocators() throws RemoteException {
        return this.server.getLookupLocators();
    }

    public void addLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.server.addLookupLocators(lookupLocatorArray);
    }

    public void removeLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.server.removeLookupLocators(lookupLocatorArray);
    }

    public void setLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.server.setLookupLocators(lookupLocatorArray);
    }

    public void destroy() throws RemoteException {
        this.server.destroy();
    }

    static final class ConstrainableAdminProxy
    extends AdminProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 1L;

        ConstrainableAdminProxy(NormServer normServer, Uuid uuid) {
            super(normServer, uuid);
            if (!(normServer instanceof RemoteMethodControl)) {
                throw new IllegalArgumentException("server must implement RemoteMethodControl");
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("server must implement RemoteMethodControl");
            }
        }

        public RemoteMethodControl setConstraints(MethodConstraints methodConstraints) {
            NormServer normServer = (NormServer)((RemoteMethodControl)this.server).setConstraints(methodConstraints);
            return new ConstrainableAdminProxy(normServer, this.uuid);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.server).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }
    }
}

