/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.norm.CancelLeaseSet;
import com.sun.jini.norm.ClientLeaseWrapper;
import com.sun.jini.norm.LeaseSetOperation;
import com.sun.jini.norm.LeaseTable;
import com.sun.jini.norm.NormServerBaseImpl;
import com.sun.jini.norm.PersistentStore;
import com.sun.jini.norm.SetProxy;
import com.sun.jini.norm.StoreException;
import com.sun.jini.norm.event.EventFactory;
import com.sun.jini.norm.event.EventType;
import com.sun.jini.norm.event.EventTypeGenerator;
import com.sun.jini.norm.event.SendMonitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import net.jini.lease.ExpirationWarningEvent;
import net.jini.security.ProxyPreparer;

class LeaseSet
implements Serializable,
LeasedResource {
    private static final long serialVersionUID = 2L;
    private long expiration;
    private transient ExpirationTime expiration2;
    private final Uuid ID;
    private final Set leases = new HashSet();
    private transient LeaseTable leaseTable;
    private long minWarning = -1L;
    private EventType warningEventType;
    private long warningSeqNum;
    private EventType failureEventType;
    private transient PersistentStore store;
    private transient NormServerBaseImpl normServerBaseImpl;

    LeaseSet(Uuid uuid, EventTypeGenerator eventTypeGenerator, PersistentStore persistentStore, NormServerBaseImpl normServerBaseImpl) {
        this.store = persistentStore;
        this.normServerBaseImpl = normServerBaseImpl;
        this.ID = uuid;
        this.expiration2 = new ExpirationTime(this.expiration);
        this.leaseTable = new LeaseTable();
        SendMonitor sendMonitor = normServerBaseImpl.newSendMonitor(this);
        try {
            this.warningEventType = eventTypeGenerator.newEventType(sendMonitor, 1L);
            this.failureEventType = eventTypeGenerator.newEventType(sendMonitor, 0L);
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.expiration2 = new ExpirationTime(this.expiration);
        this.leaseTable = new LeaseTable();
    }

    Iterator restoreTransientState(EventTypeGenerator eventTypeGenerator, PersistentStore persistentStore, NormServerBaseImpl normServerBaseImpl, ProxyPreparer proxyPreparer) {
        this.normServerBaseImpl = normServerBaseImpl;
        this.store = persistentStore;
        SendMonitor sendMonitor = normServerBaseImpl.newSendMonitor(this);
        this.warningEventType.restoreTransientState(eventTypeGenerator, sendMonitor, proxyPreparer);
        this.failureEventType.restoreTransientState(eventTypeGenerator, sendMonitor, proxyPreparer);
        this.warningEventType.setLastSequenceNumber(this.warningSeqNum + Integer.MAX_VALUE);
        normServerBaseImpl.updateLeaseCount(this.leases.size());
        return this.leases.iterator();
    }

    ClientLeaseWrapper getClientLeaseWrapper(Lease lease) {
        return this.leaseTable.get(lease);
    }

    private boolean replace(ClientLeaseWrapper clientLeaseWrapper) {
        boolean bl = this.leases.remove(clientLeaseWrapper);
        this.leases.add(clientLeaseWrapper);
        return !bl;
    }

    void update(ClientLeaseWrapper clientLeaseWrapper) {
        boolean bl = this.replace(clientLeaseWrapper);
        this.leaseTable.put(clientLeaseWrapper);
        UpdateClientLease updateClientLease = new UpdateClientLease(this, clientLeaseWrapper);
        this.store.update(updateClientLease);
        if (bl) {
            this.normServerBaseImpl.updateLeaseCount(1);
        }
    }

    void addToLeaseTable(ClientLeaseWrapper clientLeaseWrapper) {
        this.leaseTable.put(clientLeaseWrapper);
    }

    boolean doesContainWrapper(ClientLeaseWrapper clientLeaseWrapper) {
        return this.leases.contains(clientLeaseWrapper);
    }

    private boolean removeInternal(ClientLeaseWrapper clientLeaseWrapper) {
        if (this.leases.remove(clientLeaseWrapper)) {
            this.leaseTable.remove(clientLeaseWrapper);
            return true;
        }
        return false;
    }

    boolean remove(ClientLeaseWrapper clientLeaseWrapper) {
        if (!this.removeInternal(clientLeaseWrapper)) {
            return false;
        }
        RemoveClientLease removeClientLease = new RemoveClientLease(this, clientLeaseWrapper);
        this.store.update(removeClientLease);
        this.normServerBaseImpl.updateLeaseCount(-1);
        return clientLeaseWrapper.getMembershipExpiration() > System.currentTimeMillis();
    }

    Set destroy() {
        this.setExpiration(-1L);
        CancelLeaseSet cancelLeaseSet = new CancelLeaseSet(this.getUuid());
        this.store.update(cancelLeaseSet);
        this.normServerBaseImpl.updateLeaseCount(-this.leases.size());
        return this.leases;
    }

    MarshalledInstance[] getLeases() {
        long l = System.currentTimeMillis();
        Iterator iterator = this.leases.iterator();
        ArrayList<MarshalledInstance> arrayList = new ArrayList<MarshalledInstance>(this.leases.size());
        while (iterator.hasNext()) {
            ClientLeaseWrapper clientLeaseWrapper = (ClientLeaseWrapper)iterator.next();
            if (l > clientLeaseWrapper.getMembershipExpiration()) continue;
            arrayList.add(clientLeaseWrapper.getMarshalledClientLease());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new MarshalledInstance[arrayList.size()]);
    }

    EventRegistration setExpirationWarningListener(RemoteEventListener remoteEventListener, long l, MarshalledObject marshalledObject) throws IOException {
        this.minWarning = l;
        this.warningEventType.setListener(remoteEventListener, marshalledObject);
        WarningEventRegistration warningEventRegistration = new WarningEventRegistration(this);
        this.store.update(warningEventRegistration);
        if (remoteEventListener == null) {
            return null;
        }
        SetProxy setProxy = this.newSetProxy();
        return new EventRegistration(this.warningEventType.getEventID(), (Object)setProxy, setProxy.getRenewalSetLease(), this.warningEventType.getLastSequenceNumber());
    }

    EventRegistration setRenewalFailureListener(RemoteEventListener remoteEventListener, MarshalledObject marshalledObject) throws IOException {
        this.failureEventType.setListener(remoteEventListener, marshalledObject);
        FailureEventRegistration failureEventRegistration = new FailureEventRegistration(this);
        this.store.update(failureEventRegistration);
        if (remoteEventListener == null) {
            return null;
        }
        SetProxy setProxy = this.newSetProxy();
        return new EventRegistration(this.failureEventType.getEventID(), (Object)setProxy, setProxy.getRenewalSetLease(), this.failureEventType.getLastSequenceNumber());
    }

    void renewalFailure(ClientLeaseWrapper clientLeaseWrapper) {
        long l;
        if (!this.removeInternal(clientLeaseWrapper)) {
            return;
        }
        try {
            EventFactory eventFactory = clientLeaseWrapper.newFailureFactory(this.newSetProxy());
            l = this.failureEventType.sendEvent(eventFactory);
        }
        catch (IOException iOException) {
            l = this.failureEventType.bumpSequenceNumber();
        }
        RenewalFailure renewalFailure = new RenewalFailure(this, clientLeaseWrapper, l);
        this.store.update(renewalFailure);
    }

    void sendWarningEvent() {
        this.warningSeqNum = this.warningEventType.sendEvent(new WarningFactory(this));
    }

    private SetProxy newSetProxy() {
        return this.normServerBaseImpl.newSetProxy(this);
    }

    boolean haveWarningRegistration() {
        return this.warningEventType.haveListener();
    }

    long getWarningTime() {
        return this.expiration - this.minWarning;
    }

    void logRenewal(ClientLeaseWrapper clientLeaseWrapper) {
        if (!this.leases.contains(clientLeaseWrapper)) {
            return;
        }
        UpdateClientLease updateClientLease = new UpdateClientLease(this, clientLeaseWrapper);
        this.store.update(updateClientLease);
    }

    public void setExpiration(long l) {
        this.expiration = l;
        this.expiration2.set(this.expiration);
    }

    public long getExpiration() {
        return this.expiration;
    }

    boolean ensureCurrent(long l) {
        return this.expiration2.ensureCurrent(l);
    }

    public Uuid getCookie() {
        return this.ID;
    }

    Uuid getUuid() {
        return this.ID;
    }

    void definiteException(EventType eventType, RemoteEvent remoteEvent, long l) {
        boolean bl = eventType.clearListenerIfSequenceMatch(l);
        if (bl) {
            LeaseSetOperation leaseSetOperation = remoteEvent instanceof ExpirationWarningEvent ? new WarningEventRegistration(this) : new FailureEventRegistration(this);
            this.store.update(leaseSetOperation);
        }
    }

    protected boolean isolateSets() {
        return this.normServerBaseImpl.isolateSets();
    }

    public String toString() {
        return "LeaseSet" + this.ID;
    }

    private static class FailureEventRegistration
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private EventType registration;

        private FailureEventRegistration(LeaseSet leaseSet) {
            super(leaseSet.getUuid());
            this.registration = leaseSet.failureEventType;
        }

        void apply(LeaseSet leaseSet) throws StoreException {
            leaseSet.failureEventType = this.registration;
        }
    }

    private static class WarningEventRegistration
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private long warningTime;
        private EventType registration;

        private WarningEventRegistration(LeaseSet leaseSet) {
            super(leaseSet.getUuid());
            this.warningTime = leaseSet.minWarning;
            this.registration = leaseSet.warningEventType;
        }

        void apply(LeaseSet leaseSet) throws StoreException {
            leaseSet.minWarning = this.warningTime;
            leaseSet.warningEventType = this.registration;
        }
    }

    private static class RenewalFailure
    extends RemoveClientLease {
        private static final long serialVersionUID = 1L;
        private long evID;

        private RenewalFailure(LeaseSet leaseSet, ClientLeaseWrapper clientLeaseWrapper, long l) {
            super(leaseSet, clientLeaseWrapper);
            this.evID = l;
        }

        void apply(LeaseSet leaseSet) {
            super.apply(leaseSet);
            leaseSet.failureEventType.setLastSequenceNumber(this.evID);
        }
    }

    private static class RemoveClientLease
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private ClientLeaseWrapper clw;

        private RemoveClientLease(LeaseSet leaseSet, ClientLeaseWrapper clientLeaseWrapper) {
            super(leaseSet.getUuid());
            this.clw = clientLeaseWrapper;
        }

        void apply(LeaseSet leaseSet) {
            leaseSet.leases.remove(this.clw);
        }
    }

    private static class UpdateClientLease
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private ClientLeaseWrapper clw;

        private UpdateClientLease(LeaseSet leaseSet, ClientLeaseWrapper clientLeaseWrapper) {
            super(leaseSet.getUuid());
            this.clw = clientLeaseWrapper;
        }

        void apply(LeaseSet leaseSet) {
            leaseSet.replace(this.clw);
        }
    }

    static class ChangeSetExpiration
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private long expiration;

        ChangeSetExpiration(LeaseSet leaseSet, long l) {
            super(leaseSet.getUuid());
            this.expiration = l;
        }

        void apply(LeaseSet leaseSet) {
            leaseSet.setExpiration(this.expiration);
        }
    }

    private static class ExpirationTime {
        private static final long serialVersionUID = 1L;
        private long expirationTime;

        private ExpirationTime(long l) {
            this.expirationTime = l;
        }

        private synchronized void set(long l) {
            this.expirationTime = l;
        }

        private synchronized boolean ensureCurrent(long l) {
            return l <= this.expirationTime;
        }
    }

    private class WarningFactory
    implements EventFactory {
        private static final long serialVersionUID = 1L;
        private final SetProxy proxy;

        WarningFactory(LeaseSet leaseSet2) {
            this.proxy = leaseSet2.newSetProxy();
        }

        public RemoteEvent createEvent(long l, long l2, MarshalledObject marshalledObject) {
            return new ExpirationWarningEvent(this.proxy, l2, marshalledObject);
        }
    }
}

