/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm.event;

import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.logging.Levels;
import com.sun.jini.norm.event.EventFactory;
import com.sun.jini.norm.event.EventTypeGenerator;
import com.sun.jini.norm.event.SendMonitor;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.security.ProxyPreparer;

public class EventType
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private MarshalledObject marshalledListener;
    private transient RemoteEventListener listener;
    private transient ProxyPreparer recoveredListenerPreparer;
    private MarshalledObject handback;
    private long registrationNumber;
    private long lastSeqNum;
    private long evID;
    private transient SendMonitor monitor;
    private transient EventTypeGenerator generator;

    EventType(EventTypeGenerator eventTypeGenerator, SendMonitor sendMonitor, long l, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject) throws IOException {
        if (eventTypeGenerator == null) {
            throw new NullPointerException("EventType(): Must create event type objects with a non-null generator");
        }
        if (sendMonitor == null) {
            throw new NullPointerException("EventType(): Must create event type objects with a non-null monitor");
        }
        this.generator = eventTypeGenerator;
        this.monitor = sendMonitor;
        this.evID = l;
        this.setLastSequenceNumber(0L);
        this.setListener(remoteEventListener, marshalledObject);
    }

    private void clearListener() {
        this.listener = null;
        this.handback = null;
        this.marshalledListener = null;
    }

    public synchronized void setListener(RemoteEventListener remoteEventListener, MarshalledObject marshalledObject) throws IOException {
        ++this.registrationNumber;
        if (remoteEventListener == null) {
            this.clearListener();
        } else {
            this.marshalledListener = new MarshalledObject<RemoteEventListener>(remoteEventListener);
            this.listener = remoteEventListener;
            this.handback = marshalledObject;
        }
    }

    public boolean haveListener() {
        return this.marshalledListener != null;
    }

    private RemoteEventListener getListener() {
        if (!this.haveListener()) {
            return null;
        }
        if (this.listener != null) {
            return this.listener;
        }
        RemoteEventListener remoteEventListener = null;
        try {
            remoteEventListener = (RemoteEventListener)this.marshalledListener.get();
        }
        catch (IOException iOException) {
            logger.log(Levels.HANDLED, "Problem unmarshalling listener -- will retry later", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Levels.HANDLED, "Problem unmarshalling listener -- will retry later", classNotFoundException);
        }
        if (remoteEventListener != null) {
            try {
                this.listener = (RemoteEventListener)this.recoveredListenerPreparer.prepareProxy((Object)remoteEventListener);
            }
            catch (RemoteException remoteException) {
                logger.log(Levels.HANDLED, "Problem preparing listener -- will retry later", remoteException);
            }
            catch (SecurityException securityException) {
                logger.log(Levels.HANDLED, "Problem preparing listener -- will retry later", securityException);
            }
        }
        return this.listener;
    }

    public synchronized boolean clearListenerIfSequenceMatch(long l) {
        if (l == this.registrationNumber) {
            this.clearListener();
            return true;
        }
        return false;
    }

    public void setLastSequenceNumber(long l) {
        this.lastSeqNum = l;
    }

    public synchronized long getLastSequenceNumber() {
        return this.lastSeqNum;
    }

    public long getEventID() {
        return this.evID;
    }

    public synchronized long sendEvent(EventFactory eventFactory) {
        if (this.generator == null) {
            throw new IllegalStateException("EventType.sendEvent:called before state was fully restored");
        }
        ++this.lastSeqNum;
        if (!this.haveListener()) {
            return this.lastSeqNum;
        }
        TaskManager taskManager = this.generator.getTaskManager();
        WakeupManager wakeupManager = this.generator.getWakeupManager();
        taskManager.add(new SendTask(taskManager, wakeupManager, eventFactory, this.lastSeqNum));
        return this.lastSeqNum;
    }

    public synchronized long bumpSequenceNumber() {
        return ++this.lastSeqNum;
    }

    public void restoreTransientState(EventTypeGenerator eventTypeGenerator, SendMonitor sendMonitor, ProxyPreparer proxyPreparer) {
        if (eventTypeGenerator == null) {
            throw new NullPointerException("EventType.restoreTransientState:Must call with a non-null generator");
        }
        if (sendMonitor == null) {
            throw new NullPointerException("EventType.restoreTransientState:Must call with a non-null monitor");
        }
        if (proxyPreparer == null) {
            throw new NullPointerException("EventType.restoreTransientState:Must call with a non-null recoveredListenerPreparer");
        }
        this.generator = eventTypeGenerator;
        this.monitor = sendMonitor;
        this.recoveredListenerPreparer = proxyPreparer;
        eventTypeGenerator.recoverEventID(this.evID);
    }

    private class SendTask
    extends RetryTask {
        private static final long MAX_TIME = 86400000L;
        private final EventFactory eventFactory;
        private final long seqNum;
        private RemoteEvent event;
        private long eventForRegistrationNumber;

        private SendTask(TaskManager taskManager, WakeupManager wakeupManager, EventFactory eventFactory, long l) {
            super(taskManager, wakeupManager);
            this.eventForRegistrationNumber = -1L;
            this.eventFactory = eventFactory;
            this.seqNum = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryOnce() {
            long l;
            MarshalledObject marshalledObject;
            RemoteEventListener remoteEventListener;
            long l2 = System.currentTimeMillis();
            if (l2 - this.startTime() > 86400000L) {
                return true;
            }
            if (!EventType.this.monitor.isCurrent()) {
                return true;
            }
            EventType eventType = EventType.this;
            synchronized (eventType) {
                if (!EventType.this.haveListener()) {
                    return true;
                }
                remoteEventListener = EventType.this.getListener();
                if (remoteEventListener == null) {
                    return false;
                }
                marshalledObject = EventType.this.handback;
                l = EventType.this.registrationNumber;
            }
            if (this.event == null || this.eventForRegistrationNumber != l) {
                this.event = this.eventFactory.createEvent(EventType.this.evID, this.seqNum, marshalledObject);
                this.eventForRegistrationNumber = l;
            }
            try {
                remoteEventListener.notify(this.event);
                return true;
            }
            catch (Throwable throwable) {
                int n = ThrowableConstants.retryable(throwable);
                if (n == 0) {
                    logger.log(Levels.HANDLED, "Problem sending event -- will retry later", throwable);
                    return false;
                }
                if (n == 1) {
                    logger.log(Level.INFO, "Problem sending event", throwable);
                    return true;
                }
                EventType.this.monitor.definiteException(EventType.this, this.event, l, throwable);
                logger.log(Level.INFO, "Problem sending event", throwable);
                return true;
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }
}

