/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

public class ReadersWriter {
    private int activeReaders = 0;
    private int waitingWriters = 0;
    private int waitingPriorityWriters = 0;
    private boolean activeWriter = false;

    public synchronized void readLock() {
        while (this.activeWriter || this.waitingWriters != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ConcurrentLockException("read lock interrupted in thread");
            }
        }
        ++this.activeReaders;
    }

    public synchronized void readUnlock() {
        --this.activeReaders;
        if (this.activeReaders == 0) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeLock() {
        while (this.activeWriter || this.activeReaders != 0 || this.waitingPriorityWriters != 0) {
            try {
                ++this.waitingWriters;
                try {
                    this.wait();
                }
                finally {
                    --this.waitingWriters;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new ConcurrentLockException("write lock interrupted in thread");
            }
        }
        this.activeWriter = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void priorityWriteLock() {
        while (this.activeWriter || this.activeReaders != 0) {
            try {
                ++this.waitingWriters;
                ++this.waitingPriorityWriters;
                try {
                    this.wait();
                }
                finally {
                    --this.waitingWriters;
                    --this.waitingPriorityWriters;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new ConcurrentLockException("write lock interrupted in thread");
            }
        }
        this.activeWriter = true;
    }

    public synchronized void writeUnlock() {
        this.activeWriter = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readerWait(Object object, long l) {
        try {
            Object object2 = object;
            synchronized (object2) {
                this.readUnlock();
                object.wait(l);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ConcurrentLockException("read wait interrupted in thread");
        }
        finally {
            this.readLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writerWait(Object object, long l) {
        try {
            Object object2 = object;
            synchronized (object2) {
                this.writeUnlock();
                object.wait(l);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ConcurrentLockException("write wait interrupted in thread");
        }
        finally {
            this.writeLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waiterNotify(Object object) {
        Object object2 = object;
        synchronized (object2) {
            object.notifyAll();
        }
    }

    public static class ConcurrentLockException
    extends RuntimeException {
        private static final long serialVersionUID = 7027246653257040584L;

        public ConcurrentLockException() {
        }

        public ConcurrentLockException(String string) {
            super(string);
        }
    }
}

