/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.services.ColorPrefs;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.TokenizerFactory;
import com.mathworks.xml.XMLUtils;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CodeAsXML {
    public static final String PUBLICID = "-/MathWorks/Syntax Highlighted MATLAB Code/v1.0/EN";
    public static final String NAMESPACE = "http://www.mathworks.com/namespace/mcode/v1/syntaxhighlight.dtd";
    public static final String NSPREFIX = "mwsh";

    public static Node xmlize(Document document, File file) throws Exception {
        return CodeAsXML.xmlize(document, CodeAsXML.file2charArray(file));
    }

    public static Node xmlize(Document document, char[] cArray) throws Exception {
        Element element;
        if (document == null) {
            document = XMLUtils.createDocument((String)"code");
            element = document.getDocumentElement();
            element.setAttribute("xmlns:mwsh", NAMESPACE);
        } else {
            element = document.createElementNS(NAMESPACE, "mwsh:code");
        }
        element.setAttribute("xml:space", "preserve");
        if (cArray == null || cArray.length == 0) {
            return element;
        }
        Tokenizer tokenizer = TokenizerFactory.getMTokenizer();
        Tokenizer.TokenInfo[] tokenInfoArray = tokenizer.tokenize(cArray);
        String string = new String(cArray);
        Hashtable hashtable = CodeAsXML.getCategoryTags();
        int n = tokenInfoArray[0].getOffset();
        for (int i = 0; i < tokenInfoArray.length; ++i) {
            Element element2;
            String string2;
            String string3 = tokenInfoArray[i].getColorPreferenceName();
            if (string3 != null) {
                string3 = (String)hashtable.get(string3);
            }
            if (i < tokenInfoArray.length - 1) {
                int n2 = tokenInfoArray[i + 1].getOffset();
                string2 = string.substring(n, n2);
                n = n2;
            } else {
                string2 = string.substring(n);
            }
            if (string3 == null) {
                element2 = element;
            } else {
                string3 = "mwsh:" + string3;
                element2 = element.getOwnerDocument().createElement(string3);
                element2.setAttribute("xml:space", "preserve");
                element.appendChild(element2);
            }
            Text text = document.createTextNode(string2);
            element2.appendChild(text);
        }
        return element;
    }

    private static char[] file2charArray(File file) throws Exception {
        CharArrayWriter charArrayWriter = new CharArrayWriter(1024);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n = bufferedReader.read();
        while (n > 0) {
            charArrayWriter.write(n);
            n = bufferedReader.read();
        }
        return charArrayWriter.toCharArray();
    }

    private static Hashtable getCategoryTags() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(ColorPrefs.MatlabColor.KEYWORD.getKey(), "keywords");
        hashtable.put(ColorPrefs.MatlabColor.COMMENT.getKey(), "comments");
        hashtable.put(ColorPrefs.MatlabColor.STRING.getKey(), "strings");
        hashtable.put(ColorPrefs.MatlabColor.UNTERMINATED_STRING.getKey(), "unterminated_strings");
        hashtable.put(ColorPrefs.MatlabColor.SYSTEM_COMMAND.getKey(), "system_commands");
        return hashtable;
    }
}

