/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.PrefUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ActionButton;
import com.mathworks.widgets.PopupMenuCustomizer;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;

public class FileComboBox {
    private static final int DEFAULT_MAX_ITEMS = 10;
    private static final int FILENAME_DISPLAY_LENGTH = 36;
    private static final String BROWSE = MJUtilities.intlString((String)"filecombobox.browse");
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final MJComboBox fComboBox;
    private final ActionButton fOptionsDropdown;
    private final FileChosenCallback fCallback;
    private final MJFileChooserPerPlatform fChooser;
    private final JComponent fPanel;
    private Object fPreviousSelection;
    private int fMaxItems;
    private boolean fDontFireEvents;
    private boolean fPerformingSaveAs;
    private int fNewFileStartPosition;
    private PopupMenuCustomizer fOptionalPopupMenuCustomizer;
    public static final String NAME_OPTIONS_POPUP_MENU = "OptionsPopupMenu";
    public static final String NAME_OPTIONS_BUTTON = "OptionsButton";
    public static final String NAME_FILE_COMBO_BOX = "FileComboBox";

    public FileComboBox(FileChosenCallback fileChosenCallback) {
        this(fileChosenCallback, EMPTY_ARRAY);
    }

    public FileComboBox(FileChosenCallback fileChosenCallback, Object[] objectArray) {
        this.fCallback = fileChosenCallback;
        this.fMaxItems = 10;
        this.fChooser = new MJFileChooserPerPlatform();
        this.prepareChooser(this.fChooser);
        this.fComboBox = new MJComboBox(objectArray);
        this.fComboBox.setName(NAME_FILE_COMBO_BOX);
        this.fComboBox.setPrototypeDisplayValue((Object)FileComboBox.constructPrototypeDisplay());
        this.fComboBox.setRenderer((ListCellRenderer)new FilenameCellRenderer());
        this.fComboBox.addItem((Object)BROWSE);
        this.fComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!FileComboBox.this.fDontFireEvents && itemEvent.getStateChange() == 1) {
                    if (!FileComboBox.this.fPerformingSaveAs && !FileComboBox.this.fCallback.acceptChange(FileComboBox.this.fPreviousSelection, itemEvent.getItem())) {
                        FileComboBox.this.restorePreviousSelection();
                    } else if (FileComboBox.this.fComboBox.getSelectedItem() == BROWSE) {
                        FileComboBox.this.browse();
                    } else {
                        FileComboBox.this.handleSelection();
                    }
                }
            }
        });
        this.fPreviousSelection = this.fComboBox.getSelectedItem();
        this.fOptionsDropdown = ActionButton.create(new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                jPopupMenu.removeAll();
                jPopupMenu.setName(FileComboBox.NAME_OPTIONS_POPUP_MENU);
                jPopupMenu.add((Action)new MJAbstractAction(MJUtilities.intlString((String)"filecombobox.saveAs")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        FileComboBox.this.saveAs();
                    }
                });
                if (FileComboBox.this.fOptionalPopupMenuCustomizer != null) {
                    FileComboBox.this.fOptionalPopupMenuCustomizer.customize(jPopupMenu);
                }
            }
        });
        this.fOptionsDropdown.getComponent().setName(NAME_OPTIONS_BUTTON);
        this.fOptionsDropdown.getComponent().getAccessibleContext().setAccessibleName("Options menu");
        this.fPanel = this.buildPanel();
    }

    public void setOptionalPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this.fOptionalPopupMenuCustomizer = popupMenuCustomizer;
    }

    private static String constructPrototypeDisplay() {
        StringBuilder stringBuilder = new StringBuilder(36);
        for (int i = 0; i < 36; ++i) {
            stringBuilder.append('n');
        }
        return stringBuilder.toString();
    }

    private JComponent buildPanel() {
        String string = PlatformInfo.isMacintosh() ? "1dlu" : "4dlu";
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("fill:0px:grow, " + string + ", p", "p"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fComboBox, cellConstraints.xy(1, 1));
        if (PlatformInfo.isMacintosh()) {
            this.fComboBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        }
        panelBuilder.add((Component)this.fOptionsDropdown.getComponent(), cellConstraints.xy(3, 1, "fill, fill"));
        return panelBuilder.getPanel();
    }

    public void setMaxItems(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("'maxItems' must be >= 1: " + n);
        }
        this.fMaxItems = n;
        this.enforceMaxItems();
    }

    public void setRenderer(FilenameCellRenderer filenameCellRenderer) {
        if (filenameCellRenderer == null) {
            throw new IllegalArgumentException("'renderer' cannot be null");
        }
        this.fComboBox.setRenderer((ListCellRenderer)filenameCellRenderer);
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    public MJComboBox getComboBox() {
        return this.fComboBox;
    }

    public File getSelectedFile() {
        Object object = this.fComboBox.getSelectedItem();
        return object instanceof File ? (File)object : null;
    }

    public Object getSelectedItem() {
        return this.fComboBox.getSelectedItem();
    }

    public void setSelectedItem(Object object) {
        this.fComboBox.setSelectedItem(object);
    }

    public void setNewFileStartPosition(int n) {
        this.fNewFileStartPosition = n;
    }

    public void saveFilesToPrefs(String string) {
        PrefUtils.writeFileList((String)string, this.getFiles());
    }

    public void addFilesFromPrefs(String string) {
        this.addFilesFromPrefs(string, true);
    }

    public void addFilesFromPrefs(String string, boolean bl) {
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.fComboBox.getModel();
        for (File file : PrefUtils.readFileList((String)string, (boolean)bl)) {
            if (this.indexOf(file) != -1) continue;
            mutableComboBoxModel.insertElementAt(file, mutableComboBoxModel.getSize() - 1);
        }
    }

    public void addFile(File file) {
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.fComboBox.getModel();
        int n = this.indexOf(file);
        if (n != -1) {
            this.fDontFireEvents = true;
            mutableComboBoxModel.removeElementAt(n);
            this.fDontFireEvents = false;
        }
        this.insertFile(file);
        this.enforceMaxItems();
        this.fComboBox.setSelectedItem((Object)file);
    }

    private void enforceMaxItems() {
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.fComboBox.getModel();
        while (mutableComboBoxModel.getSize() > this.fMaxItems) {
            this.fDontFireEvents = true;
            mutableComboBoxModel.removeElementAt(mutableComboBoxModel.getSize() - 2);
            this.fDontFireEvents = false;
        }
    }

    public List<File> getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < this.fComboBox.getModel().getSize(); ++i) {
            Object e = this.fComboBox.getModel().getElementAt(i);
            if (!(e instanceof File)) continue;
            arrayList.add((File)e);
        }
        return arrayList;
    }

    private void insertFile(File file) {
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.fComboBox.getModel();
        int n = Math.min(this.fNewFileStartPosition, mutableComboBoxModel.getSize() - 1);
        mutableComboBoxModel.insertElementAt(file, n);
    }

    protected void prepareChooser(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
    }

    private int indexOf(File file) {
        int n = -1;
        for (int i = 0; i < this.fComboBox.getModel().getSize(); ++i) {
            if (!this.fComboBox.getModel().getElementAt(i).equals(file)) continue;
            n = i;
            break;
        }
        return n;
    }

    private void handleSelection() {
        if (this.fComboBox.getSelectedItem() instanceof File) {
            File file = (File)this.fComboBox.getSelectedItem();
            boolean bl = this.fCallback.fileChosen(file);
            if (!bl) {
                this.fDontFireEvents = true;
                this.fComboBox.removeItem((Object)file);
                this.fDontFireEvents = false;
                this.fComboBox.setSelectedItem(this.fPreviousSelection);
                assert (this.fComboBox.getSelectedItem() == this.fPreviousSelection);
            }
        } else {
            this.fCallback.otherItemChosen(this.fComboBox.getSelectedItem());
        }
        this.fPreviousSelection = this.fComboBox.getSelectedItem();
    }

    private void updateFileChooser(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
        File file = this.getSelectedFileForChooser();
        if (file != null) {
            mJFileChooserPerPlatform.setSelectedFile(file);
        }
        mJFileChooserPerPlatform.setDialogTitle(null);
    }

    protected File getSelectedFileForChooser() {
        return this.fPreviousSelection instanceof File ? (File)this.fPreviousSelection : null;
    }

    private void saveAs() {
        File file;
        boolean bl;
        this.updateFileChooser(this.fChooser);
        this.fChooser.showSaveDialog((Component)this.fComboBox);
        if (this.fChooser.getState() == 0 && this.fChooser.getSelectedFile() != null && (bl = this.fCallback.saveAs(file = this.fChooser.getSelectedFile()))) {
            this.fPerformingSaveAs = true;
            this.addFile(file);
            this.fPerformingSaveAs = false;
        }
    }

    private void browse() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileComboBox.this.updateFileChooser(FileComboBox.this.fChooser);
                FileComboBox.this.fChooser.setSelectedFiles(new File[0]);
                FileComboBox.this.fChooser.showOpenDialog((Component)FileComboBox.this.fComboBox);
                boolean bl = false;
                if (FileComboBox.this.fChooser.getState() == 0 && FileComboBox.this.fChooser.getSelectedFile() != null) {
                    File file = FileComboBox.this.fChooser.getSelectedFile();
                    bl = FileComboBox.this.fCallback.fileChosen(file);
                    if (bl) {
                        FileComboBox.this.addFile(file);
                    }
                }
                if (!bl) {
                    FileComboBox.this.restorePreviousSelection();
                }
            }
        });
    }

    private void restorePreviousSelection() {
        this.fDontFireEvents = true;
        this.fComboBox.setSelectedItem(this.fPreviousSelection);
        this.fDontFireEvents = false;
    }

    public static class FilenameCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof File) {
                File file = (File)object;
                String string = FileUtils.truncatePathname((String)file.getAbsolutePath(), (int)36);
                this.setText(string);
            }
            return this;
        }
    }

    public static interface FileChosenCallback {
        public boolean saveAs(File var1);

        public boolean acceptChange(Object var1, Object var2);

        public boolean fileChosen(File var1);

        public void otherItemChosen(Object var1);
    }
}

