/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.ToolTipProvider;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.DropdownButton;
import com.mathworks.widgets.PopupMenuCustomizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public final class PickerButton
extends MJPanel {
    public static final String MAIN_BUTTON_NAME = "Big Picker Button";
    public static final String DROPDOWN_BUTTON_NAME = "Dropdown Picker Button";
    private final AbstractButton fMainBtn;
    private final DropdownButton fDropdownBtn;
    private final ToolTippableButton fToolTippable;
    private final ButtonType fButtonType;

    public PickerButton(AbstractAction abstractAction) {
        this(abstractAction, ButtonType.PUSHBUTTON);
    }

    public PickerButton(AbstractAction abstractAction, ButtonType buttonType) {
        this.fButtonType = buttonType;
        this.fMainBtn = buttonType.createButton(abstractAction);
        this.fToolTippable = (ToolTippableButton)((Object)this.fMainBtn);
        this.fButtonType.hideText(this.fMainBtn);
        this.fDropdownBtn = new DropdownButton();
        this.fDropdownBtn.setComponentToAlignWith(this.fMainBtn);
        this.setUpButtonLayout();
    }

    private void setUpButtonLayout() {
        this.fMainBtn.setName(MAIN_BUTTON_NAME);
        this.fDropdownBtn.setName(DROPDOWN_BUTTON_NAME);
        this.setLayout(new BorderLayout());
        this.add(this.fMainBtn, "Center");
        this.add((Component)((Object)this.fDropdownBtn), "East");
        this.fMainBtn.setMargin(new Insets(0, 0, 0, 0));
        this.fDropdownBtn.setMargin(new Insets(0, 0, 0, 0));
        this.fButtonType.configureButton(this.fMainBtn);
        MJToolBar.configureButton((MJButton)this.fDropdownBtn);
        this.setMaximumSize(new Dimension(this.fMainBtn.getMaximumSize().width + this.fDropdownBtn.getMaximumSize().width + 4, this.fMainBtn.getMaximumSize().height + 4));
        if (!PlatformInfo.isMacintosh()) {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (PickerButton.this.isEnabled()) {
                        PickerButton.this.toggleAppearance(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    PickerButton.this.toggleAppearance(false);
                }
            };
            this.fMainBtn.addMouseListener(mouseAdapter);
            this.fDropdownBtn.addMouseListener(mouseAdapter);
        }
    }

    private void toggleAppearance(boolean bl) {
        if (PlatformInfo.isWindowsModernAppearance()) {
            this.fMainBtn.getModel().setRollover(bl);
            this.fDropdownBtn.getModel().setRollover(bl);
        } else {
            this.fButtonType.setFlyOverAppearance(this.fMainBtn, !bl);
            this.fDropdownBtn.setFlyOverAppearance(!bl);
        }
    }

    public void setBigButtonIcon(Icon icon) {
        this.fMainBtn.setIcon(icon);
        this.fMainBtn.invalidate();
        this.fMainBtn.revalidate();
    }

    public void setActionTracking(boolean bl) {
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fMainBtn.setEnabled(bl);
        this.fDropdownBtn.setEnabled(bl);
    }

    public void setDropDownEnabled(boolean bl) {
        this.fDropdownBtn.setEnabled(bl);
    }

    public void setSelected(boolean bl) {
        this.fMainBtn.setSelected(bl);
    }

    public boolean isSelected() {
        return this.fMainBtn.isSelected();
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this.fDropdownBtn.setPopupMenuCustomizer(popupMenuCustomizer);
    }

    public void showMenu() {
        this.fDropdownBtn.showMenu();
    }

    public void setShowMenuAutomatically(boolean bl) {
        this.fDropdownBtn.setShowMenuAutomatically(bl);
    }

    public JPopupMenu getPopupMenu() {
        return this.fDropdownBtn.getPopupMenu();
    }

    public void addMainButtonActionListener(ActionListener actionListener) {
        this.fMainBtn.addActionListener(actionListener);
    }

    public void removeMainButtonActionListener(ActionListener actionListener) {
        this.fMainBtn.removeActionListener(actionListener);
    }

    public void setToolTipText(String string) {
        this.fMainBtn.setToolTipText(string);
    }

    public void setDropDownToolTipText(String string) {
        this.fDropdownBtn.setToolTipText(string);
    }

    public void setToolTipProvider(ToolTipProvider toolTipProvider) {
        this.fToolTippable.setToolTipProvider(toolTipProvider);
    }

    public void setName(String string) {
        super.setName(string);
        this.fMainBtn.setName(string + ".mainButton");
        this.fDropdownBtn.setName(string + ".dropdownButton");
    }

    public static enum ButtonType {
        PUSHBUTTON,
        TOGGLEBUTTON;


        public AbstractButton createButton(Action action) {
            ToolTippableButton toolTippableButton = null;
            switch (this) {
                case PUSHBUTTON: {
                    toolTippableButton = new OverrideableToolTipTextButton(action);
                    break;
                }
                case TOGGLEBUTTON: {
                    toolTippableButton = new OverrideableToolTipTextToggleButton(action);
                }
            }
            return toolTippableButton;
        }

        public void hideText(AbstractButton abstractButton) {
            switch (this) {
                case PUSHBUTTON: {
                    ((MJButton)abstractButton).hideText();
                    break;
                }
                case TOGGLEBUTTON: {
                    ((MJToggleButton)abstractButton).hideText();
                }
            }
        }

        public void configureButton(AbstractButton abstractButton) {
            switch (this) {
                case PUSHBUTTON: {
                    MJToolBar.configureButton((MJButton)((MJButton)abstractButton));
                    break;
                }
                case TOGGLEBUTTON: {
                    MJToolBar.configureButton((MJToggleButton)((MJToggleButton)abstractButton));
                }
            }
        }

        public void setFlyOverAppearance(AbstractButton abstractButton, boolean bl) {
            switch (this) {
                case PUSHBUTTON: {
                    ((MJButton)abstractButton).setFlyOverAppearance(bl);
                    break;
                }
                case TOGGLEBUTTON: {
                    ((MJToggleButton)abstractButton).setFlyOverAppearance(bl);
                }
            }
        }
    }

    private static class OverrideableToolTipTextToggleButton
    extends MJToggleButton
    implements ToolTippableButton {
        private ToolTipProvider fToolTipProvider;

        OverrideableToolTipTextToggleButton(Action action) {
            super(action);
        }

        OverrideableToolTipTextToggleButton(Icon icon) {
            super(icon);
        }

        @Override
        public void setToolTipProvider(ToolTipProvider toolTipProvider) {
            this.fToolTipProvider = toolTipProvider;
        }

        public String getToolTipText() {
            return this.fToolTipProvider == null ? super.getToolTipText() : this.fToolTipProvider.getToolTipText();
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return this.fToolTipProvider == null ? super.getToolTipText(mouseEvent) : this.fToolTipProvider.getToolTipText(mouseEvent);
        }
    }

    private static class OverrideableToolTipTextButton
    extends MJButton
    implements ToolTippableButton {
        private ToolTipProvider fToolTipProvider;

        OverrideableToolTipTextButton(Action action) {
            super(action);
        }

        OverrideableToolTipTextButton(Icon icon) {
            super(icon);
        }

        @Override
        public void setToolTipProvider(ToolTipProvider toolTipProvider) {
            this.fToolTipProvider = toolTipProvider;
        }

        public String getToolTipText() {
            return this.fToolTipProvider == null ? super.getToolTipText() : this.fToolTipProvider.getToolTipText();
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return this.fToolTipProvider == null ? super.getToolTipText(mouseEvent) : this.fToolTipProvider.getToolTipText(mouseEvent);
        }
    }

    private static interface ToolTippableButton {
        public void setToolTipProvider(ToolTipProvider var1);
    }
}

