/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.KeyEventPreprocessor;
import com.mathworks.widgets.WidgetUtils;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;

public final class PromptingTextField
extends MJTextField {
    private String fPromptText = "";
    private final KeyEventPreprocessor fPreprocessor;

    public PromptingTextField() {
        this(PromptingTextField.getDefaultPromptText());
    }

    public PromptingTextField(String string) {
        this(string, null);
    }

    public PromptingTextField(String string, KeyEventPreprocessor keyEventPreprocessor) {
        PromptingTextField.checkPromptText(string);
        this.fPromptText = string;
        this.setName("PromptingTextField");
        this.addFocusListener(this.createFocusListener());
        this.fPreprocessor = keyEventPreprocessor;
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"MATLABDesktop");
    }

    public void paint(Graphics graphics) {
        block4: {
            super.paint(graphics);
            if (Utilities.isOSX()) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (!this.hasFocus() && this.getText().length() == 0) {
                try {
                    Rectangle rectangle = this.modelToView(0);
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    int n = rectangle.x;
                    int n2 = rectangle.y + rectangle.height - fontMetrics.getDescent();
                    Graphics graphics2 = graphics.create();
                    graphics2.setClip(0, 0, this.getWidth() - this.getInsets().right, this.getHeight());
                    int n3 = graphics2.getFontMetrics(this.getFont()).stringWidth(this.fPromptText);
                    graphics2.setColor(this.getBackground());
                    graphics2.fillRect(rectangle.x, rectangle.y, n3, rectangle.height);
                    graphics2.setColor(UIManager.getColor("TextField.inactiveForeground"));
                    graphics2.drawString(this.fPromptText, n, n2);
                    graphics2.dispose();
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
    }

    public static String getDefaultPromptText() {
        return WidgetUtils.lookup("PromptingTextField.defaultPromptingText");
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PromptingTextField.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PromptingTextField.this.repaint();
            }
        };
    }

    private static void checkPromptText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Prompt text cannot be null.");
        }
    }

    public String getPromptText() {
        return this.fPromptText;
    }

    public void setPromptText(String string) {
        PromptingTextField.checkPromptText(string);
        this.fPromptText = string;
        this.repaint();
    }

    public void processComponentKeyEvent(KeyEvent keyEvent) {
        if (this.fPreprocessor != null) {
            this.fPreprocessor.processComponentKeyEvent(keyEvent, (JTextComponent)((Object)this));
        } else {
            super.processComponentKeyEvent(keyEvent);
        }
    }
}

