/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.widgets.text.EditorPrefsAccessor;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;

public class StateMRUFiles
implements EventListener {
    private static StateMRUFiles sMRUFilesInstance = new StateMRUFiles();
    private List<String> fMRUFilesForState = new Vector<String>();
    private int fMaxMRUFileCount;

    private StateMRUFiles() {
        this.initMRUFileMaxCount();
    }

    public static StateMRUFiles getInstance() {
        return sMRUFilesInstance;
    }

    private void initMRUFileMaxCount() {
        this.fMaxMRUFileCount = EditorPrefsAccessor.getCodeFoldingStateMRUFileCount();
    }

    public int getMaxMRUFileCount() {
        return this.fMaxMRUFileCount;
    }

    public boolean addFile(String string) {
        boolean bl = false;
        if (string != null && !this.fMRUFilesForState.contains(string)) {
            bl = this.fMRUFilesForState.add(string);
            this.checkAndRemoveLRU();
        }
        return bl;
    }

    public boolean removeFile(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.fMRUFilesForState.remove(string);
        }
        return bl;
    }

    public boolean containsFile(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.fMRUFilesForState.contains(string);
        }
        return bl;
    }

    public void updateFileAsMRU(String string) {
        if (string != null) {
            this.fMRUFilesForState.remove(string);
            this.fMRUFilesForState.add(string);
            this.checkAndRemoveLRU();
        }
    }

    private String checkAndRemoveLRU() {
        String string = null;
        if (this.fMRUFilesForState.size() > this.fMaxMRUFileCount) {
            string = this.fMRUFilesForState.remove(0);
        }
        return string;
    }
}

