/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class SyntaxHighlightingUtils {
    private static Map<String, EditorSyntaxHighlighting> sSyntaxHighlighting = null;

    public static synchronized EditorSyntaxHighlighting findSyntaxHighlighting(EditorLanguage editorLanguage) {
        Validate.notNull((Object)editorLanguage, (String)"'language' cannot be null");
        if (sSyntaxHighlighting == null) {
            sSyntaxHighlighting = SyntaxHighlightingUtils.registerSyntaxHighlightings();
        }
        return sSyntaxHighlighting.get(editorLanguage.getInternalName());
    }

    public static synchronized Collection<EditorSyntaxHighlighting> getAllSyntaxHighlightings() {
        if (sSyntaxHighlighting == null) {
            sSyntaxHighlighting = SyntaxHighlightingUtils.registerSyntaxHighlightings();
        }
        return Collections.unmodifiableCollection(sSyntaxHighlighting.values());
    }

    private SyntaxHighlightingUtils() {
    }

    private static Map<String, EditorSyntaxHighlighting> registerSyntaxHighlightings() {
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(EditorSyntaxHighlighting.class);
        HashMap<String, EditorSyntaxHighlighting> hashMap = new HashMap<String, EditorSyntaxHighlighting>();
        for (EditorSyntaxHighlighting editorSyntaxHighlighting : collection) {
            hashMap.put(editorSyntaxHighlighting.getLanguage().getInternalName(), editorSyntaxHighlighting);
        }
        return hashMap;
    }
}

