/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleStringTrimmer;
import com.mathworks.mwswing.StringTrimmer;
import com.mathworks.widgets.desk.DTUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;

class DTEdgeButton
extends MJToggleButton {
    private int fEdge;
    private boolean fIsLocked;
    private boolean fWasSelectedUponLock;
    private static final Insets NORMAL_MARGIN = new Insets(2, 8, 2, 8);
    private static final Insets SIDEWAYS_MARGIN = new Insets(2, 8, 2, 8);
    private static final Color ROLLOVER_COLOR = new Color(243, 184, 76);
    private static final StringTrimmer sTrimmer = new SimpleStringTrimmer();

    DTEdgeButton(int n, Action action) {
        super(action);
        this.fEdge = n;
        this.setFocusable(false);
        this.setFocusTraversable(false);
        this.setMargin(this.isSideways() ? SIDEWAYS_MARGIN : NORMAL_MARGIN);
    }

    void setEdge(int n) {
        if (this.fEdge != n) {
            this.fEdge = n;
            this.setMargin(this.isSideways() ? SIDEWAYS_MARGIN : NORMAL_MARGIN);
            this.revalidate();
            this.repaint();
        }
    }

    void lock() {
        if (this.fIsLocked) {
            return;
        }
        this.fWasSelectedUponLock = this.isSelected();
        this.fIsLocked = true;
    }

    void unlock() {
        if (!this.fIsLocked) {
            return;
        }
        this.setSelected(this.fWasSelectedUponLock);
        this.fIsLocked = false;
    }

    public Dimension getPreferredSize() {
        boolean bl = MJUtilities.isHighContrast();
        if (bl && !this.isSideways()) {
            return super.getPreferredSize();
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        char[] cArray = super.getText().toCharArray();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.charsWidth(cArray, 0, cArray.length);
        Insets insets = bl ? this.getInsets() : this.getMargin();
        Icon icon = super.getIcon();
        if (icon != null) {
            n2 += icon.getIconWidth() + this.getIconTextGap();
            n = Math.max(n, icon.getIconHeight());
        }
        n += insets.top + insets.bottom;
        n2 += insets.left + insets.right;
        if (this.isSideways()) {
            return new Dimension(n, n2);
        }
        return new Dimension(n2, n);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public String getText() {
        return this.isSideways() ? null : super.getText();
    }

    public Icon getIcon() {
        return this.isSideways() ? null : super.getIcon();
    }

    public void setDisplayedMnemonicIndex(int n) {
    }

    public String getToolTipText() {
        return null;
    }

    public void paint(Graphics graphics) {
        Object object;
        Serializable serializable;
        Cloneable cloneable;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ButtonModel buttonModel = this.getModel();
        boolean bl = MJUtilities.isHighContrast();
        if (bl) {
            super.paint(graphics);
        } else {
            cloneable = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            serializable = buttonModel.isRollover() ? ROLLOVER_COLOR : UIManager.getColor("control");
            object = this.isSideways() ? DTUtilities.Axis.X_AXIS : DTUtilities.Axis.Y_AXIS;
            DTUtilities.Curvature curvature = buttonModel.isPressed() || buttonModel.isSelected() ? DTUtilities.Curvature.CONCAVE : DTUtilities.Curvature.CONVEX;
            DTUtilities.drawGradientBackground(graphics2D, cloneable, (Color)serializable, object, curvature);
            DTUtilities.drawEnds(graphics, cloneable, object);
        }
        if (this.isSideways() || !bl) {
            graphics2D.setFont(this.getFont());
            if (buttonModel.isRollover() || buttonModel.isSelected() || bl) {
                graphics2D.setColor(this.getForeground());
            } else {
                graphics2D.setColor(UIManager.getColor("textInactiveText").darker().darker());
            }
            cloneable = bl ? this.getInsets() : this.getMargin();
            serializable = graphics2D.getFontMetrics();
            object = graphics2D.getTransform();
            if (this.fEdge == 7) {
                graphics2D.translate(0, this.getHeight());
                graphics2D.rotate(-1.5707963267948966);
            } else if (this.fEdge == 3) {
                graphics2D.translate(this.getWidth(), 0);
                graphics2D.rotate(1.5707963267948966);
            }
            int n = ((Insets)cloneable).left;
            Icon icon = super.getIcon();
            if (icon != null) {
                icon.paintIcon((Component)((Object)this), graphics2D, n, ((Insets)cloneable).top);
                n += icon.getIconWidth() + this.getIconTextGap();
            }
            RenderingHints renderingHints = null;
            RenderingHints renderingHints2 = GraphicsUtils.getAntialiasingRenderingHints();
            if (renderingHints2 != null) {
                renderingHints = graphics2D.getRenderingHints();
                graphics2D.addRenderingHints(renderingHints2);
            }
            int n2 = (this.isSideways() ? this.getHeight() : this.getWidth()) - n - ((Insets)cloneable).right;
            String string = sTrimmer.shortenString(super.getText(), (FontMetrics)serializable, n2);
            int n3 = ((Insets)cloneable).top + ((FontMetrics)serializable).getAscent() + ((FontMetrics)serializable).getLeading();
            graphics2D.drawChars(string.toCharArray(), 0, string.length(), n, n3);
            graphics2D.setTransform((AffineTransform)object);
            if (renderingHints != null) {
                graphics2D.setRenderingHints(renderingHints);
            }
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (!this.fIsLocked) {
            super.fireActionPerformed(actionEvent);
        }
    }

    private boolean isSideways() {
        return this.fEdge == 7 || this.fEdge == 3;
    }
}

