/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentArranger;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDocumentTabs;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDropOutlinePainter;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTFloatingFrame;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTKeyControlledMover;
import com.mathworks.widgets.desk.DTKeyControlledResizer;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTSelectionManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.UIManager;

class DTFloatingPane
extends MJPanel
implements DTContainer,
DTDocumentArranger,
DTDropTarget {
    protected DTDocumentContainer fDocumentContainer;
    protected List<DTFloatingFrame> fFloatingFrames = new ArrayList<DTFloatingFrame>();
    private DTDocumentTabs fTabs;
    protected MJLayeredPane fLightContainer;
    protected Panel fHeavyContainer;
    protected MouseListener fLocalMouseListener;
    protected int fHeavyClientCount;
    protected boolean fIsHeavy;
    protected boolean fIsMinimizingAll;
    protected DropTarget fDropTarget;
    protected Point fNextUpperLeft = new Point(INITIAL_UPPER_LEFT);
    protected static final int CASCADE_OFFSET = 20;
    protected static final Point INITIAL_UPPER_LEFT = new Point(5, 5);
    protected static final int MIN_INITIAL_WIDTH = 100;
    protected static final int MIN_INITIAL_HEIGHT = 100;

    DTFloatingPane(DTDocumentContainer dTDocumentContainer) {
        this.fDocumentContainer = dTDocumentContainer;
        this.fLocalMouseListener = new LocalMouseListener();
        this.setLayout(null);
        this.setHeavy(false);
        this.setBackground(UIManager.getColor("control").darker());
        this.fTabs = new DTDocumentTabs(this.fDocumentContainer);
        this.fTabs.setProperties(this.fDocumentContainer.getTabProperties());
        this.fTabs.setDrawClosedTabs(true);
        this.fDocumentContainer.getTabProperties().register(this.fTabs);
        this.fTabs.setNewAction(this.fDocumentContainer.getGroup().getNewAction());
        this.fTabs.addEdgeListener(new DTDocumentTabs.EdgeListener(){

            @Override
            public void tabsMoved(DTDocumentTabs dTDocumentTabs, int n) {
                DTFloatingPane.this.revalidate();
                DTFloatingPane.this.repaint();
            }
        });
        this.add((Component)((Object)this.fTabs));
    }

    void setHeavy(boolean bl) {
        Object object;
        int n;
        if (bl == this.fIsHeavy && (bl && this.fHeavyContainer != null || !bl && this.fLightContainer != null)) {
            return;
        }
        this.fIsHeavy = bl;
        Object object2 = null;
        Component component = null;
        if (bl) {
            if (this.fLightContainer != null) {
                if (this.fFloatingFrames.size() > 0) {
                    Collections.sort(this.fFloatingFrames, new ZOrderComparator());
                }
                object2 = this.fLightContainer;
                this.fLightContainer = null;
            }
            if (this.fHeavyContainer == null) {
                this.fHeavyContainer = new Panel(){

                    @Override
                    public void paint(Graphics graphics) {
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                        super.paint(graphics);
                    }
                };
                this.fHeavyContainer.setLayout(null);
                this.fHeavyContainer.setBackground(UIManager.getColor("control").darker());
                component = this.fHeavyContainer;
            }
        } else {
            if (this.fHeavyContainer != null) {
                if (this.fFloatingFrames.size() > 0) {
                    ArrayList<DTFloatingFrame> arrayList = new ArrayList<DTFloatingFrame>(this.fFloatingFrames.size());
                    int n2 = this.fHeavyContainer.getComponentCount();
                    for (n = 0; n < n2; ++n) {
                        object = DTFloatingFrame.clientInFloatingComponent(this.fHeavyContainer.getComponent(n));
                        DTFloatingFrame dTFloatingFrame = this.findFloatingFrame((DTClient)object);
                        arrayList.add(dTFloatingFrame);
                    }
                    this.fFloatingFrames = arrayList;
                }
                object2 = this.fHeavyContainer;
                this.fHeavyContainer = null;
            }
            if (this.fLightContainer == null) {
                this.fLightContainer = new MJLayeredPane(){

                    public boolean isOptimizedDrawingEnabled() {
                        return false;
                    }
                };
                component = this.fLightContainer;
            }
        }
        if (object2 != null) {
            ((Component)object2).removeMouseListener(this.fLocalMouseListener);
            this.remove((Component)object2);
        }
        if (component != null) {
            component.addMouseListener(this.fLocalMouseListener);
            this.add(component);
            if (this.fDropTarget != null) {
                this.fDropTarget.setComponent(component);
            }
            if (this.fFloatingFrames.size() > 0) {
                if (object2 != null) {
                    ((Container)object2).removeAll();
                }
                n = this.fFloatingFrames.size();
                for (int i = 0; i < n; ++i) {
                    DTFloatingFrame dTFloatingFrame = this.fFloatingFrames.get(i);
                    object = dTFloatingFrame.getClient().getLastFloatingInLocation();
                    dTFloatingFrame.getFloatingComponent().setBounds(((DTLocation)object).getFrameBounds());
                    dTFloatingFrame.getFloatingComponent().setVisible(!((DTFloatingLocation)object).isMinimized());
                    ((Container)component).add(dTFloatingFrame.getFloatingComponent());
                }
            }
        }
    }

    boolean isHeavy() {
        return this.fIsHeavy;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        int n;
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        DTFloatingFrame dTFloatingFrame = new DTFloatingFrame(this, dTClient, this.fDocumentContainer.getMaximizeListener());
        if (dTFloatingFrame.needsHeavyParent()) {
            ++this.fHeavyClientCount;
            if (this.fHeavyClientCount == 1) {
                this.setHeavy(true);
            }
        }
        int n2 = this.fFloatingFrames.size();
        this.fFloatingFrames.add(dTFloatingFrame);
        this.setLocation(dTFloatingFrame, dTLocation);
        dTClient.locationChanged();
        DTClient dTClient2 = this.getTopMost();
        boolean bl = dTClient2 == null || dTClient.isSelected() || !dTClient2.isSelected();
        int n3 = n = bl ? 0 : n2;
        if (this.fIsHeavy) {
            this.fHeavyContainer.add(dTFloatingFrame.getFloatingComponent(), n);
        } else {
            this.fLightContainer.add(dTFloatingFrame.getFloatingComponent(), n);
        }
        this.fTabs.addTabForDocument(dTClient);
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        boolean bl = dTClient.isSelected();
        DTFloatingFrame dTFloatingFrame = this.findFloatingFrame(dTClient);
        if (this.fIsHeavy) {
            this.fHeavyContainer.remove(dTFloatingFrame.getFloatingComponent());
        } else {
            this.fLightContainer.remove(dTFloatingFrame.getFloatingComponent());
        }
        dTFloatingFrame.dispose();
        this.fFloatingFrames.remove(dTFloatingFrame);
        if (dTFloatingFrame.needsHeavyParent()) {
            --this.fHeavyClientCount;
            if (this.fHeavyClientCount == 0) {
                this.setHeavy(false);
            }
        }
        if (bl && dTClient.isClosing()) {
            this.selectTopMost();
        }
        this.fTabs.removeTabForDocument(dTClient);
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        List<DTClient> list = this.fTabs.getDocuments();
        if (bl || list.size() < 2) {
            DTClient dTClient = this.getTopMost();
            return dTSelectable == dTClient ? null : dTClient;
        }
        int n = list.indexOf(dTSelectable);
        if (n < list.size() - 1) {
            return list.get(n + 1);
        }
        return null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        List<DTClient> list = this.fTabs.getDocuments();
        if (bl || list.size() < 2) {
            DTClient dTClient = this.getTopMost();
            return dTSelectable == dTClient ? null : dTClient;
        }
        int n = list.indexOf(dTSelectable);
        if (n > 0) {
            return list.get(n - 1);
        }
        return null;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        DTFloatingFrame dTFloatingFrame = this.findFloatingFrame(dTClient);
        if (dTFloatingFrame != null) {
            Serializable serializable;
            Component component = dTFloatingFrame.getFloatingComponent();
            if (this.fIsHeavy) {
                this.fHeavyContainer.setComponentZOrder(component, 0);
            } else if (scope != DTContainer.Scope.GROUP) {
                this.fLightContainer.moveToFront(component);
            } else {
                int n = this.fLightContainer.getPosition(component);
                for (int i = 0; i < n; ++i) {
                    serializable = this.fLightContainer.getComponent(i);
                    DTClient dTClient2 = DTFloatingFrame.clientInFloatingComponent(serializable);
                    if (dTClient2.getGroup() != dTClient.getGroup()) continue;
                    this.fLightContainer.setPosition(component, i);
                    break;
                }
            }
            if (!component.isVisible()) {
                component.setVisible(true);
                dTClient.getLastFloatingInLocation().setMinimized(false);
            }
            DTFloatingLocation dTFloatingLocation = dTClient.getLastFloatingInLocation();
            DTFloatingLocation dTFloatingLocation2 = new DTFloatingLocation(dTFloatingLocation);
            serializable = this.getSize();
            if (((Dimension)serializable).width > 0 && ((Dimension)serializable).height > 0) {
                dTFloatingLocation.ensureVisible((Dimension)serializable);
                if (!dTFloatingLocation.equals(dTFloatingLocation2)) {
                    component.setBounds(dTFloatingLocation.getFrameX(), dTFloatingLocation.getFrameY(), dTFloatingLocation.getFrameWidth(), dTFloatingLocation.getFrameHeight());
                }
            }
        }
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return true;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
        new DTKeyControlledMover().activate(dTOccupant);
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        DTFloatingFrame dTFloatingFrame = this.findFloatingFrame(dTClient);
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        return rectangle.intersects(dTFloatingFrame.getFloatingComponent().getBounds());
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
        new DTKeyControlledResizer().activate(dTOccupant, (Container)((Object)this));
    }

    @Override
    public boolean isEmpty() {
        return this.fTabs.getDocuments().isEmpty();
    }

    @Override
    public List<DTClient> getOrderedDocuments() {
        return this.fTabs.getDocuments();
    }

    @Override
    public DTClient getFrontDocument() {
        return this.getTopMost();
    }

    @Override
    public void addAllDocuments(List<DTClient> list, DTClient dTClient) {
        if (list.size() > 0) {
            ArrayList<DTClient> arrayList = new ArrayList<DTClient>(list);
            Collections.sort(arrayList, new DTSelectionManager.OrderComparator());
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                DTClient dTClient2 = (DTClient)arrayList.get(i);
                this.add(dTClient2, dTClient2.getLastFloatingInLocation());
            }
        }
        this.fTabs.removeAllTabs();
        for (DTClient dTClient3 : list) {
            this.fTabs.addTabForDocument(dTClient3);
        }
    }

    @Override
    public List<DTClient> removeAllDocuments() {
        if (this.fIsHeavy) {
            this.fHeavyContainer.removeAll();
        } else {
            this.fLightContainer.removeAll();
        }
        Object object = this.fFloatingFrames.iterator();
        while (object.hasNext()) {
            DTFloatingFrame dTFloatingFrame = object.next();
            dTFloatingFrame.dispose();
            object.remove();
        }
        object = this.fTabs.getDocuments();
        this.fTabs.removeAllTabs();
        return object;
    }

    @Override
    public Rectangle getTabsBounds() {
        return this.fTabs.getBounds();
    }

    @Override
    public Insets getTabsInsets() {
        Insets insets = this.getInsets();
        switch (this.fTabs.getEdge()) {
            case 1: {
                insets.top += this.fTabs.getHeight();
                break;
            }
            case 5: {
                insets.bottom += this.fTabs.getHeight();
                break;
            }
            case 3: {
                insets.right += this.fTabs.getWidth();
                break;
            }
            case 7: {
                insets.left += this.fTabs.getWidth();
            }
        }
        return insets;
    }

    @Override
    public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.fDropTarget == null) {
            this.fDropTarget = new DropTarget();
            this.fDropTarget.setComponent(this.fIsHeavy ? this.fHeavyContainer : this.fLightContainer);
        }
        this.fDropTarget.addDropTargetListener(dropTargetListener);
    }

    @Override
    public void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTarget != null) {
            this.fDropTarget.removeDropTargetListener(dropTargetListener);
        }
    }

    DTClient getTopMost() {
        Panel panel = this.fIsHeavy ? this.fHeavyContainer : this.fLightContainer;
        int n = panel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = panel.getComponent(i);
            if (!component.isVisible()) continue;
            return DTFloatingFrame.clientInFloatingComponent(component);
        }
        return null;
    }

    void selectTopMost() {
        DTClient dTClient = this.getTopMost();
        if (dTClient != null) {
            dTClient.setSelected(true);
        } else {
            this.requestFocusInWindow();
        }
    }

    void minimizeAll() {
        this.fIsMinimizingAll = true;
        for (DTFloatingFrame dTFloatingFrame : this.fFloatingFrames) {
            DTClient dTClient = dTFloatingFrame.getClient();
            DTFloatingLocation dTFloatingLocation = dTClient.getLastFloatingInLocation();
            dTFloatingLocation.setMinimized(true);
            this.setLocation(dTClient, (DTLocation)dTFloatingLocation);
        }
        this.fIsMinimizingAll = false;
    }

    public boolean isInFront(DTClient dTClient) {
        DTFloatingFrame dTFloatingFrame = this.findFloatingFrame(dTClient);
        Component component = dTFloatingFrame.getFloatingComponent();
        if (component == null || !component.isVisible()) {
            return false;
        }
        Panel panel = this.fIsHeavy ? this.fHeavyContainer : this.fLightContainer;
        int n = panel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component2 = panel.getComponent(i);
            if (component2 == component) {
                return true;
            }
            if (!component2.isVisible()) continue;
            return false;
        }
        return false;
    }

    DTClient getClientInFront() {
        Panel panel = this.fIsHeavy ? this.fHeavyContainer : this.fLightContainer;
        int n = panel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = panel.getComponent(i);
            if (!component.isVisible()) continue;
            return DTFloatingFrame.clientInFloatingComponent(component);
        }
        return null;
    }

    void setLocation(DTClient dTClient, DTLocation dTLocation) {
        DTFloatingFrame dTFloatingFrame = this.findFloatingFrame(dTClient);
        this.setLocation(dTFloatingFrame, dTLocation);
    }

    protected void setLocation(DTFloatingFrame dTFloatingFrame, DTLocation dTLocation) {
        boolean bl;
        DTFloatingLocation dTFloatingLocation;
        DTClient dTClient = dTFloatingFrame.getClient();
        DTFloatingLocation dTFloatingLocation2 = dTFloatingLocation = dTLocation instanceof DTFloatingLocation ? (DTFloatingLocation)dTLocation : null;
        if (dTFloatingLocation != null && dTFloatingLocation.isMaximized()) {
            dTFloatingLocation.setMaximized(false);
            dTFloatingLocation.setFrameBounds(dTFloatingLocation.getRestoreBounds());
        }
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            dimension.width >>= 1;
            dimension.height >>= 1;
        }
        boolean bl2 = dTClient.maintainAspectRatio() && dTClient.getLastUndockedLocation() != null;
        boolean bl3 = dTClient.getLastLocation() != null && !dTClient.getLastLocation().isDocked() && dTFloatingLocation == dTClient.getLastDockedLocation();
        boolean bl4 = dTFloatingLocation != null && dTFloatingLocation.isSizeInitialized();
        boolean bl5 = bl = dTFloatingLocation != null && (dTFloatingLocation.isSizeInitialized() || dTFloatingLocation.hasNormalizedSize());
        if (!bl4) {
            Dimension dimension2 = new Dimension(3 * dimension.width >> 2, 3 * dimension.height >> 2);
            if (dimension2.width < 100) {
                dimension2.width = 100;
            }
            if (dimension2.height < 100) {
                dimension2.height = 100;
            }
            if (dTFloatingLocation == null) {
                dTFloatingLocation = new DTFloatingLocation(dimension2.width, dimension2.height, false);
            } else if (!dTFloatingLocation.isSizeInitialized()) {
                if (dTFloatingLocation.hasNormalizedSize()) {
                    dTFloatingLocation.initializeSize(dimension);
                } else {
                    dTFloatingLocation.setFrameSize(dimension2);
                }
            }
        }
        if (!dTFloatingLocation.isLocationInitialized()) {
            if (dTFloatingLocation.hasNormalizedLocation()) {
                dTFloatingLocation.initializeLocation(dimension);
            } else {
                dTFloatingLocation.setFrameLocation(this.getCascadeLocation(dimension, dTFloatingLocation.getFrameSize()));
            }
        }
        if (bl2 && (bl3 || !bl)) {
            int n;
            int n2 = dTFloatingLocation.getFrameWidth();
            int n3 = dTFloatingLocation.getFrameHeight();
            int n4 = dTClient.getLastUndockedLocation().getFrameWidth();
            int n5 = dTClient.getLastUndockedLocation().getFrameHeight();
            int n6 = n2 * n5;
            if (n6 > (n = n3 * n4) + n3 + n4 || n > n6 + n2 + n5) {
                int n7 = (int)Math.sqrt(n2 * n3);
                int n8 = (int)Math.sqrt(n4 * n5);
                n2 = n7 * n4 / n8;
                n3 = n7 * n5 / n8;
                int n9 = dimension.width - dTFloatingLocation.getFrameX() - 5;
                int n10 = dimension.height - dTFloatingLocation.getFrameY() - 5;
                if (n2 > n9) {
                    n3 = n3 * n9 / n2;
                    n2 = n9;
                }
                if (n3 > n10) {
                    n2 = n2 * n10 / n3;
                    n3 = n10;
                }
            }
            dTFloatingLocation.setFrameSize(n2, n3);
        }
        dTFloatingLocation.ensureVisible(dimension);
        dTFloatingLocation.setContainer(this.fDocumentContainer);
        dTFloatingLocation.setFrame(this.fDocumentContainer.getFrame());
        dTFloatingFrame.getClient().setLocation(dTFloatingLocation);
        dTFloatingFrame.getFloatingComponent().setBounds(dTFloatingLocation.getFrameBounds());
        dTFloatingFrame.getFloatingComponent().setVisible(!dTFloatingLocation.isMinimized());
        if (dTFloatingLocation.isMinimized() && dTFloatingFrame.getClient().isSelected()) {
            dTFloatingFrame.getClient().setSelected(false);
            if (!this.fIsMinimizingAll) {
                this.selectTopMost();
            }
        }
    }

    private DTFloatingFrame findFloatingFrame(DTClient dTClient) {
        int n = this.fFloatingFrames.size();
        for (int i = 0; i < n; ++i) {
            DTFloatingFrame dTFloatingFrame = this.fFloatingFrames.get(i);
            if (dTFloatingFrame.getClient() != dTClient) continue;
            return dTFloatingFrame;
        }
        return null;
    }

    void resetCascade() {
        this.fNextUpperLeft.setLocation(INITIAL_UPPER_LEFT);
    }

    protected Point getCascadeLocation(Dimension dimension, Dimension dimension2) {
        if (this.fNextUpperLeft.x + dimension2.width > dimension.width || this.fNextUpperLeft.y + dimension2.height > dimension.height) {
            this.fNextUpperLeft.setLocation(INITIAL_UPPER_LEFT);
        }
        Point point = new Point(this.fNextUpperLeft);
        this.fNextUpperLeft.translate(20, 20);
        return point;
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        Dimension dimension = this.fTabs.getEdge() == -1 ? new Dimension(0, 0) : this.fTabs.getPreferredSize();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height);
        switch (this.fTabs.getEdge()) {
            case 1: {
                rectangle2.width = rectangle.width;
                rectangle.y += rectangle2.height;
                rectangle.height -= rectangle2.height;
                break;
            }
            case 5: {
                rectangle2.height = dimension.height;
                rectangle2.width = rectangle.width;
                rectangle2.y = n2 - insets.bottom - dimension.height;
                rectangle.height -= dimension.height;
                break;
            }
            case 3: {
                rectangle2.height = rectangle.height;
                rectangle2.x = n - insets.right - dimension.width;
                rectangle.width -= dimension.width;
                break;
            }
            case 7: {
                rectangle2.height = rectangle.height;
                rectangle.x += dimension.width;
                rectangle.width -= dimension.width;
            }
        }
        if (this.fTabs.isVisible()) {
            this.fTabs.setBounds(rectangle2);
        }
        if (this.fIsHeavy) {
            this.fHeavyContainer.setBounds(rectangle);
        } else {
            this.fLightContainer.setBounds(rectangle);
        }
    }

    @Override
    public DTLocation getDropLocation(Object object, int n, int n2, DTLocation dTLocation) {
        int n3;
        int n4;
        DTClient dTClient = (DTClient)object;
        DTFloatingLocation dTFloatingLocation = dTClient.getLastFloatingInLocation();
        if (dTFloatingLocation != null) {
            n4 = dTFloatingLocation.getFrameWidth();
            n3 = dTFloatingLocation.getFrameHeight();
        } else {
            n4 = this.getWidth() / 3;
            n3 = this.getHeight() / 3;
        }
        dTFloatingLocation = dTLocation instanceof DTFloatingLocation && !dTLocation.isExternal() ? (DTFloatingLocation)dTLocation : new DTFloatingLocation(false);
        dTFloatingLocation.setFrameBounds(n - (n4 >> 1), n2 + 10, n4, n3);
        return dTFloatingLocation;
    }

    @Override
    public String getDropHint(Object object, DTLocation dTLocation) {
        return DTDragUtilities.getToOutlineHint(object);
    }

    @Override
    public void drawDropOutline(DTLocation dTLocation) {
        DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)dTLocation;
        DTDragUtilities.getDropOutlinePainter().show((Component)((Object)this), dTFloatingLocation.getFrameX(), dTFloatingLocation.getFrameY(), dTFloatingLocation.getFrameWidth(), dTFloatingLocation.getFrameHeight(), DTDropOutlinePainter.OutlineType.RECTANGLE);
    }

    @Override
    public void drop(Object object, DTLocation dTLocation) {
        DTClient dTClient = (DTClient)object;
        this.setLocation(dTClient, dTLocation);
        dTClient.setSelected(true);
    }

    public DropTarget getDropTarget() {
        return this.fDropTarget;
    }

    class ZOrderComparator
    implements Comparator<DTFloatingFrame> {
        ZOrderComparator() {
        }

        @Override
        public int compare(DTFloatingFrame dTFloatingFrame, DTFloatingFrame dTFloatingFrame2) {
            if (DTFloatingPane.this.fLightContainer == null) {
                return 0;
            }
            return DTFloatingPane.this.fLightContainer.getPosition(dTFloatingFrame2.getFloatingComponent()) - DTFloatingPane.this.fLightContainer.getPosition(dTFloatingFrame.getFloatingComponent());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ZOrderComparator;
        }
    }

    class LocalMouseListener
    extends MouseAdapter {
        LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DTClient dTClient = DTFloatingPane.this.getClientInFront();
            if (dTClient != null) {
                dTClient.getInternalFrame().setSelected(false);
            }
            DTFloatingPane.this.requestFocus();
            DTFloatingPane.this.fDocumentContainer.setSelected(true, false);
            if (mouseEvent.isPopupTrigger()) {
                this.showMenu(mouseEvent);
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showMenu(mouseEvent);
                mouseEvent.consume();
            }
        }

        void showMenu(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.setCleanupUponClose(true);
            mJPopupMenu.add(DTFloatingPane.this.fDocumentContainer.getCascadeAction());
            mJPopupMenu.add(DTFloatingPane.this.fDocumentContainer.getMinimizeAllAction());
            mJPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

