/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.jidesoft.popup.JidePopup;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.ClientCollection;
import com.mathworks.desktop.mnemonics.MnemonicsManagers;
import com.mathworks.desktop.mnemonics.MnemonicsProvider;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MComponentInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJCornerGrip;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.accessories.QuickAccessToolBar;
import com.mathworks.toolstrip.accessories.QuickAccessWrapper;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.accessories.ToolstripContextMenu;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.toolstrip.factory.QuickAccessConfiguration;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.util.AllPredicate;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTDesktopMenu;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenuBar;
import com.mathworks.widgets.desk.DTMnemonicsProvider;
import com.mathworks.widgets.desk.DTRootPane;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTToolBarContainer;
import com.mathworks.widgets.desk.DTToolBarLocation;
import com.mathworks.widgets.desk.DTToolstripFactory;
import com.mathworks.widgets.desk.DTWindowMenu;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.desk.MacScreenMenuProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DTFrame
extends MJFrame
implements DTSelectable,
PropertyChangeListener,
Externalizable {
    protected Desktop fDesktop;
    protected DTWindowMenu fWindowMenu;
    protected DTDesktopMenu fDesktopMenu;
    protected MouseListener fMenuBarMouseListener;
    protected MJStatusBar fStatusBar;
    protected MJCornerGrip fCornerGrip;
    protected MJPanel fSouthPanel;
    protected DTToolBarContainer fToolBarContainer;
    protected MJButton fActionsButton;
    protected Toolstrip fToolstrip;
    protected QuickAccessToolBar fQuickAccessBar;
    protected DTToolBarLocation fQuickAccessLocation;
    protected JidePopup fQuickAccessPopup;
    protected QuickAccessConfiguration.ChangeListener fQuickAccessConfigListener;
    protected EnumMap<DTToolBarLocation.Region, QuickAccessMoveAction> fQuickAccessMoveActionMap = new EnumMap(DTToolBarLocation.Region.class);
    protected ContextTargetingManager fTargetingManager = new ContextTargetingManager();
    private MacScreenMenuProxy fMacScreenMenuProxy;
    protected boolean fIsStatusBarVisible = true;
    protected MJAbstractAction fToggleStatusBarAction;
    protected boolean fCreatedDuringLayoutRestore;
    protected int fPendingState = 0;
    protected boolean fPendingIsRestore;
    protected boolean fOverrideFocusable;
    protected boolean fIsClosing;
    private DeferredMenuBarUpdate fPendingMenuBarUpdate;
    private DTMnemonicsProvider fMnemonicsProvider;
    private boolean qeMenuMergeComplete;
    private static boolean sScreenMenuUpdateDelayEnabled = true;
    protected static ImageIcon sReducedMatlabIcon = null;
    protected static final int CORNER_THRESHOLD = 16;
    protected static final int CASCADE_OFFSET = 20;
    protected static final Point INITIAL_UPPER_LEFT = new Point(5, PlatformInfo.isLinux() ? 35 : 5);
    static Point sUpperLeft = new Point(1000000, 1000000);
    protected static final int MIN_DOCUMENT_FRAME_WIDTH = 1100;
    public static final EnumSet<DTToolBarLocation.Region> SUPPORTED_QUICK_ACCESS_REGIONS = EnumSet.of(DTToolBarLocation.Region.RIGHT_OF_TABS, DTToolBarLocation.Region.BELOW_TOOLSTRIP);

    public DTFrame(Desktop desktop) {
        this(desktop, null);
    }

    public DTFrame(Desktop desktop, String string) {
        super(string);
        this.setName("DesktopFrame");
        this.fDesktop = desktop;
        if (this.fDesktop != null) {
            this.fDesktop.addFrame(this);
            this.fCreatedDuringLayoutRestore = this.fDesktop.isRestoringLayout();
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
                if (DTFrame.this.fCornerGrip != null) {
                    DTFrame.this.fCornerGrip.setVisible(!DTFrame.this.isMaximized());
                }
            }
        });
        LocationTracker locationTracker = new LocationTracker();
        this.addWindowListener(locationTracker);
        this.addWindowStateListener(locationTracker);
        this.addComponentListener(locationTracker);
    }

    public void setVisible(boolean bl) {
        if (PlatformInfo.isMacintosh() && this.fMacScreenMenuProxy == null && this.fDesktop != null) {
            this.fMacScreenMenuProxy = this.fDesktop.createMacScreenMenuProxy(this);
        }
        super.setVisible(bl);
    }

    public void qeClearMenuMergeFlag() {
        this.qeMenuMergeComplete = false;
    }

    public boolean qeIsMenuMergeComplete() {
        return this.qeMenuMergeComplete;
    }

    protected static Point getCascadeLocation(Dimension dimension) {
        Rectangle rectangle = WindowUtils.getScreenBounds();
        if (DTFrame.sUpperLeft.x + dimension.width > rectangle.x + rectangle.width || DTFrame.sUpperLeft.y + dimension.height > rectangle.y + rectangle.height) {
            sUpperLeft.setLocation(DTFrame.INITIAL_UPPER_LEFT.x + rectangle.x, DTFrame.INITIAL_UPPER_LEFT.y + rectangle.y);
        }
        Point point = new Point(sUpperLeft);
        sUpperLeft.translate(20, 20);
        return point;
    }

    protected static Dimension getDefaultDocumentFrameSize(Dimension dimension) {
        Dimension dimension2 = new Dimension(2 * dimension.width / 3, 2 * dimension.height / 3);
        int n = Math.min(1100, dimension.width);
        if (dimension2.width < n) {
            dimension2.width = n;
        }
        return dimension2;
    }

    public void addNotify() {
        this.fOverrideFocusable = true;
        super.addNotify();
        this.fOverrideFocusable = false;
        if (this.usingToolstrip() && !PlatformInfo.isMacintosh()) {
            if (this.fMnemonicsProvider == null) {
                this.fMnemonicsProvider = this.fDesktop.createMnemonicsProvider(this);
            }
            MnemonicsManagers.get().register((MnemonicsProvider)this.fMnemonicsProvider, (Window)((Object)this));
        }
    }

    public void removeNotify() {
        if (this.fMnemonicsProvider != null) {
            MnemonicsManagers.get().unRegister((MnemonicsProvider)this.fMnemonicsProvider, (Window)((Object)this));
            this.fMnemonicsProvider.dispose();
            this.fMnemonicsProvider = null;
        }
        super.removeNotify();
    }

    public boolean getFocusableWindowState() {
        return this.fOverrideFocusable || super.getFocusableWindowState();
    }

    void addRootBinding(KeyStroke keyStroke, Action action) {
        this.getRootInputMap().put(keyStroke, (Object)action);
        ActionMap actionMap = this.rootPane.getActionMap();
        if (actionMap != null) {
            actionMap.put(action, action);
        }
    }

    void removeRootBinding(KeyStroke keyStroke, Action action) {
        ActionMap actionMap;
        InputMap inputMap = this.rootPane.getInputMap(2);
        if (inputMap != null) {
            inputMap.remove(keyStroke);
        }
        if ((actionMap = this.rootPane.getActionMap()) != null) {
            actionMap.remove(action);
        }
    }

    public void addBindings(KeyBindingManager keyBindingManager, TSToolSet ... tSToolSetArray) {
        TSFactory.populate((ExtendedInputMap)this.getRootInputMap(), (ActionMap)this.rootPane.getActionMap(), (KeyBindingManager)keyBindingManager, (TSToolSet[])tSToolSetArray);
    }

    protected ExtendedInputMap getRootInputMap() {
        InputMap inputMap = this.rootPane.getInputMap(2);
        if (inputMap instanceof ExtendedInputMap) {
            return (ExtendedInputMap)inputMap;
        }
        MComponentInputMap mComponentInputMap = new MComponentInputMap((JComponent)this.rootPane);
        if (inputMap != null) {
            mComponentInputMap.setParent(inputMap);
        }
        this.rootPane.setInputMap(2, (InputMap)mComponentInputMap);
        return mComponentInputMap;
    }

    protected boolean supportDesktopNavigationBindings() {
        return true;
    }

    public Desktop getDesktop() {
        return this.fDesktop;
    }

    public DTGroup getGroup() {
        return null;
    }

    public ContextTargetingManager getTargetingManager() {
        return this.fTargetingManager;
    }

    public MacScreenMenuProxy getMacScreenMenuProxy() {
        return this.fMacScreenMenuProxy;
    }

    public Toolstrip getToolstrip() {
        return this.fToolstrip;
    }

    protected boolean usingToolstrip() {
        return this.fToolstrip != null;
    }

    public QuickAccessToolBar getQuickAccessBar() {
        return this.fQuickAccessBar;
    }

    public boolean isMainFrame() {
        return false;
    }

    protected boolean isClosing() {
        return this.fIsClosing;
    }

    public static DTFrame getFrame(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        DTFrame dTFrame = null;
        if (object instanceof Component) {
            dTFrame = DTFrame.getAncestorFrame((Component)mouseEvent.getSource());
        }
        return dTFrame;
    }

    static DTFrame getAncestorFrame(Component component) {
        Window window = SwingUtilities.windowForComponent(component);
        if (window instanceof DTFrame) {
            return (DTFrame)((Object)window);
        }
        if (window != null) {
            window = window.getOwner();
        }
        if (window instanceof DTFrame) {
            return (DTFrame)((Object)window);
        }
        return null;
    }

    public DTWindowMenu getWindowMenu() {
        if (this.fWindowMenu == null) {
            this.fWindowMenu = new DTWindowMenu(this.fDesktop, this);
        }
        return this.fWindowMenu;
    }

    public DTDesktopMenu getDesktopMenu() {
        return this.fDesktopMenu;
    }

    protected DTMenuBar createMenuBar(DTClient dTClient, DTGroup dTGroup) {
        if (this.fWindowMenu != null && this.fWindowMenu.hasBeenMerged()) {
            this.fWindowMenu.dispose();
            this.fWindowMenu = null;
        }
        return this.fDesktop.createMenuBar(this, dTClient, dTGroup);
    }

    public void setIcon(Icon icon) {
        if (!PlatformInfo.isMacintosh()) {
            if (icon != null && icon instanceof ImageIcon) {
                this.setIconImage(((ImageIcon)icon).getImage());
            } else {
                this.setIconImage(DTFrame.getMatlabIcon().getImage());
            }
        }
    }

    public void setSmallIcon(Icon icon) {
        if (!PlatformInfo.isMacintosh()) {
            if (icon != null && icon instanceof ImageIcon) {
                this.setSmallIconImage(((ImageIcon)icon).getImage());
            } else {
                this.setSmallIconImage(DTFrame.getSmallMatlabIcon().getImage());
            }
        }
    }

    public void setMenuBarNeighbor(JComponent jComponent) {
        if (this.rootPane instanceof DTRootPane) {
            ((DTRootPane)this.rootPane).setMenuBarNeighbor(jComponent, 3);
        }
    }

    public JComponent getMenuBarNeighbor() {
        if (this.rootPane instanceof DTRootPane) {
            return ((DTRootPane)this.rootPane).getMenuBarNeighbor();
        }
        return null;
    }

    protected void updateMenuBar() {
    }

    public static void setScreenMenuUpdateDelayEnabled(boolean bl) {
        sScreenMenuUpdateDelayEnabled = bl;
    }

    public static boolean isScreenMenuUpdateDelayEnabled() {
        return sScreenMenuUpdateDelayEnabled;
    }

    public final void initiateMenuBarUpdate() {
        if (this.usingToolstrip()) {
            return;
        }
        this.updateMenuBar();
        this.qeMenuMergeComplete = true;
    }

    public boolean isParticipantInDesktopSelection() {
        return true;
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getJMenuBar();
        if (jMenuBar2 != null) {
            this.removeListener(jMenuBar2);
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null && menuElementArray.length > 0 && menuElementArray[0] == jMenuBar2) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
        this.fOverrideFocusable = true;
        super.setJMenuBar(jMenuBar);
        this.fOverrideFocusable = false;
        if (jMenuBar != null) {
            this.addListener(jMenuBar);
        }
    }

    private void addListener(JMenuBar jMenuBar) {
        if (this.fMenuBarMouseListener == null) {
            this.fMenuBarMouseListener = new MenuBarMouseListener();
        }
        jMenuBar.addMouseListener(this.fMenuBarMouseListener);
        int n = jMenuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (jMenu == null) continue;
            jMenu.addMouseListener(this.fMenuBarMouseListener);
        }
    }

    private void removeListener(JMenuBar jMenuBar) {
        if (this.fMenuBarMouseListener != null) {
            jMenuBar.removeMouseListener(this.fMenuBarMouseListener);
            int n = jMenuBar.getMenuCount();
            for (int i = 0; i < n; ++i) {
                JMenu jMenu = jMenuBar.getMenu(i);
                if (jMenu == null) continue;
                jMenu.removeMouseListener(this.fMenuBarMouseListener);
            }
        }
    }

    protected boolean isGlobalTab(String string) {
        ToolstripTab toolstripTab = (ToolstripTab)this.fToolstrip.getModel().get(string);
        return toolstripTab != null && (Boolean)toolstripTab.getAttribute((Attribute)DTToolstripFactory.IS_GLOBAL_TAB) != false;
    }

    protected void updateToolstripTabs(ToolstripTab[] clientCollection) {
        if (this.fToolstrip != null) {
            int n;
            ClientCollection toolstripTab22;
            for (ClientCollection toolstripTab22 : clientCollection) {
                toolstripTab22.setAttribute((Attribute)ToolstripTab.ISLIGHTER, (Object)true);
            }
            ClientCollection clientCollection2 = this.fToolstrip.getModel();
            List<ToolstripTab> list = Arrays.asList(clientCollection);
            for (n = clientCollection2.size() - 1; n >= 0 && !((Boolean)(toolstripTab22 = (ToolstripTab)clientCollection2.get(n)).getAttribute((Attribute)DTToolstripFactory.IS_GLOBAL_TAB)).booleanValue(); --n) {
                if (list.contains(toolstripTab22)) continue;
                clientCollection2.remove(n);
            }
            int n2 = n + 1;
            for (ToolstripTab toolstripTab3 : list) {
                int n3 = clientCollection2.indexOf((Client)toolstripTab3);
                if (n3 == -1) {
                    clientCollection2.add(n2++, (Client)toolstripTab3);
                    continue;
                }
                n2 = n3 + 1;
            }
        }
    }

    public void setExtendedState(int n) {
        if (!this.isDisplayable()) {
            if (n != 0 && this.fPendingState == 0) {
                this.fPendingIsRestore = this.fDesktop.isRestoringLayout();
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        if (DTFrame.this.fPendingState != 0) {
                            DTFrame.super.setExtendedState(DTFrame.this.fPendingState);
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DTFrame.this.fPendingState = 0;
                                }
                            });
                            if (DTFrame.this.fPendingIsRestore && !DTFrame.this.isMainFrame() && DTFrame.this.fDesktop.hasMainFrame()) {
                                DTFrame.this.fDesktop.getMainFrame().toFront();
                            }
                        }
                        DTFrame.this.removeWindowListener(this);
                    }
                });
            }
            this.fPendingState = n;
            if (n == 1 && PlatformInfo.isWindows()) {
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowDeiconified(WindowEvent windowEvent) {
                        DTFrame.this.invalidate();
                        DTFrame.this.validate();
                        DTFrame.this.repaint();
                        DTFrame.this.removeWindowListener(this);
                    }
                });
            }
        }
        super.setExtendedState(n);
    }

    boolean isMaximizePending() {
        return this.fPendingState == 6;
    }

    public void setStatusBar(MJStatusBar mJStatusBar) {
        if (mJStatusBar != this.fStatusBar) {
            String string = null;
            if (this.fStatusBar != null) {
                string = this.fStatusBar.getText();
                this.fSouthPanel.remove((Component)this.fStatusBar);
            } else if (this.fSouthPanel == null) {
                this.fSouthPanel = new MJPanel((LayoutManager)new BorderLayout());
                if (PlatformInfo.isWindows() && !PlatformInfo.isWindowsXPAppearance()) {
                    this.fSouthPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
                }
                if (!PlatformInfo.isMacintosh()) {
                    this.fCornerGrip = new MJCornerGrip();
                    this.fSouthPanel.add((Component)this.fCornerGrip, (Object)"East");
                } else {
                    this.fSouthPanel.add((Component)new MJPanel(){

                        public Dimension getPreferredSize() {
                            return new Dimension(16, 0);
                        }

                        public Dimension getMinimumSize() {
                            return new Dimension(16, 0);
                        }
                    }, (Object)"East");
                }
                if (this.fIsStatusBarVisible) {
                    this.addSouthPanel();
                }
            }
            this.fStatusBar = mJStatusBar;
            if (mJStatusBar != null) {
                mJStatusBar.setText(string);
                this.fSouthPanel.add((Component)this.fStatusBar, (Object)"Center");
            } else if (this.fSouthPanel != null) {
                this.removeSouthPanel();
                this.fSouthPanel = null;
            }
        }
    }

    protected void addSouthPanel() {
        this.getContentPane().add((Component)this.fSouthPanel, "South");
    }

    protected void removeSouthPanel() {
        this.getContentPane().remove((Component)this.fSouthPanel);
    }

    public MJStatusBar getStatusBar() {
        return this.fStatusBar;
    }

    public boolean hasStatusBar() {
        return this.fStatusBar != null;
    }

    public void setStatusText(String string) {
        this.setStatusText(string, false);
    }

    public void setStatusText(String string, boolean bl) {
        if (this.fStatusBar != null) {
            this.fStatusBar.setText(string);
            if (bl) {
                this.fStatusBar.paintImmediately(0, 0, this.fStatusBar.getWidth(), this.fStatusBar.getHeight());
            }
        }
    }

    public void setStatusBarVisible(boolean bl) {
        if (bl != this.fIsStatusBarVisible) {
            this.fIsStatusBarVisible = bl;
            if (this.fToggleStatusBarAction != null) {
                this.fToggleStatusBarAction.setSelected(bl);
            }
            if (this.hasStatusBar()) {
                if (bl) {
                    this.addSouthPanel();
                } else {
                    this.removeSouthPanel();
                }
            }
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public boolean isStatusBarVisible() {
        return this.fIsStatusBarVisible;
    }

    public Action getToggleStatusBarAction() {
        if (this.fToggleStatusBarAction == null) {
            this.fToggleStatusBarAction = new ToggleStatusBarAction();
        }
        return this.fToggleStatusBarAction;
    }

    protected void addToolstrip(Toolstrip toolstrip, QuickAccessToolBar quickAccessToolBar) {
        this.addQuickAccessBar(quickAccessToolBar);
        Box box = Box.createVerticalBox();
        box.add(toolstrip.getComponent());
        box.add((Component)((Object)this.fToolBarContainer));
        this.getContentPane().add((Component)box, "North");
        ToolstripContextMenu.install((Toolstrip)toolstrip);
    }

    protected void addQuickAccessBar(QuickAccessToolBar quickAccessToolBar) {
        if (this.getToolBarContainer() == null) {
            this.fToolBarContainer = new DTToolBarContainer();
            this.getContentPane().add((Component)((Object)this.fToolBarContainer), "North");
        }
        this.getToolBarContainer().setOfferToggles(false);
        if (quickAccessToolBar != null && quickAccessToolBar.getConfiguration() != null) {
            this.fQuickAccessConfigListener = new QuickAccessConfiguration.ChangeListener(){

                public void configurationChanged(QuickAccessConfiguration.ChangeEvent changeEvent) {
                    if (changeEvent.getType() == QuickAccessConfiguration.ChangeType.LABEL_VISIBILITY && DTFrame.this.fQuickAccessPopup != null) {
                        DTFrame.this.fQuickAccessPopup.packPopup();
                    }
                }
            };
            quickAccessToolBar.getConfiguration().addListener(this.fQuickAccessConfigListener);
            quickAccessToolBar.setTargetingManager(this.getTargetingManager());
            this.applyQuickAccessFilters(quickAccessToolBar);
            this.fQuickAccessBar = quickAccessToolBar;
            DTToolBarLocation dTToolBarLocation = null;
            if (this.getGroup() != null) {
                dTToolBarLocation = this.getGroup().getQuickAccessLocation();
            }
            if (dTToolBarLocation == null && this.fDesktop.hasMainFrame()) {
                dTToolBarLocation = this.fDesktop.getMainFrame().getQuickAccessLocation();
            }
            if (dTToolBarLocation == null) {
                dTToolBarLocation = new DTToolBarLocation(DTToolBarLocation.Region.RIGHT_OF_TABS);
            }
            this.setQuickAccessLocation(dTToolBarLocation);
            this.fQuickAccessBar.getComponent().putClientProperty((Object)"toolstrip-context-menu-contributor", (Object)new TSContextMenuContributor(){

                public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
                    MJMenu mJMenu = new MJMenu(DTFrame.this.fDesktop.getString("menu.MoveQuickAccessToolbar"));
                    for (DTToolBarLocation.Region region : SUPPORTED_QUICK_ACCESS_REGIONS) {
                        mJMenu.add((JMenuItem)new MJCheckBoxMenuItem(DTFrame.this.getQuickAccessMoveAction(region)));
                    }
                    jPopupMenu.add((JMenuItem)mJMenu);
                    MJMenuItem mJMenuItem = new MJMenuItem(DTFrame.this.fDesktop.getString("menuitem.Customize"));
                    mJMenuItem.addActionListener((ActionListener)new MJAbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DTFrame.this.fDesktop.showToolBarCustomizationPanel("QUICK_ACCESS_PANEL");
                        }
                    });
                    jPopupMenu.add((JMenuItem)mJMenuItem);
                }
            });
            this.fQuickAccessBar.getComponent().addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    this.refresh();
                }

                @Override
                public void componentRemoved(ContainerEvent containerEvent) {
                    this.refresh();
                }

                private void refresh() {
                    if (DTFrame.this.fQuickAccessPopup != null) {
                        DTFrame.this.fQuickAccessPopup.packPopup();
                    }
                }
            });
        }
    }

    protected void setToolstripCollapsed(boolean bl) {
        if (this.fToolstrip != null) {
            this.fToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)(bl ? Toolstrip.State.COLLAPSED : Toolstrip.State.EXPANDED));
        }
    }

    protected boolean isToolstripCollapsed() {
        return this.fToolstrip != null && this.fToolstrip.getAttribute((Attribute)Toolstrip.STATE) != Toolstrip.State.EXPANDED;
    }

    protected void setQuickAccessLocation(DTToolBarLocation dTToolBarLocation) {
        DTToolBarLocation dTToolBarLocation2;
        if (this.fQuickAccessBar == null) {
            return;
        }
        DTToolBarLocation dTToolBarLocation3 = dTToolBarLocation2 = dTToolBarLocation != null && dTToolBarLocation.getRegion() == DTToolBarLocation.Region.ON_TITLE_BAR ? new DTToolBarLocation(DTToolBarLocation.Region.RIGHT_OF_TABS) : dTToolBarLocation;
        if (this.fQuickAccessLocation != null && (dTToolBarLocation2 == null || this.fQuickAccessLocation.getRegion() != dTToolBarLocation2.getRegion())) {
            if (this.fQuickAccessLocation.getRegion() == DTToolBarLocation.Region.RIGHT_OF_TABS || this.fQuickAccessLocation.getRegion() == DTToolBarLocation.Region.LEFT_OF_TABS) {
                if (this.fToolstrip != null) {
                    this.fToolstrip.removeTabNeighbor((JComponent)this.fQuickAccessBar.getComponent().getParent());
                } else if (this.fQuickAccessLocation.getRegion() == DTToolBarLocation.Region.RIGHT_OF_TABS) {
                    this.getToolBarContainer().removeRightCorner((JComponent)this.fQuickAccessBar.getComponent());
                    this.getToolBarContainer().removeAllToolBars();
                } else {
                    this.getToolBarContainer().removeToolBar("quickaccesstoolbar", this.fDesktop.getString("label.QuickAccessToolbar"));
                }
            } else if (this.fQuickAccessLocation.getRegion() == DTToolBarLocation.Region.BELOW_TOOLSTRIP) {
                this.getToolBarContainer().removeToolBar("quickaccesstoolbar", this.fDesktop.getString("label.QuickAccessToolbar"));
            } else if ((this.fQuickAccessLocation.getRegion() == DTToolBarLocation.Region.ON_TITLE_BAR || this.fQuickAccessLocation.getRegion() == DTToolBarLocation.Region.FLOATING) && this.fQuickAccessPopup != null) {
                this.fQuickAccessPopup.hidePopupImmediately();
                this.fQuickAccessPopup = null;
            }
            this.fQuickAccessLocation = null;
        }
        if (dTToolBarLocation2 == null) {
            return;
        }
        if (this.fQuickAccessLocation == null) {
            this.fQuickAccessBar.setGrowthEnd(dTToolBarLocation2.getRegion() == DTToolBarLocation.Region.RIGHT_OF_TABS ? 2 : 4);
            if (dTToolBarLocation2.getRegion() == DTToolBarLocation.Region.RIGHT_OF_TABS) {
                if (this.fToolstrip != null) {
                    JComponent[] jComponentArray;
                    for (JComponent jComponent : jComponentArray = this.fToolstrip.getTabNeighbors(4)) {
                        this.fToolstrip.removeTabNeighbor(jComponent);
                    }
                    this.fToolstrip.addTabNeighbor((JComponent)new QuickAccessWrapper((JComponent)this.fQuickAccessBar.getComponent()), 4);
                    for (JComponent jComponent : jComponentArray) {
                        this.fToolstrip.addTabNeighbor(jComponent, 4);
                    }
                } else {
                    this.getToolBarContainer().addRightCorner((JComponent)this.fQuickAccessBar.getComponent(), 0);
                    MJToolBar mJToolBar = new MJToolBar();
                    mJToolBar.setFloatable(false);
                    this.getToolBarContainer().addToolBar((Component)mJToolBar, "");
                }
            } else if (dTToolBarLocation2.getRegion() == DTToolBarLocation.Region.LEFT_OF_TABS) {
                if (this.fToolstrip != null) {
                    this.fToolstrip.addTabNeighbor((JComponent)new QuickAccessWrapper((JComponent)this.fQuickAccessBar.getComponent(), 4), 2);
                } else {
                    this.getToolBarContainer().addToolBar((JComponent)this.fQuickAccessBar.getComponent(), "quickaccesstoolbar", this.fDesktop.getString("label.QuickAccessToolbar"), true);
                }
            } else if (dTToolBarLocation2.getRegion() == DTToolBarLocation.Region.BELOW_TOOLSTRIP) {
                this.getToolBarContainer().addToolBar((JComponent)this.fQuickAccessBar.getComponent(), "quickaccesstoolbar", this.fDesktop.getString("label.QuickAccessToolbar"), true);
            } else if (dTToolBarLocation2.getRegion() == DTToolBarLocation.Region.ON_TITLE_BAR || dTToolBarLocation2.getRegion() == DTToolBarLocation.Region.FLOATING) {
                boolean bl = dTToolBarLocation2.getRegion() == DTToolBarLocation.Region.FLOATING;
                this.fQuickAccessPopup = new JidePopup();
                this.fQuickAccessPopup.setOwner((Component)((Object)this));
                this.fQuickAccessPopup.setPopupBorder(BorderFactory.createEmptyBorder());
                this.fQuickAccessPopup.setContentPane((Container)this.fQuickAccessBar.getComponent());
                this.fQuickAccessPopup.setResizable(false);
                this.fQuickAccessPopup.setMovable(bl);
                if (bl) {
                    this.fQuickAccessPopup.setGripperLocation(7);
                }
                this.fQuickAccessPopup.setName("QuickAccessToolbarPopup");
                this.fQuickAccessPopup.setAttachable(true);
                this.fQuickAccessPopup.setDetached(false);
                this.fQuickAccessPopup.setTransient(false);
                this.fQuickAccessPopup.putClientProperty((Object)"windowOpacity", (Object)Float.valueOf(0.8f));
                this.fQuickAccessPopup.setDefaultMoveOperation(1);
                if (!this.isVisible()) {
                    this.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowOpened(WindowEvent windowEvent) {
                            Point point = DTFrame.this.getQuickAccessScreenLocation(dTToolBarLocation2.getX(), dTToolBarLocation2.getY());
                            DTFrame.this.fQuickAccessPopup.showPopup(point.x, point.y, (Component)((Object)DTFrame.this));
                            DTFrame.this.removeWindowListener(this);
                        }
                    });
                } else {
                    Point point = this.getQuickAccessScreenLocation(dTToolBarLocation2.getX(), dTToolBarLocation2.getY());
                    this.fQuickAccessPopup.showPopup(point.x, point.y, (Component)((Object)this));
                }
                if (bl) {
                    this.fQuickAccessPopup.addComponentListener((ComponentListener)new ComponentAdapter(){

                        @Override
                        public void componentMoved(ComponentEvent componentEvent) {
                            DTFrame.this.recordQuickAccessPopupLocation();
                        }
                    });
                }
            }
        } else if (this.fQuickAccessLocation.getRegion() == DTToolBarLocation.Region.FLOATING && !this.fQuickAccessLocation.equals(dTToolBarLocation2) && this.fQuickAccessPopup != null) {
            Point point = this.getQuickAccessScreenLocation(dTToolBarLocation2.getX(), dTToolBarLocation2.getY());
            this.fQuickAccessPopup.setLocation(point.x, point.y);
        }
        this.fQuickAccessLocation = dTToolBarLocation2;
        for (QuickAccessMoveAction quickAccessMoveAction : this.fQuickAccessMoveActionMap.values()) {
            quickAccessMoveAction.update();
        }
    }

    protected DTToolBarLocation getQuickAccessLocation() {
        return this.fQuickAccessLocation;
    }

    private Point getQuickAccessScreenLocation(int n, int n2) {
        if (n == Integer.MAX_VALUE) {
            n = 150;
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = PlatformInfo.isWindowsClassicAppearance() ? 0 : (PlatformInfo.isWindows() ? 4 : 2);
            if ((this.getExtendedState() & 6) == 6) {
                n2 += 3;
            }
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointToScreen(point, (Component)((Object)this));
        return point;
    }

    private void recordQuickAccessPopupLocation() {
        if (this.fQuickAccessPopup != null && this.fQuickAccessLocation != null && this.fQuickAccessLocation.getRegion() == DTToolBarLocation.Region.FLOATING) {
            Point point = this.fQuickAccessPopup.getPopupBounds().getLocation();
            SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
            this.fQuickAccessLocation.setLocation(point.x, point.y);
        }
    }

    protected void quickAccessToolBarMoved() {
    }

    Action getQuickAccessMoveAction(DTToolBarLocation.Region region) {
        QuickAccessMoveAction quickAccessMoveAction = this.fQuickAccessMoveActionMap.get((Object)region);
        if (quickAccessMoveAction == null) {
            quickAccessMoveAction = new QuickAccessMoveAction(region);
            this.fQuickAccessMoveActionMap.put(region, quickAccessMoveAction);
        }
        return quickAccessMoveAction;
    }

    private void applyQuickAccessFilters(QuickAccessToolBar quickAccessToolBar) {
        Predicate<TSToolPath> predicate = this.fDesktop.getQuickAccessConfigurationFilter(this);
        QuickAccessBarContextFilter quickAccessBarContextFilter = new QuickAccessBarContextFilter();
        Predicate<TSToolPath> predicate2 = this.getGroup() == null ? null : this.getGroup().getQuickAccessToolBarFilter();
        quickAccessToolBar.setFilter((Predicate)new AllPredicate(new Predicate[]{predicate, quickAccessBarContextFilter, predicate2}));
    }

    protected DTToolBarContainer getToolBarContainer() {
        return this.fToolBarContainer;
    }

    protected JButton getActionsButton() {
        return this.fActionsButton;
    }

    public void addClient(DTClient dTClient, DTLocation dTLocation) {
        dTClient.addPropertyListener(this);
    }

    public void addClientHidden(DTClient dTClient, DTLocation dTLocation) {
        dTClient.setHidden(true);
        this.addClient(dTClient, dTLocation);
    }

    public void removeClient(DTClient dTClient) {
        DTLocation dTLocation = dTClient.getLocation();
        assert (dTLocation != null && dTLocation.getFrame() == this);
        dTLocation.setFrame(null);
        dTClient.removePropertyListener(this);
    }

    @Override
    public boolean isSelected() {
        return this.isActive();
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl) {
            this.toFront();
        } else {
            this.toBack();
        }
    }

    @Override
    public boolean isConsideringSelection() {
        return false;
    }

    @Override
    public void setConsideringSelection(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void dispose() {
        JMenuBar jMenuBar;
        this.saveState();
        if (this.fDesktop != null) {
            this.fDesktop.removeFrame(this);
        }
        if (this.fPendingMenuBarUpdate != null) {
            this.fPendingMenuBarUpdate.cancel();
            this.fPendingMenuBarUpdate = null;
        }
        if ((jMenuBar = this.getJMenuBar()) instanceof DTMenuBar) {
            ((DTMenuBar)((Object)jMenuBar)).dispose();
        }
        this.setJMenuBar(null);
        if (this.fStatusBar != null) {
            this.fSouthPanel.remove((Component)this.fStatusBar);
        }
        if (this.fWindowMenu != null) {
            this.fWindowMenu.dispose();
        }
        if (this.fDesktopMenu != null) {
            this.fDesktopMenu.dispose();
        }
        this.fWindowMenu = null;
        this.fDesktopMenu = null;
        this.getContentPane().removeAll();
        if (this.fToolstrip != null) {
            for (ToolstripTab toolstripTab : this.fToolstrip.getModel()) {
                if (!((Boolean)toolstripTab.getAttribute((Attribute)DTToolstripFactory.IS_GLOBAL_TAB)).booleanValue()) continue;
                TSFactory.disposeTab((ToolstripTab)toolstripTab);
            }
        }
        if (this.fQuickAccessBar != null) {
            if (this.fQuickAccessConfigListener != null) {
                this.fQuickAccessBar.getConfiguration().removeListener(this.fQuickAccessConfigListener);
            }
            this.fQuickAccessBar.dispose();
        }
        try {
            super.dispose();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public DTFrame() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    void saveState() {
    }

    protected JRootPane createRootPane() {
        return new DTRootPane();
    }

    protected void mainFrameCreated() {
        JMenuBar jMenuBar;
        if (this.fDesktopMenu != null) {
            this.fDesktopMenu.mainFrameCreated();
        }
        if ((jMenuBar = this.getJMenuBar()) instanceof DTMenuBar) {
            ((DTMenuBar)((Object)jMenuBar)).mainFrameCreated();
        }
    }

    protected void mainFrameDestroyed() {
        JMenuBar jMenuBar;
        if (this.fDesktopMenu != null) {
            this.fDesktopMenu.mainFrameDestroyed();
        }
        if ((jMenuBar = this.getJMenuBar()) instanceof DTMenuBar) {
            ((DTMenuBar)((Object)jMenuBar)).mainFrameDestroyed();
        }
    }

    protected DTFloatingLocation getLocationToUpdate() {
        return null;
    }

    static {
        MenuSelectionManager.defaultManager().addChangeListener(new MenuToStatusBarBridge());
    }

    private class QuickAccessMoveAction
    extends MJAbstractAction {
        private final DTToolBarLocation.Region iToRegion;

        private QuickAccessMoveAction(DTToolBarLocation.Region region) {
            super(DTFrame.this.fDesktop.getString("Tool." + region.toString().toLowerCase(Locale.ENGLISH) + ".Label"));
            this.setComponentName(region.toString());
            this.iToRegion = region;
            this.update();
        }

        private void update() {
            this.setSelected(DTFrame.this.fQuickAccessLocation != null && this.iToRegion == DTFrame.this.fQuickAccessLocation.getRegion());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTFrame.this.setQuickAccessLocation(new DTToolBarLocation(this.iToRegion));
            DTFrame.this.quickAccessToolBarMoved();
        }
    }

    class ToggleStatusBarAction
    extends MJAbstractAction {
        public ToggleStatusBarAction() {
            super(DTFrame.this.getDesktop().getString("menuitem.StatusBar"));
            this.setComponentName("ToggleStatusBar");
            this.setSelected(DTFrame.this.fIsStatusBarVisible);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            DTFrame.this.setStatusBarVisible(abstractButton.isSelected());
        }
    }

    private static class MenuToStatusBarBridge
    implements ChangeListener {
        private DTFrame iLastFrame;

        private MenuToStatusBarBridge() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MenuElement menuElement;
            String string = null;
            DTFrame dTFrame = null;
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null && menuElementArray.length > 0 && (menuElement = menuElementArray[menuElementArray.length - 1]) instanceof JMenuItem) {
                Action action = ((JMenuItem)menuElement).getAction();
                if (action != null) {
                    string = (String)action.getValue("StatusText");
                }
                dTFrame = DTFrame.getAncestorFrame(menuElement.getComponent());
            }
            if (this.iLastFrame != null && dTFrame != this.iLastFrame) {
                this.iLastFrame.setStatusText(null);
                this.iLastFrame = null;
            }
            if (dTFrame != null && string != null) {
                dTFrame.setStatusText(string);
                this.iLastFrame = dTFrame;
            }
        }
    }

    class MenuBarMouseListener
    extends MouseAdapter {
        MenuBarMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.checkContextTrigger(mouseEvent);
            if (MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent)) {
                mouseEvent.consume();
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkContextTrigger(mouseEvent);
        }

        void checkContextTrigger(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Component component = mouseEvent.getComponent();
                Point point = mouseEvent.getPoint();
                Component component2 = component;
                if (!(component instanceof JMenuBar)) {
                    component2 = component.getParent();
                    point = SwingUtilities.convertPoint(component, point, component2);
                }
                if (component2.contains(point)) {
                    this.showContextMenu(mouseEvent);
                    mouseEvent.consume();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void showContextMenu(MouseEvent mouseEvent) {
            DTToolBarContainer dTToolBarContainer = DTFrame.this.getToolBarContainer();
            if (dTToolBarContainer != null && dTToolBarContainer.offerToggles()) {
                MJPopupMenu mJPopupMenu = new MJPopupMenu();
                mJPopupMenu.setCleanupUponClose(true);
                for (Action object : dTToolBarContainer.getContextToggleActions()) {
                    mJPopupMenu.add((JMenuItem)new MJCheckBoxMenuItem(object));
                }
                if (mJPopupMenu.getComponentCount() > 0) {
                    void var5_8;
                    Object object2 = (Component)mouseEvent.getSource();
                    Point point = mouseEvent.getPoint();
                    if (object2 instanceof JMenu) {
                        Container container = ((Component)object2).getParent();
                        Point point2 = SwingUtilities.convertPoint((Component)object2, point, container);
                        object2 = container;
                    }
                    mJPopupMenu.show((Component)object2, var5_8.x, var5_8.y);
                }
            }
        }
    }

    private class LocationTracker
    extends WindowAdapter
    implements ComponentListener {
        Point iSavePosition = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);

        private LocationTracker() {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            DTFloatingLocation dTFloatingLocation = DTFrame.this.getLocationToUpdate();
            if (dTFloatingLocation != null) {
                dTFloatingLocation.setMinimized(true);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            DTFloatingLocation dTFloatingLocation = DTFrame.this.getLocationToUpdate();
            if (dTFloatingLocation != null) {
                dTFloatingLocation.setMinimized(false);
            }
            if (DTFrame.this.fQuickAccessPopup != null && DTFrame.this.fQuickAccessLocation != null) {
                Point point = DTFrame.this.getQuickAccessScreenLocation(DTFrame.this.fQuickAccessLocation.getX(), DTFrame.this.fQuickAccessLocation.getY());
                DTFrame.this.fQuickAccessPopup.showPopup(point.x, point.y, (Component)((Object)DTFrame.this));
            }
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            DTFloatingLocation dTFloatingLocation = DTFrame.this.getLocationToUpdate();
            if (dTFloatingLocation != null) {
                boolean bl;
                int n = DTFrame.this.getExtendedState();
                boolean bl2 = bl = n != -1 && (n & 6) == 6;
                if (bl && dTFloatingLocation.getFrameX() == DTFrame.this.getX() && dTFloatingLocation.getFrameY() == DTFrame.this.getY() && this.iSavePosition.x != Integer.MIN_VALUE) {
                    dTFloatingLocation.setFrameLocation(this.iSavePosition.x, this.iSavePosition.y);
                    this.iSavePosition.y = Integer.MIN_VALUE;
                    this.iSavePosition.x = Integer.MIN_VALUE;
                }
                if (bl != dTFloatingLocation.isMaximized()) {
                    dTFloatingLocation.setMaximized(bl);
                    this.updateQuickAccessBarLocation();
                }
                if (bl) {
                    dTFloatingLocation.setFrameLocation(DTFrame.this.getX(), DTFrame.this.getY());
                }
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            DTFloatingLocation dTFloatingLocation = DTFrame.this.getLocationToUpdate();
            if (dTFloatingLocation != null) {
                boolean bl;
                boolean bl2 = bl = (DTFrame.this.getExtendedState() & 6) == 6;
                if (!bl) {
                    this.iSavePosition.x = dTFloatingLocation.getFrameX();
                    this.iSavePosition.y = dTFloatingLocation.getFrameY();
                }
                if (bl != dTFloatingLocation.isMaximized()) {
                    dTFloatingLocation.setMaximized(bl);
                    this.updateQuickAccessBarLocation();
                }
                dTFloatingLocation.setFrameBounds(DTFrame.this.getX(), DTFrame.this.getY(), DTFrame.this.getWidth(), DTFrame.this.getHeight());
                dTFloatingLocation.recordVisibility(WindowUtils.getVirtualScreenBounds());
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            DTFloatingLocation dTFloatingLocation = DTFrame.this.getLocationToUpdate();
            if (dTFloatingLocation != null) {
                boolean bl;
                boolean bl2 = bl = (DTFrame.this.getExtendedState() & 6) == 6;
                if (bl != dTFloatingLocation.isMaximized()) {
                    dTFloatingLocation.setMaximized(bl);
                    this.updateQuickAccessBarLocation();
                }
                dTFloatingLocation.setFrameBounds(DTFrame.this.getX(), DTFrame.this.getY(), DTFrame.this.getWidth(), DTFrame.this.getHeight());
                dTFloatingLocation.recordVisibility(WindowUtils.getVirtualScreenBounds());
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        private void updateQuickAccessBarLocation() {
            if (DTFrame.this.fQuickAccessPopup != null && DTFrame.this.fQuickAccessLocation != null && DTFrame.this.fQuickAccessLocation.getRegion() == DTToolBarLocation.Region.ON_TITLE_BAR) {
                Point point = DTFrame.this.getQuickAccessScreenLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
                DTFrame.this.fQuickAccessPopup.showPopup(point.x, point.y, (Component)((Object)DTFrame.this));
            }
        }
    }

    private class QuickAccessBarContextFilter
    implements Predicate<TSToolPath> {
        private QuickAccessBarContextFilter() {
        }

        public boolean accept(TSToolPath tSToolPath) {
            return DTFrame.this.isMainFrame() || tSToolPath.getContextName() == null || DTFrame.this.getGroup() == null || tSToolPath.getContextName().equals(DTFrame.this.getGroup().getName());
        }
    }

    private class DeferredMenuBarUpdate
    implements ActionListener {
        private final Timer iTimer = new Timer(250, this);

        DeferredMenuBarUpdate() {
            this.iTimer.setRepeats(false);
            this.iTimer.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DTFrame.this.updateMenuBar();
            DTFrame.this.qeMenuMergeComplete = true;
            DTFrame.this.fPendingMenuBarUpdate = null;
        }

        void cancel() {
            this.iTimer.stop();
        }
    }
}

