/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ControlKeyOverride;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.widgets.desk.DTBorderContainer;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDragDetector;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDragger;
import com.mathworks.widgets.desk.DTDropOutlinePainter;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTExternalTarget;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTGroupFrame;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyBindings;
import com.mathworks.widgets.desk.DTKeyControlledMover;
import com.mathworks.widgets.desk.DTKeyControlledResizer;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTNestedLocation;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTSplitPane;
import com.mathworks.widgets.desk.DTTabbedPane;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.DTToolBarContainer;
import com.mathworks.widgets.desk.DeferredRunnable;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DTNestingContainer
extends MJPanel
implements DTContainer,
DTDropTarget,
ControlKeyOverride,
ItemListener {
    private final Desktop fDesktop;
    private DTMultipleClientFrame fFrame;
    private DTContainer fChild;
    private DTGroup fGroup;
    private DTToolBarContainer fParentToolBarContainer;
    private Point fScratchPoint = new Point();
    private boolean fIsClearing;
    private boolean fIsRestoring;
    private boolean fIsRemovingMultiple;
    private final BoundsListener fBoundsListener = new BoundsListener();
    private static final float OUTER_MARGIN_FRACTION = 0.15f;
    private static final int MAX_OUTER_MARGIN = 40;
    static final int TOP_BORDER_MARGIN = 6;
    static final int BORDER_MARGIN = 10;
    private static final float INNER_MARGIN_FRACTION = 0.25f;
    private static final int MAX_INNER_MARGIN = 100;
    private static final int MINIMUM_CLIENT_HEIGHT = 24;
    private static final int MINIMUM_CLIENT_WIDTH = 24;
    static final String SPLIT_TAG = "Split";
    private static final String ORIENTATION_ATTRIBUTE = "Orientation";
    private static final String TOP_BOTTOM_VALUE = "topBottom";
    private static final String LEFT_RIGHT_VALUE = "leftRight";
    private static final String POSITION_ATTRIBUTE = "Position";
    static final String TABBED_TAG = "Tabbed";
    private static final String PLACEMENT_ATTRIBUTE = "Placement";
    private static final String LEFT_VALUE = "left";
    private static final String RIGHT_VALUE = "right";
    private static final String TOP_VALUE = "top";
    private static final String BOTTOM_VALUE = "bottom";
    private static final String SELECTED_ATTRIBUTE = "Selected";
    static final String GROUP_TAG = "Group";
    static final String DOCUMENTS_TAG = "Documents";
    static final String VIEW_TAG = "View";
    private static final String NAME_ATTRIBUTE = "Name";
    private static final String TITLE_ATTRIBUTE = "Title";
    private static final String SHARED_DOCUMENTS = "Shared";

    DTNestingContainer(Desktop desktop, DTMultipleClientFrame dTMultipleClientFrame) {
        this.fDesktop = desktop;
        this.fFrame = dTMultipleClientFrame;
        if (this.fFrame != null) {
            this.fParentToolBarContainer = dTMultipleClientFrame.getToolBarContainer();
        }
        this.setName("DesktopNestingContainer");
        this.setLayout(new BorderLayout());
        this.setKeyBindings();
        this.setFocusTraversalPolicy(new NoTraversalPolicy());
        this.setFocusCycleRoot(true);
    }

    DTNestingContainer(Desktop desktop, DTGroupFrame dTGroupFrame) {
        this(desktop, (DTMultipleClientFrame)dTGroupFrame.getDocumentContainer().getFrame());
        this.fGroup = dTGroupFrame.getGroup();
        DTDocumentContainer dTDocumentContainer = dTGroupFrame.getDocumentContainer();
        this.add((Component)((Object)dTDocumentContainer), "Center");
        this.fChild = dTDocumentContainer;
        this.fParentToolBarContainer = dTGroupFrame.getToolBarContainer();
    }

    DTFrame getFrame() {
        return this.fFrame;
    }

    void setFrame(DTFrame dTFrame) {
        assert (dTFrame == null || dTFrame instanceof DTMultipleClientFrame);
        this.fFrame = (DTMultipleClientFrame)dTFrame;
        if (this.fParentToolBarContainer == null && dTFrame != null) {
            this.fParentToolBarContainer = dTFrame.getToolBarContainer();
        }
    }

    protected void setKeyBindings() {
        this.setInputMap(1, DTKeyBindings.getInstance().getInputMap());
        ActionMap actionMap = this.getActionMap();
        actionMap.put("select-next-client", (Action)((Object)new KeyNavigationAction("select-next-client", true, false)));
        actionMap.put("select-previous-client", (Action)((Object)new KeyNavigationAction("select-previous-client", false, false)));
        actionMap.put("select-next-tool", (Action)((Object)new KeyNavigationAction("select-next-tool", true, true)));
        actionMap.put("select-previous-tool", (Action)((Object)new KeyNavigationAction("select-previous-tool", false, true)));
    }

    Action getNextShowingAction() {
        return this.getActionMap().get("select-next-tool");
    }

    Action getPrevShowingAction() {
        return this.getActionMap().get("select-previous-tool");
    }

    public boolean wantKey(KeyStroke keyStroke, Component component) {
        DTClientFrame dTClientFrame = (DTClientFrame)((Object)SwingUtilities.getAncestorOfClass(DTClientFrame.class, component));
        return dTClientFrame == null || !dTClientFrame.getClient().wantsControlKeys();
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        dTInternalFrame.setTitleBarVisible(!dTOccupant.hideTitleWhenDocked());
        dTInternalFrame.setBorderVisible(true);
        if (!this.fIsRestoring) {
            DTNestedLocation dTNestedLocation = dTLocation instanceof DTNestedLocation ? (DTNestedLocation)dTLocation : new DTNestedLocation();
            RelativeLocation relativeLocation = null;
            if (dTNestedLocation.getHierarchy() != null) {
                relativeLocation = this.getPreviousLocation(dTOccupant, dTNestedLocation);
            }
            if (relativeLocation == null) {
                relativeLocation = this.getRelativeLocation(dTNestedLocation);
            }
            this.addContainer(dTInternalFrame, relativeLocation, dTNestedLocation);
            dTOccupant.prepareToShow();
        }
        dTInternalFrame.addItemListener(this);
        dTInternalFrame.addComponentListener(this.fBoundsListener);
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        DTLocation dTLocation = dTOccupant.getLocation();
        dTInternalFrame.removeComponentListener(this.fBoundsListener);
        if (!this.fIsClearing) {
            Container container = dTInternalFrame.getParent();
            if (dTLocation instanceof DTNestedLocation) {
                this.updateBounds((Component)((Object)dTInternalFrame));
                DTNestedLocation dTNestedLocation = (DTNestedLocation)dTLocation;
                dTNestedLocation.setHierarchy(new RootState(this.fChild, false, false));
            }
            this.removeContainer(dTInternalFrame);
            if (container instanceof DTTabbedPane && container.getParent() != null) {
                ((DTTabbedPane)((Object)container)).allRestored();
            }
        } else if (dTInternalFrame == this.fChild) {
            this.remove((Component)((Object)dTInternalFrame));
        } else {
            ((DTContainer)((Object)dTInternalFrame.getParent())).remove(dTOccupant);
        }
        dTInternalFrame.removeItemListener(this);
        dTInternalFrame.setTitleBarVisible(true);
        dTLocation.setContainer(null);
        dTOccupant.setLocation(null);
    }

    @Override
    public void replaceChild(Component component, Component component2) {
        DTInternalFrame dTInternalFrame;
        if (this.fChild == component2) {
            DTInternalFrame dTInternalFrame2;
            DTOccupant dTOccupant;
            if (component2 instanceof DTInternalFrame && (dTOccupant = (dTInternalFrame2 = (DTInternalFrame)((Object)component2)).getOccupant()).hideTitleWhenSolo()) {
                dTInternalFrame2.setTitleBarVisible(false);
                dTInternalFrame2.setBorderVisible(false);
            }
            return;
        }
        if (component != null) {
            this.remove(component);
            if (component instanceof DTInternalFrame) {
                dTInternalFrame.setTitleBarVisible(!(dTInternalFrame = (DTInternalFrame)((Object)component)).getOccupant().hideTitleWhenDocked());
                dTInternalFrame.setBorderVisible(true);
            } else if (component instanceof DTTabbedPane) {
                ((DTTabbedPane)((Object)component)).setBordersVisible(true);
            }
        }
        this.fChild = (DTContainer)((Object)component2);
        if (component2 == null) {
            this.requestFocus();
        } else {
            DTOccupant dTOccupant;
            if (component2 instanceof DTInternalFrame && (dTOccupant = (dTInternalFrame = (DTInternalFrame)((Object)component2)).getOccupant()).hideTitleWhenSolo()) {
                dTInternalFrame.setTitleBarVisible(false);
                dTInternalFrame.setBorderVisible(false);
            }
            this.add(component2, "Center");
        }
        if (this.fParentToolBarContainer != null) {
            this.fParentToolBarContainer.revalidate();
            this.fParentToolBarContainer.repaint();
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        Object object = null;
        DTSelectable dTSelectable2 = null;
        if (dTSelectable instanceof DTClient) {
            object = ((DTClient)dTSelectable).getInternalFrame();
        } else if (dTSelectable instanceof DTGroup) {
            object = ((DTGroup)dTSelectable).getInternalFrame();
        } else if (dTSelectable instanceof Component) {
            object = (Component)((Object)dTSelectable);
        }
        while (dTSelectable2 == null && object != null && object != this) {
            if (!((object = ((Component)object).getParent()) instanceof DTContainer) || object == this) continue;
            dTSelectable2 = ((DTContainer)object).getNext(dTSelectable, bl);
        }
        if (!(dTSelectable2 != null || this.fChild == null || this.fGroup != null && this.fFrame.isMainFrame() && this.fGroup.getDocumentContainer().isEmpty() && dTSelectable != null)) {
            dTSelectable2 = this.fChild.getNext(null, bl);
        }
        return dTSelectable2;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        Object object = null;
        DTSelectable dTSelectable2 = null;
        if (dTSelectable instanceof DTClient) {
            object = ((DTClient)dTSelectable).getInternalFrame();
        } else if (dTSelectable instanceof DTGroup) {
            object = ((DTGroup)dTSelectable).getInternalFrame();
        } else if (dTSelectable instanceof Component) {
            object = (Component)((Object)dTSelectable);
        }
        while (dTSelectable2 == null && object != null && object != this) {
            if (!((object = ((Component)object).getParent()) instanceof DTContainer) || object == this) continue;
            dTSelectable2 = ((DTContainer)object).getPrevious(dTSelectable, bl);
        }
        if (!(dTSelectable2 != null || this.fChild == null || this.fGroup != null && this.fFrame.isMainFrame() && this.fGroup.getDocumentContainer().isEmpty() && dTSelectable != null)) {
            dTSelectable2 = this.fChild.getPrevious(null, bl);
        }
        return dTSelectable2;
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        Container container = dTOccupant.getInternalFrame().getParent();
        if (container instanceof DTTabbedPane) {
            ((DTTabbedPane)((Object)container)).toFront(dTOccupant, scope);
        }
        this.ensureVisible(dTOccupant, scope);
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return !(this.fChild instanceof DTInternalFrame);
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
        final KeyControlledMover keyControlledMover = new KeyControlledMover();
        ((DTKeyControlledMover)keyControlledMover).activate(dTOccupant);
        keyControlledMover.startDrag(DTDragDetector.DEFAULT_THRESHOLD.width + 1, 0);
        SwingUtilities.invokeLater(new DeferredRunnable(5){

            @Override
            public void doTask() {
                keyControlledMover.startDrag(1, 0);
            }
        });
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return SwingUtilities.getAncestorOfClass(DTSplitPane.class, (Component)((Object)dTOccupant.getInternalFrame())) != null;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
        new KeyControlledResizer().activate(dTOccupant, (Container)((Object)this));
    }

    private DTContainer getNeighboringContainer(Component component, int n) {
        while (!(component instanceof DTInternalFrame) && !(component instanceof DTDocumentContainer) && component != null) {
            if (component instanceof DTTabbedPane) {
                component = ((DTTabbedPane)((Object)component)).getSelectedComponent();
                continue;
            }
            if (!(component instanceof DTSplitPane)) continue;
            DTSplitPane dTSplitPane = (DTSplitPane)((Object)component);
            switch (n) {
                case 1: {
                    if (dTSplitPane.getOrientation() == 0) {
                        component = dTSplitPane.getBottomComponent();
                        break;
                    }
                    component = dTSplitPane.getTopComponent();
                    break;
                }
                case 5: {
                    component = dTSplitPane.getTopComponent();
                    break;
                }
                case 3: {
                    component = dTSplitPane.getLeftComponent();
                    break;
                }
                case 7: {
                    component = dTSplitPane.getOrientation() == 1 ? dTSplitPane.getRightComponent() : dTSplitPane.getLeftComponent();
                }
            }
        }
        return component != null ? (DTContainer)((Object)component) : null;
    }

    private static boolean isOppositeDirection(int n, int n2) {
        return n == 3 && n2 == 7 || n == 7 && n2 == 3 || n == 1 && n2 == 5 || n == 5 && n2 == 1;
    }

    private static int getOppositeDirection(int n) {
        switch (n) {
            case 1: {
                return 5;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        return 0;
    }

    DTContainer getChild() {
        return this.fChild;
    }

    void beginClear() {
        this.fIsClearing = true;
        this.updateBounds((Component)((Object)this));
    }

    void endClear() {
        this.fIsClearing = false;
        if (this.fChild != null) {
            this.remove((Component)((Object)this.fChild));
            this.fChild = null;
        }
    }

    void beginMultipleRemove() {
        this.fIsRemovingMultiple = true;
    }

    void endMultipleRemove() {
        this.fIsRemovingMultiple = false;
        this.updateOccupantLocations((Container)((Object)this));
    }

    DTSelectable getNearestSelectable(DTNestedLocation dTNestedLocation) {
        if (this.fIsClearing) {
            return null;
        }
        DTContainer dTContainer = this.getRelativeLocation((DTNestedLocation)dTNestedLocation).fContainer;
        if (dTContainer == null) {
            return null;
        }
        return dTContainer.getNext(null, true);
    }

    private RelativeLocation getRelativeLocation(DTNestedLocation dTNestedLocation) {
        DTSplitPane dTSplitPane;
        int n;
        DTContainer dTContainer = this.fChild;
        int n2 = dTNestedLocation.getPathLength();
        int n3 = 3;
        int n4 = 1;
        for (n = 0; n < n2 && dTContainer instanceof DTSplitPane; ++n) {
            int n5 = dTNestedLocation.getDirection(n);
            dTSplitPane = (DTSplitPane)dTContainer;
            if (dTSplitPane.getOrientation() == 1) {
                if (n5 == 7) {
                    dTContainer = (DTContainer)((Object)dTSplitPane.getLeftComponent());
                } else {
                    if (n5 != 3) break;
                    dTContainer = (DTContainer)((Object)dTSplitPane.getRightComponent());
                }
                n3 = n5;
                continue;
            }
            if (n5 == 1) {
                dTContainer = (DTContainer)((Object)dTSplitPane.getTopComponent());
            } else {
                if (n5 != 5) break;
                dTContainer = (DTContainer)((Object)dTSplitPane.getBottomComponent());
            }
            n4 = n5;
        }
        if (dTContainer instanceof DTTabbedPane && n == n2) {
            dTContainer = (DTContainer)((Object)((DTTabbedPane)dTContainer).getComponentAt(0));
        }
        RelativeLocation relativeLocation = new RelativeLocation();
        if (n < n2 && dTNestedLocation.getDirection(n) != 2) {
            if (n == 0) {
                relativeLocation.fDirection = this.getDominantDirection(dTNestedLocation);
            } else {
                relativeLocation.fDirection = dTNestedLocation.getDirection(n2 - 1);
                if (relativeLocation.fDirection == 2) {
                    relativeLocation.fDirection = dTNestedLocation.getDirection(n2 - 2);
                }
            }
        } else {
            relativeLocation.fDirection = dTContainer instanceof DTSplitPane ? ((dTSplitPane = (DTSplitPane)dTContainer).getOrientation() == 1 ? n4 : n3) : 2;
        }
        relativeLocation.setContainer(dTContainer);
        return relativeLocation;
    }

    private int getDominantDirection(DTNestedLocation dTNestedLocation) {
        boolean[] blArray = new boolean[DTNestedLocation.MAX_DIRECTION_VALUE + 1];
        boolean[] blArray2 = new boolean[DTNestedLocation.MAX_DIRECTION_VALUE + 1];
        Arrays.fill(blArray, true);
        Arrays.fill(blArray2, true);
        for (int i = 0; i < dTNestedLocation.getPathLength(); ++i) {
            int n = dTNestedLocation.getDirection(i);
            blArray[DTNestingContainer.getOppositeDirection((int)n)] = false;
            for (int j = 0; j < blArray2.length; ++j) {
                if (j == n) continue;
                blArray2[j] = false;
            }
        }
        if (blArray2[7]) {
            return 7;
        }
        if (blArray2[3]) {
            return 3;
        }
        if (blArray2[1]) {
            return 1;
        }
        if (blArray2[5]) {
            return 5;
        }
        if (blArray[7]) {
            return 7;
        }
        if (blArray[3]) {
            return 3;
        }
        if (blArray[1]) {
            return 1;
        }
        if (blArray[5]) {
            return 5;
        }
        return 7;
    }

    private DTNestedLocation getAbsoluteLocation(RelativeLocation relativeLocation) {
        DTNestedLocation dTNestedLocation = this.getAncestry((Component)((Object)relativeLocation.getContainer()), new DTNestedLocation());
        return dTNestedLocation.append(relativeLocation.fDirection);
    }

    private RelativeLocation getPreviousLocation(DTOccupant dTOccupant, DTNestedLocation dTNestedLocation) {
        RootState rootState;
        TreeState treeState;
        TreeState treeState2;
        TreeState treeState3;
        RelativeLocation relativeLocation = null;
        RootState rootState2 = (RootState)dTNestedLocation.getHierarchy();
        TreeState treeState4 = rootState2.findSubTree(treeState3 = DTNestingContainer.createChildState(dTOccupant.getInternalFrame(), false, false));
        if (treeState4 != null && treeState4.getParent() instanceof SplitState && (treeState2 = ((SplitState)treeState4.getParent()).getSibling(treeState4)).getChildCount() > 0 && (treeState = (rootState = new RootState(this.fChild, false, true)).findSubTree(treeState2)) != null) {
            relativeLocation = new RelativeLocation();
            relativeLocation.setContainer(treeState.fPeer);
            relativeLocation.fDirection = dTNestedLocation.getDirection(dTNestedLocation.getPathLength() - 1);
        }
        return relativeLocation;
    }

    private void addContainer(DTContainer dTContainer, RelativeLocation relativeLocation, DTNestedLocation dTNestedLocation) {
        Component component = (Component)((Object)dTContainer);
        DTContainer dTContainer2 = relativeLocation.getContainer();
        if (dTContainer2 == null) {
            if (this.fChild == null) {
                this.replaceChild(null, component);
                this.updateOccupantLocations((Container)((Object)this));
                this.invalidate();
                this.validate();
                this.repaint();
                return;
            }
            dTContainer2 = this.fChild;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        DTNestingContainer.getHeavyweights(component, arrayList);
        DTNestingContainer.shrinkHeavyweights(arrayList);
        DTNestingContainer.setHeavyweightsVisible(arrayList, false);
        Component component2 = null;
        if (!(this.fIsRestoring || this.fIsClearing || (component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) == null || SwingUtilities.isDescendingFrom(component2, (Component)((Object)this)))) {
            component2 = null;
        }
        if (relativeLocation.fDirection == 2) {
            if (dTContainer instanceof DTDocumentContainer) {
                relativeLocation.fDirection = 3;
            } else if (dTContainer2 instanceof DTDocumentContainer) {
                relativeLocation.fDirection = 7;
            }
        }
        Container container = ((Component)((Object)dTContainer2)).getParent();
        assert (container != null);
        DTInternalFrame dTInternalFrame = null;
        if (relativeLocation.fDirection == 2) {
            Object object;
            DTTabbedPane dTTabbedPane;
            if (dTContainer2 instanceof DTTabbedPane) {
                dTTabbedPane = (DTTabbedPane)dTContainer2;
            } else if (container instanceof DTTabbedPane) {
                dTTabbedPane = (DTTabbedPane)((Object)container);
            } else {
                object = new ArrayList();
                DTNestingContainer.getHeavyweights((Component)((Object)dTContainer2), (List<Component>)object);
                DTNestingContainer.setHeavyweightsVisible((List<Component>)object, false);
                arrayList.addAll((Collection<Component>)object);
                dTTabbedPane = new DTTabbedPane();
                ((DTContainer)((Object)container)).replaceChild((Component)((Object)dTContainer2), (Component)((Object)dTTabbedPane));
                dTInternalFrame = (DTInternalFrame)dTContainer2;
                dTTabbedPane.add(dTInternalFrame.getOccupant(), null);
            }
            object = (DTInternalFrame)dTContainer;
            dTTabbedPane.add(((DTInternalFrame)object).getOccupant(), dTNestedLocation);
            if (dTInternalFrame != null && dTInternalFrame.isSelected()) {
                dTInternalFrame.getOccupant().requestFocusLater();
            }
        } else {
            ArrayList<Component> arrayList2;
            Object object;
            int n = relativeLocation.fDirection == 1 || relativeLocation.fDirection == 5 ? 0 : 1;
            Dimension dimension = ((Component)((Object)dTContainer2)).getSize();
            Dimension dimension2 = null;
            if (dTContainer instanceof DTClientFrame && ((DTClient)(object = ((DTClientFrame)dTContainer).getClient())).honorPreferredSizeWhenDocked()) {
                dimension2 = ((DTClient)object).getComponent().getPreferredSize();
                arrayList2 = ((DTClientFrame)dTContainer).getDecorationInsets();
                dimension2.width += ((Insets)((Object)arrayList2)).left + ((Insets)((Object)arrayList2)).right;
                dimension2.height += ((Insets)((Object)arrayList2)).top + ((Insets)((Object)arrayList2)).bottom;
            }
            object = new DTSplitPane(n);
            object.addPropertyChangeListener("dividerLocation", (PropertyChangeListener)this.fBoundsListener);
            arrayList2 = new ArrayList();
            DTNestingContainer.getHeavyweights((Component)((Object)dTContainer2), arrayList2);
            DTNestingContainer.setHeavyweightsVisible(arrayList2, false);
            arrayList.addAll(arrayList2);
            ((DTContainer)((Object)container)).replaceChild((Component)((Object)dTContainer2), (Component)object);
            ((DTSplitPane)object).setComponent(component, relativeLocation.fDirection);
            ((DTSplitPane)object).setUnoccupiedComponent((Component)((Object)dTContainer2));
            boolean bl = false;
            if (dTNestedLocation != null) {
                Dimension dimension3 = dTNestedLocation.getFrameSize();
                Dimension dimension4 = dTNestedLocation.getParentSize();
                int n2 = this.getDeepestSplitOrientation(dTNestedLocation);
                if (dimension3 != null && dimension3.width > 0 && dimension3.height > 0 && n == n2) {
                    if (n == 0 && dimension4 != null && dimension4.height > 0 && dimension4.height != dimension.height) {
                        if (dimension2 == null) {
                            double d = (double)dimension3.height / (double)dimension4.height;
                            if (relativeLocation.fDirection != 1) {
                                d = 1.0 - d;
                            }
                            object.setDividerLocation(d);
                            bl = true;
                        }
                    } else if (n == 1 && dimension4 != null && dimension4.width > 0 && dimension4.width != dimension.width) {
                        if (dimension2 == null) {
                            double d = (double)dimension3.width / (double)dimension4.width;
                            if (relativeLocation.fDirection != 7) {
                                d = 1.0 - d;
                            }
                            object.setDividerLocation(d);
                            bl = true;
                        }
                    } else {
                        this.setDividerLocation((DTSplitPane)object, dimension, dimension3, relativeLocation.fDirection);
                        bl = true;
                    }
                }
            }
            if (!bl) {
                if (dimension2 != null) {
                    this.setDividerLocation((DTSplitPane)object, dimension, dimension2, relativeLocation.fDirection);
                } else {
                    double d = 0.5;
                    if (dTContainer instanceof DTGroupFrame && dTContainer2 instanceof DTClientFrame) {
                        d = relativeLocation.fDirection == 1 || relativeLocation.fDirection == 7 ? 0.667 : 0.333;
                    } else if ((dTContainer2 instanceof DTGroupFrame || dTContainer2 instanceof DTDocumentContainer) && dTContainer instanceof DTClientFrame) {
                        d = relativeLocation.fDirection == 5 || relativeLocation.fDirection == 3 ? 0.667 : 0.333;
                    }
                    object.setDividerLocation(d);
                }
            }
            if (dTContainer2 instanceof DTTabbedPane) {
                ((DTTabbedPane)dTContainer2).refresh();
            }
        }
        this.updateOccupantLocations(container);
        if (component2 != null && component2.isShowing() && SwingUtilities.isDescendingFrom(component2, (Component)((Object)this))) {
            component2.requestFocusInWindow();
        }
        container.invalidate();
        container.validate();
        container.repaint();
        DTNestingContainer.setHeavyweightsVisible(arrayList, true);
        if (arrayList.size() > 0) {
            DTNestingContainer.refreshTabPanes((Component)((Object)this));
        }
    }

    private void setDividerLocation(DTSplitPane dTSplitPane, Dimension dimension, Dimension dimension2, int n) {
        if (dimension.width > 0 || dimension.height > 0) {
            dTSplitPane.setSize(dimension);
        }
        if (dTSplitPane.getOrientation() == 0) {
            if (n == 1) {
                dTSplitPane.setFirstComponentSize(dimension2.height, 24);
            } else {
                dTSplitPane.setSecondComponentSize(dimension2.height, 24);
            }
        } else if (n == 7) {
            dTSplitPane.setFirstComponentSize(dimension2.width, 24);
        } else {
            dTSplitPane.setSecondComponentSize(dimension2.width, 24);
        }
    }

    void rescaleDividerLocations(Dimension dimension, Dimension dimension2) {
        float f = 1.0f;
        float f2 = 1.0f;
        if (dimension.width != dimension2.width) {
            f = (float)dimension2.width / (float)dimension.width;
        }
        if (dimension.height != dimension2.height) {
            f2 = (float)dimension2.height / (float)dimension.height;
        }
        this.rescaleDividerLocations((Component)((Object)this.fChild), f, f2);
    }

    private void rescaleDividerLocations(Component component, float f, float f2) {
        if (component instanceof DTSplitPane) {
            DTSplitPane dTSplitPane = (DTSplitPane)((Object)component);
            int n = dTSplitPane.getDividerLocation();
            if (n > 0) {
                if (f != 1.0f && dTSplitPane.getOrientation() == 1) {
                    dTSplitPane.setDividerLocation((int)((float)n * f));
                }
                if (f2 != 1.0f && dTSplitPane.getOrientation() == 0) {
                    dTSplitPane.setDividerLocation((int)((float)n * f2));
                }
            }
            this.rescaleDividerLocations(dTSplitPane.getLeftComponent(), f, f2);
            this.rescaleDividerLocations(dTSplitPane.getRightComponent(), f, f2);
        }
    }

    private void removeContainer(DTContainer dTContainer) {
        Component component = null;
        if (!(this.fIsRestoring || this.fIsClearing || (component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) == null || SwingUtilities.isDescendingFrom(component, (Component)((Object)this)))) {
            component = null;
        }
        Component component2 = (Component)((Object)dTContainer);
        Container container = component2.getParent();
        assert (container != null);
        ArrayList<Component> arrayList = new ArrayList<Component>();
        DTNestingContainer.getHeavyweights(component2, arrayList);
        DTNestingContainer.setHeavyweightsVisible(arrayList, false);
        if (container instanceof DTSplitPane) {
            DTSplitPane dTSplitPane = (DTSplitPane)((Object)container);
            Container container2 = dTSplitPane.getParent();
            Component component3 = dTSplitPane.getLeftComponent();
            Component component4 = dTSplitPane.getRightComponent();
            dTSplitPane.setLeftComponent(null);
            dTSplitPane.setRightComponent(null);
            Component component5 = component2 == component3 ? component4 : component3;
            ArrayList<Component> arrayList2 = new ArrayList<Component>();
            DTNestingContainer.getHeavyweights(component5, arrayList2);
            DTNestingContainer.setHeavyweightsVisible(arrayList2, false);
            arrayList.addAll(arrayList2);
            ((DTContainer)((Object)container2)).replaceChild((Component)((Object)dTSplitPane), component5);
            if (component5 instanceof DTTabbedPane) {
                ((DTTabbedPane)((Object)component5)).refresh();
            }
            container = container2;
        } else if (container instanceof DTTabbedPane) {
            DTTabbedPane dTTabbedPane = (DTTabbedPane)((Object)container);
            DTInternalFrame dTInternalFrame = (DTInternalFrame)dTContainer;
            dTTabbedPane.remove(dTInternalFrame.getOccupant());
            dTInternalFrame.setTitleBarVisible(!dTInternalFrame.getOccupant().hideTitleWhenDocked());
            if (dTTabbedPane.getTabCount() == 1) {
                Component component6 = dTTabbedPane.getComponentAt(0);
                DTInternalFrame dTInternalFrame2 = (DTInternalFrame)((Object)component6);
                DTOccupant dTOccupant = dTInternalFrame2.getOccupant();
                dTTabbedPane.remove(dTOccupant);
                dTInternalFrame2.setTitleBarVisible(!dTOccupant.hideTitleWhenDocked());
                if (!this.fIsClearing && dTOccupant instanceof DTClient) {
                    dTOccupant.prepareToShow();
                }
                component6.setVisible(true);
                Container container3 = dTTabbedPane.getParent();
                ArrayList<Component> arrayList3 = new ArrayList<Component>();
                DTNestingContainer.getHeavyweights(component6, arrayList3);
                DTNestingContainer.setHeavyweightsVisible(arrayList3, false);
                arrayList.addAll(arrayList3);
                ((DTContainer)((Object)container3)).replaceChild((Component)((Object)dTTabbedPane), component6);
                container = container3;
            }
        } else if (container instanceof DTNestingContainer) {
            ((DTContainer)((Object)container)).replaceChild(component2, null);
        }
        this.updateOccupantLocations(container);
        if (component != null && component.isShowing() && SwingUtilities.isDescendingFrom(component, (Component)((Object)this))) {
            component.requestFocusInWindow();
        }
        container.invalidate();
        container.validate();
        container.repaint();
        component2.setVisible(true);
        DTNestingContainer.setHeavyweightsVisible(arrayList, true);
        if (arrayList.size() > 0) {
            DTNestingContainer.refreshTabPanes((Component)((Object)this));
        }
    }

    private static void getHeavyweights(Component component, List<Component> list) {
        if (!(component instanceof JComponent) && !(component instanceof BasicSplitPaneDivider) && component.isVisible()) {
            list.add(component);
        }
        if (component instanceof Container && component.isVisible()) {
            int n = ((Container)component).getComponentCount();
            for (int i = 0; i < n; ++i) {
                DTNestingContainer.getHeavyweights(((Container)component).getComponent(i), list);
            }
        }
    }

    private static void setHeavyweightsVisible(List<Component> list, boolean bl) {
        for (Component component : list) {
            component.setVisible(bl);
        }
    }

    private static void shrinkHeavyweights(List<Component> list) {
        for (Component component : list) {
            if (!(component instanceof Canvas)) continue;
            component.setSize(10, 10);
        }
    }

    private static void refreshTabPanes(Component component) {
        if (component instanceof DTTabbedPane) {
            ((DTTabbedPane)((Object)component)).refresh();
        } else if (component instanceof DTSplitPane) {
            DTSplitPane dTSplitPane = (DTSplitPane)((Object)component);
            DTNestingContainer.refreshTabPanes(dTSplitPane.getLeftComponent());
            DTNestingContainer.refreshTabPanes(dTSplitPane.getRightComponent());
        } else if (component instanceof DTNestingContainer) {
            DTNestingContainer.refreshTabPanes((Component)((Object)((DTNestingContainer)((Object)component)).fChild));
        }
    }

    private void updateOccupantLocations(Container container) {
        if (this.fIsRemovingMultiple) {
            return;
        }
        DTNestedLocation dTNestedLocation = new DTNestedLocation();
        dTNestedLocation.setContainer(this);
        dTNestedLocation.setFrame(this.fFrame);
        DTNestedLocation dTNestedLocation2 = this.getAncestry(container, dTNestedLocation);
        this.setDescendantLocations(container, dTNestedLocation2);
    }

    private DTNestedLocation getAncestry(Component component, DTNestedLocation dTNestedLocation) {
        Container container = component.getParent();
        if (container instanceof DTSplitPane) {
            dTNestedLocation = this.getAncestry(container, dTNestedLocation);
            DTSplitPane dTSplitPane = (DTSplitPane)((Object)container);
            int n = dTSplitPane.getOrientation() == 1 ? (dTSplitPane.getLeftComponent() == component ? 7 : 3) : (dTSplitPane.getTopComponent() == component ? 1 : 5);
            dTNestedLocation = dTNestedLocation.append(n);
        }
        return dTNestedLocation;
    }

    private void setDescendantLocations(Component component, DTNestedLocation dTNestedLocation) {
        if (component instanceof DTSplitPane) {
            int n;
            int n2;
            DTSplitPane dTSplitPane = (DTSplitPane)((Object)component);
            int n3 = dTSplitPane.getOrientation();
            if (n3 == 1) {
                n2 = 7;
                n = 3;
            } else {
                n2 = 1;
                n = 5;
            }
            this.setDescendantLocations(dTSplitPane.getLeftComponent(), dTNestedLocation.append(n2));
            this.setDescendantLocations(dTSplitPane.getRightComponent(), dTNestedLocation.append(n));
        } else if (component instanceof DTTabbedPane) {
            DTTabbedPane dTTabbedPane = (DTTabbedPane)((Object)component);
            dTNestedLocation = dTNestedLocation.append(2);
            for (int i = 0; i < dTTabbedPane.getTabCount(); ++i) {
                DTNestedLocation dTNestedLocation2 = new DTNestedLocation(dTNestedLocation);
                dTNestedLocation2.setTabIndex(i);
                this.setDescendantLocations(dTTabbedPane.getComponentAt(i), dTNestedLocation2);
            }
        } else if (component instanceof DTInternalFrame) {
            DTInternalFrame dTInternalFrame = (DTInternalFrame)((Object)component);
            if (dTInternalFrame.getOccupant() instanceof DTClient || this.fFrame.isMainFrame()) {
                DTLocation dTLocation = dTInternalFrame.getOccupant().getLocation();
                if (dTLocation != null) {
                    dTNestedLocation.setFrameBounds(dTLocation.getFrameBounds());
                }
                dTInternalFrame.getOccupant().setLocation(dTNestedLocation);
            }
        } else if (component instanceof DTNestingContainer) {
            this.setDescendantLocations((Component)((Object)this.fChild), dTNestedLocation);
        }
    }

    private void updateBounds(Component component) {
        if (component instanceof DTSplitPane) {
            DTSplitPane dTSplitPane = (DTSplitPane)((Object)component);
            this.updateBounds(dTSplitPane.getLeftComponent());
            this.updateBounds(dTSplitPane.getRightComponent());
        } else if (component instanceof DTTabbedPane) {
            DTTabbedPane dTTabbedPane = (DTTabbedPane)((Object)component);
            for (int i = 0; i < dTTabbedPane.getTabCount(); ++i) {
                this.updateBounds(dTTabbedPane.getComponentAt(i));
            }
        } else if (component instanceof DTInternalFrame) {
            DTInternalFrame dTInternalFrame = (DTInternalFrame)((Object)component);
            DTLocation dTLocation = dTInternalFrame.getOccupant().getLocation();
            if (dTLocation instanceof DTNestedLocation) {
                Point point = new Point();
                SwingUtilities.convertPointToScreen(point, (Component)((Object)dTInternalFrame));
                DTNestedLocation dTNestedLocation = (DTNestedLocation)dTLocation;
                dTNestedLocation.setFrameLocation(point.x, point.y);
                dTNestedLocation.setFrameSize(dTInternalFrame.getWidth(), dTInternalFrame.getHeight());
                Container container = component.getParent();
                if (container != null) {
                    dTNestedLocation.setParentSize(container.getWidth(), container.getHeight());
                }
            }
        } else if (component instanceof DTNestingContainer) {
            this.updateBounds((Component)((Object)this.fChild));
        }
    }

    private int getDeepestSplitOrientation(DTNestedLocation dTNestedLocation) {
        int n = dTNestedLocation.getPathLength();
        int n2 = 8;
        if (n > 0) {
            n2 = dTNestedLocation.getDirection(n - 1);
        }
        switch (n2) {
            case 1: 
            case 5: {
                return 0;
            }
            case 3: 
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    @Override
    public DTLocation getDropLocation(Object object, int n, int n2, DTLocation dTLocation) {
        int n3;
        Component component;
        Component component2 = SwingUtilities.getDeepestComponentAt((Component)((Object)this), n, n2);
        if (component2 == null) {
            return null;
        }
        Container container = SwingUtilities.getAncestorOfClass(DTNestingContainer.class, component2);
        if (container == null) {
            return null;
        }
        if (container != this) {
            component2 = container.getParent();
        }
        RelativeLocation relativeLocation = dTLocation instanceof RelativeLocation ? (RelativeLocation)dTLocation : new RelativeLocation();
        relativeLocation.setContainer(null);
        relativeLocation.fDirection = -1;
        DTInternalFrame dTInternalFrame = ((DTOccupant)object).getInternalFrame();
        DTTitleBar dTTitleBar = null;
        if (component2 instanceof DTTitleBar) {
            dTTitleBar = (DTTitleBar)component2;
        } else if (component2.getParent() instanceof DTTitleBar) {
            dTTitleBar = (DTTitleBar)component2.getParent();
        }
        if (dTTitleBar != null) {
            Container container2 = SwingUtilities.getAncestorOfClass(DTContainer.class, dTTitleBar);
            if (container2 == dTInternalFrame) {
                relativeLocation.setContainer(dTInternalFrame);
                relativeLocation.fDirection = 0;
                return relativeLocation;
            }
            component = container2.getParent();
            if (component instanceof DTSplitPane || component instanceof DTTabbedPane || component == this) {
                relativeLocation.setContainer((DTContainer)((Object)container2));
                relativeLocation.fDirection = 2;
                return relativeLocation;
            }
        }
        if ((n3 = this.getProximity(n, n2, this.getWidth(), this.getHeight(), 0.15f, 40)) != 2) {
            relativeLocation.setContainer(this);
            relativeLocation.fDirection = n3;
            return relativeLocation;
        }
        component = null;
        Component component3 = component2;
        for (Container container3 = component2.getParent(); container3 != null && !(container3 instanceof DTNestingContainer); container3 = container3.getParent()) {
            if (container3 instanceof DTGroupFrame) {
                component = container3.getParent() instanceof DTTabbedPane ? container3.getParent() : container3;
            } else if (container3 instanceof DTClientFrame && container3.getParent() instanceof DTNestingContainer) {
                component = container3;
            } else if (container3 instanceof DTTabbedPane) {
                component = container3;
            } else if (container3 instanceof DTSplitPane && component3 instanceof DTClientFrame) {
                component = component3;
            } else if (this.fGroup != null && container3 instanceof DTDocumentContainer) {
                component = container3;
            }
            if (component != null) {
                relativeLocation.setContainer((DTContainer)((Object)component));
                if (component == dTInternalFrame) {
                    relativeLocation.fDirection = 0;
                } else {
                    this.fScratchPoint.x = n;
                    this.fScratchPoint.y = n2;
                    this.fScratchPoint = SwingUtilities.convertPoint((Component)((Object)this), this.fScratchPoint, component);
                    relativeLocation.fDirection = this.getProximity(this.fScratchPoint.x, this.fScratchPoint.y, component.getWidth(), component.getHeight(), 0.25f, 100);
                    if (relativeLocation.fDirection == 2 && component instanceof DTDocumentContainer) {
                        relativeLocation.fDirection = 8;
                    }
                }
                return relativeLocation;
            }
            component3 = container3;
        }
        return relativeLocation;
    }

    private int getProximity(int n, int n2, int n3, int n4, float f, int n5) {
        boolean bl;
        int n6 = (int)(f * (float)n3);
        int n7 = (int)(f * (float)n4);
        if (n6 > n5) {
            n6 = n5;
        }
        if (n7 > n5) {
            n7 = n5;
        }
        if (n > n6 && n < n3 - n6 && n2 > n7 && n2 < n4 - n7) {
            return 2;
        }
        int n8 = n4 * n;
        int n9 = n3 * n2;
        boolean bl2 = n8 > n9;
        boolean bl3 = bl = n8 < n4 * n3 - n9;
        if (bl2) {
            return bl ? 1 : 3;
        }
        return bl ? 7 : 5;
    }

    @Override
    public String getDropHint(Object object, DTLocation dTLocation) {
        if (dTLocation == null || dTLocation.getContainer() == null) {
            return null;
        }
        switch (((RelativeLocation)dTLocation).fDirection) {
            case 1: {
                return DTDragUtilities.getToNorth(object);
            }
            case 5: {
                return DTDragUtilities.getToSouth(object);
            }
            case 3: {
                return DTDragUtilities.getToEast(object);
            }
            case 7: {
                return DTDragUtilities.getToWest(object);
            }
            case 0: {
                return DTDragUtilities.getToLeaveHint(object);
            }
            case 2: {
                return DTDragUtilities.getToTab(object);
            }
        }
        return null;
    }

    @Override
    public void drawDropOutline(DTLocation dTLocation) {
        if (dTLocation == null || dTLocation.getContainer() == null) {
            return;
        }
        RelativeLocation relativeLocation = (RelativeLocation)dTLocation;
        Component component = (Component)((Object)dTLocation.getContainer());
        if (component.getParent() instanceof DTTabbedPane) {
            component = component.getParent();
        }
        int n = component.getWidth();
        int n2 = component.getHeight();
        DTDropOutlinePainter dTDropOutlinePainter = DTDragUtilities.getDropOutlinePainter();
        switch (relativeLocation.fDirection) {
            case 1: {
                dTDropOutlinePainter.show(component, 0, 0, n, n2 >> 1, DTDropOutlinePainter.OutlineType.RECTANGLE);
                break;
            }
            case 5: {
                int n3 = n2 >> 1;
                dTDropOutlinePainter.show(component, 0, n3, n, n2 - n3, DTDropOutlinePainter.OutlineType.RECTANGLE);
                break;
            }
            case 3: {
                int n4 = n >> 1;
                dTDropOutlinePainter.show(component, n4, 0, n - n4, n2, DTDropOutlinePainter.OutlineType.RECTANGLE);
                break;
            }
            case 7: {
                dTDropOutlinePainter.show(component, 0, 0, n >> 1, n2, DTDropOutlinePainter.OutlineType.RECTANGLE);
                break;
            }
            case 0: {
                dTDropOutlinePainter.show(component, 0, 0, n, n2, DTDropOutlinePainter.OutlineType.RECTANGLE);
                break;
            }
            case 2: {
                dTDropOutlinePainter.show(component, 0, 0, n, n2, DTDropOutlinePainter.OutlineType.TABBED_RECTANGLE);
            }
        }
    }

    @Override
    public void drop(Object object, DTLocation dTLocation) {
        Object object2;
        PropertyChangeListener propertyChangeListener;
        if (dTLocation == null || dTLocation.getContainer() == null) {
            return;
        }
        RelativeLocation relativeLocation = (RelativeLocation)dTLocation;
        if (relativeLocation.fDirection == 8 || relativeLocation.fDirection == 0) {
            return;
        }
        DTInternalFrame dTInternalFrame = ((DTOccupant)object).getInternalFrame();
        if (object instanceof DTClient) {
            ((DTClient)object).saveFocus();
        }
        DTContainer dTContainer = relativeLocation.getContainer();
        DTContainer dTContainer2 = DTNestingContainer.getDTContainerAncestor(dTInternalFrame);
        if (object instanceof DTOccupant) {
            propertyChangeListener = (DTOccupant)object;
            object2 = ((DTOccupant)propertyChangeListener).getLocation();
            if (dTContainer2 instanceof DTSplitPane && object2 instanceof DTNestedLocation) {
                DTSplitPane dTSplitPane = (DTSplitPane)dTContainer2;
                Component component = dTSplitPane.getOtherComponent((Component)((Object)dTInternalFrame));
                DTNestedLocation dTNestedLocation = (DTNestedLocation)object2;
                if (component == dTContainer && relativeLocation.fDirection == dTNestedLocation.getDirection(dTNestedLocation.getPathLength() - 1)) {
                    return;
                }
            }
            if (object2 != null && ((DTLocation)object2).isMinimized()) {
                ((DTOccupant)propertyChangeListener).setLastNestedLocation(this.getAbsoluteLocation(relativeLocation));
                this.fDesktop.setOccupantMinimized((DTOccupant)propertyChangeListener, false, 0);
                return;
            }
        }
        if (SwingUtilities.isDescendingFrom((Component)((Object)dTContainer2), (Component)((Object)this))) {
            if (dTContainer instanceof DTTabbedPane && dTContainer == dTContainer2 && (propertyChangeListener = (DTTabbedPane)dTContainer).getTabCount() == 2) {
                object2 = (DTContainer)((Object)propertyChangeListener.getComponentAt(0));
                if (object2 == dTInternalFrame) {
                    object2 = (DTContainer)((Object)propertyChangeListener.getComponentAt(1));
                }
                relativeLocation.setContainer((DTContainer)object2);
            }
            this.removeContainer(dTInternalFrame);
        }
        if (dTContainer == this) {
            relativeLocation.setContainer(this.fChild);
        }
        this.addContainer(dTInternalFrame, relativeLocation, null);
        if (((Component)((Object)dTInternalFrame)).getParent() instanceof DTTabbedPane && (propertyChangeListener = (DTTabbedPane)((Object)((Component)((Object)dTInternalFrame)).getParent())).getSelectedComponent() != dTInternalFrame) {
            propertyChangeListener.setSelectedComponent((Component)((Object)dTInternalFrame));
        }
        if (object instanceof DTOccupant) {
            ((DTOccupant)object).requestFocusLater();
        }
    }

    private static DTContainer getDTContainerAncestor(DTContainer dTContainer) {
        Component component = (Component)((Object)dTContainer);
        while (component != null) {
            Container container = component.getParent();
            if (container instanceof DTContainer) {
                return (DTContainer)((Object)container);
            }
            component = container;
        }
        return null;
    }

    void startDrag(Object object, Component component) {
        new Dragger(object, component);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        DTInternalFrame dTInternalFrame;
        if (itemEvent.getStateChange() == 1 && (dTInternalFrame = (DTInternalFrame)itemEvent.getItem()) != null) {
            this.ensureVisible(dTInternalFrame.getOccupant(), DTContainer.Scope.FRAME);
        }
    }

    private void ensureVisible(DTOccupant dTOccupant, DTContainer.Scope scope) {
        if (scope == DTContainer.Scope.FRAME) {
            if (this.fGroup != null) {
                if (this.fGroup.hasInternalFrame()) {
                    this.fGroup.getGroupFrame().revealNestingContainer();
                }
            } else if (this.fFrame != null) {
                this.fFrame.revealNestingContainer();
            }
        }
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        Dimension dimension = dTInternalFrame.getMinimumVisibleSize();
        this.ensureVisible((Component)((Object)dTInternalFrame), dimension.width, dimension.height);
    }

    private void ensureVisible(Component component, int n, int n2) {
        if (component.getWidth() < n || component.getHeight() < n2) {
            int n3;
            int n4;
            Serializable serializable;
            DTContainer dTContainer;
            Container container = component.getParent();
            int n5 = 0;
            int n6 = 0;
            if (container == null || container instanceof DTNestingContainer) {
                return;
            }
            if (container instanceof DTSplitPane) {
                dTContainer = (DTSplitPane)((Object)container);
                serializable = ((DTSplitPane)dTContainer).getOtherComponent(component);
                if (dTContainer.getOrientation() == 0) {
                    n6 = dTContainer.getDividerSize() + serializable.getMinimumSize().height;
                } else {
                    n5 = dTContainer.getDividerSize() + serializable.getMinimumSize().width;
                }
            } else if (container instanceof DTTabbedPane) {
                dTContainer = (DTTabbedPane)((Object)container);
                serializable = null;
                n4 = dTContainer.getTabCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    Rectangle rectangle = dTContainer.getBoundsAt(n3);
                    if (rectangle == null) continue;
                    serializable = serializable == null ? rectangle : ((Rectangle)serializable).union(rectangle);
                }
                if (serializable != null) {
                    if (dTContainer.getTabPlacement() == 1 || dTContainer.getTabPlacement() == 3) {
                        n6 = ((Rectangle)serializable).height;
                    } else {
                        n5 = ((Rectangle)serializable).width;
                    }
                }
            }
            this.ensureVisible(container, n + n5, n2 + n6);
            if (container instanceof DTSplitPane) {
                dTContainer = (DTSplitPane)((Object)container);
                boolean bl = false;
                if (dTContainer.getOrientation() == 0) {
                    n3 = dTContainer.getHeight() - dTContainer.getDividerSize();
                    if (n3 > 0) {
                        if (component == dTContainer.getBottomComponent()) {
                            if (n3 - dTContainer.getDividerLocation() < n2) {
                                n4 = n3 - n2;
                                if (n4 < 0) {
                                    n4 = 0;
                                }
                                dTContainer.setDividerLocation(n4);
                                bl = true;
                            }
                        } else if (dTContainer.getDividerLocation() < n2) {
                            dTContainer.setDividerLocation(Math.min(n3, n2));
                            bl = true;
                        }
                    }
                } else {
                    n3 = dTContainer.getWidth() - dTContainer.getDividerSize();
                    if (n3 > 0) {
                        if (component == dTContainer.getRightComponent()) {
                            if (n3 - dTContainer.getDividerLocation() < n) {
                                n4 = n3 - n;
                                if (n4 < 0) {
                                    n4 = 0;
                                }
                                dTContainer.setDividerLocation(n4);
                                bl = true;
                            }
                        } else if (dTContainer.getDividerLocation() < n) {
                            dTContainer.setDividerLocation(Math.min(n3, n));
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    ((DTSplitPane)dTContainer).doLayout();
                }
            }
        }
    }

    Object getState(boolean bl) {
        return new RootState(this.fChild, bl, false);
    }

    void restoreState(Object object) {
        this.fIsRestoring = true;
        DTContainer dTContainer = ((RootState)object).restore(this);
        if (dTContainer != null) {
            this.replaceChild((Component)((Object)this.fChild), (Component)((Object)dTContainer));
            this.updateOccupantLocations((Container)((Object)this));
        }
        this.fIsRestoring = false;
    }

    static Element stateToXML(Object object, Document document) {
        return ((RootState)object).toXML(document);
    }

    static Object stateFromXML(SimpleElement simpleElement) throws DataFormatException {
        return new RootState(simpleElement);
    }

    private static TreeState createChildState(DTContainer dTContainer, boolean bl, boolean bl2) {
        if (dTContainer instanceof DTSplitPane) {
            return new SplitState((DTSplitPane)dTContainer, bl, bl2);
        }
        if (dTContainer instanceof DTTabbedPane) {
            return new TabState((DTTabbedPane)dTContainer, bl2);
        }
        if (dTContainer instanceof DTGroupFrame) {
            return new GroupState((DTGroupFrame)dTContainer, bl2);
        }
        if (dTContainer instanceof DTDocumentContainer) {
            return new DocumentsState((DTDocumentContainer)dTContainer, bl2);
        }
        if (dTContainer instanceof DTClientFrame) {
            return new ViewState((DTClientFrame)dTContainer, bl2);
        }
        return null;
    }

    private static TreeState createChildState(SimpleElement simpleElement) throws DataFormatException {
        if (simpleElement == null) {
            return null;
        }
        String string = simpleElement.getTagName();
        if (string.equals(SPLIT_TAG)) {
            return new SplitState(simpleElement);
        }
        if (string.equals(TABBED_TAG)) {
            return new TabState(simpleElement);
        }
        if (string.equals(GROUP_TAG)) {
            return new GroupState(simpleElement);
        }
        if (string.equals(DOCUMENTS_TAG)) {
            return new DocumentsState(simpleElement);
        }
        if (string.equals(VIEW_TAG)) {
            return new ViewState(simpleElement);
        }
        return null;
    }

    private static class ViewState
    extends TreeState {
        String fName;
        String fTitle;

        ViewState(DTClientFrame dTClientFrame, boolean bl) {
            if (bl) {
                this.fPeer = dTClientFrame;
            }
            this.fName = dTClientFrame.getClient().getName();
            this.fTitle = dTClientFrame.getClient().getShortTitle();
        }

        ViewState(SimpleElement simpleElement) {
            if (simpleElement.hasAttribute(DTNestingContainer.TITLE_ATTRIBUTE)) {
                this.fTitle = simpleElement.getAttribute(DTNestingContainer.TITLE_ATTRIBUTE);
            }
            this.fName = simpleElement.hasAttribute(DTNestingContainer.NAME_ATTRIBUTE) ? simpleElement.getAttribute(DTNestingContainer.NAME_ATTRIBUTE) : this.fTitle;
        }

        @Override
        Element toXML(Document document) {
            Element element = document.createElement(DTNestingContainer.VIEW_TAG);
            element.setAttribute(DTNestingContainer.NAME_ATTRIBUTE, this.fName);
            element.setAttribute(DTNestingContainer.TITLE_ATTRIBUTE, this.fTitle);
            return element;
        }

        @Override
        DTContainer restore(DTNestingContainer dTNestingContainer, boolean bl) {
            String string;
            Desktop desktop = dTNestingContainer.fDesktop;
            DTClient dTClient = desktop.getSingleton(this.fName, string = dTNestingContainer.fGroup == null ? null : dTNestingContainer.fGroup.getName());
            if (dTClient == null) {
                if (!desktop.hadClient(this.fName, string)) {
                    Object[] objectArray = new Object[]{this.fName};
                    String string2 = MessageFormat.format(dTNestingContainer.fDesktop.getString("error.ClassNotSpecified"), objectArray);
                    desktop.getErrorReportingStream().println(string2);
                }
                return null;
            }
            if (bl) {
                dTClient.createSurrogateComponent();
            } else {
                dTClient.prepareToShow();
            }
            DTLocation dTLocation = null;
            if (dTClient.getLastLocation() != null && !(dTClient.getLastLocation() instanceof DTNestedLocation)) {
                dTLocation = DTLocation.create("N");
            }
            desktop.setClientShowing(dTClient, true, dTLocation, false);
            if (dTClient.getComponent() == null) {
                return null;
            }
            if (dTClient.getInternalFrame().getParent() != null) {
                Object[] objectArray = new Object[]{this.fName};
                String string3 = MessageFormat.format(dTNestingContainer.fDesktop.getString("error.DuplicationInLayout"), objectArray);
                desktop.getErrorReportingStream().println(string3);
                return null;
            }
            return dTClient.getInternalFrame();
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeState getChild(int n) {
            return null;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ViewState && this.fName.equals(((ViewState)object).fName);
        }
    }

    private static class DocumentsState
    extends TreeState {
        String fTitle;
        String fName;

        DocumentsState(DTDocumentContainer dTDocumentContainer, boolean bl) {
            DTGroup dTGroup;
            if (bl) {
                this.fPeer = dTDocumentContainer;
            }
            this.fName = (dTGroup = dTDocumentContainer.getGroup()) != null ? dTGroup.getName() : DTNestingContainer.SHARED_DOCUMENTS;
            this.fTitle = dTGroup != null ? dTGroup.getTitle() : DTNestingContainer.SHARED_DOCUMENTS;
        }

        DocumentsState(SimpleElement simpleElement) {
            if (simpleElement.hasAttribute(DTNestingContainer.TITLE_ATTRIBUTE)) {
                this.fTitle = simpleElement.getAttribute(DTNestingContainer.TITLE_ATTRIBUTE);
            }
            this.fName = simpleElement.hasAttribute(DTNestingContainer.NAME_ATTRIBUTE) ? simpleElement.getAttribute(DTNestingContainer.NAME_ATTRIBUTE) : this.fTitle;
        }

        @Override
        Element toXML(Document document) {
            Element element = document.createElement(DTNestingContainer.DOCUMENTS_TAG);
            element.setAttribute(DTNestingContainer.NAME_ATTRIBUTE, this.fName);
            element.setAttribute(DTNestingContainer.TITLE_ATTRIBUTE, this.fTitle);
            return element;
        }

        @Override
        DTContainer restore(DTNestingContainer dTNestingContainer, boolean bl) {
            DTMultipleClientFrame dTMultipleClientFrame = dTNestingContainer.fFrame;
            Desktop desktop = dTNestingContainer.fDesktop;
            if (dTNestingContainer.fGroup == null && desktop.getMajorVersionBeingRestored() <= 2) {
                return new GroupState(this.fTitle).restore(dTNestingContainer, bl);
            }
            int n = desktop.getDocumentContainment();
            if (DTNestingContainer.SHARED_DOCUMENTS.equals(this.fName) || this.fName == null || this.fName.length() == 0) {
                return n == 1 ? dTNestingContainer.fFrame.getSharedDocumentContainer() : null;
            }
            if (dTMultipleClientFrame == null || !((DTFrame)dTMultipleClientFrame).isMainFrame() || n == 2) {
                DTGroup dTGroup = desktop.getGroup(this.fName);
                return dTGroup != null ? dTGroup.getDocumentContainer() : null;
            }
            return null;
        }

        @Override
        int getChildCount() {
            return 0;
        }

        @Override
        TreeState getChild(int n) {
            return null;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof DocumentsState && this.fName.equals(((DocumentsState)object).fName);
        }
    }

    private static class GroupState
    extends TreeState {
        String fName;
        String fTitle;

        GroupState(DTGroupFrame dTGroupFrame, boolean bl) {
            DTGroup dTGroup;
            if (bl) {
                this.fPeer = dTGroupFrame;
            }
            this.fName = (dTGroup = dTGroupFrame.getGroup()) != null ? dTGroup.getName() : DTNestingContainer.SHARED_DOCUMENTS;
            this.fTitle = dTGroup != null ? dTGroup.getTitle() : DTNestingContainer.SHARED_DOCUMENTS;
        }

        GroupState(SimpleElement simpleElement) {
            if (simpleElement.hasAttribute(DTNestingContainer.TITLE_ATTRIBUTE)) {
                this.fTitle = simpleElement.getAttribute(DTNestingContainer.TITLE_ATTRIBUTE);
            }
            this.fName = simpleElement.hasAttribute(DTNestingContainer.NAME_ATTRIBUTE) ? simpleElement.getAttribute(DTNestingContainer.NAME_ATTRIBUTE) : this.fTitle;
        }

        GroupState(String string) {
            this.fName = string;
            this.fTitle = string;
        }

        @Override
        Element toXML(Document document) {
            Element element = document.createElement(DTNestingContainer.GROUP_TAG);
            element.setAttribute(DTNestingContainer.NAME_ATTRIBUTE, this.fName);
            element.setAttribute(DTNestingContainer.TITLE_ATTRIBUTE, this.fTitle);
            return element;
        }

        @Override
        DTContainer restore(DTNestingContainer dTNestingContainer, boolean bl) {
            DTMultipleClientFrame dTMultipleClientFrame = dTNestingContainer.fFrame;
            Desktop desktop = dTNestingContainer.fDesktop;
            int n = desktop.getDocumentContainment();
            if (DTNestingContainer.SHARED_DOCUMENTS.equals(this.fName) || this.fName == null || this.fName.length() == 0) {
                return n == 1 ? dTNestingContainer.fFrame.getSharedDocuments().getDocumentsFrame() : null;
            }
            if (!((DTFrame)dTMultipleClientFrame).isMainFrame() || n == 2) {
                DTGroup dTGroup = desktop.getGroup(this.fName);
                if (dTGroup == null) {
                    return null;
                }
                DTInternalFrame dTInternalFrame = dTGroup.getInternalFrame();
                dTNestingContainer.fFrame.addGroup(dTGroup, null);
                return dTInternalFrame;
            }
            return null;
        }

        @Override
        int getChildCount() {
            return 0;
        }

        @Override
        TreeState getChild(int n) {
            return null;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof GroupState && this.fName.equals(((GroupState)object).fName);
        }
    }

    private static class TabState
    extends TreeState {
        int fTabPlacement;
        int fSelectedIndex;
        List<TreeState> fChildren = new ArrayList<TreeState>();

        TabState(DTTabbedPane dTTabbedPane, boolean bl) {
            if (bl) {
                this.fPeer = dTTabbedPane;
            }
            this.fTabPlacement = dTTabbedPane.getTabPlacement();
            this.fSelectedIndex = dTTabbedPane.getSelectedIndex();
            int n = dTTabbedPane.getTabCount();
            for (int i = 0; i < n; ++i) {
                TreeState treeState = DTNestingContainer.createChildState((DTContainer)((Object)dTTabbedPane.getComponentAt(i)), false, bl);
                treeState.setParent(this);
                this.fChildren.add(treeState);
            }
        }

        TabState(SimpleElement simpleElement) throws DataFormatException {
            String string = simpleElement.getAttribute(DTNestingContainer.PLACEMENT_ATTRIBUTE);
            if (DTNestingContainer.TOP_VALUE.equalsIgnoreCase(string)) {
                this.fTabPlacement = 1;
            } else if (DTNestingContainer.BOTTOM_VALUE.equalsIgnoreCase(string)) {
                this.fTabPlacement = 3;
            } else if (DTNestingContainer.LEFT_VALUE.equalsIgnoreCase(string)) {
                this.fTabPlacement = 2;
            } else if (DTNestingContainer.RIGHT_VALUE.equalsIgnoreCase(string)) {
                this.fTabPlacement = 4;
            } else {
                throw new DataFormatException("Unrecognized Placement: " + string);
            }
            String string2 = simpleElement.getAttribute(DTNestingContainer.SELECTED_ATTRIBUTE);
            try {
                this.fSelectedIndex = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Selected: " + string2);
            }
            SimpleNodeList simpleNodeList = simpleElement.getChildNodes();
            int n = simpleNodeList.getLength();
            for (int i = 0; i < n; ++i) {
                TreeState treeState = DTNestingContainer.createChildState((SimpleElement)simpleNodeList.item(i));
                treeState.setParent(this);
                this.fChildren.add(treeState);
            }
            if (this.fSelectedIndex < 0 || this.fSelectedIndex >= this.fChildren.size()) {
                throw new DataFormatException("Invalid Selected: " + string2);
            }
        }

        @Override
        Element toXML(Document document) {
            Element element = document.createElement(DTNestingContainer.TABBED_TAG);
            String string = null;
            switch (this.fTabPlacement) {
                case 1: {
                    string = DTNestingContainer.TOP_VALUE;
                    break;
                }
                case 3: {
                    string = DTNestingContainer.BOTTOM_VALUE;
                    break;
                }
                case 2: {
                    string = DTNestingContainer.LEFT_VALUE;
                    break;
                }
                case 4: {
                    string = DTNestingContainer.RIGHT_VALUE;
                }
            }
            element.setAttribute(DTNestingContainer.PLACEMENT_ATTRIBUTE, string);
            element.setAttribute(DTNestingContainer.SELECTED_ATTRIBUTE, Integer.toString(this.fSelectedIndex));
            int n = this.fChildren.size();
            for (int i = 0; i < n; ++i) {
                TreeState treeState = this.fChildren.get(i);
                element.appendChild(treeState.toXML(document));
            }
            return element;
        }

        @Override
        DTContainer restore(DTNestingContainer dTNestingContainer, boolean bl) {
            DTTabbedPane dTTabbedPane = new DTTabbedPane(this.fTabPlacement);
            int n = this.fChildren.size();
            for (int i = 0; i < n; ++i) {
                TreeState treeState = this.fChildren.get(i);
                DTContainer dTContainer = treeState.restore(dTNestingContainer, i != this.fSelectedIndex);
                if (dTContainer == null) continue;
                dTTabbedPane.add(((DTInternalFrame)dTContainer).getOccupant(), null);
            }
            if (this.fSelectedIndex < dTTabbedPane.getTabCount()) {
                dTTabbedPane.ignoreSelection(true);
                dTTabbedPane.setSelectedIndex(this.fSelectedIndex);
                dTTabbedPane.ignoreSelection(false);
            }
            dTTabbedPane.allRestored();
            return dTTabbedPane;
        }

        @Override
        int getChildCount() {
            return this.fChildren.size();
        }

        @Override
        TreeState getChild(int n) {
            return this.fChildren.get(n);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof TabState && super.equals(object);
        }
    }

    private static class SplitState
    extends TreeState {
        int fOrientation;
        int fDividerPosition = -1;
        double fDividerFraction = -1.0;
        TreeState fLeftChild;
        TreeState fRightChild;

        SplitState(DTSplitPane dTSplitPane, boolean bl, boolean bl2) {
            if (bl2) {
                this.fPeer = dTSplitPane;
            }
            this.fOrientation = dTSplitPane.getOrientation();
            if (bl) {
                int n;
                int n2 = n = this.fOrientation == 0 ? dTSplitPane.getHeight() : dTSplitPane.getWidth();
                this.fDividerFraction = n == 0 ? 0.0 : ((double)dTSplitPane.getDividerLocation() + 0.5) / (double)n;
            } else {
                this.fDividerPosition = dTSplitPane.getDividerLocation();
            }
            this.fLeftChild = DTNestingContainer.createChildState((DTContainer)((Object)dTSplitPane.getLeftComponent()), bl, bl2);
            this.fRightChild = DTNestingContainer.createChildState((DTContainer)((Object)dTSplitPane.getRightComponent()), bl, bl2);
            this.fLeftChild.setParent(this);
            this.fRightChild.setParent(this);
        }

        SplitState(SimpleElement simpleElement) throws DataFormatException {
            int n;
            String string = simpleElement.getAttribute(DTNestingContainer.ORIENTATION_ATTRIBUTE);
            if (DTNestingContainer.TOP_BOTTOM_VALUE.equalsIgnoreCase(string)) {
                this.fOrientation = 0;
            } else if (DTNestingContainer.LEFT_RIGHT_VALUE.equalsIgnoreCase(string)) {
                this.fOrientation = 1;
            } else {
                throw new DataFormatException("Unrecognized Orientation: " + string);
            }
            String string2 = simpleElement.getAttribute(DTNestingContainer.POSITION_ATTRIBUTE);
            if (string2 != null) {
                try {
                    if (string2.indexOf(46) == -1) {
                        this.fDividerPosition = Integer.parseInt(string2);
                    } else {
                        this.fDividerFraction = Double.parseDouble(string2);
                        if (this.fDividerFraction < 0.0 || this.fDividerFraction > 1.0) {
                            throw new DataFormatException("Invalid Position: " + string2);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid Position: " + string2);
                }
            }
            SimpleNodeList simpleNodeList = simpleElement.getChildNodes();
            int n2 = simpleNodeList.getLength();
            for (n = 0; n < n2 && this.fLeftChild == null; ++n) {
                this.fLeftChild = DTNestingContainer.createChildState((SimpleElement)simpleNodeList.item(n));
                this.fLeftChild.setParent(this);
            }
            while (n < n2 && this.fRightChild == null) {
                this.fRightChild = DTNestingContainer.createChildState((SimpleElement)simpleNodeList.item(n));
                this.fRightChild.setParent(this);
                ++n;
            }
            if (this.fLeftChild == null || this.fRightChild == null) {
                throw new DataFormatException("Split must have two children");
            }
        }

        @Override
        Element toXML(Document document) {
            Element element = document.createElement(DTNestingContainer.SPLIT_TAG);
            element.setAttribute(DTNestingContainer.ORIENTATION_ATTRIBUTE, this.fOrientation == 0 ? DTNestingContainer.TOP_BOTTOM_VALUE : DTNestingContainer.LEFT_RIGHT_VALUE);
            if (this.fDividerPosition >= 0) {
                element.setAttribute(DTNestingContainer.POSITION_ATTRIBUTE, Integer.toString(this.fDividerPosition));
            } else if (this.fDividerFraction >= 0.0) {
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
                numberFormat.setMaximumFractionDigits(4);
                element.setAttribute(DTNestingContainer.POSITION_ATTRIBUTE, numberFormat.format(this.fDividerFraction));
            }
            element.appendChild(this.fLeftChild.toXML(document));
            element.appendChild(this.fRightChild.toXML(document));
            return element;
        }

        @Override
        DTContainer restore(DTNestingContainer dTNestingContainer, boolean bl) {
            DTSplitPane dTSplitPane = new DTSplitPane(this.fOrientation);
            dTSplitPane.addPropertyChangeListener("dividerLocation", dTNestingContainer.fBoundsListener);
            DTContainer dTContainer = this.fLeftChild.restore(dTNestingContainer, bl);
            DTContainer dTContainer2 = this.fRightChild.restore(dTNestingContainer, bl);
            if (dTContainer == null) {
                return dTContainer2;
            }
            if (dTContainer2 == null) {
                return dTContainer;
            }
            dTSplitPane.setLeftComponent((Component)((Object)dTContainer));
            dTSplitPane.setRightComponent((Component)((Object)dTContainer2));
            if (this.fDividerPosition >= 0) {
                dTSplitPane.setDividerLocation(this.fDividerPosition);
            } else if (this.fDividerFraction >= 0.0) {
                dTSplitPane.setDividerLocation(this.fDividerFraction);
            }
            return dTSplitPane;
        }

        @Override
        int getChildCount() {
            return 2;
        }

        @Override
        TreeState getChild(int n) {
            if (n == 0) {
                return this.fLeftChild;
            }
            if (n == 1) {
                return this.fRightChild;
            }
            return null;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof SplitState && super.equals(object);
        }

        TreeState getSibling(TreeState treeState) {
            if (treeState == this.fLeftChild) {
                return this.fRightChild;
            }
            if (treeState == this.fRightChild) {
                return this.fLeftChild;
            }
            return null;
        }
    }

    private static class RootState
    extends TreeState {
        TreeState fChildState;

        RootState(DTContainer dTContainer, boolean bl, boolean bl2) {
            if (dTContainer != null) {
                this.fChildState = DTNestingContainer.createChildState(dTContainer, bl, bl2);
                this.fChildState.setParent(this);
                if (bl2) {
                    this.fPeer = dTContainer;
                }
            }
        }

        RootState(SimpleElement simpleElement) throws DataFormatException {
            this.fChildState = DTNestingContainer.createChildState(simpleElement);
            this.fChildState.setParent(this);
        }

        @Override
        Element toXML(Document document) {
            if (this.fChildState == null) {
                return null;
            }
            return this.fChildState.toXML(document);
        }

        DTContainer restore(DTNestingContainer dTNestingContainer) {
            return this.restore(dTNestingContainer, false);
        }

        @Override
        DTContainer restore(DTNestingContainer dTNestingContainer, boolean bl) {
            return this.fChildState == null ? null : this.fChildState.restore(dTNestingContainer, bl);
        }

        @Override
        int getChildCount() {
            return this.fChildState == null ? 0 : 1;
        }

        @Override
        TreeState getChild(int n) {
            return this.fChildState;
        }
    }

    static abstract class TreeState {
        TreeState fParent;
        DTContainer fPeer;

        TreeState() {
        }

        abstract Element toXML(Document var1);

        abstract DTContainer restore(DTNestingContainer var1, boolean var2);

        void setParent(TreeState treeState) {
            this.fParent = treeState;
        }

        TreeState getParent() {
            return this.fParent;
        }

        abstract int getChildCount();

        abstract TreeState getChild(int var1);

        public boolean equals(Object object) {
            if (!(object instanceof TreeState)) {
                return false;
            }
            TreeState treeState = (TreeState)object;
            if (this.getChildCount() != treeState.getChildCount()) {
                return false;
            }
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (this.getChild(i).equals(treeState.getChild(i))) continue;
                return false;
            }
            return true;
        }

        TreeState findSubTree(TreeState treeState) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeState treeState2 = this.getChild(i);
                if (treeState2.equals(treeState)) {
                    return treeState2;
                }
                TreeState treeState3 = treeState2.findSubTree(treeState);
                if (treeState3 == null) continue;
                return treeState3;
            }
            return null;
        }
    }

    private class BoundsListener
    extends ComponentAdapter
    implements PropertyChangeListener {
        private BoundsListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (this.shouldUpdateBounds()) {
                DTNestingContainer.this.updateBounds(componentEvent.getComponent());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.shouldUpdateBounds()) {
                DTNestingContainer.this.updateBounds((Component)propertyChangeEvent.getSource());
            }
        }

        private boolean shouldUpdateBounds() {
            return !DTNestingContainer.this.fIsClearing && !DTNestingContainer.this.fIsRestoring;
        }
    }

    private class KeyNavigationAction
    extends MJAbstractAction {
        Object fActionKey;
        boolean fForward;
        boolean fShowing;

        KeyNavigationAction(Object object, boolean bl, boolean bl2) {
            this.fActionKey = object;
            this.fForward = bl;
            this.fShowing = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTSelectable dTSelectable;
            DTSelectable dTSelectable2 = dTSelectable = DTNestingContainer.this.fGroup != null ? DTNestingContainer.this.fGroup.getSelectedClient() : DTNestingContainer.this.fFrame.getSelection();
            if (dTSelectable == null && DTNestingContainer.this.fGroup == null) {
                return;
            }
            DTSelectable dTSelectable3 = this.fForward ? DTNestingContainer.this.getNext(dTSelectable, this.fShowing) : DTNestingContainer.this.getPrevious(dTSelectable, this.fShowing);
            if (DTNestingContainer.this.fFrame.isMainFrame() && DTNestingContainer.this.fGroup != null && (dTSelectable3 == null || dTSelectable3 instanceof DTClient && !((DTClient)dTSelectable3).isSingleton() && dTSelectable instanceof DTClient && ((DTClient)dTSelectable).isSingleton())) {
                Action action;
                DTNestingContainer dTNestingContainer = (DTNestingContainer)((Object)SwingUtilities.getAncestorOfClass(DTNestingContainer.class, (Component)((Object)DTNestingContainer.this.fGroup.getGroupFrame())));
                if (dTNestingContainer != null && (action = dTNestingContainer.getActionMap().get(this.fActionKey)) != null) {
                    action.actionPerformed(actionEvent);
                }
            } else if (dTSelectable3 != null) {
                dTSelectable3.setSelected(true);
            }
        }
    }

    class Dragger
    extends DTDragger {
        BorderInfo fBorderInfo;

        Dragger(Object object, Component component) {
            super(object, component);
            this.fBorderInfo = new BorderInfo();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint(component, point, (Component)((Object)DTNestingContainer.this));
            DTDropTarget dTDropTarget = this.fTarget;
            this.fTarget = null;
            DTLocation dTLocation = this.fPreviousLocation;
            this.fPreviousLocation = this.fDropLocation;
            this.fDropLocation = dTLocation;
            if (this.fBorderInfo.iContainer != null && this.fBorderInfo.iOuterRect.contains(point.x, point.y) && !this.fBorderInfo.iInnerRect.contains(point.x, point.y)) {
                this.fTarget = this.fBorderInfo.iContainer;
                SwingUtilities.convertPoint((Component)((Object)DTNestingContainer.this), point, (Component)((Object)this.fBorderInfo.iContainer));
            } else if (point.x >= 0 && point.x <= DTNestingContainer.this.getWidth() && point.y >= 0 && point.y <= DTNestingContainer.this.getHeight()) {
                this.fTarget = DTNestingContainer.this;
            } else if (this.fLoad instanceof DTClient && ((DTClient)this.fLoad).permitUserUndock()) {
                if (this.fExternalTarget == null) {
                    this.fExternalTarget = new DTExternalTarget(DTNestingContainer.this.fDesktop, (DTClient)this.fLoad);
                }
                this.fTarget = this.fExternalTarget;
                SwingUtilities.convertPointToScreen(point, (Component)((Object)DTNestingContainer.this));
            } else if (this.fLoad instanceof DTGroup && ((DTGroup)this.fLoad).permitUserUndock()) {
                if (this.fExternalTarget == null) {
                    this.fExternalTarget = new DTExternalTarget(DTNestingContainer.this.fDesktop, (DTGroup)this.fLoad);
                }
                this.fTarget = this.fExternalTarget;
                SwingUtilities.convertPointToScreen(point, (Component)((Object)DTNestingContainer.this));
            } else {
                this.fTarget = null;
                this.fDropLocation = null;
                component.setCursor(DragSource.DefaultMoveNoDrop);
                if (dTDropTarget != null) {
                    DTDragUtilities.getDropOutlinePainter().hide(false);
                    DTDragUtilities.showHint(this.fFrame, DTNestingContainer.this.fDesktop.getString("status.MoveDocumentsElsewhere"));
                }
                return;
            }
            this.fDropLocation = this.fTarget.getDropLocation(this.fLoad, point.x, point.y, this.fDropLocation);
            if (this.fDropLocation instanceof RelativeLocation && ((RelativeLocation)this.fDropLocation).fDirection == 8) {
                component.setCursor(DragSource.DefaultMoveNoDrop);
                if (dTDropTarget != null) {
                    DTDragUtilities.getDropOutlinePainter().hide(false);
                    DTDragUtilities.showHint(this.fFrame, DTNestingContainer.this.fDesktop.getString("status.MoveElsewhere"));
                }
            } else {
                component.setCursor(null);
                if (!(this.fPreviousLocation == this.fDropLocation || this.fDropLocation != null && this.fDropLocation.equals(this.fPreviousLocation))) {
                    this.fTarget.drawDropOutline(this.fDropLocation);
                    String string = this.fTarget.getDropHint(this.fLoad, this.fDropLocation);
                    DTDragUtilities.showHint(this.fFrame, string);
                }
            }
        }
    }

    private class RelativeLocation
    extends DTLocation {
        int fDirection;

        private RelativeLocation() {
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof RelativeLocation && super.equals(object) && this.fDirection == ((RelativeLocation)object).fDirection;
        }

        public int hashCode() {
            return this.fDirection;
        }
    }

    private class KeyControlledResizer
    extends DTKeyControlledResizer {
        private KeyControlledResizer() {
        }

        @Override
        protected Point getDragStartPoint() {
            DTSplitPane dTSplitPane;
            DTSplitPane dTSplitPane2;
            Object object;
            Serializable serializable;
            DTSplitPane dTSplitPane3 = null;
            DTSplitPane dTSplitPane4 = null;
            DTSplitPane dTSplitPane5 = null;
            DTSplitPane dTSplitPane6 = null;
            Component component = this.fInvoker;
            for (serializable = this.fInvoker.getParent(); serializable != null && serializable != DTNestingContainer.this; serializable = serializable.getParent()) {
                if (serializable instanceof DTSplitPane) {
                    object = (DTSplitPane)((Object)serializable);
                    if (object.getOrientation() == 1) {
                        if (object.getLeftComponent() == component && dTSplitPane4 == null) {
                            dTSplitPane4 = object;
                        }
                        if (object.getRightComponent() == component && dTSplitPane3 == null) {
                            dTSplitPane3 = object;
                        }
                    } else {
                        if (object.getTopComponent() == component && dTSplitPane6 == null) {
                            dTSplitPane6 = object;
                        }
                        if (object.getBottomComponent() == component && dTSplitPane5 == null) {
                            dTSplitPane5 = object;
                        }
                    }
                }
                component = serializable;
            }
            serializable = new Point(this.fInvoker.getWidth() / 2, this.fInvoker.getHeight() / 2);
            serializable = SwingUtilities.convertPoint(this.fInvoker, (Point)serializable, (Component)((Object)DTNestingContainer.this));
            object = new Point((Point)serializable);
            Point point = new Point();
            DTSplitPane dTSplitPane7 = dTSplitPane2 = dTSplitPane4 != null ? dTSplitPane4 : dTSplitPane3;
            if (dTSplitPane2 != null) {
                point.x = dTSplitPane2.getDividerLocation() + dTSplitPane2.getDividerSize() / 2;
                point = SwingUtilities.convertPoint((Component)((Object)dTSplitPane2), point, (Component)((Object)DTNestingContainer.this));
                ((Point)object).x = point.x;
            }
            DTSplitPane dTSplitPane8 = dTSplitPane = dTSplitPane6 != null ? dTSplitPane6 : dTSplitPane5;
            if (dTSplitPane != null) {
                point.y = dTSplitPane.getDividerLocation() + dTSplitPane.getDividerSize() / 2;
                point = SwingUtilities.convertPoint((Component)((Object)dTSplitPane), point, (Component)((Object)DTNestingContainer.this));
                ((Point)object).y = point.y;
            }
            SwingUtilities.convertPointToScreen((Point)object, (Component)((Object)DTNestingContainer.this));
            return object;
        }
    }

    private class KeyControlledMover
    extends DTKeyControlledMover {
        RelativeLocation iLastLocation;
        BorderInfo iBorderInfo;

        private KeyControlledMover() {
            this.iBorderInfo = new BorderInfo();
        }

        @Override
        public void activate(DTOccupant dTOccupant) {
            super.activate(dTOccupant);
            if (this.isActive()) {
                this.iLastLocation = new RelativeLocation();
                this.iLastLocation.fContainer = (DTContainer)((Object)this.fInvoker);
                this.iLastLocation.fDirection = 0;
            }
        }

        @Override
        public void deactivate(boolean bl) {
            super.deactivate(bl);
            this.iLastLocation = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Point getNextPoint(Point point, int n) {
            int n2;
            Object object;
            Object object2;
            RelativeLocation relativeLocation = new RelativeLocation();
            if (this.iLastLocation.fContainer == DTNestingContainer.this) {
                if (n == this.iLastLocation.fDirection) {
                    if (this.iBorderInfo.iContainer == null || this.iBorderInfo.iContainer.getCenterComponent() != DTNestingContainer.this) return point;
                    relativeLocation.fContainer = this.iBorderInfo.iContainer;
                    relativeLocation.fDirection = n;
                } else if (DTNestingContainer.isOppositeDirection(this.iLastLocation.fDirection, n)) {
                    object2 = DTNestingContainer.this.getNeighboringContainer((Component)((Object)DTNestingContainer.this.fChild), n);
                    if (object2 == null) {
                        return point;
                    }
                    relativeLocation.fContainer = object2;
                    relativeLocation.fDirection = this.iLastLocation.fDirection;
                } else {
                    relativeLocation.fContainer = DTNestingContainer.this;
                    relativeLocation.fDirection = n;
                }
            } else if (this.iLastLocation.fContainer == this.iBorderInfo.iContainer) {
                if (n == this.iLastLocation.fDirection) {
                    return point;
                }
                if (DTNestingContainer.isOppositeDirection(this.iLastLocation.fDirection, n)) {
                    relativeLocation.fContainer = DTNestingContainer.this;
                    relativeLocation.fDirection = this.iLastLocation.fDirection;
                } else {
                    relativeLocation.fContainer = this.iBorderInfo.iContainer;
                    relativeLocation.fDirection = n;
                }
            } else {
                boolean bl = this.iLastLocation.fContainer == this.fInvoker;
                object = this.fInvoker.getParent();
                while (bl && object != null && !(object instanceof DTNestingContainer) && !(object instanceof DTSplitPane)) {
                    bl = !(object instanceof DTTabbedPane);
                }
                if (bl) {
                    this.iLastLocation.fDirection = n;
                }
                if (this.iLastLocation.fDirection == 0) {
                    relativeLocation.fContainer = this.iLastLocation.fContainer;
                    relativeLocation.fDirection = n;
                } else if (DTNestingContainer.isOppositeDirection(this.iLastLocation.fDirection, n)) {
                    relativeLocation.fContainer = this.iLastLocation.fContainer;
                    relativeLocation.fDirection = this.iLastLocation.fContainer instanceof DTDocumentContainer ? n : 0;
                } else if (this.iLastLocation.fDirection != n) {
                    relativeLocation.fContainer = this.iLastLocation.fContainer;
                    relativeLocation.fDirection = n;
                } else {
                    object = (Component)((Object)this.iLastLocation.fContainer);
                    Component component = null;
                    n2 = 0;
                    Object object3 = ((Component)object).getParent();
                    while (n2 == 0 && object3 != null && object3 != DTNestingContainer.this) {
                        if (object3 instanceof DTSplitPane) {
                            DTSplitPane dTSplitPane = (DTSplitPane)object3;
                            switch (n) {
                                case 1: {
                                    if (dTSplitPane.getOrientation() != 0 || dTSplitPane.getBottomComponent() != object) break;
                                    component = dTSplitPane.getTopComponent();
                                    n2 = 1;
                                    break;
                                }
                                case 5: {
                                    if (dTSplitPane.getOrientation() != 0 || dTSplitPane.getTopComponent() != object) break;
                                    component = dTSplitPane.getBottomComponent();
                                    n2 = 1;
                                    break;
                                }
                                case 3: {
                                    if (dTSplitPane.getOrientation() != 1 || dTSplitPane.getLeftComponent() != object) break;
                                    component = dTSplitPane.getRightComponent();
                                    n2 = 1;
                                    break;
                                }
                                case 7: {
                                    if (dTSplitPane.getOrientation() != 1 || dTSplitPane.getRightComponent() != object) break;
                                    component = dTSplitPane.getLeftComponent();
                                    n2 = 1;
                                }
                            }
                        }
                        object = object3;
                        object3 = ((Component)object).getParent();
                    }
                    if (n2 == 0) {
                        relativeLocation.fContainer = DTNestingContainer.this;
                        relativeLocation.fDirection = n;
                    } else {
                        object3 = DTNestingContainer.this.getNeighboringContainer(component, n);
                        if (object3 == null) {
                            return point;
                        }
                        relativeLocation.fContainer = object3;
                        relativeLocation.fDirection = DTNestingContainer.getOppositeDirection(n);
                    }
                }
            }
            if (relativeLocation.fContainer == null) {
                return point;
            }
            object2 = (Component)((Object)relativeLocation.getContainer());
            object = new Point(((Component)object2).getWidth() / 2, ((Component)object2).getHeight() / 2);
            if (relativeLocation.fContainer instanceof DTBorderContainer) {
                switch (relativeLocation.fDirection) {
                    case 1: {
                        ((Point)object).y = (this.iBorderInfo.iInnerRect.y + this.iBorderInfo.iOuterRect.y) / 2;
                        break;
                    }
                    case 5: {
                        ((Point)object).y = (this.iBorderInfo.iInnerRect.y + this.iBorderInfo.iInnerRect.height + this.iBorderInfo.iOuterRect.y + this.iBorderInfo.iOuterRect.height) / 2;
                        break;
                    }
                    case 3: {
                        ((Point)object).x = (this.iBorderInfo.iInnerRect.x + this.iBorderInfo.iInnerRect.width + this.iBorderInfo.iOuterRect.x + this.iBorderInfo.iOuterRect.width) / 2;
                        break;
                    }
                    case 7: {
                        ((Point)object).x = (this.iBorderInfo.iInnerRect.x + this.iBorderInfo.iOuterRect.x) / 2;
                    }
                }
                object = SwingUtilities.convertPoint((Component)((Object)DTNestingContainer.this), (Point)object, (Component)object2);
            } else {
                float f = relativeLocation.fContainer instanceof DTNestingContainer ? 0.15f : 0.25f;
                int n3 = relativeLocation.fContainer instanceof DTNestingContainer ? 40 : 100;
                n2 = (int)(f * (float)((Component)object2).getWidth());
                int n4 = (int)(f * (float)((Component)object2).getHeight());
                if (n2 > n3) {
                    n2 = n3;
                }
                if (n4 > n3) {
                    n4 = n3;
                }
                switch (relativeLocation.fDirection) {
                    case 1: {
                        ((Point)object).y = 3 * n4 / 4 - 5;
                        break;
                    }
                    case 5: {
                        ((Point)object).y = ((Component)object2).getHeight() - 3 * n4 / 4 + 2;
                        break;
                    }
                    case 3: {
                        ((Point)object).x = ((Component)object2).getWidth() - n2 + 5;
                        break;
                    }
                    case 7: {
                        ((Point)object).x = n2 - 5;
                    }
                }
            }
            SwingUtilities.convertPointToScreen((Point)object, (Component)object2);
            this.iLastLocation = relativeLocation;
            return object;
        }
    }

    private class BorderInfo {
        DTBorderContainer iContainer;
        Rectangle iOuterRect;
        Rectangle iInnerRect;

        BorderInfo() {
            this.iContainer = (DTBorderContainer)((Object)SwingUtilities.getAncestorOfClass(DTBorderContainer.class, (Component)((Object)DTNestingContainer.this)));
            if (this.iContainer != null && this.iContainer.getCenterComponent() == DTNestingContainer.this) {
                this.iOuterRect = new Rectangle(0, 0, this.iContainer.getWidth(), this.iContainer.getHeight());
                this.iOuterRect = SwingUtilities.convertRectangle((Component)((Object)this.iContainer), this.iOuterRect, (Component)((Object)DTNestingContainer.this));
                this.iInnerRect = new Rectangle(0, 0, DTNestingContainer.this.getWidth(), DTNestingContainer.this.getHeight());
                if (this.iOuterRect.x == 0) {
                    this.iInnerRect.x = 10;
                    this.iInnerRect.width -= 10;
                }
                if (this.iOuterRect.y == 0) {
                    this.iInnerRect.y = 6;
                    this.iInnerRect.height -= 6;
                }
                if (this.iOuterRect.x + this.iOuterRect.width == this.iInnerRect.x + this.iInnerRect.width) {
                    this.iInnerRect.width -= 10;
                }
                if (this.iOuterRect.y + this.iOuterRect.height == this.iInnerRect.y + this.iInnerRect.height) {
                    this.iInnerRect.height -= 10;
                }
            }
        }
    }

    private class NoTraversalPolicy
    extends FocusTraversalPolicy {
        private NoTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            return null;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            return null;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return null;
        }

        @Override
        public Component getLastComponent(Container container) {
            return null;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return null;
        }
    }
}

