/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ComponentMover;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJWindow;
import com.mathworks.mwswing.MMouseEvent;
import com.mathworks.mwswing.MouseInputLatch;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTComponentResizer;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyControlledMover;
import com.mathworks.widgets.desk.DTKeyControlledResizer;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTRootPane;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.Desktop;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.SplineInterpolator;

public class DTOnTopWindow
extends MJWindow
implements DTContainer,
PropertyChangeListener {
    private Desktop fDesktop;
    private DTFrame fFrame;
    private DTOccupant fOccupant;
    private Dimension fMinimumSize;
    private MouseInputListener fTitleBarListener;
    private MouseInputListener fBorderListener;
    private DTComponentResizer fResizer;
    private boolean fWasShowingActionsMenu;
    private PopupEventListener fPopupEventListener;
    private boolean fIsAnchored;
    static KeyDispatcher sKeyDispatcher;
    static boolean sSuppressDisposeOnHide;
    static boolean sSuppressCollapseAnimation;
    private static final int ANIMATION_DURATION = 500;
    private static final int ANIMATION_INTERVAL = 30;

    public DTOnTopWindow(Desktop desktop, DTFrame dTFrame, DTOccupant dTOccupant, DTLocation dTLocation) {
        super((Frame)((Object)dTFrame));
        Object object;
        this.fDesktop = desktop;
        this.fFrame = dTFrame;
        this.fOccupant = dTOccupant;
        this.setFocusableWindowState(true);
        this.setName(dTOccupant.getName() + "Window");
        dTOccupant.prepareToShow();
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        this.getContentPane().add((Component)((Object)dTInternalFrame), "Center");
        dTInternalFrame.setTitleBarVisible(true);
        dTInternalFrame.setBorderVisible(true);
        dTInternalFrame.setTitleBarMaximizeAllowed(false);
        dTInternalFrame.setFocusable(true);
        if (dTOccupant.isDockable()) {
            dTInternalFrame.getTitleBar().setDockListener((ActionListener)dTOccupant.getDockAction(), false);
        }
        boolean bl = dTOccupant.getContextMenu() != null || dTOccupant instanceof DTClient && ((DTClient)dTOccupant).getContextActions().size() > 0;
        this.fWasShowingActionsMenu = dTInternalFrame.getTitleBar().isShowingActionsMenu();
        if (!bl) {
            dTInternalFrame.getTitleBar().setShowActionMenu(false);
        }
        this.fTitleBarListener = new MouseInputLatch((MouseInputListener)new ComponentMover((Component)((Object)this)){

            protected void moveComponent(Point point) {
                DTOnTopWindow.this.setAnchored(false);
                super.moveComponent(point);
            }
        });
        dTInternalFrame.getTitleBar().addMouseListener(this.fTitleBarListener);
        dTInternalFrame.getTitleBar().addMouseMotionListener(this.fTitleBarListener);
        dTInternalFrame.setTitleBarMinimizeAllowed(false);
        this.fResizer = new Resizer();
        this.fBorderListener = new MouseInputLatch((MouseInputListener)this.fResizer);
        dTInternalFrame.addMouseListener(this.fBorderListener);
        dTInternalFrame.addMouseMotionListener(this.fBorderListener);
        DTFloatingLocation dTFloatingLocation = this.refineFloatingLocation(dTLocation);
        dTFloatingLocation.setFrame(dTFrame);
        dTFloatingLocation.setContainer(this);
        this.setBounds(dTFloatingLocation.getFrameBounds());
        dTOccupant.setLocation(dTFloatingLocation);
        if (this.fFrame instanceof DTMultipleClientFrame) {
            ((DTMultipleClientFrame)this.fFrame).beginTracking(dTOccupant);
        }
        if (this.fOccupant instanceof DTClient && ((DTClient)this.fOccupant).isDockableTearOff()) {
            object = (DTClient)this.fOccupant;
            if (this.fDesktop.isRestoringLayout() || this.fDesktop.isTesting() || sSuppressCollapseAnimation) {
                if (dTLocation == null || dTLocation.isAnchored()) {
                    this.setAnchored(true);
                    dTInternalFrame.getTitleBar().setAnchorListener((ActionListener)((DTClient)object).getDetachAction(), true);
                } else {
                    dTInternalFrame.getTitleBar().setAnchorListener((ActionListener)((DTClient)object).getAnchorAction(), false);
                    dTInternalFrame.getTitleBar().setPromoteAnchor(true);
                    if (this.fDesktop.isRestoringLayout()) {
                        ((DTClient)object).fireClientEvent(new DTClientEvent(((DTClient)object).getComponent(), 14));
                    }
                }
            } else {
                dTFloatingLocation.setAnchored(false);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        Timer timer = new Timer(100, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                DTOnTopWindow.this.setAnchored(true);
                            }
                        });
                        timer.setRepeats(false);
                        timer.start();
                        DTOnTopWindow.this.removeWindowListener(this);
                    }
                });
            }
            this.fPopupEventListener = new PopupEventListener();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.fPopupEventListener, 16L);
            this.fFrame.addComponentListener(this.fPopupEventListener);
            ((DTOccupant)object).addPropertyListener(this);
        } else if (!this.fDesktop.isRestoringLayout()) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    if (DTOnTopWindow.this.fOccupant != null) {
                        DTOnTopWindow.this.fOccupant.requestFocus();
                    }
                    DTOnTopWindow.this.removeWindowListener(this);
                }
            });
        }
        this.addComponentListener(new LocalComponentListener());
        if (sKeyDispatcher == null) {
            sKeyDispatcher = new KeyDispatcher();
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            ((KeyboardFocusManager)object).addKeyEventDispatcher(sKeyDispatcher);
            ((KeyboardFocusManager)object).addKeyEventPostProcessor(sKeyDispatcher);
        }
        desktop.fActionManager.addActionsToWindow((JWindow)((Object)this));
    }

    public static void setSuppressDisposeOnHideForTest(boolean bl) {
        sSuppressDisposeOnHide = bl;
    }

    public static void setSuppressCollapseAnimation(boolean bl) {
        sSuppressCollapseAnimation = bl;
    }

    private DTFloatingLocation refineFloatingLocation(DTLocation dTLocation) {
        Serializable serializable;
        Rectangle rectangle = WindowUtils.getScreenBounds();
        DTFloatingLocation dTFloatingLocation = dTLocation instanceof DTFloatingLocation ? (DTFloatingLocation)dTLocation : null;
        boolean bl = this.fOccupant.getLastLocation() != null && this.fOccupant.getLastLocation().isDocked();
        Rectangle rectangle2 = null;
        if (bl) {
            if (dTFloatingLocation == this.fOccupant.getLastUndockedLocation()) {
                dTFloatingLocation = null;
            }
            if (this.fOccupant.getLastLocation().isLocationInitialized() && this.fOccupant.getLastLocation().isSizeInitialized()) {
                rectangle2 = this.fOccupant.getLastLocation().getFrameBounds();
            }
        }
        if (dTFloatingLocation == null || !dTFloatingLocation.isSizeInitialized()) {
            if (dTFloatingLocation == null) {
                dTFloatingLocation = new DTFloatingLocation(true);
            }
            if (dTFloatingLocation.hasNormalizedSize()) {
                dTFloatingLocation.initializeSize(rectangle.getSize());
            } else if (rectangle2 != null) {
                dTFloatingLocation.setFrameSize(rectangle2.width, rectangle2.height);
            } else if (this.fOccupant instanceof DTClient) {
                dTFloatingLocation.setFrameSize(3 * rectangle.width / 8, 3 * rectangle.height / 8);
            } else {
                dTFloatingLocation.setFrameSize(9 * rectangle.width / 16, 5 * rectangle.height / 8);
            }
        }
        if (!dTFloatingLocation.isLocationInitialized()) {
            if (dTFloatingLocation.hasNormalizedLocation()) {
                dTFloatingLocation.initializeLocation(rectangle);
            } else if (rectangle2 != null) {
                dTFloatingLocation.setFrameLocation(Math.max(rectangle2.x - 20, 0), Math.max(rectangle2.y - 20, 0));
            } else {
                serializable = null;
                if (this.fOccupant instanceof DTClient && ((DTClient)this.fOccupant).getGroup() != null) {
                    serializable = ((DTClient)this.fOccupant).getGroup().getContainingFrame();
                }
                if (serializable == null) {
                    serializable = this.fDesktop.getMainFrame();
                }
                if (serializable == null) {
                    dTFloatingLocation.setFrameLocation(0, 0);
                } else {
                    dTFloatingLocation.setFrameLocation(Math.max(serializable.getX() - 20, 0), Math.max(serializable.getY() - 20, 0));
                }
            }
        }
        serializable = dTFloatingLocation.getFrameSize();
        Dimension dimension = this.getMinimumClientSize();
        if (serializable.width < dimension.width) {
            serializable.width = dimension.width;
        }
        if (serializable.height < dimension.height) {
            serializable.height = dimension.height;
        }
        dTFloatingLocation.setFrameSize((Dimension)serializable);
        dTFloatingLocation.ensureVisible(WindowUtils.getVirtualScreenBounds());
        if (dTFloatingLocation.getFrameX() < 0 && PlatformInfo.isLinux()) {
            dTFloatingLocation.setFrameLocation(0, dTFloatingLocation.getFrameY());
        }
        return dTFloatingLocation;
    }

    DTOccupant getOccupant() {
        return this.fOccupant;
    }

    void setAnchored(boolean bl) {
        if (this.fOccupant instanceof DTClient && ((DTClient)this.fOccupant).isDockableTearOff() && this.fIsAnchored != bl) {
            this.fIsAnchored = bl;
            DTClient dTClient = (DTClient)this.fOccupant;
            DTLocation dTLocation = this.fOccupant.getLocation();
            DTClientFrame dTClientFrame = dTClient.getClientFrame();
            dTClientFrame.setTearOffLook(bl);
            dTClientFrame.getTitleBar().setAnchorListener((ActionListener)(bl ? dTClient.getDetachAction() : dTClient.getAnchorAction()), bl);
            dTClientFrame.getTitleBar().setPromoteAnchor(!bl);
            this.setFocusableWindowState(!bl);
            this.getRootPane().putClientProperty("Window.shadow", !bl);
            JComponent jComponent = dTClientFrame.getTitleBar().getResizeGrip();
            if (jComponent != null) {
                CornerResizer cornerResizer = new CornerResizer();
                jComponent.addMouseListener(cornerResizer);
                jComponent.addMouseMotionListener(cornerResizer);
            }
            this.fResizer.setDragPermitted(5, !bl);
            this.fResizer.setDragPermitted(7, !bl);
            if (bl != dTLocation.isAnchored()) {
                ((DTFloatingLocation)dTLocation).setAnchored(bl);
                if (bl && this.isVisible()) {
                    if (this.fDesktop.isRestoringLayout() || sSuppressCollapseAnimation) {
                        this.setVisible(false);
                    } else {
                        this.doCollapse(dTClient.getAnchorLocation());
                    }
                }
            }
            dTClient.fireClientEvent(new DTClientEvent(dTClient.getComponent(), this.fIsAnchored ? 13 : 14));
        }
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            if (!bl && this.fOccupant instanceof DTClient && ((DTClient)this.fOccupant).isDockableTearOff() && this.fOccupant.getLocation() != null && this.fOccupant.getLocation().isAnchored()) {
                this.fOccupant.setSelected(false);
                if (PlatformInfo.isLinux() && !sSuppressDisposeOnHide) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DTOnTopWindow.super.dispose();
                        }
                    });
                }
            }
        }
    }

    private void doCollapse(Point point) {
        final BufferedImage bufferedImage = this.createSnapShot();
        MJPanel mJPanel = new MJPanel(){

            public void paint(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            }
        };
        JWindow jWindow = new JWindow(this.getOwner());
        jWindow.setContentPane((Container)mJPanel);
        jWindow.setBounds(this.getBounds());
        jWindow.setVisible(true);
        if (!PlatformInfo.isMacintosh()) {
            this.setVisible(false);
        }
        new CollapseAnimator(jWindow, point);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName()) && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && this.fOccupant.getLocation().isAnchored() && !this.isVisible()) {
            this.setBounds(((DTClient)this.fOccupant).getAnchoredBounds());
            this.setVisible(true);
        }
    }

    private BufferedImage createSnapShot() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void dispose() {
        if (this.fOccupant != null) {
            DTInternalFrame dTInternalFrame = this.fOccupant.getInternalFrame();
            if (this.fFrame instanceof DTMultipleClientFrame) {
                ((DTMultipleClientFrame)this.fFrame).endTracking(this.fOccupant);
            }
            if (this.fOccupant.getLocation() != null) {
                this.fOccupant.getLocation().setContainer(null);
                this.fOccupant.setLocation(null);
            }
            if (this.fOccupant.isSelected() && this.fOccupant.isClosing()) {
                this.fDesktop.getSelectionManager().clearSelection();
            }
            dTInternalFrame.getTitleBar().removeMouseListener(this.fTitleBarListener);
            dTInternalFrame.getTitleBar().removeMouseMotionListener(this.fTitleBarListener);
            dTInternalFrame.setTitleBarMinimizeAllowed(true);
            dTInternalFrame.setTitleBarMaximizeAllowed(true);
            this.getContentPane().remove((Component)((Object)dTInternalFrame));
            dTInternalFrame.removeMouseListener(this.fBorderListener);
            dTInternalFrame.removeMouseMotionListener(this.fBorderListener);
            dTInternalFrame.setFocusable(false);
            dTInternalFrame.getTitleBar().setDockListener((ActionListener)(this.fOccupant.permitUserUndock() ? this.fOccupant.getUndockAction() : null), true);
            dTInternalFrame.getTitleBar().setShowActionMenu(this.fWasShowingActionsMenu);
            dTInternalFrame.getTitleBar().setAnchorListener(null, false);
            if (this.fOccupant instanceof DTClient && ((DTClient)this.fOccupant).isDockableTearOff()) {
                ((DTClientFrame)dTInternalFrame).setTearOffLook(false);
                dTInternalFrame.getTitleBar().setPromoteAnchor(false);
                this.fOccupant.removePropertyListener(this);
            }
            if (this.fPopupEventListener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.fPopupEventListener);
                this.fFrame.removeComponentListener(this.fPopupEventListener);
            }
            this.fOccupant = null;
            this.fFrame = null;
        }
        super.dispose();
    }

    boolean hasBeenDisposed() {
        return this.fOccupant == null;
    }

    protected Dimension getMinimumClientSize() {
        if (this.fMinimumSize == null) {
            if (this.fOccupant == null) {
                this.fMinimumSize = new Dimension(100, 20);
            } else {
                Insets insets = this.fOccupant.getInternalFrame().getInsets();
                DTTitleBar dTTitleBar = this.fOccupant.getInternalFrame().getTitleBar();
                this.fMinimumSize = dTTitleBar.getPreferredSize();
                this.fMinimumSize.height += insets.top + insets.bottom;
                this.fMinimumSize.width = 100;
            }
        }
        return this.fMinimumSize;
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        return null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        return null;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return true;
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return true;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
        new DTKeyControlledMover().activate(dTOccupant);
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
        new DTKeyControlledResizer().activate(dTOccupant, null);
    }

    static void repaintMnemonicsInWindow(Window window) {
        Window[] windowArray;
        if (window == null || !window.isShowing()) {
            return;
        }
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            DTOnTopWindow.repaintMnemonicsInWindow(window2);
        }
        DTOnTopWindow.repaintMnemonicsInContainer(window);
    }

    static void repaintMnemonicsInContainer(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component == null || !component.isVisible()) continue;
            if (component instanceof AbstractButton && ((AbstractButton)component).getMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (component instanceof JLabel && ((JLabel)component).getDisplayedMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (!(component instanceof Container)) continue;
            DTOnTopWindow.repaintMnemonicsInContainer((Container)component);
        }
    }

    static {
        sSuppressDisposeOnHide = false;
        sSuppressCollapseAnimation = false;
    }

    static class KeyDispatcher
    implements KeyEventDispatcher,
    KeyEventPostProcessor {
        KeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return keyEvent.getKeyCode() == 18 && PlatformInfo.isWindows() && this.processAlt(keyEvent);
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            DTOnTopWindow dTOnTopWindow;
            if (keyEvent.getKeyCode() == 18) {
                return PlatformInfo.isWindows() && this.processAlt(keyEvent);
            }
            if (keyEvent.getID() == 401 && (keyEvent.isActionKey() || keyEvent.isAltDown() || (keyEvent.getModifiers() & KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK) != 0) && (dTOnTopWindow = this.getOnTopWindow(keyEvent)) != null) {
                DTFrame dTFrame = dTOnTopWindow.fFrame;
                JRootPane jRootPane = dTFrame.getRootPane();
                if (jRootPane instanceof DTRootPane) {
                    MenuSelectionManager menuSelectionManager;
                    Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    ((DTRootPane)jRootPane).processKeyEvent(keyEvent);
                    if (keyEvent.isConsumed() && (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath().length > 0) {
                        this.restoreFocusUponMenuClose(component);
                    }
                }
                return true;
            }
            return false;
        }

        private DTOnTopWindow getOnTopWindow(KeyEvent keyEvent) {
            JRootPane jRootPane = SwingUtilities.getRootPane(keyEvent.getComponent());
            Window window = jRootPane == null ? null : SwingUtilities.getWindowAncestor(jRootPane);
            return window instanceof DTOnTopWindow ? (DTOnTopWindow)((Object)window) : null;
        }

        private void restoreFocusUponMenuClose(final Component component) {
            final MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (menuSelectionManager.getSelectedPath().length == 0) {
                        component.requestFocus();
                        menuSelectionManager.removeChangeListener(this);
                    }
                }
            });
        }

        private boolean processAlt(KeyEvent keyEvent) {
            DTOnTopWindow dTOnTopWindow = this.getOnTopWindow(keyEvent);
            if (dTOnTopWindow != null) {
                DTFrame dTFrame = dTOnTopWindow.fFrame;
                if (keyEvent.getID() == 401) {
                    if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                        if (menuElementArray.length == 0) {
                            WindowsLookAndFeel.setMnemonicHidden((boolean)false);
                            DTOnTopWindow.repaintMnemonicsInWindow((Window)((Object)dTFrame));
                        }
                        keyEvent.consume();
                    }
                } else if (keyEvent.getID() == 402) {
                    JMenu jMenu;
                    JMenuBar jMenuBar = dTFrame.getJMenuBar();
                    JMenu jMenu2 = jMenu = jMenuBar == null ? null : jMenuBar.getMenu(0);
                    if (jMenu != null) {
                        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        this.restoreFocusUponMenuClose(component);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class CornerResizer
    extends MouseInputAdapter {
        private CornerResizer() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DTOnTopWindow.this.fResizer.mousePressed(this.convertEvent(mouseEvent));
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            DTOnTopWindow.this.fResizer.mouseReleased(this.convertEvent(mouseEvent));
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            DTOnTopWindow.this.fResizer.mouseMoved(this.convertEvent(mouseEvent));
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            DTOnTopWindow.this.fResizer.mouseDragged(this.convertEvent(mouseEvent));
        }

        private MouseEvent convertEvent(MouseEvent mouseEvent) {
            DTInternalFrame dTInternalFrame = DTOnTopWindow.this.fOccupant.getInternalFrame();
            return SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, (Component)((Object)dTInternalFrame));
        }
    }

    private class Resizer
    extends DTComponentResizer {
        Resizer() {
            super((Component)((Object)DTOnTopWindow.this));
        }

        @Override
        protected Insets getResizeInsets() {
            return DTOnTopWindow.this.fOccupant != null ? DTOnTopWindow.this.fOccupant.getInternalFrame().getInsets() : new Insets(0, 0, 0, 0);
        }

        @Override
        protected Dimension getMinimumSize() {
            return DTOnTopWindow.this.getMinimumClientSize();
        }

        @Override
        int getCursorType(Point point) {
            if (DTOnTopWindow.this.fIsAnchored) {
                DTInternalFrame dTInternalFrame = DTOnTopWindow.this.fOccupant.getInternalFrame();
                int n = dTInternalFrame.getTitleBar().getHeight();
                int n2 = dTInternalFrame.getWidth();
                if (point.y < n && point.x > n2 - n && n2 - point.x >= point.y) {
                    return 7;
                }
            }
            return super.getCursorType(point);
        }
    }

    private class LocalComponentListener
    extends ComponentAdapter {
        private LocalComponentListener() {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (DTOnTopWindow.this.fOccupant != null && DTOnTopWindow.this.fOccupant.getLocation() != null) {
                DTOnTopWindow.this.fOccupant.getLocation().setFrameLocation(DTOnTopWindow.this.getX(), DTOnTopWindow.this.getY());
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (DTOnTopWindow.this.fOccupant != null && DTOnTopWindow.this.fOccupant.getLocation() != null) {
                DTOnTopWindow.this.fOccupant.getLocation().setFrameSize(DTOnTopWindow.this.getWidth(), DTOnTopWindow.this.getHeight());
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    }

    private class CollapseAnimator
    implements ActionListener {
        private JWindow iWindow;
        private Point iInitialCenter;
        private Dimension iInitialSize;
        private int iCenterXDiff;
        private int iCenterYDiff;
        private long iStartTime;
        private Timer iTimer;
        private final Interpolator iInterpolator = new SplineInterpolator(0.1f, 0.05f, 0.8f, 0.9f);

        private CollapseAnimator(JWindow jWindow, Point point) {
            this.iWindow = jWindow;
            this.iStartTime = System.currentTimeMillis();
            this.iInitialSize = jWindow.getSize();
            this.iInitialCenter = new Point(jWindow.getX() + this.iInitialSize.width / 2, jWindow.getY() + this.iInitialSize.height / 2);
            this.iCenterXDiff = point.x - this.iInitialCenter.x;
            this.iCenterYDiff = point.y - this.iInitialCenter.y;
            this.iTimer = new Timer(30 * (Math.abs(this.iCenterXDiff) + Math.abs(this.iCenterYDiff) + this.iInitialSize.width + this.iInitialSize.height) / 1000, this);
            this.iTimer.setRepeats(true);
            this.iTimer.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            float f;
            if (PlatformInfo.isMacintosh()) {
                DTOnTopWindow.this.setVisible(false);
            }
            float f2 = f = (f = (float)(System.currentTimeMillis() - this.iStartTime) / 500.0f) > 1.0f ? 1.0f : this.iInterpolator.interpolate(f);
            if (f < 1.0f) {
                float f3 = 1.0f - f;
                float f4 = f3 * (float)this.iInitialSize.width;
                float f5 = f3 * (float)this.iInitialSize.height;
                this.iWindow.setBounds(this.iInitialCenter.x + (int)(f * (float)this.iCenterXDiff - f4 / 2.0f), this.iInitialCenter.y + (int)(f * (float)this.iCenterYDiff - f5 / 2.0f), (int)f4, (int)f5);
            } else {
                this.iTimer.stop();
                this.iWindow.dispose();
            }
        }
    }

    private class PopupEventListener
    implements AWTEventListener,
    ComponentListener {
        private PopupEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Component component;
            if (!(aWTEvent.getID() != 501 || aWTEvent instanceof MMouseEvent && ((MMouseEvent)aWTEvent).isKeyTriggered() || SwingUtilities.isDescendingFrom(component = ((MouseEvent)aWTEvent).getComponent(), (Component)((Object)DTOnTopWindow.this)) || component instanceof JMenuItem || SwingUtilities.windowForComponent(component) instanceof JDialog)) {
                this.hideIfAnchored();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.hideIfAnchored();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.hideIfAnchored();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        private void hideIfAnchored() {
            if (DTOnTopWindow.this.fOccupant.getLocation().isAnchored() && !((DTClient)DTOnTopWindow.this.fOccupant).isPseudoModal()) {
                DTOnTopWindow.this.setVisible(false);
            }
        }
    }
}

