/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.widgets.desk.DTClientPropertyProvider;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTLazyPropertyProvider;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTPropertyProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;

class DTPropertyBridge
implements DTPropertyProvider {
    private JComponent fComponent;
    private DTClientPropertyProvider fClientProvider;
    private DTGroupPropertyProvider fGroupProvider;

    DTPropertyBridge(JComponent jComponent) {
        this.fComponent = jComponent;
    }

    DTPropertyBridge(DTClientPropertyProvider dTClientPropertyProvider) {
        this.fClientProvider = dTClientPropertyProvider;
    }

    DTPropertyBridge(DTGroupPropertyProvider dTGroupPropertyProvider) {
        this.fGroupProvider = dTGroupPropertyProvider;
    }

    Object getUnderlyingProvider() {
        if (this.fComponent != null) {
            return this.fComponent;
        }
        if (this.fClientProvider != null) {
            return this.fClientProvider;
        }
        if (this.fGroupProvider != null) {
            return this.fGroupProvider;
        }
        return null;
    }

    @Override
    public void putProperty(DTProperty dTProperty, Object object) {
        if (this.fComponent != null) {
            this.fComponent.putClientProperty(dTProperty, object);
        } else if (this.fClientProvider != null) {
            this.fClientProvider.putClientProperty(dTProperty, object);
        } else if (this.fGroupProvider != null) {
            this.fGroupProvider.putGroupProperty(dTProperty, object);
        }
    }

    @Override
    public Object getProperty(DTProperty dTProperty) {
        if (this.fComponent != null) {
            Object object = null;
            if (this.fClientProvider instanceof DTLazyPropertyProvider) {
                object = ((DTLazyPropertyProvider)((Object)this.fClientProvider)).getLazyProperty(dTProperty);
            }
            if (object == null) {
                object = this.fComponent.getClientProperty(dTProperty);
            }
            return object;
        }
        if (this.fClientProvider != null) {
            Object object = null;
            if (this.fClientProvider instanceof DTLazyPropertyProvider) {
                object = ((DTLazyPropertyProvider)((Object)this.fClientProvider)).getLazyProperty(dTProperty);
            }
            if (object == null) {
                object = this.fClientProvider.getClientProperty(dTProperty);
            }
            return object;
        }
        if (this.fGroupProvider != null) {
            Object object = null;
            if (this.fGroupProvider instanceof DTLazyPropertyProvider) {
                object = ((DTLazyPropertyProvider)((Object)this.fGroupProvider)).getLazyProperty(dTProperty);
            }
            if (object == null) {
                object = this.fGroupProvider.getGroupProperty(dTProperty);
            }
            return object;
        }
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        WeakLink weakLink = new WeakLink(propertyChangeListener);
        if (this.fComponent != null) {
            this.fComponent.addPropertyChangeListener(weakLink);
        } else if (this.fClientProvider != null) {
            this.fClientProvider.addPropertyChangeListener(weakLink);
        } else if (this.fGroupProvider != null) {
            this.fGroupProvider.addPropertyChangeListener(weakLink);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray = null;
        if (this.fComponent != null) {
            propertyChangeListenerArray = this.fComponent.getPropertyChangeListeners();
        } else if (this.fClientProvider != null) {
            propertyChangeListenerArray = this.fClientProvider.getPropertyChangeListeners();
        } else if (this.fGroupProvider != null) {
            propertyChangeListenerArray = this.fGroupProvider.getPropertyChangeListeners();
        }
        if (propertyChangeListenerArray == null) {
            return;
        }
        WeakLink weakLink = null;
        for (PropertyChangeListener propertyChangeListener2 : propertyChangeListenerArray) {
            if (!(propertyChangeListener2 instanceof WeakLink) || ((WeakLink)propertyChangeListener2).get() != propertyChangeListener) continue;
            weakLink = (WeakLink)propertyChangeListener2;
        }
        if (weakLink != null) {
            if (this.fComponent != null) {
                this.fComponent.removePropertyChangeListener(weakLink);
            } else if (this.fClientProvider != null) {
                this.fClientProvider.removePropertyChangeListener(weakLink);
            } else if (this.fGroupProvider != null) {
                this.fGroupProvider.removePropertyChangeListener(weakLink);
            }
        }
    }

    private static class WeakLink
    extends WeakReference<PropertyChangeListener>
    implements PropertyChangeListener {
        WeakLink(PropertyChangeListener propertyChangeListener) {
            super(propertyChangeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.get();
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }
}

