/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class DTRootPane
extends JRootPane {
    protected JComponent fMenuBarNeighbor;
    protected int fNeighborPosition;

    void setMenuBarNeighbor(JComponent jComponent, int n) {
        if (this.fMenuBarNeighbor != null) {
            this.layeredPane.remove(this.fMenuBarNeighbor);
        }
        this.fMenuBarNeighbor = jComponent;
        this.fNeighborPosition = n;
        if (jComponent != null) {
            jComponent.setOpaque(false);
            this.layeredPane.add((Component)jComponent, JLayeredPane.PALETTE_LAYER);
        }
    }

    public JComponent getMenuBarNeighbor() {
        return this.fMenuBarNeighbor;
    }

    @Override
    public void setMenuBar(JMenuBar jMenuBar) {
        Border border;
        if (this.getJMenuBar() != null) {
            border = this.getJMenuBar().getBorder();
            if (border instanceof CompoundBorder) {
                this.getJMenuBar().setBorder(((CompoundBorder)border).getOutsideBorder());
            } else {
                this.getJMenuBar().setBorder(null);
            }
        }
        if (jMenuBar != null) {
            border = jMenuBar.getBorder();
            AbstractBorder abstractBorder = border != null ? BorderFactory.createCompoundBorder(border, new NeighborBorder()) : new NeighborBorder();
            jMenuBar.setBorder(abstractBorder);
        }
        super.setJMenuBar(jMenuBar);
    }

    @Override
    protected LayoutManager createRootLayout() {
        return new DTRootLayout();
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
    }

    private class NeighborBorder
    extends AbstractBorder {
        private NeighborBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            if (DTRootPane.this.fMenuBarNeighbor != null) {
                if (DTRootPane.this.fNeighborPosition == 7) {
                    insets.left = DTRootPane.this.fMenuBarNeighbor.getPreferredSize().width;
                } else {
                    insets.right = DTRootPane.this.fMenuBarNeighbor.getPreferredSize().width;
                }
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }
    }

    protected class DTRootLayout
    extends JRootPane.RootLayout {
        protected DTRootLayout() {
            super(DTRootPane.this);
        }

        @Override
        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            if (DTRootPane.this.fMenuBarNeighbor != null && DTRootPane.this.getJMenuBar() != null) {
                Dimension dimension = DTRootPane.this.fMenuBarNeighbor.getPreferredSize();
                Rectangle rectangle = DTRootPane.this.getJMenuBar().getBounds();
                Insets insets = DTRootPane.this.getJMenuBar().getInsets();
                int n = rectangle.height - insets.top - insets.bottom;
                if (dimension.height > n) {
                    dimension.height = n;
                }
                int n2 = rectangle.y + insets.top + (n - dimension.height) / 2;
                if (DTRootPane.this.fNeighborPosition == 7) {
                    DTRootPane.this.fMenuBarNeighbor.setBounds(rectangle.x, n2, dimension.width, dimension.height);
                } else {
                    DTRootPane.this.fMenuBarNeighbor.setBounds(rectangle.x + rectangle.width - dimension.width, n2, dimension.width, dimension.height);
                }
            }
        }
    }
}

