/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class DTToolBarFactory {
    public static final String TOOL_BAR_ITEM_PROPERTY_KEY = "ToolBarItemPropertyKey";
    public static final String TOOL_BAR_KEY_PROPERTY_KEY = "ToolBarKey";
    public static final String TOOL_BAR_LABEL_PROPERTY_KEY = "ToolBarLabel";
    public static final String TOOL_BAR_APPEND_PROPERTY_KEY = "ToolBarAppend";

    public static JToolBar createToolBar(DTToolBarInfo dTToolBarInfo, DTToolBarConfiguration dTToolBarConfiguration, Object object) {
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setFloatable(false);
        mJToolBar.setName(dTToolBarInfo.getKey());
        mJToolBar.putClientProperty((Object)TOOL_BAR_KEY_PROPERTY_KEY, (Object)dTToolBarInfo.getKey());
        mJToolBar.putClientProperty((Object)TOOL_BAR_LABEL_PROPERTY_KEY, (Object)dTToolBarInfo.getLabel());
        mJToolBar.putClientProperty((Object)TOOL_BAR_APPEND_PROPERTY_KEY, (Object)dTToolBarInfo.appendToPreviousRow());
        if (dTToolBarConfiguration == null) {
            dTToolBarConfiguration = dTToolBarInfo.getDefaultConfig();
        }
        DTToolBarFactory.buildToolBar((JToolBar)mJToolBar, dTToolBarInfo.getToolSet(), dTToolBarConfiguration, object);
        return mJToolBar;
    }

    public static void udpateToolBar(JToolBar jToolBar, DTToolSet dTToolSet, DTToolBarConfiguration dTToolBarConfiguration, Object object) {
        DTToolBarFactory.buildToolBar(jToolBar, dTToolSet, dTToolBarConfiguration, object);
    }

    public static DTToolBarConfiguration reconcile(DTToolSet dTToolSet, DTToolBarConfiguration dTToolBarConfiguration, DTToolBarConfiguration dTToolBarConfiguration2) {
        Object object;
        if (dTToolBarConfiguration == null) {
            return dTToolBarConfiguration2;
        }
        List<String> list = dTToolSet.getKeys();
        int[] nArray = new int[list.size()];
        Arrays.fill(nArray, -1);
        ArrayList<String> arrayList = new ArrayList<String>(dTToolBarConfiguration.getVisibleItemKeys());
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!((String)object).equals("Tool Bar Separator Key")) {
                int n2 = list.indexOf(object);
                if (n2 == -1 || nArray[n2] != -1) {
                    iterator.remove();
                } else {
                    nArray[n2] = n;
                }
            }
            ++n;
        }
        boolean bl = arrayList.size() != dTToolBarConfiguration.getVisibleItemKeys().size();
        object = dTToolBarConfiguration.getHiddenItemKeys();
        List<String> list2 = dTToolBarConfiguration2.getVisibleItemKeys();
        for (int i = 0; i < list.size(); ++i) {
            int n3;
            String string = list.get(i);
            if (nArray[i] != -1 || (n3 = list2.indexOf(string)) == -1 || object.contains(string)) continue;
            int n4 = -1;
            --n3;
            while (n3 > 0 && n4 == -1) {
                String string2 = list2.get(n3);
                int n5 = list.indexOf(string2);
                if (n5 != -1) {
                    n4 = nArray[n5];
                }
                --n3;
            }
            if (n4 == -1) {
                arrayList.add(string);
            } else {
                arrayList.add(n4 + 1, string);
            }
            bl = true;
        }
        if (!bl) {
            return dTToolBarConfiguration;
        }
        object = new ArrayList<String>();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != -1) continue;
            object.add((String)list.get(n));
        }
        return new DTToolBarConfiguration((List<String>)arrayList, (List<String>)object);
    }

    private static void buildToolBar(JToolBar jToolBar, DTToolSet dTToolSet, DTToolBarConfiguration dTToolBarConfiguration, Object object) {
        boolean bl = false;
        if (jToolBar instanceof MJToolBar && (bl = ((MJToolBar)jToolBar).isMorePopupEnabled())) {
            ((MJToolBar)jToolBar).setMorePopupEnabled(false);
        }
        jToolBar.removeAll();
        for (String string : dTToolBarConfiguration.getVisibleItemKeys()) {
            if (string.equals("Tool Bar Separator Key")) {
                jToolBar.addSeparator();
                continue;
            }
            Component component = dTToolSet.getComponent(string, object);
            if (component == null) continue;
            if (dTToolSet.includeLabelOnBar(string)) {
                String string2 = dTToolSet.getLabel(string);
                MJLabel mJLabel = new MJLabel(string2 + ":");
                if (component instanceof JComboBox && ((JComboBox)component).isEditable()) {
                    mJLabel.setLabelForWithoutGrabbingFocus(((JComboBox)component).getEditor().getEditorComponent());
                } else {
                    mJLabel.setLabelForWithoutGrabbingFocus(component);
                }
                mJLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
                MJToolBar.markAsNonEssential((JComponent)mJLabel);
                jToolBar.add((Component)mJLabel);
            }
            if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty(TOOL_BAR_ITEM_PROPERTY_KEY, string);
            }
            jToolBar.add(component);
        }
        DTToolBarFactory.removeExtraSeparators(jToolBar);
        if (bl) {
            ((MJToolBar)jToolBar).setMorePopupEnabled(true);
        }
    }

    private static void removeExtraSeparators(JToolBar jToolBar) {
        Component component;
        Component[] componentArray;
        boolean bl = true;
        for (Component component2 : componentArray = jToolBar.getComponents()) {
            if (component2 instanceof JSeparator || component2 instanceof MJToolBar.VisibleSeparator) {
                if (bl) {
                    jToolBar.remove(component2);
                }
                bl = true;
                continue;
            }
            bl = false;
        }
        int n = jToolBar.getComponentCount();
        Component component3 = component = n > 0 ? jToolBar.getComponent(n - 1) : null;
        if (component instanceof JSeparator || component instanceof MJToolBar.VisibleSeparator) {
            jToolBar.remove(component);
        }
    }
}

