/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTToolstripFactory;
import com.mathworks.widgets.desk.Desktop;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.Action;

public class DefaultViewTabFactory {
    private final Desktop fDesktop;
    private TSToolSetContents fToolSetContents;
    private TSTabConfiguration fTabConfig;

    DefaultViewTabFactory(Desktop desktop) {
        this.fDesktop = desktop;
        try {
            this.fToolSetContents = new TSToolSetContents(SimpleDOMUtils.read((URL)DefaultViewTabFactory.class.getResource("resources/DefaultViewToolset.xml")));
            this.fTabConfig = new TSTabConfiguration(SimpleDOMUtils.read((URL)DefaultViewTabFactory.class.getResource("resources/DefaultViewTab.xml")));
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        catch (DataFormatException dataFormatException) {
            Log.logException((Exception)dataFormatException);
        }
    }

    public TSToolSet createToolSet(String string) {
        DTGroup dTGroup = this.fDesktop.getGroup(string);
        if (dTGroup == null) {
            throw new IllegalArgumentException("Group " + string + " not found");
        }
        return this.createToolSet(dTGroup);
    }

    public ToolstripTab createTab(String string) {
        DTGroup dTGroup = this.fDesktop.getGroup(string);
        return this.createTab(dTGroup);
    }

    ToolstripTab createTab(DTGroup dTGroup) {
        TSTabConfiguration.Tool tool = this.fTabConfig.findTool("tiles", "float", "default_view_toolset");
        if (tool != null) {
            tool.setVisible(dTGroup.permitUserFloat());
        }
        return TSFactory.createTab((TSTabConfiguration)this.fTabConfig, (TSToolSet[])new TSToolSet[]{this.createToolSet(dTGroup)});
    }

    TSToolSetContents getToolSetContents() {
        return this.fToolSetContents;
    }

    static void disposeTab(ToolstripTab toolstripTab) {
        TSFactory.disposeTab((ToolstripTab)toolstripTab);
    }

    private TSToolSet createToolSet(DTGroup dTGroup) {
        TSToolSet tSToolSet = new TSToolSet(this.fToolSetContents);
        Map<DTToolstripFactory.DocumentArrangement, Action> map = DTToolstripFactory.getDocumentArrangementActions(dTGroup);
        for (DTToolstripFactory.DocumentArrangement documentArrangement : DTToolstripFactory.DocumentArrangement.values()) {
            tSToolSet.configureAndAdd(documentArrangement.name().toLowerCase(Locale.ENGLISH), map.get((Object)documentArrangement));
        }
        DTDocumentContainer dTDocumentContainer = dTGroup.getDocumentContainer();
        tSToolSet.configureAndAdd("bar_at_top", dTDocumentContainer.getTabsToNorthAction());
        tSToolSet.configureAndAdd("bar_at_bottom", dTDocumentContainer.getTabsToSouthAction());
        tSToolSet.configureAndAdd("bar_at_right", dTDocumentContainer.getTabsToEastAction());
        tSToolSet.configureAndAdd("bar_at_left", dTDocumentContainer.getTabsToWestAction());
        if (dTGroup.permitDocumentBarHide()) {
            tSToolSet.configureAndAdd("bar_hidden", dTDocumentContainer.getHideTabsAction());
        }
        tSToolSet.configureAndAdd("shrink_tabs", dTDocumentContainer.getToggleShrinkTabsToFitAction());
        if (dTGroup.getAlphabetizeAction() != null) {
            tSToolSet.configureAndAdd("alphabetize_bar", (Action)dTGroup.getAlphabetizeAction());
        }
        tSToolSet.configureAndAdd("switch_windows", (Action)((Object)new DTToolstripFactory.WindowAction(this.fDesktop, dTGroup.getName())));
        return tSToolSet;
    }
}

